{|
  Unit   : uEstSearchDialogBde
  Date   : 01-01-2004
  Auteur : Erik Stok
  Doel   : Bde versie van het search dialog component
|}
unit uEstSearchDialogBde;

interface

uses 
  Classes, DB, SysUtils, uEstSearchDialog, DBTables;

type

  TEstSearchDialogBde = class(TEstSearchDialog)
  private
    FConnection: TDatabase;
    FSearchQuery: TQuery;
    FcountQuery: TQuery;
  protected
    procedure SetConnection(const Value: TDatabase); virtual;

    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;

    procedure DoSetSearchQuery(Sender: TObject; SQL: String); override;
    procedure DoSetCountQuery(Sender: TObject; SQL: String); override;

    function ValidConnection: Boolean; override;

    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure AssignTo(Dest: TPersistent); override;

  published
    property Connection: TDatabase read FConnection write SetConnection;
  end;


implementation

{ TEstSearchDialogBde }

constructor TEstSearchDialogBde.Create(AOwner: TComponent);
begin
  inherited;

  // Init privates
  FConnection := nil;

  FSearchQuery := TQuery.Create(Self);
  FcountQuery := TQuery.Create(Self);
end;

destructor TEstSearchDialogBde.Destroy;
begin
  // Ruim alles netjes op
  FSearchQuery.Free;
  FcountQuery.Free;

  inherited;
end;

{|
  Procedure : TEstSearchDialogBde.SetConnection
  Auteur    : Erik Stok
  Doel      : Stel de connection van het search dialog component in
|}
procedure TEstSearchDialogBde.SetConnection(const Value: TDatabase);
begin
  if Value <> FConnection then
  begin
    // Stel connection in op gegeven waarde
    FConnection := Value;

    // Stel van de search en count queries ook de connections in
    if Assigned(FConnection) then
    begin
      FSearchQuery.DatabaseName := FConnection.DatabaseName;
      FcountQuery.DatabaseName := FConnection.DatabaseName;
    end
    else
    begin
      FSearchQuery.DatabaseName := '';
      FcountQuery.DatabaseName := '';
    end;

  end;
end;

function TEstSearchDialogBde.CountDataSet: TDataSet;
begin
  Result := FCountQuery;
end;

function TEstSearchDialogBde.SearchDataSet: TDataSet;
begin
  Result := FSearchQuery;
end;

procedure TEstSearchDialogBde.DoSetSearchQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel search query in
  FSearchQuery.Close;
  FSearchQuery.SQL.Text := SQL;
end;

procedure TEstSearchDialogBde.DoSetCountQuery(Sender: TObject; SQL: String);
begin
  inherited;
  
  // Stel count query in
  FCountQuery.Close;
  FCountQuery.SQL.Text := SQL;
end;

{|
  Procedure : TEstSearchDialogBde.AssignTo
  Auteur    : Erik Stok
  Doel      : Assign ook de connection
|}
procedure TEstSearchDialogBde.AssignTo(Dest: TPersistent);
var
  DestSearchDialog : TEstSearchDialogBde;
begin
  inherited AssignTo(Dest);

  DestSearchDialog := Dest as TEstSearchDialogBde;
  DestSearchDialog.Connection := Connection;
end;

{|
  Procedure : TEstSearchDialogBde.ValidConnection
  Auteur    : Erik Stok
  Doel      : Controleer of de opgegeven connection geldig is
|}
function TEstSearchDialogBde.ValidConnection: Boolean;
begin
  // De connection is geldig als deze assigned is
  Result := Assigned(FConnection);
end;

procedure TEstSearchDialogBde.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;

  // Als de connection verwijderd wordt, zet dan de property op nil
  if (AComponent = FConnection) and (Operation = opRemove) then
    Connection := nil;
end;

end.
