{|
  Unit   : uEstSearchDialogAdo
  Date   : 01-01-2004
  Auteur : Erik Stok
  Doel   : Ado versie van het search dialog component
|}
unit uEstSearchDialogAdo;

interface

uses
  Classes, DB, AdoDB, uEstSearchDialog;

type

  TEstSearchDialogAdo = class(TEstSearchDialog)
  private
    FConnection: TAdoConnection;
    FSearchQuery: TAdoDataSet;
    FcountQuery: TAdoDataSet;
  protected
    procedure SetConnection(const Value: TAdoConnection); virtual;

    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;

    procedure DoSetSearchQuery(Sender: TObject; SQL: String); override;
    procedure DoSetCountQuery(Sender: TObject; SQL: String); override;

    function ValidConnection: Boolean; override;

    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure AssignTo(Dest: TPersistent); override;

  published
    property Connection: TAdoConnection read FConnection write SetConnection;
  end;


implementation

{ TEstSearchDialogAdo }

constructor TEstSearchDialogAdo.Create(AOwner: TComponent);
begin
  inherited;

  // Init privates
  FConnection := nil;

  FSearchQuery := TAdoDataSet.Create(Self);
  FcountQuery := TAdoDataSet.Create(Self);
end;

destructor TEstSearchDialogAdo.Destroy;
begin
  // Ruim alles netjes op
  FSearchQuery.Free;
  FcountQuery.Free;

  inherited;
end;

{|
  Procedure : TEstSearchDialogAdo.SetConnection
  Auteur    : Erik Stok
  Doel      : Stel de connection van het search dialog component in
|}
procedure TEstSearchDialogAdo.SetConnection(const Value: TAdoConnection);
begin
  if Value <> FConnection then
  begin
    // Stel connection in op gegeven waarde
    FConnection := Value;

    // Stel van de search en count queries ook de connections in
    FSearchQuery.Connection := FConnection;
    FcountQuery.Connection := FConnection;
  end;
end;

function TEstSearchDialogAdo.CountDataSet: TDataSet;
begin
  Result := FCountQuery;
end;

function TEstSearchDialogAdo.SearchDataSet: TDataSet;
begin
  Result := FSearchQuery;
end;

procedure TEstSearchDialogAdo.DoSetSearchQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel search query in
  FSearchQuery.Close;
  FSearchQuery.CommandText := SQL;
end;

procedure TEstSearchDialogAdo.DoSetCountQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel count query in
  FCountQuery.Close;
  FCountQuery.CommandText := SQL;
end;

{|
  Procedure : TEstSearchDialogAdo.AssignTo
  Auteur    : Erik Stok
  Doel      : Assign ook de connection
|}
procedure TEstSearchDialogAdo.AssignTo(Dest: TPersistent);
var
  DestSearchDialog : TEstSearchDialogAdo;
begin
  inherited AssignTo(Dest);

  DestSearchDialog := Dest as TEstSearchDialogAdo;
  DestSearchDialog.Connection := Connection;
end;

{|
  Procedure : TEstSearchDialogAdo.ValidConnection
  Auteur    : Erik Stok
  Doel      : Controleer of de opgegeven connection geldig is
|}
function TEstSearchDialogAdo.ValidConnection: Boolean;
begin
  Result := Assigned(Connection);
end;

procedure TEstSearchDialogAdo.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;

  // Als de connection verwijderd wordt, zet dan de property op nil
  if (AComponent = FConnection) and (Operation = opRemove) then
    Connection := nil;
end;

end.
