{|
  Unit    : fEstSearchDialogEditorZeos
  Datum   : 01-01-2004
  Auteur  : Erik Stok
  Doel    : ErikStok search dialog designtime editor for Zeos
|}
unit fEstSearchDialogEditorZeos;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fEstSearchDialogEditor, DB, ActnList, StdCtrls, Grids, DBGrids,
  ComCtrls, ExtCtrls, uEstSearchDialog, uEstSearchDialogZeos,
  ZAbstractRODataset, ZDataset;

type
  TFrmEstSearchDialogEditorZeos = class(TFrmEstSearchDialogEditor)
    qrySearch: TZReadOnlyQuery;
    qryCount: TZReadOnlyQuery;
  protected
    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;
    procedure SetSearchSQL(SQL: String); override;
    procedure SetCountSQL(SQL: String); override;

    procedure SetSearchDialog(const Value: TEstSearchDialog); override;
  end;

implementation

{$R *.dfm}

{ TFrmEstSearchDialogEditorZeos }

function TFrmEstSearchDialogEditorZeos.CountDataSet: TDataSet;
begin
  Result := qryCount;
end;

function TFrmEstSearchDialogEditorZeos.SearchDataSet: TDataSet;
begin
  Result := qrySearch;
end;

procedure TFrmEstSearchDialogEditorZeos.SetCountSQL(SQL: String);
begin
  qryCount.Close;
  qryCount.SQL.Text := SQL;
end;

procedure TFrmEstSearchDialogEditorZeos.SetSearchDialog(const Value: TEstSearchDialog);
begin
  inherited;

  // Stel ook de connection van beide query componenten in
  qrySearch.Connection := (Value as TEstSearchDialogZeos).Connection;
  qryCount.Connection := (Value as TEstSearchDialogZeos).Connection;
end;

procedure TFrmEstSearchDialogEditorZeos.SetSearchSQL(SQL: String);
begin
  qrySearch.Close;
  qrySearch.SQL.Text := SQL;
end;

end.
