{|
  Unit    : fEstSearchDialogEditorNexus
  Datum   : 01-01-2004
  Auteur  : Erik Stok
  Doel    : ErikStok search dialog designtime editor for Nexus
|}
unit fEstSearchDialogEditorNexus;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fEstSearchDialogEditor, DB, ActnList, StdCtrls, Grids, DBGrids,
  ComCtrls, ExtCtrls, uEstSearchDialog, uEstSearchDialogNexus, nxdb;

type
  TFrmEstSearchDialogEditorNexus = class(TFrmEstSearchDialogEditor)
    qrySearch: TnxQuery;
    qryCount: TnxQuery;
  protected
    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;
    procedure SetSearchSQL(SQL: String); override;
    procedure SetCountSQL(SQL: String); override;

    procedure SetSearchDialog(const Value: TEstSearchDialog); override;
  end;

implementation

{$R *.dfm}

{ TFrmEstSearchDialogEditorNexus }

function TFrmEstSearchDialogEditorNexus.CountDataSet: TDataSet;
begin
  Result := qryCount;
end;

function TFrmEstSearchDialogEditorNexus.SearchDataSet: TDataSet;
begin
  Result := qrySearch;
end;

procedure TFrmEstSearchDialogEditorNexus.SetCountSQL(SQL: String);
begin
  qryCount.Close;
  qryCount.SQL.Text := SQL;
end;

procedure TFrmEstSearchDialogEditorNexus.SetSearchDialog(const Value: TEstSearchDialog);
begin
  inherited;

  // Stel ook de connection van beide query componenten in
  qrySearch.Database := (Value as TEstSearchDialogNexus).Connection;
  qryCount.Database := (Value as TEstSearchDialogNexus).Connection;
end;

procedure TFrmEstSearchDialogEditorNexus.SetSearchSQL(SQL: String);
begin
  qrySearch.Close;
  qrySearch.SQL.Text := SQL;
end;

end.
