{|
  Unit    : fEstSearchDialogEditorIbx
  Datum   : 01-01-2004
  Auteur  : Erik Stok
  Doel    : ErikStok search dialog designtime editor for Ibx
|}
unit fEstSearchDialogEditorIbx;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fEstSearchDialogEditor, DB, ActnList, StdCtrls, Grids, DBGrids,
  ComCtrls, ExtCtrls, uEstSearchDialog, uEstSearchDialogIbx, IBCustomDataSet;

type
  TFrmEstSearchDialogEditorIbx = class(TFrmEstSearchDialogEditor)
    qrySearch: TIBDataSet;
    qryCount: TIBDataSet;
  protected
    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;
    procedure SetSearchSQL(SQL: String); override;
    procedure SetCountSQL(SQL: String); override;

    procedure SetSearchDialog(const Value: TEstSearchDialog); override;
  end;

implementation

{$R *.dfm}

{ TFrmEstSearchDialogEditorIbx }

function TFrmEstSearchDialogEditorIbx.CountDataSet: TDataSet;
begin
  Result := qryCount;
end;

function TFrmEstSearchDialogEditorIbx.SearchDataSet: TDataSet;
begin
  Result := qrySearch;
end;

procedure TFrmEstSearchDialogEditorIbx.SetCountSQL(SQL: String);
begin
  qryCount.Close;
  qryCount.SelectSQL.Text := SQL;
end;

procedure TFrmEstSearchDialogEditorIbx.SetSearchDialog(const Value: TEstSearchDialog);
begin
  inherited;

  // Stel ook de connection van beide query componenten in
  qrySearch.Database := (Value as TEstSearchDialogIbx).Connection;
  qryCount.Database := (Value as TEstSearchDialogIbx).Connection;
end;

procedure TFrmEstSearchDialogEditorIbx.SetSearchSQL(SQL: String);
begin
  qrySearch.Close;
  qrySearch.SelectSQL.Text := SQL;
end;

end.
