{|
  Unit    : fEstSearchDialogEditorFF
  Datum   : 01-01-2004
  Auteur  : Erik Stok
  Doel    : ErikStok search dialog designtime editor for FF
|}
unit fEstSearchDialogEditorFF;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fEstSearchDialogEditor, DB, ActnList, StdCtrls, Grids, DBGrids,
  ComCtrls, ExtCtrls, uEstSearchDialog, uEstSearchDialogFF, ffdb;

type
  TFrmEstSearchDialogEditorFF = class(TFrmEstSearchDialogEditor)
    qrySearch: TffQuery;
    qryCount: TffQuery;
  protected
    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;
    procedure SetSearchSQL(SQL: String); override;
    procedure SetCountSQL(SQL: String); override;

    procedure SetSearchDialog(const Value: TEstSearchDialog); override;
  end;

implementation

{$R *.dfm}

{ TFrmEstSearchDialogEditorNexus }

function TFrmEstSearchDialogEditorFF.CountDataSet: TDataSet;
begin
  Result := qryCount;
end;

function TFrmEstSearchDialogEditorFF.SearchDataSet: TDataSet;
begin
  Result := qrySearch;
end;

procedure TFrmEstSearchDialogEditorFF.SetCountSQL(SQL: String);
begin
  qryCount.Close;
  qryCount.SQL.Text := SQL;
end;

procedure TFrmEstSearchDialogEditorFF.SetSearchDialog(const Value: TEstSearchDialog);
begin
  inherited;

  // Stel ook de connection van beide query componenten in
  qrySearch.DatabaseName := (Value as TEstSearchDialogFF).Connection.DatabaseName;
  qryCount.DatabaseName := (Value as TEstSearchDialogFF).Connection.DatabaseName;
end;

procedure TFrmEstSearchDialogEditorFF.SetSearchSQL(SQL: String);
begin
  qrySearch.Close;
  qrySearch.SQL.Text := SQL;
end;

end.
