{|
  Unit    : fEstSearchDialogEditorDbx
  Datum   : 01-01-2004
  Auteur  : Erik Stok
  Doel    : ErikStok search dialog designtime editor for Dbx
|}
unit fEstSearchDialogEditorDbx;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fEstSearchDialogEditor, DB, ActnList, StdCtrls, Grids, DBGrids,
  ComCtrls, ExtCtrls, uEstSearchDialog, uEstSearchDialogDbx, FMTBcd,
  SqlExpr, DBClient, Provider;

type
  TFrmEstSearchDialogEditorDbx = class(TFrmEstSearchDialogEditor)
    qrySearch: TSQLDataSet;
    qryCount: TSQLDataSet;
    prvSearch: TDataSetProvider;
    prvCount: TDataSetProvider;
    cdsSearch: TClientDataSet;
    cdsCount: TClientDataSet;
  protected
    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;
    procedure SetSearchSQL(SQL: String); override;
    procedure SetCountSQL(SQL: String); override;

    procedure SetSearchDialog(const Value: TEstSearchDialog); override;
  end;

implementation

{$R *.dfm}

{ TFrmEstSearchDialogEditorDbx }

function TFrmEstSearchDialogEditorDbx.CountDataSet: TDataSet;
begin
  Result := cdsCount;
end;

function TFrmEstSearchDialogEditorDbx.SearchDataSet: TDataSet;
begin
  Result := cdsSearch;
end;

procedure TFrmEstSearchDialogEditorDbx.SetCountSQL(SQL: String);
begin
  cdsCount.Close;
  qryCount.Close;
  qryCount.CommandText := SQL;
end;

procedure TFrmEstSearchDialogEditorDbx.SetSearchSQL(SQL: String);
begin
  cdsSearch.Close;
  qrySearch.Close;
  qrySearch.CommandText := SQL;
end;

procedure TFrmEstSearchDialogEditorDbx.SetSearchDialog(const Value: TEstSearchDialog);
begin
  inherited;

  // Stel ook de connection van beide query componenten in
  qrySearch.SQLConnection := (Value as TEstSearchDialogDbx).Connection;
  qryCount.SQLConnection := (Value as TEstSearchDialogDbx).Connection;
end;

end.
