{|
  Unit    : fEstSearchDialogEditorBde
  Datum   : 01-01-2004
  Auteur  : Erik Stok
  Doel    : ErikStok search dialog designtime editor for Bde
|}
unit fEstSearchDialogEditorBde;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fEstSearchDialogEditor, DB, ActnList, StdCtrls, Grids, DBGrids,
  ComCtrls, ExtCtrls, uEstSearchDialog, uEstSearchDialogBde, DBTables;

type
  TFrmEstSearchDialogEditorBde = class(TFrmEstSearchDialogEditor)
    qrySearch: TQuery;
    qryCount: TQuery;
  protected
    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;
    procedure SetSearchSQL(SQL: String); override;
    procedure SetCountSQL(SQL: String); override;

    procedure SetSearchDialog(const Value: TEstSearchDialog); override;
  end;

implementation

{$R *.dfm}

{ TFrmEstSearchDialogEditorBde }

function TFrmEstSearchDialogEditorBde.CountDataSet: TDataSet;
begin
  Result := qryCount;
end;

function TFrmEstSearchDialogEditorBde.SearchDataSet: TDataSet;
begin
  Result := qrySearch;
end;

procedure TFrmEstSearchDialogEditorBde.SetCountSQL(SQL: String);
begin
  qryCount.Close;
  qryCount.SQL.Text := SQL;
end;

procedure TFrmEstSearchDialogEditorBde.SetSearchDialog(const Value: TEstSearchDialog);
begin
  inherited;

  // Stel ook de connection van beide query componenten in
  qrySearch.DatabaseName := (Value as TEstSearchDialogBde).Connection.DatabaseName;
  qryCount.DatabaseName := (Value as TEstSearchDialogBde).Connection.DatabaseName;
end;

procedure TFrmEstSearchDialogEditorBde.SetSearchSQL(SQL: String);
begin
  qrySearch.Close;
  qrySearch.SQL.Text := SQL;
end;

end.
