{|
  Unit    : fEstSearchDialogEditorAdo
  Datum   : 01-01-2004
  Auteur  : Erik Stok
  Doel    : ErikStok search dialog designtime editor for Ado
|}
unit fEstSearchDialogEditorAdo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, fEstSearchDialogEditor, DB, ActnList, StdCtrls, Grids, DBGrids,
  ComCtrls, ExtCtrls, ADODB, uEstSearchDialog, uEstSearchDialogAdo;

type
  TFrmEstSearchDialogEditorAdo = class(TFrmEstSearchDialogEditor)
    qrySearch: TADODataSet;
    qryCount: TADODataSet;
  protected
    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;
    procedure SetSearchSQL(SQL: String); override;
    procedure SetCountSQL(SQL: String); override;

    procedure SetSearchDialog(const Value: TEstSearchDialog); override;
  end;

implementation

{$R *.dfm}

{ TFrmEstSearchDialogEditorAdo }

function TFrmEstSearchDialogEditorAdo.CountDataSet: TDataSet;
begin
  Result := qryCount;
end;

function TFrmEstSearchDialogEditorAdo.SearchDataSet: TDataSet;
begin
  Result := qrySearch;
end;

procedure TFrmEstSearchDialogEditorAdo.SetCountSQL(SQL: String);
begin
  qryCount.Close;
  qryCount.CommandText := SQL;
end;

procedure TFrmEstSearchDialogEditorAdo.SetSearchSQL(SQL: String);
begin
  qrySearch.Close;
  qrySearch.CommandText := SQL;
end;

procedure TFrmEstSearchDialogEditorAdo.SetSearchDialog(const Value: TEstSearchDialog);
begin
  inherited;

  // Stel ook de connection van beide query componenten in
  qrySearch.Connection := (Value as TEstSearchDialogAdo).Connection;
  qryCount.Connection := (Value as TEstSearchDialogAdo).Connection;
end;

end.
