{
TEditInsideHelp  Component Version 1.0 - Suite GLib
Copyright () 2005,  by Germn Estvez (Neftal)

  Permite definir un texto de ayuda en la parte interna del control de edicin.
  El texto desaparace cuando el control contiene algun texto que el usuario ha
  aadido. Permite modificar el texto que aparece y el color de ste.
  Basta con activar la propiedad InsideHelpActive.

=========================================================================
IMPORTANTE PROGRAMADORES: Por favor, si tienes comentarios, mejoras, ampliaciones,
  errores y/o cualquier otro tipo de sugerencia envame un mail a:
  german_ral@hotmail.com

IMPORTANT PROGRAMMERS: please, if you have comments, improvements, enlargements,
errors and/or any another type of suggestion send a mail to:
german_ral@hotmail.com    
=========================================================================

@author Germn Estvez (Neftal)
@cat Package GLib
}
unit CEditInsideHelp;
{
=========================================================================

  CEditInsideHelp.pas

  Componente

  Propsito: Permite definir un texto de ayuda en la parte interna del control
  de edicin. El texto desaparace cuando el control contiene algun texto que
  el usuario ha aadido.

========================================================================
  Historia de las Versiones
------------------------------------------------------------------------

  23/01/2006  Germn Estvez

  * Creacin.

=========================================================================

  Errores detectados no corregidos

=========================================================================
}

//=========================================================================
//
// I N T E R F A C E
//
//=========================================================================
interface

uses
  Windows, Messages, SysUtils, Classes, Controls, StdCtrls, Graphics;

type
  {: Clase que define el componente TEditInsideHelp.}
  TEditInsideHelp = class(TEdit)
  private
    FInsideHelpActive: Boolean;
    FInsideHelpText: String;
    FInsideHelpColor: TColor;

    procedure SetInsideHelpActive(const Value: Boolean);
    procedure SetInsideHelpColor(const Value: TColor);
    procedure SetInsideHelpText(const Value: String);

  protected
    //: Capturamos el evento se repintado.
    procedure WMPaint(var Message: TWMPaint); message WM_PAINT;
    //: Capturamos el evento de salida para pintar.
    procedure CMExit(var Message: TCMExit); message CM_EXIT;

  public
    //: Redefinimos el constructor.
    constructor Create(AOwner: TComponent); override;
  published
    //: Permite definir el texto de ayuda.
    property InsideHelpText:String read FInsideHelpText write SetInsideHelpText;
    //: Permite definir el color del texto de ayuda.
    property InsideHelpColor:TColor read FInsideHelpColor write SetInsideHelpColor;
    //: Permite activar la caracterstica de ayuda interior.
    property InsideHelpActive:Boolean read FInsideHelpActive write SetInsideHelpActive;

  end;

// Constantes para el componente
const
  DEFAULT_COLOR = clScrollBar;

procedure Register;

//=========================================================================
//
// I M P L E M E N T A T I O N
//
//=========================================================================
implementation

uses
  Forms;

//: Procedimniento de registro.
procedure Register;
begin
  RegisterComponents('GLib', [TEditInsideHelp]);
end;


procedure TEditInsideHelp.CMExit(var Message: TCMExit);
begin
  Self.Repaint;
end;

constructor TEditInsideHelp.Create(AOwner: TComponent);
begin
  inherited;

  // Inicializaciones
  Self.FInsideHelpActive := False;
  Self.FInsideHelpText := Self.FInsideHelpText;
  Self.FInsideHelpColor := Self.FInsideHelpColor;

end;


procedure TEditInsideHelp.SetInsideHelpActive(const Value: Boolean);
begin
  // Activar
  Self.FInsideHelpActive := Value;
  // repintar
  Self.Repaint;
end;

procedure TEditInsideHelp.SetInsideHelpColor(const Value: TColor);
begin
  Self.FInsideHelpColor := Value;
  // repintar
  Repaint;
end;

procedure TEditInsideHelp.SetInsideHelpText(const Value: String);
begin
  Self.FInsideHelpText := Value;
  // repintar
  Repaint;
end;

procedure TEditInsideHelp.WMPaint(var Message: TWMPaint);
var
  MCanvas: TControlCanvas;
  DrawBounds: TRect;
begin

  // Casos en los que no hacemos nada
  if (Self.Text <> '') or (not Self.FInsideHelpActive) then begin
    inherited;
    Exit;
  end;

  inherited;

  MCanvas := TControlCanvas.Create;
  DrawBounds := ClientRect;

  // proteccion
  try
    // Asignar el canvas
    MCanvas.Control := Self;

    // Pintar
    MCanvas.Brush.Color := Self.Color;
    MCanvas.Font.Color := Self.FInsideHelpColor;
    MCanvas.Font.Name := 'Arial';
    MCanvas.Font.Style := MCanvas.Font.Style + [fsBold];
    // texto
    MCanvas.TextOut(2,2, Self.FInsideHelpText);

  finally
    MCanvas.Free;
  end;

end;



end.

