unit UBM_Public;

// Version publie de UBM

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, Buttons, StdCtrls, DDU_Public ;

Const LargeurBouton = 135 ;
      HauteurBouton =  27 ;

type
  TFBM = class(TForm)
    procedure LesSpeedButtonsClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormPaint(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
    BoutonChoisi : integer ;
    Raccourcis : ShortString ;
    LeMessage : String ;
    Hauteur : Integer ;
  end;



Function BM(LeTitre, LeMessage : String ; ListeDesBoutons : String ='Ok'; Couleur : Tcolor = 0 ) : integer ;
var
  FBM: TFBM;

implementation

{$R *.dfm}





Function BM(LeTitre, LeMessage : String ; ListeDesBoutons : String ='Ok'; Couleur : Tcolor = 0 ) : integer ;
Var S : String ;
    BN : ShortString ;
    Count : integer ;
    I, X, Y : Integer ;
    UnSB : TSpeedButton ;
    Ok : Boolean ;
    ExColor : TColor ;
Begin
  // Premier appel  BM
  If FBM=Nil then FBM := TFBM.Create(application) ;
  // Couleur
  If Couleur<>0 then
  Begin
    ExColor := FBM.Color ;
    FBM.Color := Couleur ;
  End ;
  // Titre
  FBM.Caption := LeTitre ;
  // Message
  S := LeMessage ;
  Remplace('#13',#13,S) ;
  Remplace(#13,'<P>',S) ;

  FBM.LeMessage := S ;
  // Liste des Boutons
  S := ListeDesBoutons ;
  Remplace('#13',#13,S) ;
  X := 20 ;
  Y := 20 ;
  FBM.hauteur := 0 ;
  //----------------------------------------------------------------------------
  // Boucle de cration des boutons
  Count := 1 ;
  While S<>'' do
  Begin
    //--------------------------------------------------------------------------
    // Dtermination du Nom du Bouton (BN : Button Name)
    If Pos(#13,S)>0 then
    Begin
      BN := Copy(S,1,Pos(#13,S)-1) ;
      Delete(S,1,Pos(#13,S)) ;
    End Else
    Begin
      BN := S ;
      S := '' ;
    End ;
    // Suppression des espaces de dbut et de fin du nom du bouton
    While Copy(BN,1,1)=' ' do BN := Copy(BN,2,255) ;
    While Copy(BN,Length(BN),1)=' ' do BN := Copy(BN,1,Length(BN)-1) ;
    If BN<>'' then
    Begin
      If X>FBM.Width-LargeurBouton-10 then
      Begin
        X := 20 ;
        Inc(Y,HauteurBouton+3) ;
      End ;
      UnSB := TSpeedButton.Create(FBM) ;
      UnSB.Parent := FBM ;
      // Racourci clavier
      If Pos('&',BN)=0 then
      Begin
        FBM.Raccourcis := FBM.Raccourcis + upcase(BN[1])  ;
        BN := '&'+BN ;
      End Else FBM.Raccourcis := FBM.Raccourcis + upcase(BN[Pos('&',BN)+1]) ;
      UnSB.Caption := BN ;
      UnSB.Name := 'B'+IntToStr(Count) ;
      Inc(Count) ;
      UnSB.Left := X ;
      UnSB.Top := Y ;
      UnSB.Width := LargeurBouton ;
      UnSB.Height := HauteurBouton  ;
      UnSB.OnClick := FBM.LesSpeedButtonsClick ;
      // GLYPH !!!!!!
      If FileExists(BN+'.BMP') then UnSB.Glyph.LoadFromFile(BN+'.BMP') ;
      Inc(X,largeurBouton + 5 ) ;
    End ;
  End ;
  // Dimensionnement de la fentre
  FBM.ClientHeight := Y + HauteurBouton + 10 ;
  //      UnSB.Anchors := [akLeft,akBottom] ;

  // Boucle de cration des boutons
  //----------------------------------------------------------------------------

  // Init resultat (BoutonChoisi)  AUCUN
  FBM.BoutonChoisi := 0 ;

  // Affichage de la Bote de Message (FBM) en MODAL
  FBM.ShowModal ;

  // Report du Rsultat
  Result := FBM.BoutonChoisi ;

  // Double boucle "breake" car button.free dcale les indices de FBM.Component
  // mais je viens de me rendre compte qu'un DOWNTO aurait p'tt fait l'affaire
  While Not OK do
  Begin
    Ok := True ;
    For I := 1 to FBM.ComponentCount do
    Begin
      If FBM.Components[i-1] is TSpeedButton then
      Begin
        TSpeedButton(FBM.Components[i-1]).Free ;
        Ok := False ;
        BREAK ;
      End ;
    End ;
  End ;
  If Couleur<>0 then FBM.Color := ExColor ;
End ;



procedure TFBM.LesSpeedButtonsClick(Sender: TObject);
var s : ShortString ;
begin
  If Sender is TSpeedButton then
  Begin
    S := TSpeedButton(sender).Name ;
    BoutonChoisi := StrtoInt(S[2]) ;
  End ;
  ModalResult := mrOk ;
end;

procedure TFBM.FormKeyPress(Sender: TObject; var Key: Char);
begin
  Key := UpCase(key) ;
  BoutonChoisi := Pos(Key,raccourcis) ;
  If BoutonChoisi<>0 then Modalresult := mrOk ;
end;

procedure TFBM.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  If Key=13 then
  Begin
    BoutonChoisi := 1 ;
    ModalResult := mrOk ;
  End ;
  If Key=27 then
  Begin
    BoutonChoisi := 1 ;
    ModalResult := mrOk ;
  End ;
end;

procedure TFBM.FormPaint(Sender: TObject);
Var H : Integer ;
begin
  H := TextHTMLOut(Canvas,20,10,ClientWidth-40,LeMessage) ;
  If hauteur<>H then
  Begin
    Hauteur := H ;
    ClientHeight := ClientHeight + H ;
    Top := (Screen.DesktopHeight-Height) div 2
  End ;

end;

procedure TFBM.FormShow(Sender: TObject);
Var i : integer ;
begin
  For I := 1 to ComponentCount Do
  If Components[i-1] is TSpeedButton then TSpeedButton(Components[i-1]).Anchors := [akLeft,akBottom] ;
end;

procedure TFBM.FormResize(Sender: TObject);
begin
  Invalidate ;
end;

end.
