Unit DDU_Public ;
// Version publie de DDU   //
{ Digo Delphi Unit }
{ Procdures et fonctions diverses }

interface
uses
     Windows,
     ShellApi,
     Registry,
     JPeg,
     Graphics,
     Forms,
     Controls,
     StdCtrls,
     Printers,
     Dialogs,
     // Tlchargs WINDOWS
     sysutils,
     Classes,
     Types ;

Const

Touche_RETURN = vk_RETURN  ;
Touche_CONTROL = vk_CONTROL;
Touche_MENU = vk_MENU      ;
Touche_TAB = vk_TAB        ;
Touche_BACK = vk_BACK      ;
Touche_PAUSE = vk_PAUSE    ;
Touche_ESCAPE = vk_ESCAPE  ;
Touche_SPACE = vk_SPACE    ;
Touche_PRIOR = vk_PRIOR    ;
Touche_NEXT = vk_NEXT      ;
Touche_END = vk_END        ;
Touche_HOME = vk_HOME      ;
Touche_LEFT = vk_LEFT      ;
Touche_UP = vk_UP          ;
Touche_RIGHT = vk_RIGHT    ;
Touche_DOWN = vk_DOWN      ;
Touche_PRINT = vk_PRINT    ;
Touche_EXECUTE = vk_EXECUTE;
Touche_INSERT = vk_INSERT  ;
Touche_DELETE = vk_DELETE  ;
Touche_HELP = vk_HELP      ;
Touche_MULTIPLY = vk_MULTIPLY     ;
Touche_Plus = vk_add       ;
Touche_Minus = vk_subtract;
Touche_F1 = vk_F1          ;
Touche_F2 = vk_F2          ;
Touche_F3 = vk_F3          ;
Touche_F4 = vk_F4          ;
Touche_F5 = vk_F5          ;
Touche_F6 = vk_F6          ;
Touche_F7 = vk_F7          ;
Touche_F8 = vk_F8          ;
Touche_F9 = vk_F9          ;
Touche_F10 = vk_F10        ;
Touche_F11 = vk_F11        ;
Touche_F12 = vk_F12        ;
Touche_F13 = vk_F13        ;
Touche_F14 = vk_F14        ;
Touche_F15 = vk_F15        ;
Touche_F16 = vk_F16        ;
Touche_F17 = vk_F17        ;
Touche_F18 = vk_F18        ;
Touche_F19 = vk_F19        ;
Touche_F20 = vk_F20        ;
Touche_F21 = vk_F21        ;
Touche_F22 = vk_F22        ;
Touche_F23 = vk_F23        ;
Touche_F24 = vk_F24        ;
Touche_NUMLOCK = vk_NUMLOCK;
CRLF = #13#10 ;
Var OrientationTexte : Integer = 0 ;
    PasDeJPEG : Boolean = False ;
    Silence : Array[1..7500] of Byte ;
  Monnaie : string[20] = 'Euro' ;
  SautDEPage       : String[40]  = #12 ;
  PasElite         : String[40] = #18#27'M' ;
  PasPica          : String[40] = #18#27'P' ;
  PasCondense      : String[40] = #15 ;
  EliteCondense    : String[40] = #27'M'#27'~80'#15 ;
  StyleItalique    : String[40] = #27'!'#127 ; { EPSON seulement ! }
  StyleRomain      : String[40] = #27'!'#0 ; { EPSON seulement ! }
  NQL              : String[40] = #27'x'#1 ;
  Brouillon        : String[40] = #27'x'#0 ;
  Gras             : String[40] = #27'G'#1 ;
  NonGras          : String[40] = #27'G'#0 ;

  DoubleFrappe     : String[40] = #27'G'#1 ;
  SimpleFrappe     : String[40] = #27'G'#0 ;

  Reinit           : string[40] = #27'@' ;
  NonOmbre         : String[40] = #27'q'#0 ;
  Contourne        : String[40] = #27'q'#1 ;
  Ombre            : String[40] = #27'q'#2 ;
  ContourneETOmbre : String[40] = #27'q'#3 ;
  Negatif          : String[40] = #29'B1' ;
  Positif          : String[40] = #29'B0' ;
  DoubleH          : String[40] = #27'w'#1 ;
  DoubleL          : String[40] = #27'W'#1 ;
  NormalH          : String[40] = #27'w'#0 ;
  NormalL          : String[40] = #27'W'#0 ;
  Souligne         : String[40] = #27'-'#1 ;
  NonSouligne      : String[40] = #27'-'#0 ;
  DX, DY : Array[1..25] of ShortInt ;
  AvecHistorique   : Boolean    = False ;
  LargeurChoixListe : Integer = 0 ;
  EditeAscii : Boolean = False ;
  DossierInitial : String ;
  TableauDesCursorPos : Array of
  Record
     Name : ShortString ;
     Size : Integer ;
     Color : Tcolor ;
     Style : TFontStyles ;
     CursorPos, Xd, Yd, Xf, Yf : Integer ;
  End ;
  TableauDesLiens : Array of Record
     X1, Y1, X2, Y2 : Integer ;
     Lien : ShortString ;
  End ;
  Fontes : Array of Record
           Name : ShortString ;
           Size : Integer ;
           Color : Tcolor ;
           Style : TFontStyles ;
  End ;

Type
  TableauDeLignes = Array of ShortString ;
  TFichier = Thandle ;
  NamedImage = Record
    NomFichierJPEG : String[8] ;
    NomLong : ShortString ;
    Image : TJPegImage ;
  End ;
  TypeDeRaccourci = (_DESKTOP, _QUICKLAUNCH, _SENDTO, _STARTMENU);
  TranstypageColor = Array[0..3] of byte ;
  { Fiches }
  Fiches = Array of char ;
  TStr8 = String[8];
  TStr12 = String[12] ;
  TString30 = String[30] ;
  PathStr = String[79] ;
  Dates = Record
    Jour, Mois : Byte ;
     Annee : word ;
  End ;
Var
  ExAujourDhui : Dates ;
  ExDateHeure  : TDateTime ;
  Images : Array of NamedImage ;
Type Periodes = Record
       Date_de_Depart : Dates ;
       Date_de_Fin : Dates ;
  End ;

  Moiss = Packed Record
     Mois : Byte ;
     Annee : word ;
  End ;
  Heures = Record
       Heure : Byte ;
       Minute : Byte ;
       Secondes : Byte ;
  End ;


Const Lecture  = 64 ;
      Ecriture = 34 ;

Var TitreMB,TexteMB : ShortString ;
    PoliceChoix : ShortString = 'MS Sans Serif' ;
    DateVide : Dates ;
    TableauVide : Fiches ;
    ExFonte : HFont ;
    OctetsNonCopies : DWord ;
    TableauDesDecalages :
    Array of Record
      Y : Integer ;
      Decalage : Integer ;
    End ;

Var
      Pointeur                : Pointer     = Nil ;
      LongVide                : ShortString = '                                                   ' ;
      LongWWW                 : ShortString = 'WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW' ;
      majuscules              : ShortString = 'AZERTYUIOPQSDFGHJKLMWXCVBN' ;
      minuscules              : ShortString = 'azertyuiopqsdfghjklmwxcvbn' ;
      chiffres                : ShortString = '1234567890';
      accentues               : ShortString = '' ;
      Reste                   : ShortString = ' !"#$%&''()*+,-./:;<=>?@[\]^_`{|}~'#255'' ;
      Interdits               : ShortString =  '/:*?"<>|' ;
      TOUT                    : ShortString = 'AZERTYUIOPQSDFGHJKLMWXCVBNazertyuiopqsdfghjklmwxcvbn1234567890 !"#$%&''()*+,-./:;<=>?@[\]^_`{|}~'#255'/:*?"<>|';
      NonNul                  : Boolean     = False ;
      CouleurFiligrane        : TColor      = 15132391 ;
      StrInterrompu           : ShortString = 'interrompu' ;
      StrRealise              : ShortString = 'ralis' ;
      Str11                   : ShortString = 'Interruption' ;
      Str12                   : ShortString = 'L''interruption est fortement dconseille.'#13'Voulez-vous vraiment l''interrompre ?' ;
var
      Langue                  : Byte        = 0 ; // 0=Francais 1=Espaol 2=English 3=Russe
      SeparateurDeDate        : String[1]   = '/' ;
      Imprimante              : Integer     = -1 ;
      AvecSeparateurDecimales : Boolean     = False ;
      Virgule                 : String[1]   = ',' ;
      SeparateurMillier       : String[1]   = ' ' ;
      IntituleMillion         : String[10]  = 'million ' ;
      IntituleMillier         : String[10]  = 'mille ' ;
      IntituleUnite           : String[10]  = 'franc' ;
      IntituleVirgule         : String[10]  = ' et ' ;
      IntituleCentieme        : String[10]  = 'centime' ;
      LangueWindows           : Word  = $40C ;
      LangueAppli             : Word  = $40C ;
      LangueUtilisee          : Word  = $40C ;
      ImprimanteCouleur       : Boolean = True ;
      ModeZero                : Boolean = False ;
      NeTramePas              : Boolean = True ;

      NomUtilisateur          : String[30] = '' ;
      ActionsAutorisees       : String  = '' ;

      UtilisateurCreeDossier  : Boolean = True ;
      TypeDeSousDossier       : String[40] = 'Aucun' ;
      DossiersAutorises       : String  = '' ;
      ListeDesDossiers        : String  = '' ;
      ListeDesSocietes        : String  = '' ;
      NomOption : ShortString ;

Procedure Historique( Evenement : ShortString) ;
Function BoiteDeMessage( LeTitre, LeMessage : String ; TypeDlg : TMsgDlgType = mtInformation ;Boutons : TMsgDlgButtons = [mbOk] ;  X : Integer = -1 ; Y : Integer = -1  ) : TMsgDlgBtn ;

Function Confirmation( Question : String ) : Boolean ;


Function StrNumero( V : DWord ) : TString30 ;
Function StrEntier( V : Integer ) : TString30 ;
Function StrOctet( V : Byte ) : TString30 ;
// DATES
Function AujourdHui : Dates ;
procedure Lendemain(Var  Date : Dates ; Nbr : Word = 1 );
procedure Veille(Var  Date : Dates ; Nbr : Word = 1 );
Function QuelMois(Mois:Byte): ShortString ;
Function QuelMoiss(Mois:Moiss): ShortString ;
Function DateEnFrancais( D : Dates) : ShortString ;
Function StrDate( D : Dates) : TStr12 ;
Function StrDateSansEspace( D : Dates) : TStr12 ;
Function DatesEgales( D1, D2 : Dates ; Comparaison : Boolean ) : Boolean ;
function Croissant(Date1,Date2:Dates):Boolean;
Function DateStr( S : ShortString ) : Dates ;
Function MoisStr( S : ShortString ) : Moiss ;
Function NomDeJour( J : Integer ) : Shortstring ;
Function JourDeSemaine( Date : Dates ) : ShortString ;
Function BooleenStr(S : ShortString ; Var Car : Char ) : Boolean ;
Function Ecart(D1,D2 : Dates ) : Word ;
Function Age(DateN : Dates) : ShortString ;
Function DernierJourDuMois(UneDate : dates ) : Byte ;
Function StrDateAlpha( D : Dates ; Sep : cHar = '-' ) : TSTR12 ;
Function StrReel( Valeur : Real ; L,D : Byte ) : PathStr ;
Function StrCompte( Valeur : Real ; L,D : Byte ; SansTrait : Boolean = False) : PathStr ;
Procedure ElagueLesEspaces( Var Chaine : ShortString ) ;
Procedure ElagueLesEspacesS( Var Chaine : String ) ;
Function StrCourt( Valeur : Real ; Decimales : Byte ) : PathStr ;
Function StrCourtInseccable( Valeur : Real ; Decimales : Byte ) : PathStr ;
Function EnAnsi( ChaineAscii : ShortString ) : ShortString ;
Function EnAscii( ChaineAnsi : ShortString ) : ShortString ;
Procedure Ansi( Var ChaineAscii : ShortString ) ;
Function CouleurEnFrancais( C : TColor ) : TString30 ;
Function StyleEnFrancais( Style : TFontStyles ) : ShortString ;
Function PoliceEnFrancais( Police : TFont ) : ShortString ;
Function Majuscule( S : String ) : String ; OverLoad ;
Function Majuscule( S : ShortString ) : ShortString ; OverLoad ;
Function Minuscule( S : ShortString ) : ShortString ; OverLoad ;
Function Minuscule( S : String ) : String ; OverLoad ;
Function Minuscule2( S : String ) : String ;
Function AvecArticle( S : ShortString ; Article : TStr8 ) : ShortString ;
Function Pluriel( S : ShortString ) : ShortString ;
Function Syntaxique( S : ShortString ) : ShortString ;
Function Fichique( S : ShortString ) : ShortString ; // inutilis au 16 juin 2005 ???
Function CreeFichier( NomDuFichier : ShortString ) : TFichier ;
Function OuvreFichier( NomDuFichier : ShortString ) : TFichier ;
Function OuvreEnLecture( NomDuFichier : ShortString ) : TFichier ;
Function OuvreEnEcriture( NomDuFichier : ShortString ) : TFichier ;
Function TailleDuFichier( Fichier : TFichier ) : DWord ;
Procedure PositionneFichier( Fichier : TFichier ; Position : Integer ; Relatif : integer = 0 ) ;
Procedure PositionneFichierAlafin( Fichier : TFichier ) ;
Procedure ReculePointeurFichier( Fichier : TFichier ; TailleRecord : Integer ) ;
Function EcritFichier( Fichier : TFichier ; Var Fiche : Fiches ; TailleRecord : DWord ) : Boolean ;
Function LitFichier( Fichier : TFichier ; Var Fiche : Fiches ; TailleRecord : DWord ) : Boolean ;
Function PositionDuFichier( Fichier : TFichier ) : DWord ;
Function VerrouilleFichier( Fichier : TFichier ; Position, TailleRecord, NbrEnregistrement : Cardinal ) : Boolean ;
Function DeVerrouilleFichier( Fichier : TFichier ; Position, TailleRecord, NbrEnregistrement : Cardinal ) : Boolean ;
Procedure InsertionFichier(Fichier : TFichier ; Position : DWord ; Fiche : Fiches ; Taille : DWord ; NomDuFichier : ShortString) ;
Procedure CompactageFichier(Fichier : TFichier ; Position : DWord ; Taille : DWord ; NomDuFichier : ShortString) ;
Procedure FermeLeFichier( Fichier : TFichier ) ;
Function CriterePos( S1, S2 : ShortString ; VideOk : Boolean = False ) : Integer ;
Function SansEspaces( S : ShortString ) : ShortString ;
Var
    ListeDesChoisis : String ;
Procedure TrieListe(Var LaListe : String ) ;
Function ReelStr( S : ShortString ) : Real ;
Function OctetStr( S : ShortString ) : Byte ;
Function EntierStr( S : ShortString ) : DWord ;
Function WordStr( S : ShortString ) : Word ;
Function NomDeFichierCourt( NomF : ShortString) : ShortString ;
Function NomDeFichierLong( NomF : ShortString) : ShortString ;
Function TraiteLigneOption(Var  L : ShortString ; Option : ShortString ; Var Valeur : ShortString ) : Boolean ;
Function TraiteLigneOptionString(Var  L : ShortString ; Option : ShortString ; Var Valeur : String ) : Boolean ;
Function TraiteLigneOptionReelle(Var  L : ShortString ; Option : ShortString ; Var Valeur : Real ) : Boolean ;
Function TraiteLigneOptionEntierLong(Var  L : ShortString ; Option : ShortString ; Var Valeur : LongInt ) : Boolean ;
Function TraiteLigneOptionEntiere( Var L : ShortString ; Option : ShortString ; Var Valeur : Integer ) : Boolean ;
Function TraiteLigneOptionMot( Var L : ShortString ; Option : ShortString ; Var Valeur : Word ) : Boolean ;
Function TraiteLigneOptionDoubleMot( Var L : ShortString ; Option : ShortString ; Var Valeur : DWord ) : Boolean ;
Function TraiteLigneOptionCouleur( Var L : ShortString ; Option : ShortString ; Var Valeur : TColor ) : Boolean ;
Function TraiteLigneOptionOctet( Var L : ShortString ; Option : ShortString ; Var Valeur : Byte ) : Boolean ;
Function TraiteLigneOptionBooleene( Var L : ShortString ; Option : ShortString ; Var Valeur : Boolean ) : Boolean ;
Procedure ChangeOrientation( LeCanvas : TCanvas ; Orientation : Integer ) ;
Procedure AnnuleOrientation( LeCanvas : TCanvas ) ;
Procedure Histogramme( LeCanvas : TCanvas ; X,Y1,Y2 : Integer ; FuiteX, FuiteY : Byte ; Largeur : Integer ; Couleur : TColor ) ;
Function CouleurPeriodique( I : Integer ) : TColor ;
//Function CouleurMoyenne(Couleur1, Couleur2 : Tcolor ) : TColor ;
Function Visionne( N : Tfilename ) : Boolean ;
Function NomDeFichierValide(NomF : PathStr ; LeFichierNeDoitPasExister : Boolean ; AvecMessage : Boolean ) : Boolean ;
Function CopieFichier( Source, destination : ShortString ) : Boolean ;
Function ReelEnFrancais( Valeur : Real ; Monnaie : ShortString  ) : String ;
Function ReelEnEspagnol ( Valeur : Real ; Unite : ShortString  ) : ShortString ;
Function ReelEnAnglais ( Valeur : Real ; Unite : ShortString  ) : ShortString ;
Function StrReel_en_lettres( Valeur : Real ; Monnaie : ShortString ) : String ;
Function ExtraitDate( DateHeure : TdateTime ) : Dates ;
Function DatesVersTDate( Date : Dates ) : Tdate ;
Function ExtraitHeure( DateHeure : TdateTime ) : Heures ;
Function DateEtHeure( DateHeure : TdateTime ) : ShortString ;
Function Duree( DateHeure : TdateTime ) : ShortString ;
//Function Dureems( DateHeure : TdateTime ) : ShortString ;
Function CurrentUser : ShortString ;
Function CreeRepertoire( NomRep : ShortString ) : Boolean ;
Function EnHexadecimal( Valeur : DWord ) : ShortString ;
Function StopAttribut( S : ShortString ) : ShortString ;
Function Inseccable( S : ShortString ) : ShortString ;
Function HauteurDecalee(Y : Integer) : Integer ;
Function  Remplace(Remplacer, Par : ShortString ; Var Texte : String ) : Integer  ;       // DANS STRING
Function  RemplaceA(Remplacer, Par : ShortString ; Var Texte : ShortString )  : Integer  ; // DANS    S h o r t STRING
Function StrDe( Quoi : ShortString ) : ShortString ;
Function StrLe( Quoi : ShortString ; Feminin : Boolean ) : ShortString ;
Function StrDeLe( Quoi : ShortString ; Feminin : Boolean ) : ShortString ;
Function RGB(R,G,B : Byte) : TColor ;
Procedure Delay( Ms : Integer) ;
Function IsValidFileName( S : String ) : Boolean ;
Procedure ValidateFileName( Var S : String ) ;
Function NomFichierValide( S : String ) : String ;
Procedure VersMac( Var S : ShortString ) ;
Function FVersMac( S : ShortString ) : ShortString ;
Function FVersMacA( S : String ) : String ;
Procedure ImprimeGraphicDansCanvas( Canvas : TCanvas ; R : TRect ; Image : TJPegImage ; TypeDeTramage : integer = 1 ; Bitmap : TBitMap = Nil  ) ;
Function Racine( X : Real ; N : Real ) : Real ;
Function Puissance( X : Real ; N : Real ) : Real ;
Function Arrondi( X : Real ; decimale : Byte ) : Real ;
Function VersDates( J, M : Byte ; A : Word ) : Dates ;
function deldir(dir: String): boolean;
Function DernierJourOuvre( d : dates ) : dates ;
Function GetImage( Filename : TFileName ) : TJPegImage ;
procedure Decoupe(CanvasCible : TCanvas ; Largeur : Integer ; Chaine : String ; Var LignesTexte : TableauDeLignes ) ;
Function HTMLVersTXT( Var Chaine : OpenString ) : Integer ;
Function TextHTMLOut(CanvasCible : TCanvas ; X, Y, Largeur : Integer ; Chaine : String ; AvecMarques : Boolean = False ) : integer ;



implementation



Function NomDeFichierCourt( NomF : ShortString) : ShortString ;
Var  NC : PAnsiChar ;
Begin
  GetMem(NC,255) ;
  Result := NomF ;
  GetShortPathName(PansiChar(String(NomF)),NC,255) ;
  Result := ShortString(String(NC) ) ;
  FreeMem(NC,255) ;
End ;



Function TraiteLigneOption(Var  L : ShortString ; Option : ShortString ; Var Valeur : ShortString ) : Boolean ;
Var Ligne : ShortString ;
    PositionDiese : Byte ;
    ValeurDiese : String[6] ;
    Code  : Integer ;
    Octet : Byte ;
Begin
  Option := Majuscule(option) ;
  Ligne := L ;
  Ligne := Majuscule(Ligne) ;
  Result := False ;
  If Pos(Option,Ligne)=1 then                      { STRICTEMENT EGAL }
  if Pos(Ligne[Ord(Option[0])+1],' =')>0 then      {  A L'OPTION !!!  }
  If Pos('=',L)<>0 then
  Begin
    Ligne := Copy(L,Pos('=',L)+1,Length(L)) ;
    ElagueLesEspaces(Ligne) ;
    If Ligne='' then
    Begin
      L := Copy(L,1,Pos('=',L))+' '+Valeur ;
      Valeur := '' ;
      Result := True ;
      EXIT ;
    End ;
    Valeur := Ligne ;
    While Pos('#',Valeur)<>0 do
    Begin
      PositionDiese := Pos('#',Valeur) ;
      ValeurDiese := '0' ;
      Delete(Valeur,PositionDiese,1) ;
      While (PositionDiese<=Length(Valeur)) and (Pos(Copy(Valeur,PositionDiese,1),' ')=0) Do
      Begin
        ValeurDiese := ValeurDiese + Copy(Valeur,PositionDiese,1) ;
        Delete(Valeur,PositionDiese,1) ;
      End ;
      If (PositionDiese<=Length(Valeur)) then Delete(Valeur,PositionDiese,1) ;
      Val(ValeurDiese,Octet,Code) ;
      If Code=0 then System.Insert(Chr(Octet),Valeur,PositionDiese) ;
    End ;
    Result := TRUE ;
  End ;
End ;

Function TraiteLigneOptionString(Var  L : ShortString ; Option : ShortString ; Var Valeur : String ) : Boolean ;
Var Ligne : ShortString ;
    PositionDiese : Byte ;
    ValeurDiese : String[6] ;
    Code  : Integer ;
    Octet : Byte ;
Begin
  Option := Majuscule(option) ;
  Ligne := L ;
  Ligne := Majuscule(Ligne) ;
  Result := False ;
  If Pos(Option,Ligne)=1 then                      { STRICTEMENT EGAL }
  if Pos(Ligne[Ord(Option[0])+1],' =')>0 then      {  A L'OPTION !!!  }
  If Pos('=',L)<>0 then
  Begin
    Ligne := Copy(L,Pos('=',L)+1,Length(L)) ;
    ElagueLesEspaces(Ligne) ;
    If Ligne='' then
    Begin
      L := Copy(L,1,Pos('=',L))+' '+Valeur ;
      Valeur := '' ;
      Result := True ;
      EXIT ;
    End ;
    Valeur := Ligne ;
    While Pos('#',Valeur)<>0 do
    Begin
      PositionDiese := Pos('#',Valeur) ;
      ValeurDiese := '0' ;
      Delete(Valeur,PositionDiese,1) ;
      While (PositionDiese<=Length(Valeur)) and (Pos(Copy(Valeur,PositionDiese,1),' ')=0) Do
      Begin
        ValeurDiese := ValeurDiese + Copy(Valeur,PositionDiese,1) ;
        Delete(Valeur,PositionDiese,1) ;
      End ;
      If (PositionDiese<=Length(Valeur)) then Delete(Valeur,PositionDiese,1) ;
      Val(ValeurDiese,Octet,Code) ;
      If Code=0 then System.Insert(Chr(Octet),Valeur,PositionDiese) ;
    End ;
    Result := TRUE ;
  End ;
End ;



Function TraiteLigneOptionReelle( Var  L : ShortString ; Option : ShortString ; Var Valeur : Real ) : Boolean ;
Var
    Ligne : ShortString ;
    Code : Integer ;
Begin
  Str(Valeur:20:3,Ligne) ;
  ElagueLesESpaces(Ligne) ;
  Result := TraiteLigneOption(L,Option,Ligne) ;
  If Ligne<>'' then
  Begin
    Val(Ligne,Valeur,Code) ;
    If Code<>0 then Result := False ;
  End ;
End ;


Function TraiteLigneOptionEntiere( Var  L : ShortString ; Option : ShortString ; Var Valeur : Integer ) : Boolean ;
Var
    Ligne : ShortString ;
    Code : Integer ;
Begin
  Str(Valeur:20,Ligne) ;
  ElagueLesESpaces(Ligne) ;
  Result := TraiteLigneOption(L,Option,Ligne) ;
  If Ligne<>'' then
  Begin
    Val(Ligne,Valeur,Code) ;
    If Code<>0 then Result := False ;
  End ;
End ;

Function TraiteLigneOptionEntierLong(Var  L : ShortString ; Option : ShortString ; Var Valeur : LongInt ) : Boolean ;
Var
    Ligne : ShortString ;
    Code : Integer ;
Begin
  Ligne := '' ;
  Result := TraiteLigneOption(L,Option,Ligne) ;
  If Ligne<>'' then
  Begin
    Val(Ligne,Valeur,Code) ;
    If Code<>0 then Result := False ;
  End ;
End ;

Function TraiteLigneOptionMot(Var  L : ShortString ; Option : ShortString ; Var Valeur : Word ) : Boolean ;
Var
    Ligne : ShortString ;
    Code : Integer ;
Begin
  Str(Valeur:20,Ligne) ;
  ElagueLesESpaces(Ligne) ;
  Result := TraiteLigneOption(L,Option,Ligne) ;
  If Ligne<>'' then
  Begin
    Val(Ligne,Valeur,Code) ;
    If Code<>0 then Result := False ;
  End ;
End ;

Function TraiteLigneOptionDoubleMot(Var  L : ShortString ; Option : ShortString ; Var Valeur : DWord ) : Boolean ;
Var
    Ligne : ShortString ;
    Code : Integer ;
Begin
  Str(Valeur:20,Ligne) ;
  ElagueLesESpaces(Ligne) ;
  Result := TraiteLigneOption(L,Option,Ligne) ;
  If Ligne<>'' then
  Begin
    Val(Ligne,Valeur,Code) ;
    If Code<>0 then Result := False ;
  End ;
End ;

Function TraiteLigneOptionCouleur(Var  L : ShortString ; Option : ShortString ; Var Valeur : TColor ) : Boolean ;
Var
    Ligne : ShortString ;
    Code : Integer ;
Begin
  Str(Valeur:20,Ligne) ;
  ElagueLesESpaces(Ligne) ;
  Result := TraiteLigneOption(L,Option,Ligne) ;
  If Ligne<>'' then
  Begin
    Val(Ligne,Valeur,Code) ;
    If Code<>0 then Result := False ;
  End ;
End ;

Function TraiteLigneOptionOctet(Var  L : ShortString ; Option : ShortString ; Var Valeur : Byte ) : Boolean ;
Var
    Ligne : ShortString ;
    Code : Integer ;
Begin
  Str(Valeur:20,Ligne) ;
  ElagueLesESpaces(Ligne) ;
  Result := TraiteLigneOption(L,Option,Ligne) ;
  If Ligne<>'' then
  Begin
    Val(Ligne,Valeur,Code) ;
    If Code<>0 then Result := False ;
  End ;
End ;

Function TraiteLigneOptionBooleene(Var  L : ShortString ; Option : ShortString ; Var Valeur : Boolean ) : Boolean ;
Var
    Ligne : ShortString ;
Begin
  If Valeur then Ligne := 'ON' else Ligne := 'OFF' ;
  Ligne := '' ;
  Result := TraiteLigneOption(L,Option,Ligne) ;
  If Ligne<>'' then
  Begin
    Ligne := Majuscule(Ligne) ;
    If Pos('ON',Ligne)=1 then Valeur := True Else
    If Pos('OFF',Ligne)=1 then Valeur := False Else Result := False ;
  End ;
End ;









Function SansEspaces( S : ShortString ) : ShortString ;
Begin
  While Copy(S,1,1)=' ' do delete(S,1,1) ;
  While S[ord(S[0])]=' ' do delete(S,ord(S[0]),1) ;
  Result := S ;
End ;



Function Majuscule( S : String ) : String ; OverLoad ;
var I : Integer ;
Begin
  If S='' then
  Begin
    Result := '' ;
    EXIT ;
  End ;
  For I:= 1 to Length(S) do
  Begin
    Case S[I] Of
      '','','' : S[I] := 'A' ;
      '' : S[I] := 'C' ;
      '','','','' : S[I] := 'E' ;
      '','' : S[I] := 'I' ;
      '','' : S[I] := 'O' ;
      '','','' : S[I] := 'U' ;
    Else S[I] := UpCase(S[I]) ;
    End ;
  End ;
  Majuscule := S ;
End ;

Function Majuscule( S : ShortString ) : ShortString ;OverLoad ;
var I : Byte ;
Begin
  If S='' then
  Begin
    Result := '' ;
    EXIT ;
  End ;
  For I:= 1 to Length(S) do
  Begin
    Case S[I] Of
      '','','' : S[I] := 'A' ;
      '' : S[I] := 'C' ;
      '','','','' : S[I] := 'E' ;
      '','' : S[I] := 'I' ;
      '','' : S[I] := 'O' ;
      '','','' : S[I] := 'U' ;
    Else S[I] := UpCase(S[I]) ;
    End ;
  End ;
  Majuscule := S ;
End ;

Function Minuscule( S : String ) : String ;OverLoad ;
var I : Integer ;
Begin
  If S='' then
  Begin
    Result := '' ;
    EXIT ;
  End ;
  For I:= 1 to Length(S) do
  Begin
    Case S[I] Of
        'A'..'Z' : S[I] := Chr(Ord(S[I])+32) ;
    End ;
  End ;
  Result  := S ;
End ;


Function Minuscule2( S : String ) : String ;
Var I , J : Integer ;
Begin
  If S='' then
  Begin
    Result := '' ;
    EXIT ;
  End ;
  S := Minuscule(S) ;
  S[1] := UpCase(S[1]) ;
  For I := 1 to Length(S) do If S[i] = '.' then
  Begin
    J := I + 1 ;
    If J <= Length(S) then If S[J] = ' ' then Inc(J) ;
    If J <= Length(S) then S[J] := UpCase(S[J]) ;
  End ;
  rESULT := s ;
End ;
Function Minuscule( S : ShortString ) : ShortString ;OverLoad ;
var I : Byte ;
Begin
  For I:= 1 to Length(S) do
  Begin
    Case S[I] Of
        'A'..'Z' : S[I] := Chr(Ord(S[I])+32) ;
    End ;
  End ;
  Minuscule := S ;
End ;

Function AvecArticle( S : ShortString ; Article : TStr8 ) : ShortString ;
Var Feminin : Boolean ;
Begin
  Feminin := (POS('MODIFICATION',Majuscule(S))=1) Or (POS('SAISIE',Majuscule(S))=1) ;
  If Article<>'LE'
  then If Feminin then Result := 'une '+S
       else Result := 'un '+S
  else If Pos(S[1],'AEIOUYaeiou')>0
       then Result := 'l'''+S
       else If Feminin then Result := 'la '+S
       else Result := 'le '+S ;

End ;

Function Pluriel( S : ShortString ) : ShortString ;
var
    EnMajuscule : ShortString ;
    ToutEnMajuscule : Boolean ;
    S2 : ShortString ;
Begin
  If (Pos('(',S)>0) and (Pos(')',S)>Pos('(',S)+1) then
  Begin
    S2 := Copy(S,Pos('(',S)+1,Pos(')',S)-Pos('(',S)-1) ;
    Delete(S,Pos('(',S)+1,Length(S2) ) ;
    S := Pluriel(S) ;
    Insert(S2,S,Pos('()',S)+1) ;
  End ;
  If LangueUtilisee and $FF = $A then langue := 1 ;
  Case Langue of
    0 : Begin
      If S='En-tte' then
      Begin
        Result := 'En-ttes' ;
        EXIT ;
      End ;
      If S='' then
      Begin
        Pluriel := '' ;
        EXIT ;
      End ;
      If Pos(' ',S)>0
      then Result := Pluriel(Copy(S,1,Pos(' ',S)-1))
      else If Pos('-',S)>0
      then Result := Pluriel(Copy(S,1,Pos('-',S)-1))
      else Begin
        Result := S ;
        EnMajuscule := Majuscule(S) ;
        ToutEnMajuscule := (EnMajuscule = Result) ;
        If EnMajuscule='OEIL' then Result := 'yeux' else
        If EnMajuscule='AIL' then Result := 'aulx' else
        If EnMajuscule='UNMOTAUSINGULIER' then Result := 'lemotaupluriel' else
        If Pos(Result[Ord(Result[0])],'zZxsXS')>0 then Exit
        else If (EnMajuscule='LANDAU')Or
                (EnMajuscule='SARRAU')Or
                (EnMajuscule='BLEU')Or
                (EnMajuscule='PNEU')Or
                (EnMajuscule='BAL')Or
                (EnMajuscule='CARNAVAL')Or
                (EnMajuscule='CHACAL')Or
                (EnMajuscule='FESTIVAL')Or
                (EnMajuscule='RECITAL')Or
                (EnMajuscule='REGAL')  then Result := Result + 's'
        Else If (EnMajuscule='BIJOU')Or
                (EnMajuscule='CAILLOU')Or
                (EnMajuscule='CHOU')Or
                (EnMajuscule='GENOU')Or
                (EnMajuscule='HIBOU')Or
                (EnMajuscule='JOUJOU')Or
                (EnMajuscule='POU') Or
                ((EnMajuscule[0]>#2)AND(Copy(EnMajuscule,Ord(EnMajuscule[0])-1,2)='AU')) Or
                ((EnMajuscule[0]>#2)AND(Copy(EnMajuscule,Ord(EnMajuscule[0])-1,2)='EU'))
                                        then Result := Result + 'x'
        Else If (EnMajuscule='BAIL')Or
                (EnMajuscule='CORAIL')Or
                (EnMajuscule='EMAIL')Or
                (EnMajuscule='SOUPIRAIL')Or
                (EnMajuscule='TRAVAIL')Or
                (EnMajuscule='VANTAIL')Or
                (EnMajuscule='VITRAIL')
                                        then Result := Copy(Result,1,Ord(Result[0])-3)+'aux'
        Else If ((EnMajuscule[0]>#2)AND(Copy(EnMajuscule,Ord(EnMajuscule[0])-1,2)='AL'))
                                        then Result := Copy(Result,1,Ord(Result[0])-1)+'ux'
        Else Result := Result + 's' ;
        If ToutEnMajuscule Then Result := Majuscule(Result) ;
      End ;
      If Pos(' ',S)>0 then
      If (Pos(' A ',Majuscule(S))>0) or
         (Pos(' DE ',Majuscule(S))>0) or
         (Pos(' D''',Majuscule(S))>0)  then Result := Result+Copy(S,Pos(' ',S),30)
      else Result := Result+' '+Pluriel(Copy(S,Pos(' ',S)+1,30))
      else If Pos('-',S)>0 then Result := Result+Copy(S,Pos('-',S),30) ;
    End ;
    1 : Begin // Espaol
      If S='' then
      Begin
        Pluriel := '' ;
        EXIT ;
      End ;
      If Pos(' ',S)>0
      then Result := Pluriel(Copy(S,1,Pos(' ',S)-1))
      else If Pos('-',S)>0
      then Result := Pluriel(Copy(S,1,Pos('-',S)-1))
      else Begin
        Result := S ;
        EnMajuscule := Majuscule(S) ;
        ToutEnMajuscule := (EnMajuscule = Result) ;
        If Pos(EnMajuscule[Ord(EnMajuscule[0])],'aAeEiIoOuU')>0 then Result := Result+ 's' else Result := Result + 'es' ;
        If ToutEnMajuscule Then Result := Majuscule(Result) ;
      End ;
    End ;
  End ; { Case Langue }
End ;


Function Syntaxique( S : ShortString ) : ShortString ;
Var R : ShortString ;
    I : Integer ;
Begin
  {  exclusion des accents }
  S := Majuscule(S) ;
  S := Minuscule(S) ;
  { Remplacement des ' et espaces et autres sparateurs }
  R := ''' ,;:!/.?-+/=(){"&}][|`^' ;
  For I := 1 to Length(R)
  Do While Pos(R[i],S)<>0 Do S[Pos(R[i],S)] := '_' ;
  { Effacement de tout caractre NON majuscules/minuscules/chiffre/'_' }
  S[1] := UpCase(S[1]) ;
  For I := 1 to Length(S) do If S[I]='_' then S[i+1] := UpCase(S[i+1]) ;
  R := Majuscules+Minuscules+Chiffres+'_' ;
  For I := 1 to Length(S) Do
  If Pos(S[i],R)=0 Then S[i] := '_' ;
  Syntaxique := S ;
End ;

Function Fichique( S : ShortString ) : ShortString ;
Var R : ShortString ;
    I : Integer ;                   // inutilis au 16 juin 2005 ???
Begin
  { Remplacement des caractres interdits }
  R := Interdits ;
  For I := 1 to Length(R) do RemplaceA(R[i],'-',S) ;
  Fichique := S ;
End ;



Function CouleurEnFrancais( C : TColor ) : TString30 ;
Begin
  Case C Of
    { Couleur }
    clAqua : CouleurEnFrancais := 'Bleu ciel' ;
    clBlack : CouleurEnFrancais := 'Noir' ;
    clBlue : CouleurEnFrancais := 'Bleu' ;
    {clDkGray : CouleurEnFrancais := 'Gris fonc' = GRIS;}
    clFuchsia : CouleurEnFrancais := 'Magenta' ;
    clGray : CouleurEnFrancais := 'Gris' ;
    clGreen : CouleurEnFrancais := 'Vert' ;
    clLime : CouleurEnFrancais := 'Citron' ;
    {clltGray : CouleurEnFrancais := 'Gris clair' = ARGENT ;}
    clMaroon : CouleurEnFrancais := 'Acajou' ;
    clNavy : CouleurEnFrancais := 'Marine' ;
    clOlive : CouleurEnFrancais := 'Olive' ;
    clPurple : CouleurEnFrancais := 'Pourpre' ;
    clRed : CouleurEnFrancais := 'Rouge' ;
    clSilver : CouleurEnFrancais := 'Argent' ;
    clTeal : CouleurEnFrancais := 'Vert de gris' ;
    clWhite : CouleurEnFrancais := 'Blanc' ;
    clYellow : CouleurEnFrancais := 'Jaune' ;
    clNone : CouleurEnFrancais := 'incolore' ;
    clDefault : CouleurEnFrancais := 'Couleur par dfaut' ;

    
  End { case } ;
End ;

Function StyleEnFrancais( Style : TFontStyles ) : ShortString ;
Begin
  { fsBold, fsItalic, fsUnderline, fsStrikeOut }
  Result := '' ;
  If fsItalic in Style Then Result := 'Italique' ;
  If fsBold in Style Then Result := Result + ' Gras' ;
  If fsUnderline in Style Then Result := Result + ' Soulign' ;
  If fsStrikeOut in Style Then Result := Result + ' Barr' ;
  ElagueLesEspaces(Result) ;
  While Pos(' ',Result)<>0 Do Result[Pos(' ',Result)] := '/' ;
End ;

Function PoliceEnFrancais( Police : TFont ) : ShortString ;
Begin
  Result := Police.Name + ' ' + SansEspaces(StrNumero(Police.Size))+'pts' ;
  If Police.Style<>[] then Result := Result + ' ' +StyleEnFrancais(Police.Style) ;
  If Police.Color<>clBlack then Result := Result + ' ' + CouleurEnFrancais(Police.Color) ;
End ;


Function StrNumero( V : DWord ) : TString30 ;
Var Num : TString30 ;
Begin
  Str(Round(V),Num) ;
  StrNumero := Num ;
End ;
Function StrEntier( V : Integer ) : TString30 ;
Var Num : TString30 ;
Begin
  Str(Round(V),Num) ;
  StrEntier := Num ;
End ;

Function StrOctet( V : Byte ) : TString30 ;
Var Num : TString30 ;
Begin
  Str(Round(V),Num) ;
  StrOctet := Num ;
End ;




Function AujourdHui : Dates ;
var
  DateHeure : TDateTime ;
  i : Integer  ;
begin
  DateHeure := Date ;
  If Round(Double(DateHeure))<>Round(Double(ExDateHeure)) then
  begin
    Result.Jour := 30 ;
    Result.Mois := 12 ;
    Result.Annee := 1899 ;
    For I := 0 to Round(Double(DateHeure)) do Lendemain(Result) ;
    ExAujourDhui := Result ;
  End Else Result := ExAujourDhui ;
  ExDateHeure := DateHeure ;
end;

procedure Veille(Var  Date : Dates ; Nbr : Word = 1 );
begin
  While Nbr>0 Do
  Begin
    Dec(Nbr) ;
    Dec(Date.Jour);
    If Date.jour=0 then
    Begin
      Dec(Date.mois) ;
      If Date.Mois=0 then
      Begin
        Dec(Date.annee) ;
        Date.Mois := 12 ;
      End ;
      case Date.Mois of
        1,3,5,7,8,10,12 : Date.Jour := 31 ;
        4,6,9,11        : Date.Jour := 30 ;
        2  :if (Date.Annee) mod 4 = 0
        then Date.Jour := 29
        else Date.Jour := 28 ;
      end;
    end;
  End ;
end;    {     Veille -------> Dcremente une  Date   }
procedure Lendemain(Var  Date : Dates ; Nbr : Word = 1 );
begin
  While Nbr>0 Do
  Begin
    Dec(Nbr) ;
    inc(Date.Jour);
    case Date.Mois of
      1,3,5,7,8,10,12 :if Date.Jour >31 then
      begin
        inc(Date.Mois);
        Date.Jour:=1;
      end;
      4,6,9,11        :if Date.Jour >30 then
      begin
        inc(Date.Mois);
        Date.Jour:=1;
      end;

      2               :if (Date.Annee) mod 4 = 0 then
      if  Date.Jour >29 then
      begin
        inc(Date.Mois);
        Date.Jour:=1;
      end else
      else if  Date.Jour >28 then
      begin
        inc(Date.Mois);
        Date.Jour:=1;
      end;
    end;
    if Date.Mois >12 then
    begin
      inc(Date.Annee);
      Date.Mois:=1;
    end;
  End ;
end;    {     Lendemain -------> incremente une  Date   }

Function QuelMois(Mois:Byte): ShortString ;
Begin
  Case Mois Of
    1 :  QuelMois := 'Janvier'   ;
    2 :  QuelMois := 'Fvrier'   ;
    3 :  QuelMois := 'Mars'      ;
    4 :  QuelMois := 'Avril'     ;
    5 :  QuelMois := 'Mai'       ;
    6 :  QuelMois := 'Juin'      ;
    7 :  QuelMois := 'Juillet'   ;
    8 :  QuelMois := 'Aot'      ;
    9 :  QuelMois := 'Septembre' ;
    10 : QuelMois := 'Octobre'   ;
    11 : QuelMois := 'Novembre'  ;
    12 : QuelMois := 'Dcembre'  ;
  Else QuelMois := 'Indfini' ;
  End ;
End ;

Function QuelMoiss(Mois:Moiss): ShortString ;
Begin
  If Mois.Annee=0 then
  If Mois.Mois=0 then Result := 'tous les mois de toutes les annes'
  else Result := 'tous les mois de '+QuelMois(Mois.mois)+' de toutes les annes'
  Else If Mois.Mois=0 then Result := 'tous les mois de '+StrNumero(Mois.Annee)
  else Result := QuelMois(Mois.mois)+' de '+StrNumero(Mois.Annee) ;
End ;

Function MoisStr( S : ShortString ) : Moiss ;
Begin
   If Pos('Janvier',S)=1 then Result.mois := 1 ;
   If Pos('Fvrier',S)=1 then Result.mois := 2 ;
   If Pos('Mars',S)=1 then Result.mois := 3 ;
   If Pos('Avril',S)=1 then Result.mois := 4 ;
   If Pos('Mai',S)=1 then Result.mois := 5 ;
   If Pos('Juin',S)=1 then Result.mois := 6 ;
   If Pos('Juillet',S)=1 then Result.mois := 7 ;
   If Pos('Aot',S)=1 then Result.mois := 8 ;
   If Pos('Septembre',S)=1 then Result.mois := 9 ;
   If Pos('Octobre',S)=1 then Result.mois := 10 ;
   If Pos('Novembre',S)=1 then Result.mois := 11 ;
   if Pos('Dcembre',S)=1 then Result.mois := 12 ;
   Delete(S,1,Pos(' ',S)) ;
   Result.Annee := WordStr(S) ;
end ;

Function NomDeJour( J : Integer ) : Shortstring ;
Begin
  Case J of
    1 : Result := 'Dimanche' ;
    2 : Result := 'Lundi' ;
    3 : Result := 'Mardi' ;
    4 : Result := 'Mercredi' ;
    5 : Result := 'Jeudi' ;
    6 : Result := 'Vendredi' ;
    7 : Result := 'Samedi';
    else Result := 'indfini' ;
  End ;
End ;

Function JourDeSemaine( Date : Dates ) : ShortString ;
Var JDS : Integer ;
    D1 : Dates ;
    R : Real ;
Begin
  D1.Jour := 30 ;
  D1.mois := 12 ;
  D1.Annee := 1899 ;
  R := Ecart(D1,Date) ;
  JDS := Round(R-2) mod 7 ;
  Result := NomDeJour(JDS+1) ;
End ;


Function BooleenStr(S : ShortString ; Var Car : Char ) : Boolean ;
Begin
  S := Majuscule(S) ;
  If (S='TRUE') or (S='VRAI') or (S='O') or (S='OUI') or (S='YES') or (S='1')then
  Begin
    Result := True ;
    Car := 'O' ;
  End Else
  If (S='FALSE') or (S='FAUX') or (S='N') or (S='NON') or (S='NO') or (S='0')then
  Begin
    Result := False ;
    Car := 'N' ;
  End Else
  Begin
    Result := False ;
    Car := '?' ;
  End ;
End ;

Function DateEnFrancais( D : Dates) : ShortString ;
Var S : String[18] ;
Begin
  If D.Jour<>0 then S := StrReel(D.Jour,2,0) +' ' Else S := '' ;
  If D.Mois<>0 then S := S + QuelMois(D.Mois) + ' ' ;
  If D.Annee<>0 then S := S+ StrNumero(D.Annee) ;
  Result := S ;
End ;

Function StrDate( D : Dates) : TStr12 ;
Begin
  If ModeZero Then
  Begin
    Result := StrNumero(D.Annee) ;
    While Length(Result) < 4 Do Result := '0'+Result ;
    Result := SansEspaces(StrReel(D.Mois,2,0))+ SeparateurDeDate+ Result ;
    While Length(Result) < 7 Do Result := '0'+Result ;
    Result := SansEspaces(StrReel(D.Jour,2,0))+ SeparateurDeDate+ Result ;
    While Length(Result) < 10 Do Result := '0'+Result ;
  End Else Result := StrReel(D.Jour,2,0)+SeparateurDeDate+StrReel(D.Mois,2,0)+ SeparateurDeDate+ StrNumero(D.Annee) ;
End ;

Function StrDateSansEspace( D : Dates) : TStr12 ;
Begin
  Result := StrDate(D) ;
  While Pos(' ',Result)>0 do Delete(Result,Pos(' ',Result),1) ;
End ;

Function DatesEgales( D1, D2 : Dates ; Comparaison : Boolean ) : Boolean ;
Begin
  Result := (    (Comparaison and (D1.Jour = 0) )     Or (D1.Jour=D2.Jour)       )
        And (    (Comparaison and (D1.Mois = 0) )     Or (D1.Mois=D2.Mois)       )
        And (    (Comparaison and (D1.Annee = 0) )   Or (D1.Annee=D2.Annee)     ) ;
        { le 17 mars 2005
  Result := (    (Comparaison and ((D1.Jour = 0) Or (D2.Jour=0)))     Or (D1.Jour=D2.Jour)       )
        And (    (Comparaison and ((D1.Mois = 0) Or (D2.Mois=0)))     Or (D1.Mois=D2.Mois)       )
        And (    (Comparaison and ((D1.Annee = 0) Or (D2.Annee=0)))   Or (D1.Annee=D2.Annee)     ) ;
        }
End ;

function Croissant(Date1,Date2:Dates):Boolean;
var Bol : Boolean ;
begin
  {  le 17 mars 2005 !!!!!
  If Date1.Jour=0 then Date1.Jour := Date2.Jour ;
  If Date2.Jour=0 then Date2.Jour := Date1.Jour ;
  If Date1.Mois=0 then Date1.Mois := Date2.Mois ;
  If Date2.Mois=0 then Date2.Mois := Date1.Mois ;
  If Date1.Annee=0 then Date1.Annee := Date2.Annee ;
  If Date2.Annee=0 then Date2.Annee := Date1.Annee ;
  }
  if Date1.annee>Date2.annee then Bol :=False
         else if Date1.annee<Date2.annee then Bol :=True
                     else if Date1.Mois<Date2.Mois then Bol :=True
                                   else if Date1.Mois>Date2.Mois then Bol :=False
                                                 else if Date1.Jour<Date2.Jour then Bol :=True
                                                             else if Date1.Jour>Date2.Jour then Bol :=False
                                                                          else Bol :=True;
  Croissant := Bol ;
end;


Function StrReel( Valeur : Real ; L,D : Byte ) : PathStr ;
Var Chaine : String[25] ;
    R : Real ;
Begin
  If D>6 then D := 6 ;
  If (D=0) Then If L>16 Then L := 16
   Else Else If L>17 then L := 17 ;
  R := Abs(Valeur) ;
  If R< 0.0000001 then Valeur := 0 ;
  Str(Valeur:14+D:D,Chaine) ;
  If D=0 then
  Begin
    Chaine := Copy(chaine,2,19) ;
    Chaine := Chaine +'.000000'
  End else Chaine := Chaine + Copy('000000',1,6-D) ;
  Chaine[14] := Virgule[1] ;
  If AvecSeparateurDecimales then System.Insert(SeparateurMillier,Chaine,18) ;
  System.Insert(SeparateurMillier,Chaine,11) ;
  System.Insert(SeparateurMillier,Chaine,8) ;
  System.Insert(SeparateurMillier,Chaine,5) ;
  If D=0 then Result := Copy(Chaine,17-L,L) Else Result := Copy(Chaine,18-L+D,L) ;
End ;
Function StrCompte( Valeur : Real ; L,D : Byte ; SansTrait : Boolean = False) : PathStr ;
Var Trait : Char ;
Begin
  If SansTrait then Trait := ' ' else Trait := '|' ;
  If Valeur<0 Then
    Result := Copy('             ',1,L)+Trait+StrReel(Abs(Valeur),L,D) Else Result := StrReel(Valeur,L,D)+Trait+Copy('             ',1,L) ;
End ;

Procedure ElagueLesEspaces( Var Chaine : ShortString ) ;
Begin
  While Copy(Chaine,1,1)=' ' do Delete(Chaine,1,1) ;
  While Copy(Chaine,Length(Chaine),1)=' ' do Delete(Chaine,Length(Chaine),1) ;
End ;

Procedure ElagueLesEspacesS( Var Chaine : String ) ;
Begin
  While Copy(Chaine,1,1)=' ' do Delete(Chaine,1,1) ;
  While Copy(Chaine,Length(Chaine),1)=' ' do Delete(Chaine,Length(Chaine),1) ;
End ;


Function StrCourt( Valeur : Real ; Decimales : Byte ) : PathStr ;
Var S :String[16] ;
Begin
  If NonNul then If Valeur=0 then
  Begin
    Result := '' ;
    Exit ;
  End ;
  S := StrREel(Valeur,16,Decimales) ;
  ElagueLesEspaces(S) ;
  StrCourt := S ;
End ;
Function StrCourtInseccable( Valeur : Real ; Decimales : Byte ) : PathStr ;
Begin
  Result := Inseccable(StrCourt(Valeur,Decimales)) ;
End ;
Function EnAnsi( ChaineAscii : ShortString ) : ShortString ;
Begin
  //{$IFDEF MSWINDOWS}
  ChaineAscii := ChaineAscii+#0 ;
  OemToAnsi(Addr(ChaineAscii[1]),Addr(ChaineAscii[1])) ;
  Dec(ChaineAscii[0]) ;
  //{$ ENDIF}
  EnAnsi := ChaineAscii ;
End ;

Function EnAscii( ChaineAnsi : ShortString ) : ShortString ;
Begin
  //{$IFDEF MSWINDOWS}
  ChaineAnsi := ChaineAnsi+#0 ;
  AnsiToOem(Addr(ChaineAnsi[1]),Addr(ChaineAnsi[1])) ;
  Dec(ChaineAnsi[0]) ;
  //{$ ENDIF}
  EnAscii := ChaineAnsi ;
End ;

Procedure Ansi( Var ChaineAscii : ShortString ) ;
Begin
  ChaineAscii := EnAnsi(ChaineAscii) ;
End ;

Function BoiteDeMessage( LeTitre, LeMessage : String ; 
                         TypeDlg : TMsgDlgType = mtInformation ;
                         Boutons : TMsgDlgButtons = [mbOk] ;
                         X : Integer = -1 ; Y : Integer = -1  ) : TMsgDlgBtn ;
Var  S : String ;
     R : Word ;
Begin
  BoiteDeMessage := mbOk ;
  If Application=Nil then Exit ;
  If CriterePos('Attention',LeTitre)>0  then TypeDlg := mtWarning ;
  If CriterePos('ERREUR',LeTitre)>0 then TypeDlg := mtError ;
  S := application.title ;
  application.title := LeTitre ;
  If CriterePos(copy(LeTitre,1,30),LeMessage)=0 then LeMessage := Letitre+#13#13+LeMessage ;
  R := MessageDlg(LeMessage,TypeDlg,Boutons,0) ;
  Case R Of
    mrOk       : Result := mbOK       ;
    mrCancel   : Result := mbCancel   ;
    mrYes      : Result := mbYes      ;
    mrNo       : Result := mbNo       ;
    mrAbort    : Result := mbAbort    ;
    mrRetry    : Result := mbRetry    ;
    mrIgnore   : Result := mbIgnore   ;
    //{$IFDEF MSWINDOWS}
    mrAll      : Result := mbAll      ;
    mrNoToAll  : Result := mbNoToAll  ;
    MrYesToAll : Result := mbYesToAll ;
    //{$ ENDIF}
  End ;
  application.title := S ;
End ;

Function Confirmation( Question : String ) : Boolean ;
Begin
  Result := (BoiteDeMessage('',Question,mtConfirmation,[MbYes,mbNo])=mbYes) ;
End ;

Procedure FermeLeFichier( Fichier : TFichier ) ;
Begin
  CloseHandle(Fichier) ;
End ;


Function CreeFichier( NomDuFichier : ShortString ) : TFichier ;
Begin
  Result := CreateFile(PChar(String(NomDuFichier+#0)), Generic_Write or Generic_Read,FILE_SHARE_READ or FILE_SHARE_Write,nil, CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL, 0) ;
End ;


Function OuvreFichier( NomDuFichier : ShortString ) : TFichier ;
Begin
  Result := CreateFile(PChar(String(NomDuFichier+#0)), Generic_Write or Generic_Read,FILE_SHARE_READ or FILE_SHARE_Write,nil, OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL, 0) ;

End ;
Function OuvreEnLecture( NomDuFichier : ShortString ) : TFichier ;
Begin
  Result := CreateFile(PChar(String(NomDuFichier+#0)), Generic_Read,FILE_SHARE_READ or FILE_SHARE_Write,nil, OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL, 0) ;
End ;
Function OuvreEnEcriture( NomDuFichier : ShortString ) : TFichier ;
Begin
  Result := CreateFile(PChar(String(NomDuFichier+#0)), Generic_Write or Generic_Read,FILE_SHARE_READ ,nil, OPEN_ALWAYS,FILE_ATTRIBUTE_NORMAL, 0) ;
End ;

Function TailleDuFichier( Fichier : TFichier ) : DWord ;
begin
  Result := GetFileSize(fichier, 0);
End ;

Procedure PositionneFichier( Fichier : TFichier ; Position : Integer ; Relatif : integer = 0 ) ;
Begin
  Case Relatif of
    0 : Relatif := File_Begin ;
    1 : Relatif := File_current ;
    2 : Relatif := File_End ;
  End ;
  SetFilePointer(fichier, Position ,Nil, Relatif ) ;
end;
Procedure PositionneFichierAlafin( Fichier : TFichier ) ;
Begin
  PositionneFichier(Fichier,TailleDuFichier(Fichier)) ;
End ;
Procedure ReculePointeurFichier( Fichier : TFichier ; TailleRecord : Integer ) ;
Begin
  SetFilePointer(fichier, -1*TailleRecord , Nil, FILE_Current) ;
end;
Function EcritFichier( Fichier : TFichier ; Var Fiche : Fiches ; TailleRecord : DWord ) : Boolean ;
Begin
  Result := (FileWrite(Fichier,Fiche[0],TailleRecord)=TailleRecord) ;
end;


Function LitFichier( Fichier : TFichier ; Var Fiche : Fiches ; TailleRecord : DWord ) : Boolean ;
Var UnDWORD : DWord ;
Begin
  UnDWORD := FileRead(Fichier,Fiche[0],TailleRecord) ;
  Result := (UnDWORD=TailleRecord) ;
end;


Function PositionDuFichier( Fichier : TFichier ) : DWord ;
Begin
    Result := SetFilePointer(Fichier, 0, nil, FILE_CURRENT);
End ;
Function VerrouilleFichier( Fichier : TFichier ; Position, TailleRecord, NbrEnregistrement : Cardinal ) : Boolean ;
Begin
  Result := LockFile(Fichier,Position,0,TailleRecord * NbrEnregistrement,0) ;
End ;
Function DeVerrouilleFichier( Fichier : TFichier ; Position, TailleRecord, NbrEnregistrement : Cardinal ) : Boolean ;
Begin
  Result := UnLockFile(Fichier,Position,0,TailleRecord * NbrEnregistrement,0) ;
End ;

Procedure InsertionFichier(Fichier : TFichier ; Position : DWord ; Fiche : Fiches ; Taille : DWord ; NomDuFichier : ShortString ) ;
Var Pointeur : Pointer ;
    FinF : DWord ;
Begin
  FinF := TailleDuFichier( Fichier ) ;
  Position := Position * Taille ;
  Pointeur := Nil ;
  If Position <> FinF then
  Begin
    GetMem(Pointeur,FinF-Position) ;
    PositionneFichier( Fichier,Position) ;

    If Not(LitFichier(Fichier,Fiches(Pointeur),FinF-Position)) then
    Begin
      BoiteDeMessage('INCIDENT sur le FICHIER "'+NomDuFichier+'"','Veuillez communiquer au 04 90 46 96 23 que l''incident "INSERTION FICHIER / LECTURE BLOCK" vient de se produire. Cet incident n''a aucune gravit. Il ncessite nanmoins que vous finissiez le travail en cours puis que vous arrtiez '+Application.MainForm.Caption+' quitte  le relancer pour continuer votre travail') ;
      Historique('******* DDU.InsertionFichier INCIDENT sur le FICHIER "'+NomDuFichier+'" : LECTURE VOULUE<>OBTENUE') ;
    End ;
  End ;
  PositionneFichier(Fichier,Position) ;
  If Not(EcritFichier(Fichier,Fiche,Taille)) then
  Begin
    BoiteDeMessage('INCIDENT sur le FICHIER "'+NomDuFichier+'"',
    'Veuillez communiquer au 04 90 46 96 23 que l''incident "INSERTION FICHIER / ECRITURE" vient de se produire. '#13+
    'Cet incident n''a aucune gravit. Il ncessite nanmoins que vous finissiez le travail en cours puis que vous '#13+
    'arrtiez '+Application.MainForm.Caption+' quitte  le relancer pour continuer votre travail') ;
    Historique('******* DDU.InsertionFichier INCIDENT sur le FICHIER "'+NomDuFichier+'" : ECRITURE VOULUE<>OBTENUE') ;
  End ;
  If Position <> FinF then
  Begin
    If Not(EcritFichier(Fichier,Fiches(Pointeur),FinF-Position)) then
    Begin
      BoiteDeMessage('INCIDENT sur le FICHIER "'+NomDuFichier+'"',
                     'Veuillez communiquer au 04 90 46 96 23 que '#13+
                     'l''incident "INSERTION FICHIER / ECRITURE BLOCK" vient de se produire.'#13+
                     'Cet incident n''a aucune gravit.'#13+
                     'Il ncessite nanmoins que vous finissiez le travail en cours'#13+
                     'puis que vous arrtiez '+Application.MainForm.Caption+' quitte  le relancer pour continuer votre travail') ;
      Historique('******* DDU.InsertionFichier INCIDENT sur le FICHIER "'+NomDuFichier+'" : ECRITURE VOULUE<>OBTENUE') ;
    End ;
    FreeMem(Pointeur,FinF-Position) ;
  End ;
End ;

Procedure CompactageFichier(Fichier : TFichier ; Position : DWord ; Taille : DWord ; NomDuFichier : ShortString) ;
Var Pointeur : Pointer ;
    FinF : DWord ;
    Bool : Boolean ;
Begin
  FinF := TailleDuFichier(Fichier) ;
  Position := Position ;
  If Position < FinF then
  Begin
    If FinF-Position-Taille>0 then
    Begin
      GetMem(Pointeur,FinF-Position-Taille) ;
      PositionneFichier(Fichier,Position+taille) ;
      If Not(LitFichier(Fichier,Fiches(Pointeur),FinF-Position-Taille)) then
      Begin
        BoiteDeMessage('INCIDENT sur le FICHIER "'+NomDuFichier+'"',
                       'Veuillez communiquer au 04 90 46 96 23 que l''incident "COMPACTAGE FICHIER / LECTURE BLOCK" '+
                       'vient de se produire. Cet incident n''a aucune gravit. Il ncessite nanmoins que vous finissiez '+
                       'le travail en cours puis que vous arrtiez '+Application.MainForm.Caption+' quitte  le relancer '+
                       'pour continuer votre travail') ;
        Historique('******* DDU.Compactage Fichier INCIDENT sur le FICHIER "'+NomDuFichier+'" : LECTURE VOULUE<>OBTENUE') ;
      End ;
      PositionneFichier(Fichier,Position) ;
      If Not(EcritFichier(Fichier,Fiches(Pointeur),FinF-Position-Taille)) then
      Begin
        BoiteDeMessage('INCIDENT sur le FICHIER "'+NomDuFichier+'"','Veuillez communiquer au 04 90 46 96 23 que l''incident "COMPACTAGE FICHIER / ECRITURE BLOCK" vient de se produire. Cet incident n''a aucune gravit. Il ncessite nanmoins que vous finissiez le travail en cours puis que vous arrtiez '+Application.MainForm.Caption+' quitte  le relancer pour continuer votre travail') ;
        Historique('******* DDU.Compactage Fichier INCIDENT sur le FICHIER "'+NomDuFichier+'" : ECRITURE VOULUE<>OBTENUE') ;
      End ;
    End else PositionneFichier(Fichier,FinF-taille) ;
    FreeMem(Pointeur,FinF-Position-taille) ;
    Bool := SetEndOfFile(Fichier) ;
    If Not Bool then
    Begin
      BoiteDemessage('Compactage de fichier echoue ','Veuillez communiquer au 04 90 46 96 23 cette incident') ;
      Historique('******* DDU.Compactage Fichier INCIDENT sur le FICHIER "'+NomDuFichier+'" : TRUNCATE ECHOU') ;
    End ;
  End ;
End ;

Function CriterePos( S1, S2 : ShortString ; VideOk : Boolean = False ) : Integer ;
Begin
  S1 := Majuscule(S1) ;
  S2 := Majuscule(S2) ;
  Result := Pos(S1,S2) ;
  If VideOk and (S1='') then Result := 1 ;
End ;


Procedure EnCodeListe( Var Liste : String ) ;
Var Posi : Word ;
Begin
  Remplace('#13 ',#13,Liste) ;
  Remplace('#13',#13,Liste) ;
End ;

Var NomIndefini : ShortString = 'Indfini'  ;

Function Nbrliste( s : String ) : byte ;
Var Nbr  : word ;
    Posi : Word ;
Begin
  EnCodeListe(S) ;
  Nbr := 0 ;
  Posi := Pos(#13,S) ;
  While Posi<>0 do
  Begin
    S[Posi] :=';'  ;
    Posi := Pos(#13,S) ;
    Inc(Nbr) ;
  End ;
  NbrListe  := Nbr ;
End ;


Function Maxliste( s : String ) : byte ;
Var Max : Byte ;
    I : Word ;
    L : ShortString ;
    tester : Boolean ;
Begin
  EnCodeListe(S) ;
  Max := Length(NomIndefini) ;
  SetLength(L,NbrListe(S)) ;
  tester := False ;
  //If S='Tube'#13'Coude'#13'T'#13'Bossage'#13'Piquage'#13'Corps de vanne'#13'Elments contrls'#13 then tester := True ;
  For I := 1 to NbrListe(S) do
  Begin
    L := Copy(S,1,Pos(#13,S)-1) ;
    Delete(S,1,Pos(#13,S)) ;
    If Length(L)>Max then Max := Length(L) ;
    If Tester then BoiteDeMessage(L,inttostr(max)) ;
  End ;
  MaxListe := Max ;
End ;


Function Liste( S : String ; N : byte ; SansET : Boolean = True ) : ShortString ;
Var Posi : Word ;
    Max : Byte ;
Begin
  EnCodeListe(S) ;
  Max := MaxListe(S) ;
  Posi := 1 ;
  If N = 0 then
  Begin
    Liste := Copy(NomIndefini+'                                                 ',1,Max) ;
    EXIT ;
  End ;
  While Posi<>N do
  Begin
    Delete(S,1,Pos(#13,S) ) ;
    Inc(Posi) ;
  End ;
  Delete(S,Pos(#13,S),Length(S) ) ;
  { le 29 AOUT 2000
  S := S +'                                            ' ;
  Liste := Copy(S+'                                                 ',1,Max) ;
  }
  If SansET then Remplace('&','',S) ;
  Liste := SansEspaces(S) ;
End ;

Function PosListe( Item : ShortString ; S : String ) : Byte  ;
Var Posi : word ;
    Resultat : Byte ;
    i : word ;
Begin
  EnCodeListe(S) ;
  Posi := CriterePos(Item,S) ;
  If Posi =0 then Posliste := 0
  Else Begin
    Resultat := 1 ;
    For I:= 1 to Posi Do If S[I]=#13 then Inc(Resultat) ;
    Posliste := Resultat ;
  End ;
End ;


Procedure TrieListe(Var LaListe : String ) ;
Var BoiteL : TListBox ;
    i : Integer ;
Begin
  BoiteL := TListBox.Create(Application.MainForm) ;
  BoiteL.Parent := Application.MainForm ;
  BoiteL.Sorted := True ;
  For I := 1 to NbrListe(LaListe) do BoiteL.Items.Add(Liste(LaListe,I) ) ;
  LaListe := '' ;
  For I := 1 to BoiteL.Items.Count do
  LaListe := LaListe + BoiteL.Items.Strings[I-1] + #13  ;
  BoiteL.Free ;
End ;


Function ReelStr( S : ShortString ) : Real ;
var Code : Integer ;
    Negatif : Boolean ;
Begin
  If Pos('          ',S)=1 then Negatif := True else Negatif := False;
  RemplaceA(' ','',S) ;
  RemplaceA(',','.',S) ;
  Val(S,Result,Code) ;
  If Negatif then Result := ABS(Result) * -1 ;
End ;

Function EntierStr( S : ShortString ) : DWord ;
Var R : Real ;
Begin
  R := ReelStr( S ) ;
  Result := Round(R) ;
End ;

Function OctetStr( S : ShortString ) : Byte ;
var Code : Integer ;
Begin
  While Pos(' ',S)>0 Do Delete(S,Pos(' ',S),1) ;
  While Pos(',',S)>0 Do S[Pos(',',S)] := '.' ;
  Val(S,Result,Code) ;
End ;


Function WordStr( S : ShortString ) : Word ;
Var R : Real ;
Begin
  R := ReelStr( S ) ;
  Result := Round(R) ;
End ;

Function DateStr( S : ShortString ) : Dates ;
Begin
  If Pos('/',S)=0 then
  Begin
    Insert('/',S,5) ;
    Insert('/',S,3) ;
  End ;
  Result.Jour := EntierStr(Copy(S,1,Pos('/',S)-1)) ;
  Delete(S,1,Pos('/',S)) ;
  Result.Mois := EntierStr(Copy(S,1,Pos('/',S)-1)) ;
  Delete(S,1,Pos('/',S)) ;
  Result.Annee := EntierStr(S) ;
  If Result.Annee < 50 then Result.Annee := 2000 + Result.Annee ;
  If Result.Annee < 100 then Result.Annee := 1900 + Result.Annee ;
End ;

Function Ecart(D1,D2 : Dates ) : Word ;
Begin
  If D1.Jour<>0 then
  Begin
    Result := 0 ;
    While Not Croissant(D2,D1) Do
    Begin
      Inc(Result) ;
      Lendemain(D1) ;
    End ;
  End {;
  Result := D2.Jour-D1.Jour+(D2.Mois-D1.Mois)*61 div 2 + (D2.Annee-D1.Annee)*365}
  Else If D1.Mois<>0 then Result := D2.Mois-D1.Mois+(D2.Annee-D1.Annee)*12
  Else Result := D2.Annee-D1.Annee ;
End ;



Function NomDeFichierLong( NomF : ShortString) : ShortString ;
Var SearchRec : TSearchRec ;
    N : Byte ;
Begin
  Result := NomF ;
  //{$IFDEF MSWINDOWS}
  If Pos('~',NomF)=0 then EXIT ;
  If FindFirst(NomF,faAnyFile,SearchRec)=0 then Result := SearchRec.Name ;
  FindClose(SearchRec) ;
  //{$ENDIF}
End ;

Procedure ChangeOrientation( LeCanvas : TCanvas ; Orientation : Integer ) ;
var
  LogFont: TLogFont;
  UnePolice : HFont ;
Begin
  { Creation d'une police identique  l'actuelle mais avec la nouvelle orientation }
  With LogFont Do
  Begin
    lfHeight := LeCanvas.Font.Height;
    lfWidth := 0; { have font mapper choose }
    lfEscapement := Orientation ; { only straight fonts }
    lfOrientation := 0 ;
    if fsBold in LeCanvas.Font.Style then
      lfWeight := FW_BOLD
    else
      lfWeight := FW_NORMAL;
    lfItalic := Byte(fsItalic in LeCanvas.Font.Style);
    lfUnderline := Byte(fsUnderline in LeCanvas.Font.Style);
    lfStrikeOut := Byte(fsStrikeOut in LeCanvas.Font.Style);
    lfCharSet := Byte(LeCanvas.Font.Charset);
    if AnsiCompareText(LeCanvas.Font.Name, 'Default') = 0 then  // do not localize
      StrPCopy(lfFaceName, DefFontData.Name)
    else
      StrPCopy(lfFaceName, LeCanvas.Font.Name);
    lfQuality := DEFAULT_QUALITY;
    { Everything else as default }
    lfOutPrecision := OUT_DEFAULT_PRECIS;
    lfClipPrecision := CLIP_DEFAULT_PRECIS;
    lfPitchAndFamily := DEFAULT_PITCH;
  End ;
  UnePolice := CreateFontIndirect(LogFont);
  UnePolice := SelectObject(LeCanvas.Handle,UnePolice) ;
  If ExFonte=0 then ExFonte:=UnePolice Else DeleteObject(UnePolice) ;
End ;

Procedure Histogramme( LeCanvas : TCanvas ; X,Y1,Y2 : Integer ; FuiteX, FuiteY : Byte ; Largeur : Integer ; Couleur : TColor ) ;
Var A,B, C, D : Tpoint ;
    Polygone : Array Of TPoint ;
Begin
  SetLength(Polygone,4) ;

  A.x := x + Largeur ;
  B.x := x + Largeur + FuiteX ;
  C.x := x + FuiteX ;
  D.x := x ;
  A.y := y2 ;
  B.y := y2 - FuiteY ;
  C.y := y2 - FuiteY ;
  D.y := y2 ;
  LeCanvas.Brush.Color := clWhite ;

  Polygone[0] := A ;
  Polygone[1] := B ;
  Polygone[2] := C ;
  Polygone[3] := D ;
  LeCanvas.Pen.Color := LeCanvas.Brush.Color ;
  LeCanvas.Polygon(Polygone) ;

  C.x := x + Largeur + FuiteX ;
  D.x := x + Largeur ;
  C.y := y1 - FuiteY ;
  D.y := y1 ;
  LeCanvas.Brush.Color := RGB(130,130,130) + Couleur div 255 * 125 ;

  Polygone[0] := A ;
  Polygone[1] := B ;
  Polygone[2] := C ;
  Polygone[3] := D ;
  LeCanvas.Pen.Color := LeCanvas.Brush.Color ;
  LeCanvas.Polygon(Polygone) ;

  LeCanvas.Brush.Color := RGB(200,200,200) + Couleur div 255 * 55 ;
  LeCanvas.Pen.Color := LeCanvas.Brush.Color ;
  LeCanvas.Rectangle(X,Y1,X+Largeur,Y2) ;
  SetLength(Polygone,0) ;
End ;

Procedure AnnuleOrientation( LeCanvas : TCanvas ) ;
Var
  UnePolice : HFont ;
Begin
  If ExFonte<>0 then
  Begin
    UnePolice := SelectObject(LeCanvas.Handle,ExFonte) ;
    DeleteObject(UnePolice) ;
    ExFonte := 0 ;
  End ;
End ;
Function CouleurPeriodique( I : Integer ) : TColor ;
Begin
  Result := 0 ;
  Case (I-1) mod 15 of
    0   : Result := clRed ;
    1   : Result := clBlue ;
    2   : Result := clGreen ;
    3   : Result := clMaroon ;
    4   : Result := clSilver ;
    5   : Result := clYellow ;
    6   : Result := clFuchsia ;
    7   : Result := clLime ;
    8   : Result := clNavy ;
    9   : Result := clOlive ;
    10  : Result := clGray ;
    11  : Result := clBlack;
    12  : Result := clAqua ;
    13  : Result := clPurple ;
    14  : Result := clTeal ;
  End ;
End ;

Function Age(DateN : Dates) : ShortString ;
var annee, mois, jour : Word ;
    SJour,Smois,Sannee : String[20] ;
begin
  annee := Aujourdhui.annee - dateN.annee ;
  mois := Aujourdhui.mois - dateN.mois ;
  jour := Aujourdhui.jour - dateN.jour ;
  If Jour=0 then SJour := '' else If Jour=1 then SJour := 'un jour' else Sjour := StrNumero(jour)+' jours' ;
  If Mois=0 then SMois := '' else If Mois=1 then SMois := 'un mois' else SMois := StrNumero(Mois)+' mois' ;
  If Annee=0 then SAnnee := '' else If Annee=1 then SAnnee := 'un an' else SAnnee := StrNumero(Annee)+' ans' ;
  If (Mois>2) or (Annee>0) then SJour := '' ;
  If Annee>10 then
  Begin
    SMois := '' ;
    SJour := '' ;
  End ;
  Result := SAnnee+ ' ' + Smois +' ' + Sjour ;
  ElagueLesEspaces(Result) ;
end;

Function DernierJourDuMois( Unedate : dates ) : Byte ;
Var Jour : Byte ;
Begin
  Case UneDate.Mois Of
     1,3,5,7,8,10,12 : Jour := 31 ;
     2 : If UneDate.annee mod 4 = 0 then Jour := 29 else Jour := 28 ;
     4,6,9,11        : Jour := 30 ;
  else Jour := 31 ;
  End ;
  DernierJourDuMois := Jour ;
End ;

Function StrDateAlpha( D : Dates ; Sep : char = '-'  ) : TSTR12 ;
Begin
  Result := IntToStr(D.Jour) ;
  While Length(Result)<2 do Result := '0'+Result ;
  Result := IntToStr(D.Mois) + Result  ;
  While Length(Result)<4 do Result := '0'+Result ;
  Result := IntToStr(D.Annee)  + Result ;
  While Length(Result)<8 do Result := '0'+Result ;
  If Sep<>'' then
  Begin
    Insert(Sep,Result,7) ;
    Insert(Sep,Result,5) ;
  End ;
End ;


Function CouleurMoyenne(Couleur1, Couleur2 : Tcolor ) : TColor ;   // VOIR Function Moyenne(C1,C2,Coef) dans CurvedSpeedButton.pas
Var X0, X1, X2 : TranstypageColor ;
Begin
  X1 := TranstypageColor(Couleur1) ;
  X2 := TranstypageColor(Couleur2) ;
  X0[0] := X1[0] div 2 + X2[0] div 2 ;
  X0[1] := X1[1] div 2 + X2[1] div 2 ;
  X0[2] := X1[2] div 2 + X2[2] div 2 ;
  X0[3] := 0 ;
  Result := Tcolor(X0) ;
End ;


Function Visionne( N : Tfilename ) : Boolean ;
Var Reponse : integer ;
    P , O : String ;
Begin
  If Pos(#13,N)>0 then
  Begin
    P := Copy(N,1,Pos(#13,N)-1)+#0 ;
    O := Copy(N,Pos(#13,N)+1,Length(N))+#0 ;
  End else
  Begin
    P := N +#0  ;
    O := ''#0 ;
  End ;
  // erreur ?                Handle de l'appelant      Ouvrir
  Reponse := ShellExecute(application.MainForm.Handle,'open',Pchar(P),Pchar(O),Nil,0) ;
  If Reponse<=32 then
  Begin
    Case Reponse of
      0:BoiteDeMessage('Erreur lors du lancement de l''aide !','Le systme n''a plus assez de mmoire ou de ressources pour continuer.') ;
      ERROR_FILE_NOT_FOUND:BoiteDeMessage('Erreur lors du lancement de l''aide !','Le fichier "'+n+'" n''a pas t trouv.') ;
      ERROR_PATH_NOT_FOUND:BoiteDeMessage('Erreur lors du lancement de l''aide !','Le n specifi n''a pas t trouv.') ;
      ERROR_BAD_FORMAT:BoiteDeMessage('Erreur lors du lancement de l''aide !','Le fichier xecutable est invalide (non Win32 .EXE ou erreur dans .EXE image).') ;
      SE_ERR_ACCESSDENIED:BoiteDeMessage('Erreur lors du lancement de l''aide !','Le systme refuse l''accs au fichier "'+n+'" (dj ouvert par autre utilisateur?).') ;
      SE_ERR_ASSOCINCOMPLETE:BoiteDeMessage('Erreur lors du lancement de l''aide !','L''association aux fichiers "'+ExtractFileExt(N)+'" est mal faite.') ;

      SE_ERR_DDEBUSY:BoiteDeMessage('Erreur lors du lancement de l''aide !','La transaction DDE ne peut pas tre xecute car d''autres transactions sont en cours...') ;
      SE_ERR_DDEFAIL:BoiteDeMessage('Erreur lors du lancement de l''aide !','La transaction DDE a chou.') ;
      SE_ERR_DDETIMEOUT:BoiteDeMessage('Erreur lors du lancement de l''aide !','La transaction DDE ne peut pas tre xecute car la requte a dpass le temp qui lui tait imparti.') ;
      SE_ERR_DLLNOTFOUND:BoiteDeMessage('Erreur lors du lancement de l''aide !','La DLL specifie (dynamic-link library) n''a pas t trouve.') ;
      SE_ERR_NOASSOC:BoiteDeMessage('Erreur lors du lancement de l''aide !','Il n''y a pas d''application associe aux fichiers "'+ExtractFileExt(N)+'".') ;
      SE_ERR_OOM:BoiteDeMessage('Erreur lors du lancement de l''aide !','Il n''y a pas assez de mmoire pour ouvrir "'+n+'".') ;
      SE_ERR_SHARE:BoiteDeMessage('Erreur lors du lancement de l''aide !','Une violation de partage s''est produite.') ;
    End ; //Case
  end ;
End ;

Function NomDeFichierValide(NomF : PathStr ; LeFichierNeDoitPasExister : Boolean ; AvecMessage : Boolean ) : Boolean ;
Begin
  result := True ;
  If Pos('/',NomF)>0 then
  Begin
    result := False ;
    BoiteDeMessage('Nom refus !','Le nom de fichier "'+NomF+'" est invalide. Il ne peut pas tre accept.') ;
    Exit ;
  End ;
  If LeFichierNeDoitPasExister then
  if FileExists(NomF) then
  Begin
    result := False ;
    BoiteDeMessage('Fichier existant !','Un fichier de nom "'+NomF+'" existe dj. Ce nom ne peut pas tre accept.') ;
    Exit ;
  End ;
End ;

Function CopieFichier( Source, destination : ShortString ) : Boolean ;
Var P1, P2 : Pchar ;
Begin
  If Not(FileExists(Source)) then
  Begin
    BoiteDeMessage('ERREUR de Copie','Le fichier "'+Source+'" n''a pas t trouv !'#13'Copie abandonne !') ;
    Result := False ;
    EXIT ;
  End ;
  Source := Source + #0 ;
  Destination := Destination + #0 ;
  P1 := Addr(Source[1]) ;
  P2 := Addr(Destination[1]) ;
  Result := ( CopyFile(P1,P2,False) ) ;
  If Not Result then
  Begin
    BoiteDeMessage('Echec de copie !',
                   'Echec de copie !'#13+
                   'Impossible de copier '+Source+' vers '+Destination ) ;
  End ;
End ;




Function Chiffre( Digit : Char ) : String ;
Begin
  Case digit of
    '1' : Chiffre := 'un ';
    '2' : Chiffre := 'deux ';
    '3' : Chiffre := 'trois ';
    '4' : Chiffre := 'quatre ';
    '5' : Chiffre := 'cinq ';
    '6' : Chiffre := 'six  ';
    '7' : Chiffre := 'sept ';
    '8' : Chiffre := 'huit ';
    '9' : Chiffre := 'neuf ';
    else Chiffre := '' ;
  End ;
End ;

Function ReelEnFrancais( Valeur : Real ; Monnaie : ShortString  ) : String ;
Type Str3  = String[3]  ;
     Str10 = String[10] ;

 Function Millier( S3 : Str3 ; Unite : Str10 ) : String ;
  Var Resultat : String ;
 Begin
   If (S3[1] =' ') or (S3[1] ='.') or (S3[1]='0') then Resultat := ''
   Else If S3[1]='1' then Resultat := 'cent '
    Else If Copy(S3,2,2)='00' then Resultat := Chiffre(S3[1])+'cents '
     Else  Resultat := Chiffre(S3[1])+'cent ';

   If S3[2] = '2' then If S3[3] = '1' then Resultat := Resultat + 'vingt et un '
   Else Resultat := Resultat +'vingt-'+ chiffre(S3[3]) ;

   If S3[2] = '3' then If S3[3] = '1' then Resultat := Resultat + 'trente et un '
   Else Resultat := Resultat +'trente-'+ chiffre(S3[3]) ;

   If S3[2] = '4' then If S3[3] = '1' then Resultat := Resultat + 'quarante et un '
   Else Resultat := Resultat +'quarante-'+ Chiffre(S3[3]) ;

   If S3[2] = '5' then If S3[3] = '1' then Resultat := Resultat + 'cinquante et un '
   Else Resultat := Resultat +'cinquante-'+ Chiffre(S3[3]) ;

   If S3[2] = '6' then If S3[3] = '1' then Resultat := Resultat + 'soixante et un '
   Else Resultat := Resultat +'soixante-'+ Chiffre(S3[3]) ;

   If S3[2] = '7' then If S3[3] = '1' then Resultat := Resultat + 'Soixante et '
   else Resultat := Resultat + 'soixante-' ;

   If S3[2] = '8' then If S3[3] = '0' then Resultat := Resultat + 'quatre-vingts '
   Else Resultat := Resultat +'quatre-vingt '+ Chiffre(S3[3]) ;

   If S3[2] = '9' then Resultat := Resultat + 'quatre-vingt ' ;
   If (S3[2] = '1') or (S3[2] = '9')or (S3[2] = '7')  then
   Begin
     If S3[3] = '0' then Resultat := Resultat + 'dix '
     Else If S3[3] = '1' then Resultat := Resultat + 'onze '
      Else If S3[3] = '2' then Resultat := Resultat + 'douze '
       Else If S3[3] = '3' then Resultat := Resultat + 'treize '
        Else If S3[3] = '4' then Resultat := Resultat + 'quatorze '
         Else If S3[3] = '5' then Resultat := Resultat + 'quinze '
          Else If S3[3] = '6' then Resultat := Resultat + 'seize '
           Else Resultat := Resultat + 'dix-'+ Chiffre(S3[3]) ;
   End ;

   If S3[2] = '0' then Resultat := Resultat + Chiffre(S3[3]) ;
   If S3[2] = ' ' then If (Unite='mille ') and (S3[3]='1') then Resultat := Resultat + ' '
   Else Resultat := Resultat + Chiffre(S3[3]) ;
   If Resultat <> '' then Resultat := Resultat + unite ;
   Millier := Resultat ;
 End ;
Var Chaine : String ;
    Millions, Milliers, unites, centimes : STR3 ;
Begin
  If Abs(Valeur) > 999999999.99 then Result := StrReel( Valeur,20,2 ) + ' '+ unites
  Else Begin
    Str(Abs(Valeur):12:2,Chaine) ;
    While Length(Chaine)<12 do System.Insert(' ',Chaine,1) ;
    Millions := Copy(Chaine,1,3) ;
    Milliers := Copy(Chaine,4,3) ;
    Unites   := Copy(Chaine,7,3) ;
    Centimes := Copy(Chaine,10,3) ;
    If Pos('(',Monnaie)=1 then
    Begin
      Dec(Monnaie[0]) ;
      Monnaie := Copy(Monnaie,5,10) ;
    End ;
    If Monnaie='' then Monnaie := IntituleUnite ;
    If Monnaie[Ord(Monnaie[0])]='s' then Dec(Monnaie[0]) ; 
    If Round(Valeur)=0 then Chaine := 'zro '+ Monnaie
    else If Abs(Valeur)<2 then Chaine := 'un '+Monnaie
     else Chaine := Millier(Millions,IntituleMillion)
                  + Millier(Milliers,IntituleMillier)
                  + Millier(Unites,'')+ Monnaie+ 's' ;

    If Centimes<>'.00' then
    If Centimes='.01' then Chaine := Chaine + intituleVirgule +'un '+intituleCentieme
     else Chaine := Chaine + IntituleVirgule + Millier(Centimes,IntituleCentieme+'s') ;
    Chaine := SansEspaces(Chaine) ;
    Result := Chaine ;
  End ;
End ;


function Conversion(s:longint):string;
begin
  case s of
     1: Conversion :='uno';
     2: Conversion :='dos';
     3: Conversion :='tres';
     4: Conversion :='cuatro';
     5: Conversion :='cinco';
     6: Conversion :='seis';
     7: Conversion :='siete';
     8: Conversion :='ocho';
     9: Conversion :='nueve';
    10: Conversion :='diez';
    11: Conversion :='once';
    12: Conversion :='doce';
    13: Conversion :='trece';
    14: Conversion :='catorce';
    15: Conversion :='quince';
    20: Conversion :='veinte';
    30: Conversion :='treinta';
    40: Conversion :='cuarenta';
    60: Conversion :='sesenta';
    70: Conversion :='setenta';
    80: Conversion :='ochenta';
    90: Conversion :='noventa';
    100:Conversion :='cien';
    500:Conversion :='quinientos';
    700:Conversion :='setecientos';
    900:Conversion :='novecientos';
    50: Conversion :='cincuenta';
  end;
end;




Function ReelEnEspagnol ( Valeur : Real ; Unite : ShortString  ) : ShortString ;
var
   erro,
   Centimes,
   Unites,
   Dizaines,
   Centaine,
   salva,
   miles,
   Dizainesmil,
   Centainemil,
   mill,
   aux,
   N : longint;
   Chaine,
   Chaine2:string;

begin
  begin
    N := Trunc(Valeur) ;
    Centimes := Round(Frac(Valeur)*100) ;
    aux :=n div 1000000; mill := aux; n :=n mod 1000000;
    aux :=n div 100000;  Centainemil := aux;n :=n mod 100000;
    aux :=n div 10000;   Dizainesmil := aux;n :=n mod 10000;
    aux :=n div 1000;    miles := aux;n :=n mod 1000;
    aux :=n div 100;     Centaine := aux;n :=n mod 100;
    aux :=n div 10;      Dizaines := aux;n :=n mod 10;
    aux :=n div 1 ;Unites := aux;
    Chaine :='';
    if mill >0 then
    if mill = 1 then Chaine := 'un millon ' else
    begin
     n := mill;
     Chaine := ReelEnEspagnol(Mill,'millones') ;
    end;
   {empieza la conversin de las Centaineenas de miles}
    Chaine2 :='';
    case Centainemil of
         1:if (miles=0) and (Dizainesmil=0) then Chaine2 :=Conversion(100)
              else Chaine2 :='ciento ';
         2:Chaine2 :=Conversion(2)+'cientos ';
         3:Chaine2 :=Conversion(3)+'cientos ';
         4:Chaine2 :=Conversion(4)+'cientos ';
         5:Chaine2 :=Conversion(500)+' ';
         6:Chaine2 :=Conversion(6)+'cientos ';
         7:Chaine2 :=Conversion(700)+' ';
         8:Chaine2 :=Conversion(8)+'cientos ';
         9:Chaine2 :=Conversion(900)+' ';
    end;
    Chaine :=Chaine+Chaine2;
     {Termina la conversin de las Centaineenas}


    {empieza la conversin de las Dizainesenas y Unites de miles}
  Chaine2 :='';
    case Dizainesmil of
       0:if miles <> 1 then Chaine2 :=Conversion(miles);
       1:if miles<=5 then Chaine2 :=Conversion(Dizainesmil*10+miles)
            else Chaine2 :='dieci'+ Conversion(miles);
       2:if miles=0 then Chaine2 :=Conversion(20)
            else if miles=1 then Chaine2 :='veintiun' else
            Chaine2 :='veinti'+Conversion(miles);
       3:if miles=0 then Chaine2 :=Conversion(30)
            else if miles=1 then Chaine2 :='treinta y un' else
            Chaine2 :='treinta y '+Conversion(miles);
       4:if miles=0 then Chaine2 :=Conversion(40)
            else if miles=1 then Chaine2 :='cuarenta y un' else
            Chaine2 :='cuarenta y '+Conversion(miles);
       5:if miles=0 then Chaine2 :=Conversion(50)
            else if miles=1 then Chaine2 :='cincuenta y un' else
            Chaine2 :='cincuenta y '+Conversion(miles);
       6:if miles=0 then Chaine2 :=Conversion(60)
            else if miles=1 then Chaine2 :='sesenta y un' else
            Chaine2 :='sesenta y '+Conversion(miles);
       7:if miles=0 then Chaine2 :=Conversion(70)
            else if miles=1 then Chaine2 :='setenta y un' else
            Chaine2 :='setenta y '+Conversion(miles);
       8:if miles=0 then Chaine2 :=Conversion(80)
            else if miles=1 then Chaine2 :='ochenta y un' else
            Chaine2 :='ochenta y '+Conversion(miles);
       9:if miles=0 then Chaine2 :=Conversion(90)
            else if miles=1 then Chaine2 :='noventa y un' else
            Chaine2 :='noventa y '+Conversion(miles);
      end;
  if (Centainemil > 0) and (miles = 1) then Chaine2 := Chaine2 + 'un';
  if (miles>0) or (Dizainesmil>0) or (Centainemil>0) then Chaine2 :=Chaine2+' mil ';
  Chaine :=Chaine+Chaine2;
      {termina la conversin de las Dizainesenas y Unites de miles}

   {empieza la conversin de las Centaineenas}
   Chaine2 :='';
    case Centaine of
         1:if (Unites=0) and (Dizaines=0) then Chaine2 :=Conversion(100)
              else Chaine2 :='ciento ';
         2:Chaine2 :=Conversion(2)+'cientos ';
         3:Chaine2 :=Conversion(3)+'cientos ';
         4:Chaine2 :=Conversion(4)+'cientos ';
         5:Chaine2 :=Conversion(500)+' ';
         6:Chaine2 :=Conversion(6)+'cientos ';
         7:Chaine2 :=Conversion(700)+' ';
         8:Chaine2 :=Conversion(8)+'cientos ';
         9:Chaine2 :=Conversion(900)+' ';
    end;
  Chaine :=Chaine+Chaine2;
     {Termina la conversin de las Centaine}

    {empieza la conversin de las Dizainesenas y Unites}
  Chaine2 :='';
    case Dizaines of
       0:Chaine2 :=Conversion(Unites);
       1:if Unites<=5 then Chaine2 :=Conversion(Dizaines*10+Unites)
            else Chaine2 :='dieci'+ Conversion(Unites);
       2:if Unites=0 then Chaine2 :=Conversion(20)
            else Chaine2 :='veinti'+Conversion(Unites);
       3:if Unites=0 then Chaine2 :=Conversion(30)
            else Chaine2 :='treinta y '+Conversion(Unites);
       4:if Unites=0 then Chaine2 :=Conversion(40)
            else Chaine2 :='cuarenta y '+Conversion(Unites);
       5:if Unites=0 then Chaine2 :=Conversion(50)
            else Chaine2 :='cincuenta y '+Conversion(Unites);
       6:if Unites=0 then Chaine2 :=Conversion(60)
            else Chaine2 :='sesenta y '+Conversion(Unites);
       7:if Unites=0 then Chaine2 :=Conversion(70)
            else Chaine2 :='setenta y '+Conversion(Unites);
       8:if Unites=0 then Chaine2 :=Conversion(80)
            else Chaine2 :='ochenta y '+Conversion(Unites);
       9:if Unites=0 then Chaine2 :=Conversion(90)
            else Chaine2 :='noventa y '+Conversion(Unites);
      end;
    Chaine :=Chaine+Chaine2;
    If Valeur>1 then Unite := Unite +'s' ;
      {termina la conversin de las Dizainesenas y Unites}
    if Chaine <> '' then
      If Centimes>0 then Result :=Chaine +' '+Unite + ' y '+ReelEnEspagnol(Centimes,'centavo')
      else Result :=Chaine+' '+Unite
    Else If Centimes>0 then Result := ReelEnEspagnol(Centimes,'centavo')+ ' de '+Unite
    else Result := 'Cero';
  end;
end;

function Convertion(s:longint):string;
begin
  case s of
     1: Result := 'One' ;
     2: Result := 'two' ;
     3: Result := 'three' ;
     4: Result := 'four' ;
     5: Result := 'five' ;
     6: Result := 'six' ;
     7: Result := 'seven' ;
     8: Result := 'eight' ;
     9: Result := 'nine' ;
    10: Result := 'ten' ;
    11: Result := 'eleven' ;
    12: Result := 'twelve' ;
    13: Result := 'thirteen' ;
    14: Result := 'fourteen' ;
    15: Result := 'fifteen' ;
    20: Result := 'twenty' ;
    30: Result := 'thirty' ;
    40: Result := 'forty' ;
    50: Result := 'fifty' ;
    60: Result := 'sixty' ;
    70: Result := 'seventy' ;
    80: Result := 'eighty' ;
    90: Result := 'ninety' ;
    100:Result := 'hundred' ;
    500:Result := 'five hundred' ;
    700:Result := 'seven hundred' ;
    900:Result := 'nine hundred' ;
  end;
end;


Function ReelEnAnglais ( Valeur : Real ; Unite : ShortString  ) : ShortString ;
var
   erro,
   Centimes,
   Unites,
   Dizaines,
   Centaine,
   salva,
   miles,
   Dizainesmil,
   Centainemil,
   mill,
   aux,
   N : longint;
   Chaine,
   Chaine2:string;

begin
  begin
    N := Trunc(Valeur) ;
    Centimes := Round(Frac(Valeur)*100) ;
    aux :=n div 1000000; mill := aux; n :=n mod 1000000;
    aux :=n div 100000;  Centainemil := aux;n :=n mod 100000;
    aux :=n div 10000;   Dizainesmil := aux;n :=n mod 10000;
    aux :=n div 1000;    miles := aux;n :=n mod 1000;
    aux :=n div 100;     Centaine := aux;n :=n mod 100;
    aux :=n div 10;      Dizaines := aux;n :=n mod 10;
    aux :=n div 1 ;Unites := aux;
    Chaine :='';
    if mill >0 then
    if mill = 1 then Chaine := 'one million ' else
    begin
     n := mill;
     Chaine := ReelEnAnglais(Mill,'millions') ;
    end;
   {empieza la conversin de las Centaineenas de miles}
    Chaine2 :='';
    case Centainemil of
         1:if (miles=0) and (Dizainesmil=0) then Chaine2 :=Convertion(100)
              else Chaine2 :='hundred ';
         2:Chaine2 :=Convertion(2)+' hundred ';
         3:Chaine2 :=Convertion(3)+' hundred ';
         4:Chaine2 :=Convertion(4)+' hundred ';
         5:Chaine2 :=Convertion(500)+' ';
         6:Chaine2 :=Convertion(6)+' hundred ';
         7:Chaine2 :=Convertion(700)+' ';
         8:Chaine2 :=Convertion(8)+' hundred ';
         9:Chaine2 :=Convertion(900)+' ';
    end;
    Chaine :=Chaine+Chaine2;
     {Termina la conversin de las Centaineenas}


    {empieza la conversin de las Dizainesenas y Unites de miles}
  Chaine2 :='';
    case Dizainesmil of
       0:if miles <> 1 then Chaine2 :=Convertion(miles);
       1:if miles<=5 then Chaine2 :=Convertion(Dizainesmil*10+miles)
            else Chaine2 :='ten '+ Convertion(miles);
       2:if miles=0 then Chaine2 :=Convertion(20)
            else if miles=1 then Chaine2 :='twenty one' else
            Chaine2 :='twenty '+Convertion(miles);
       3:if miles=0 then Chaine2 :=Convertion(30)
            else if miles=1 then Chaine2 :='twenty one' else
            Chaine2 :='twenty '+Convertion(miles);
       4:if miles=0 then Chaine2 :=Convertion(40)
            else if miles=1 then Chaine2 :='forty one' else
            Chaine2 :='forty '+Convertion(miles);
       5:if miles=0 then Chaine2 :=Convertion(50)
            else if miles=1 then Chaine2 :='fifty un' else
            Chaine2 :='fifty '+Convertion(miles);
       6:if miles=0 then Chaine2 :=Convertion(60)
            else if miles=1 then Chaine2 :='sixty one' else
            Chaine2 :='sixty '+Convertion(miles);
       7:if miles=0 then Chaine2 :=Convertion(70)
            else if miles=1 then Chaine2 :='seventy one' else
            Chaine2 :='seventy '+Convertion(miles);
       8:if miles=0 then Chaine2 :=Convertion(80)
            else if miles=1 then Chaine2 :='heighty un' else
            Chaine2 := 'heighty '+Convertion(miles);
       9:if miles=0 then Chaine2 :=Convertion(90)
            else if miles=1 then Chaine2 :='ninety un' else
            Chaine2 :='ninety '+Convertion(miles);
      end;
  if (Centainemil > 0) and (miles = 1) then Chaine2 := Chaine2 + 'one';
  if (miles>0) or (Dizainesmil>0) or (Centainemil>0) then Chaine2 :=Chaine2+' thousand ';
  Chaine :=Chaine+Chaine2;
      {termina la conversin de las Dizainesenas y Unites de miles}

   {empieza la conversin de las Centaineenas}
   Chaine2 :='';
    case Centaine of
         1:if (Unites=0) and (Dizaines=0) then Chaine2 :=Convertion(100)
              else Chaine2 :='hundred ';
         2:Chaine2 :=Convertion(2)+' hundred ';
         3:Chaine2 :=Convertion(3)+' hundred ';
         4:Chaine2 :=Convertion(4)+' hundred ';
         5:Chaine2 :=Convertion(500)+' ';
         6:Chaine2 :=Convertion(6)+' hundred ';
         7:Chaine2 :=Convertion(700)+' ';
         8:Chaine2 :=Convertion(8)+' hundred ';
         9:Chaine2 :=Convertion(900)+' ';
    end;
  Chaine :=Chaine+Chaine2;
     {Termina la conversin de las Centaine}

    {empieza la conversin de las Dizainesenas y Unites}
  Chaine2 :='';
    case Dizaines of
       0:Chaine2 :=Convertion(Unites);
       1: if Unites<=5 then Chaine2 :=Convertion(Dizaines*10+Unites)
            else Chaine2 :=Convertion(Unites)+'teen';
       2:if Unites=0 then Chaine2 :=Convertion(20)
            else Chaine2 :='twenty '+Convertion(Unites);
       else if Unites=0 then Chaine2 :=Convertion(dizaines*10)
            else Chaine2 := Convertion(dizaines*10) + ' '+Convertion(Unites);
      end;
    Chaine :=Chaine+Chaine2;
    If Valeur>1 then Unite := Unite +'s' ;
      {termina la conversin de las Dizainesenas y Unites}
    if Chaine <> '' then
      If Centimes>0 then Result :=Chaine +' '+Unite + ' and '+ReelEnAnglais(Centimes,'cent')
      else Result :=Chaine+' '+Unite
    Else If Centimes>0 then Result := ReelEnAnglais(Centimes,'cent')+ ' of '+Unite
    else Result := 'zero';
  end;
end;



Function StrReel_en_lettres( Valeur : Real ; Monnaie : ShortString ) : String ;
Begin
  If LangueUtilisee and $FF = $9 then Result := ReelEnAnglais(Valeur,Monnaie) else
  If LangueUtilisee and $FF = $A then Result := ReelEnEspagnol(Valeur,Monnaie) else
  Result := ReelEnFrancais(Valeur,Monnaie) ;
End ;


Function ExtraitDate( DateHeure : TdateTime ) : Dates ;
var R : double ;
    NbrA : Integer ;
Begin
  R := Int(DateHeure) ;
  If R=0 then
  Begin
    Result.jour := 0 ;
    Result.mois := 0 ;
    Result.Annee := 0 ;
    Exit ;
  End ;
  Result.jour := 31 ;
  Result.mois := 12 ;
  Result.Annee := 1899 ;
  NbrA := 366 ;
  While R>NbrA do
  Begin
    R := R - NbrA ;
    If (Result.Annee mod 4 =0)
    then NbrA := 366
    else NbrA := 365 ;
    Inc(Result.Annee) ;
  End ;
  Lendemain(Result,Round(R)) ;
End ;

Function DatesVersTDate( Date : Dates ) : Tdate ;
Var DateX : Dates ;
    LaTDate : Double ;
Begin
  DateX.Jour := 30 ;
  DateX.Mois := 12 ;
  DateX.Annee := 1899 ;
  LaTDate := 0.25 ;
  While Not(DatesEgales(Date,DateX,True)) do
  Begin
    LaTDate := LaTdate +1 ;
    Lendemain(DateX) ;
  End ;
  LaTDate := Round(LaTDate) - 1 ;
  Result := TDate(LaTDate) ;
End ;


Function ExtraitHeure( DateHeure : TdateTime ) : Heures ;
var R : double ;
Begin
  R := Frac(DateHeure) ;
  R := R * 24 ;
  Result.Heure := Round(Int(R)) ;
  R := Frac(R) ;
  R := R * 60 ;
  Result.minute := Round(Int(R)) ;
  R := Frac(R) ;
  R := R * 60 ;
  Result.Secondes := Round(Int(R)) ;
End ;

Function DateEtHeure( DateHeure : TdateTime ) : ShortString ;
Var D : dates ;
    H : Heures ;
Begin
  D := ExtraitDate(DateHeure) ;
  H := ExtraitHeure(DateHeure) ;
  If (H.Heure=0) and (H.minute=0)
  then Result := StrDate(D)
  else
  If H.Minute>9
  then  Result := StrDate(D) +' '+StrNumero(H.heure)+'h'+StrNumero(H.minute)
  else Result := StrDate(D) +' '+StrNumero(H.heure)+'h0'+StrNumero(H.minute) ;
end ;

Function Duree( DateHeure : TdateTime ) : ShortString ;
Var D : dates ;
    H : Heures ;
Begin
  D := ExtraitDate(DateHeure) ;
  H := ExtraitHeure(DateHeure) ;
  Result := '' ;
  If D.annee>=1900 then
  Begin
    D.annee := D.annee-1900 ;
    D.Mois := D.Mois - 1 ;
    D.jour := D.jour -1 ;
  end ;
  If D.annee=1 then Result := 'un an ' else If D.annee>1 then Result := IntToStr(D.annee)+' ans ' ;
  If D.mois>0 then Result := Result + IntToStr(D.Mois)+' mois ' ;
  If D.Jour=1 then Result := Result + 'un jour ' else if D.Jour>1 then Result := Result + IntToStr(D.jour)+' jours ' ;
  If H.heure>0 then Result := Result +IntToStr(H.Heure)+'h' ;
  If H.Minute>0 then if H.Minute>9 then Result := Result+IntToStr(H.Minute)+'mn' else Result := Result+'0'+IntToStr(H.Minute)+'mn' ;
  If H.Secondes>0 then if H.Secondes>9 then Result := Result+IntToStr(H.Secondes)+'s' else  Result := Result+'0'+IntToStr(H.Secondes)+'s';
  If Result = '' then result := '0s' ;
end ;

{Function Duree( DateHeure : TdateTime ) : ShortString ;
Var D : dates ;
    H : Heures ;
Begin
  D := ExtraitDate(DateHeure) ;
  H := ExtraitHeure(DateHeure) ;
  Result := '' ;
  If D.annee>=1900 then
  Begin
    D.annee := D.annee-1900 ;
    D.Mois := D.Mois - 1 ;
    D.jour := D.jour -1 ;
  end ;
  If D.annee=1 then Result := 'un an ' else If D.annee>1 then Result := IntToStr(D.annee)+' ans ' ;
  If D.mois>0 then Result := Result + IntToStr(D.Mois)+' mois ' ;
  If D.Jour=1 then Result := Result + 'un jour ' else if D.Jour>1 then Result := Result + IntToStr(D.jour)+' jours ' ;
  If H.heure>0 then Result := Result +IntToStr(H.Heure)+'h' ;
  If H.Minute>0 then if H.Minute>9 then Result := Result+IntToStr(H.Minute)+'mn' else Result := Result+'0'+IntToStr(H.Minute)+'mn' ;
  If H.Secondes>0 then if H.Secondes>9 then Result := Result+IntToStr(H.Secondes)+'s' else  Result := Result+'0'+IntToStr(H.Secondes)+'s';
  If Result = '' then result := '0s' ;
end ;

}






//{$IFDEF MSWINDOWS}
Function CurrentUser : ShortString ;
var
  u: array[0..127] of Char;
  sz:DWord;

begin
  sz:=SizeOf(u);
  GetUserName(u,sz);
  Result:=u;
end;



Procedure Historique( Evenement : ShortString) ;
Var T : TextFile ;
    Nf : String[30] ;
    N : String[2] ;
Begin
  If Not(AvecHistorique) then EXIT ;
  Nf := 'c:'+PathDelim+
        Copy(ExtractFileName(ParamStr(0)),1,CriterePos('.EXE',ExtractFileName(ParamStr(0)))- 1)+
        ' '+
        StrNumero(AujourDHui.annee) ;
  N := StrNumero(AujourDHui.mois) ;
  While Length(N)<2 do N := '0' + N ;
  Nf := Nf + N ;
  N := StrNumero(AujourDHui.jour) ;
  While Length(N)<2 do N := '0' + N ;
  Nf := Nf + N +'.HST' ;
  Assign(T,Nf) ;
  If Not FileEXists(Nf) then
  Begin
    Rewrite(T) ;
    Writeln(T,'Le '+DatetoStr(Date)+'  '+TimeToStr(Time)+' : CREATION DU FICHIER HISTORIQUE') ;
    CloseFile(T) ;
    //{$IFDEF MSWINDOWS}
    //FileSetAttr(Nf,faHidden) ;
    //{ $ENDIF}
  End ;
  Append(T) ;
  If Pos('Ouverture',Evenement)>0 then Writeln(T,'--------------------------------------------------------') ;
  Writeln(T,TimeToStr(Time)+' : '+Evenement) ;
  If Pos('Fermeture',Evenement)>0 then Writeln(T,'--------------------------------------------------------') ;
  CloseFile(T) ;
End ;

Function CreeRepertoire( NomRep : ShortString ) : Boolean ;
var RepPrecedant : ShortString ;
Begin
  Result := True ;
  If Not(CreateDir(NomRep)) then
  If Pos(PathDelim,NomRep)>1 then
  Begin
    RepPrecedant := NomRep ;
    While RepPrecedant[Length(RepPrecedant)]<>PathDelim do Delete(RepPrecedant,Length(RepPrecedant),1) ;
    Delete(RepPrecedant,Length(RepPrecedant),1) ;
    Result := CreeRepertoire(RepPrecedant) ;
    If Result then Result := CreateDir(NomRep) ;
  End Else Result := False ;
End ;

Function EnHexadecimal( Valeur : DWord ) : ShortString ;
Var DW : Dword ;
    Octet : Byte ;
    i : byte ;
Begin
  Result := '' ;
  For I := 1 to 8 do
  Begin
    Case I of
      1 : DW := Valeur and $F ;
      2 : DW := Valeur and $F0 ;
      3 : DW := Valeur and $F00 ;
      4 : DW := Valeur and $F000 ;
      5 : DW := Valeur and $F0000 ;
      6 : DW := Valeur and $F00000 ;
      7 : DW := Valeur and $F000000 ;
      8 : DW := Valeur and $F0000000 ;
    End ;
    DW := DW Shr (4*(i-1)) ;
    Octet := Lo(Lo(DW)) ;
    Case Octet of
      0 : Result := '0' + Result ;
      1 : Result := '1' + Result ;
      2 : Result := '2' + Result ;
      3 : Result := '3' + Result ;
      4 : Result := '4' + Result ;
      5 : Result := '5' + Result ;
      6 : Result := '6' + Result ;
      7 : Result := '7' + Result ;
      8 : Result := '8' + Result ;
      9 : Result := '9' + Result ;
     10 : Result := 'A' + Result ;
     11 : Result := 'B' + Result ;
     12 : Result := 'C' + Result ;
     13 : Result := 'D' + Result ;
     14 : Result := 'E' + Result ;
     15 : Result := 'F' + Result ;
    end ;
  End ;
End ;
Function StopAttribut( S : ShortString ) : ShortString ;
Begin
  Result := '' ;
  If Pos('<S>',S) >0 then Result := Result + '</S>' ;
  If Pos('<B>',S) >0 then Result := Result + '</B>' ;
  If Pos('<I>',S) >0 then Result := Result + '</I>' ;
  If Pos('<FONT',S)> 0  then  Result := Result + '</FONT>'  ;
End ;


Function Inseccable( S : ShortString ) : ShortString ;
Var PosEsp : Byte ;
Begin
  RemplaceA(' ','&nbsp;',S) ;
  Result := S ;
End ;

Function HauteurDecalee(Y : Integer) : Integer ;
Var DecalageTotal  : Integer ;
    I : Integer ;
Begin
 Result := - y ;
 If Length(TableauDesDecalages)=0 then EXIT ;
 DecalageTotal := 0 ;
 For I := 1 to Length(TableauDesDecalages) do
 If Y>TableauDesDecalages[I-1].Y then  DecalageTotal := DecalageTotal + TableauDesDecalages[I-1].Decalage ;
 Result := - Y + DecalageTotal ;
End ;

Function Remplace(Remplacer, Par : ShortString ; Var Texte : String ) : Integer ;
Var MRemplacer : ShortString ;
    MTexte : String ;
Begin
  MRemplacer := Majuscule(Remplacer) ;
  MTexte := Majuscule(Texte) ;
  Result := 0 ;
  While Pos(MRemplacer,Mtexte)>0 Do
  Begin
    Insert(#1,Texte,Pos(MRemplacer,Mtexte)) ;
    Insert(#1,MTexte,Pos(MRemplacer,Mtexte)) ;
    Delete(Texte,Pos(MRemplacer,MTexte),Length(Remplacer)) ;
    Delete(MTexte,Pos(MRemplacer,MTexte),Length(Remplacer)) ;
  End ;
  While Pos(#1,Texte)>0 Do
  Begin
    Insert(Par,Texte,Pos(#1,Texte)) ;
    Delete(Texte,Pos(#1,Texte),1) ;
    Inc(Result) ;
  End ;
End ;

Function RemplaceA(Remplacer, Par : ShortString ; Var Texte : ShortString ) : Integer  ;
Begin
  Result := 0 ;
  While Pos(Majuscule(Remplacer),Majuscule(Texte))>0 Do
  Begin
    Insert(#1,Texte,Pos(Majuscule(Remplacer),Majuscule(Texte))) ;
    Delete(Texte,Pos(Majuscule(Remplacer),Majuscule(Texte)),Length(Remplacer)) ;
  End ;
  While Pos(#1,Texte)>0 Do
  Begin
    Inc(Result) ;
    Insert(Par,Texte,Pos(#1,Texte)) ;
    Delete(Texte,Pos(#1,Texte),1) ;
  End ;
End ;

Procedure RemplaceX(Remplacer, Par : ShortString ; Var Texte : ShortString ) ;
Begin
  While Pos(Remplacer,Texte)>0 Do
  Begin
    Insert(#1,Texte,Pos(Remplacer,Texte)) ;
    Delete(Texte,Pos(Remplacer,Texte),Length(Remplacer)) ;
  End ;
  While Pos(#1,Texte)>0 Do
  Begin
    Insert(Par,Texte,Pos(#1,Texte)) ;
    Delete(Texte,Pos(#1,Texte),1) ;
  End ;
End ;
Procedure RemplaceXA(Remplacer, Par : ShortString ; Var Texte : String ) ;
Begin
  While Pos(Remplacer,Texte)>0 Do
  Begin
    Insert(#1,Texte,Pos(Remplacer,Texte)) ;
    Delete(Texte,Pos(Remplacer,Texte),Length(Remplacer)) ;
  End ;
  While Pos(#1,Texte)>0 Do
  Begin
    Insert(Par,Texte,Pos(#1,Texte)) ;
    Delete(Texte,Pos(#1,Texte),1) ;
  End ;
End ;

Function StrDe( Quoi : ShortString ) : ShortString ;
Begin
  If LangueUtilisee and $FF = $9 then Result := 'of '+quoi else
  If Pos(UpCase(Quoi[1]),'AEIOUYH')>0 then Result := 'd'''+Quoi else Result := 'de '+quoi ;
End ;

Function StrLe( Quoi : ShortString ; Feminin : Boolean ) : ShortString ;
Begin
  If LangueUtilisee and $FF = $9 then Result := 'the '+quoi else
  If Pos(UpCase(Quoi[1]),'AEIOUYH')>0
  then Result := 'l'''+Quoi
  else If Feminin
     then Result := 'la '+quoi
  else Result := 'le '+quoi ;
End ;

Function StrDeLe( Quoi : ShortString ; Feminin : Boolean ) : ShortString ;
Begin
  If LangueUtilisee and $FF = $9 then Result := 'of the '+quoi else
  If Pos(UpCase(Quoi[1]),'AEIOUYH')>0
  then Result := 'de l'''+Quoi
  else If Feminin
     then Result := 'de la '+quoi
  else Result := 'du '+quoi ;
End ;



Function RGB(R,G,B : Byte) : TColor ;
Var D : DWord ;
Begin
  D := B * 256 + G ;
  D := D * 256 + R ;
  Result := TColor(D) ;
End ;




Procedure Delay( Ms : Integer) ;
Var Heure : TDateTime ;
    Fin : TDateTime ;
Begin
  Heure := GetTime ;
  Fin := Heure + Ms/86400000  ;
  While Heure<Fin Do Heure := GetTime ;
End ;

Function IsValidFileName( S : String ) : Boolean ;
Var i : Integer ;
Begin
  If S='' then
  Begin
    Result := False ;
    EXIT ;
  End ;
  For I := 1 to Length(S) Do If Pos(S[I],'/\:*?"<>|')>0 then
  Begin
    Result := False ;
    EXIT ;
  End ;
  Result := True ;
End ;

Procedure ValidateFileName( Var S : String ) ;
Var i : Integer ;
    CI  : String[9] ;
    Car : String[1] ;
Begin
  If S='' then
  Begin
    S := 'x' ;
    EXIT ;
  End ;
  CI := '/\:*?"<>|' ;
  For I := 1 to Length(CI) do
  Begin
    Car := Copy(CI,I,1) ;
    Remplace(Car,'-',S) ;
  End ;
End ;

Function NomFichierValide( S : String ) : String ;
Begin
  ValidateFileName(S) ;
  Result := S ;
End ;


Procedure VersMac( Var S : ShortString ) ;
Begin
  If S='' then Exit ;
  RemplaceX('','',S) ;
  RemplaceX('-','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('_','!',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','''',S) ;
  RemplaceX('','2',S) ;
  RemplaceX('-','-',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','?',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','=',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','',S) ;
  RemplaceX('','-',S) ;
  RemplaceX('','',S) ;
End ;


Function FVersMac( S : ShortString ) : ShortString ;
Begin
  VersMac(S) ;
  Result := S ;
End ;

Function FVersMacA( S : String ) : String ;
Begin
  Result := '' ;
  If S='' then Exit ;
  RemplaceXA('','',S) ;
  RemplaceXA('-','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('_','!',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','''',S) ;
  RemplaceXA('','2',S) ;
  RemplaceXA('-','-',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','?',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','=',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','',S) ;
  RemplaceXA('','-',S) ;
  RemplaceXA('','',S) ;
  Result := S ;
End ;



Function Racine( X : Real ; N : Real ) : Real ;
Var A , B : Real ;
Begin
  //Application.MainForm.Caption := 'Racine '+StrCourt(n,2)+'me de '+StrCourt(X,2) ;
  If X<1 then Result := 0 else Result := Exp( ln(x) / n  ) ;
End ;

Function Puissance( X : Real ; N : Real ) : Real ;
Var A , B : Real ;
Begin
  //Application.MainForm.Caption := 'Racine '+StrCourt(n,2)+'me de '+StrCourt(X,2) ;
  If X<1 then Result := 0 else Result := Exp( ln(x) * n  ) ;
End ;

Function Arrondi( X : Real ; decimale : Byte ) : Real ;
Var Dix : Real ;
    R : Real ;
Begin
  Dix := Puissance(10,Decimale) ;
  R := X * Dix ;
  R := Round(R) ;
  R := R / Dix ;
  Result := R ;
End ;

Procedure ImprimeGraphicDansCanvas( Canvas : TCanvas ; R : TRect ; Image : TJPegImage ; TypeDeTramage : integer = 1 ; Bitmap : TBitMap = Nil  ) ;
Var
       BPP: Integer;
       ExMM : Integer ;
       I, J, X,Y, X2, Y2 : Integer ;
       Lpix,Hpix : Real ;
       Ok : Boolean ;
       Couleur : TColor ;
       Hp, Lp : Real  ;
       T : TextFile ;
       EX_MM : Integer ;
       //Couleurs : Array[-1..1,-1..1] of Byte ; supprim - tait envisag pour correction d'erreur (arrondi) radiale
       xx, yy : array[1..16] of Byte ;
       Erreur, Erreur3 : Byte ;
       ErreurH : array of Byte ;
       CouleurMax : Byte ;
       NR, CR,CV,CB : Real ;

begin
  If
      //  (Printer.PrinterIndex>-1) and     supprim car Printer index n''est jamais gal

     (Pos('ACROBAT',Majuscule(Printer.Printers[Printer.PrinterIndex]))>0) then BPP := 8
  else BPP := GetDeviceCaps(Canvas.Handle, BITSPIXEL) * GetDeviceCaps(Canvas.Handle, PLANES);
  If NeTramePas then BPP := 8 ;
  If  (BPP<8) // donc Imprimante en N&B (Black and White Printer)
    and                           //   E T  //
      (R.Right-R.Left>Image.Width)// L'image doit tre agrandie (Picture must be enlarged) SINON StrechDraw CONVIENT
                                  //                                             (ELSE StrechDraw )
  then
  Begin
    If BPP=0 then
    EX_MM := SetMapMode(Canvas.Handle,mm_text) ;
    EX_MM := SetMapMode(Canvas.Handle,mm_text) ;
    If EX_MM=mm_HiMetric then
    // Si le systme de coordonnes en cours est mm_HiMetric (dizimes de mm)
    // A FAIRE : grer les autres MapMode (TO DO : manage others MapMode)
    Begin
      R.Right := Round(R.Right / 2540 * Canvas.Font.PixelsPerInch) ;
      R.Left := Round(R.Left / 2540 * Canvas.Font.PixelsPerInch) ;
      R.Top := Round(-R.Top / 2540 * Canvas.Font.PixelsPerInch) ;
      R.Bottom := Round(-R.Bottom / 2540 * Canvas.Font.PixelsPerInch) ;
    End ;
    // Nombre de Pixel PHYSIQUES du rectangle de destination
    Lpix := (R.Right-R.Left) ;
    Hpix := (R.Bottom-R.Top) ;
    If BitMap=Nil then
    // Creation d'un BitMap quivalent au JPEG
    Begin
      If Image {TJpeg !} = NIL then EXIT ; // Jpeg=Nil possible IF BitMap<>Nil !!!!
      BitMap := TBitMap.Create ;
      BitMap.PixelFormat := pf24bit ;
      BitMap.Width := Image.Width ;
      BitMap.Height  := Image.Height ;
      BitMap.Canvas.Draw(0,0,Image) ;
    End ;
    // Dimension d'un Pixel de l'image en pixel du Canvas
    Lp := LPix / BitMap.Width ;
    Hp := HPix / BitMap.Height ;
    Canvas.Brush.Style := bsSolid ;
    Canvas.Brush.Color := ClBlack ;
    Canvas.Pen.Color := ClBlack ;
    If TypeDeTramage=1 then
    // TypeDeTramage = 1 : Trame de 16 pixels (4x4)
    Begin
       xx[1] := 1 ; yy[1] := 1 ;     //                                                     //
       xx[2] := 2 ; yy[2] := 2 ;     //           0   1   2   3                             //
       xx[3] := 2 ; yy[3] := 1 ;     //         |---|---|---|---|                           //
       xx[4] := 1 ; yy[4] := 2 ;     //      0  | 5 | 9 | G | 7 |     A = 10                //
       xx[5] := 0 ; yy[5] := 0 ;     //         |---|---|---|---|           ...  G = 16     //
       xx[6] := 3 ; yy[6] := 3 ;     //      1  | D | 1 | 3 | C |                           //
       xx[7] := 3 ; yy[7] := 0 ;     //         |---|---|---|---|                           //
       xx[8] := 0 ; yy[8] := 3 ;     //      2  | B | 4 | 2 | E |                           //
       xx[9] := 1 ; yy[9] := 0 ;     //         |---|---|---|---|                           //
       xx[10] :=2  ; yy[10] := 3 ;   //      3  | 8 | F | A | 6 |                           //
       xx[11] :=0  ; yy[11] := 2 ;   //         |---|---|---|---|                           //
       xx[12] :=3  ; yy[12] := 1 ;   //                                                     //
       xx[13] :=0  ; yy[13] := 1 ;   //                                                     //
       xx[14] :=3  ; yy[14] := 2 ;   //  Ce masque de trame peut tre amlior.
       xx[15] :=1  ; yy[15] := 3 ;   //  Par exemple recentr
       xx[16] :=2  ; yy[16] := 0 ;   //  (This Raster can be enhanced, for exemple recentered)
       Erreur := 0 ;
       SetLength(ErreurH,(R.Bottom  - R.Top) div 4 + 1) ;
       X2 := R.Left ;
       Repeat
         Y2 := R.Top ;
         Repeat
           X := Round((X2-R.Left)/Lp) ;
           Y := Round((Y2-R.Top)/Hp) ;
           Couleur := Bitmap.Canvas.Pixels[X,Y] ;
           CR := Couleur and $FF ;
           CV := (Couleur and $FF00 ) div 255 ;                      
           CB := ((Couleur and $FF0000 ) div 255) div 255 ;
           NR :=  Racine((255-CR)*(255-CV)*(255-CB),3.35) ;
           //NR := ((255-CR)+(255-CV)+(255-CB))/3 ;
           Couleur := 255-Round(NR) ;

           // REPORT de l'erreur d'arrondi (Dithering)
           Couleur := Couleur + erreur ;
           If X2 > R.Left then Couleur := Couleur + erreurH[(Y2-R.Top) div 4] ;
           // Calcul de l'ARRONDI et de Report de l'erreur d'arrondi (Dithering)
           NR := (Couleur ) / 16 ;
           Erreur := Couleur - 16*Round(Int(NR))  ;

           Couleur := Couleur div 16  ;

           // Repartition de l'erreur sur les point Y+1, et X+1, et (X+1,Y-1)
           If Y2-R.Top>0 then
           Begin
             erreurH[(Y2-R.Top) div 4] := erreur div 5 * 2 ;
             erreurH[(Y2-R.Top-4) div 4] := erreurH[(Y2-R.Top-4) div 4] + erreur div 5  ;
             erreur := erreur - (erreur div 5 * 3) ;
           End else
           Begin
             erreurH[(Y2-R.Top) div 4] := erreur div 2 ;
             erreur := erreur - (erreur div 2) ;
           End ;
           // Traage du masque de trame
           For I := 1 to 16 do
           Begin
             If Couleur>=16 then Break ;
             Canvas.Pixels[X2+xx[i],Y2+yy[i]] := clBlack ;
             Inc(Couleur) ;
           End ;
           // Trame suivante
           Y2 := Y2 + 4 ;
         Until Y2>=R.Bottom ;
         // Trame suivante
         X2 := X2 + 4 ;
       Until X2>=R.Right ;
       SetLength(ErreurH,0) ;
    End Else
    // Type de tramage 2 et 3 : Trames en partant de la source
    // la trame dpend du rapport taille Image / Taille en pixel de la destination
    For X := 0 to BitMap.Width do
    For Y := 0 to BitMap.Height do
    Begin
       Couleur := Bitmap.Canvas.Pixels[X,Y] ;
       Couleur := (Couleur and $FF + (Couleur and $FF00 )div 255 +  ((Couleur and $FF0000 ) div 255) div 255) DIV 3 ;
       //Couleur := Round(Couleur + cos( Couleur / 256 * 2 * pi )* ABS(Couleur-128) / 10   ) ;
           // ligne supprime - correction de courbe luminosite
       If TypeDeTramage=2 then
       // TypeDeTramage=2 : Trame alatoire (Random Rastering)
       Begin
         For X2 := Round( (X-0.5) * Lp) to Round( (X+0.5) * Lp) do
         For Y2 := Round( (Y-0.5) * Hp) to Round( (Y+0.5) * Hp) do
         If Random(210)>Couleur then Canvas.Pixels[R.Left+X2,R.Top+Y2] := clBlack ;
       End Else
       // un carr d'une taille inversement proportionnelle  la clart du point  reproduire est trac
       // (translate yourself !!!)
       If Couleur<255 then
       Canvas.Rectangle(R.Left+Round(X*Lp-(Lp*(255-couleur)/255/2)),
                      R.Top+Round(Y*Hp-(Hp*(255-couleur)/255/2)),
                      R.Left+Round(X*Lp+(Lp*(255-couleur)/255/2+0.5)),
                      R.Top+Round(Y*Hp+(Hp*(255-couleur)/255/2+0.5))
                      );
    End ;
    Canvas.Brush.Color := ClWhite ;
    Canvas.Pen.Color := ClBlack ;
    Canvas.Brush.Style := bsClear ;
    BitMap.Free ;
    SetMapMode(Canvas.Handle,EX_mm) ;
  End Else
  If BitMap=Nil then
  Begin
    If Image<>Nil then
    Begin
      Canvas.StretchDraw(R,Image);  // Si je ne double pas STRECHDRAW, l'image n'est pas toujours imprime
      Canvas.StretchDraw(R,Image);  // Pourquoi ? Je ne sais pas !
    End ;
  End else
  Begin
    Canvas.StretchDraw(R,BitMap);  // Si je ne double pas STRECHDRAW, l'image n'est pas toujours imprime
    Canvas.StretchDraw(R,BitMap);  // Je ne sais pas si ce problme se produit AUSSI avec un TBitMap ?
  End ;
end;


Function VersDates( J, M : Byte ; A : Word ) : Dates ;
Begin
  Result.Jour  := J ;
  Result.Mois  := M ;
  Result.Annee := A ;
End ;



function deldir(dir: String): boolean;
var
 fos: TSHFileOpStruct;

begin
 ZeroMemory(@fos, SizeOf(fos));
 with fos do begin
  wFunc := FO_DELETE;
  fFlags := FOF_SILENT or FOF_NOCONFIRMATION;
  pFrom := PChar(dir+#0);
 end;
Result:=(0=ShFileOperation(fos));
end;

Function DernierJourOuvre( d : dates ) : dates ;
Begin
    While (JourDeSemaine(D)='Dimanche') Or
          (JourDeSemaine(D)='Samedi') Or
          ((D.jour=1) and (D.Mois=1)) or
          ((D.jour=1) and (D.Mois=5)) or
          ((D.jour=8) and (D.Mois=5)) or
          ((D.jour=14) and (D.Mois=7)) or
          ((D.jour=15) and (D.Mois=8)) or
          ((D.jour=31) and (D.Mois=10)) or
          ((D.jour=11) and (D.Mois=11)) or
          ((D.jour=24) and (D.Mois=12)) or
          ((D.jour=31) and (D.Mois=12))                   DO Veille(D) ;
    Result := D ;
End ;


Function GetImage( Filename : TFileName ) : TJPegImage ;
Var NomCourt : TStr12 ;
    I : Integer ;
    ResultNil : Boolean ;
Begin
  ResultNil := True ;
  NomCourt := NomDeFichierCourt(FileName+'.jpg') ;
  Delete(NomCourt,Pos(ExtractFileExt(NomCourt),NomCourt),4) ;
  For I := 1 to Length(Images) Do
  If NomCourt=Images[i-1].NomFichierJPEG then
  Begin
    Result := Images[i-1].Image ;
    ResultNil := False ;
    BREAK ;
  End ;
  If ResultNil then
  If Not(FileExists(NomCourt+'.jpg')) then
  Begin
    BoiteDeMessage('Le fichier '+FileName+' est introuvable !','Une image AU HASARD s''affichera  sa place') ;
    If Length(Images)=0 then
    Begin
      SetLength(Images,Length(Images)+1) ;
      Images[Length(Images)-1].NomFichierJPEG := 'Config~1' ;
      Images[Length(Images)-1].Image := TJpegImage.create;
      Result := Images[Length(Images)-1].Image ;
      ResultNil := False ;
      Result.LoadFromFile('Config~1.JPG') ;
    End Else
    Begin
      Result := Images[Length(Images)-1].Image ;
      ResultNil := False ;
    End ;
  End else
  Begin
    SetLength(Images,Length(Images)+1) ;
    Images[Length(Images)-1].NomFichierJPEG := NomCourt ;
    Images[Length(Images)-1].Image := TJpegImage.create;
    Result := Images[Length(Images)-1].Image ;
    Result.LoadFromFile(NomCourt+'.jpg');
    ResultNil := False ;
  End ;
End ;







procedure Decoupe(CanvasCible : TCanvas ; Largeur : Integer ; Chaine : String ; Var LignesTexte : TableauDeLignes ) ;
Var S, SS, SSP : String ;
    Y, I : Integer ;
    PremierPassage : Boolean ;
begin
  SetLength(LignesTexte,0) ;
  If (Chaine='') or (Largeur<CanvasCible.TextWidth('i')) then
  Begin
    SetLength(LignesTexte,1) ;
    LignesTexte[0] := '' ;
    If Largeur<CanvasCible.TextWidth('i') then LignesTexte[0] := Chaine ;
  End ;
  While Chaine<>'' do
  Begin
    If Pos(#13,Chaine)>0 then
    Begin
      S := Copy(Chaine,1,Pos(#13,Chaine)) ;
      Delete(Chaine,1,Pos(#13,Chaine)) ;
    End else
    Begin
      S := Chaine ;
      Chaine := '' ;
    End ;
    PremierPassage := True ;
    While (S<>'') or PremierPassage do
    Begin
      SS := S ;
      PremierPassage := False ;
      S := '' ;
      While CanvasCible.TextWidth(SS)+6> Largeur do
      Begin
        S := Copy(SS,Length(SS),1) + S ;
        SS := Copy(SS,1,Length(SS)-1) ;
        If Pos(' ',SS)>0 then
        While Copy(SS,Length(SS),1)<>' ' do
        Begin
          S := Copy(SS,Length(SS),1) + S ;
          SS := Copy(SS,1,Length(SS)-1) ;
        End ;
      End ;
      Remplace(#10,'',SS) ;
      Remplace(#13,'',SS) ;
      SetLength(LignesTexte,Length(LignesTexte)+1) ;
      LignesTexte[Length(LignesTexte)-1] := SS ;
      SSP := SS ;
      Remplace('','',SS) ;
    End ;
  End ;
end ;

Function HTMLVersTXT( Var Chaine : OpenString ) : Integer ;
Var LengthIni : Integer ;
    SS : ShortString ;
Begin
  LengthIni := Length(Chaine) ;
  RemplaceA('&quot;', #34, Chaine ) ;
  RemplaceA('&amp;', #38, Chaine ) ;
  RemplaceA('&nbsp;', #160, Chaine ) ;
  RemplaceA('&iexcl;', #161, Chaine ) ;
  RemplaceA('&cent;', #162, Chaine ) ;
  RemplaceA('&pound;', #163, Chaine ) ;
  RemplaceA('&curren;', #164, Chaine ) ;
  RemplaceA('&yen;', #165, Chaine ) ;
  RemplaceA('&brvbar;', #166, Chaine ) ;
  RemplaceA('&sect;', #167, Chaine ) ;
  RemplaceA('&uml;', #168, Chaine ) ;
  RemplaceA('&copy;', #169, Chaine ) ;
  RemplaceA('&ordf;', #170, Chaine ) ;
  RemplaceA('&laquo;', #171, Chaine ) ;
  RemplaceA('&not;', #172, Chaine ) ;
  RemplaceA('&shy;', #173, Chaine ) ;
  RemplaceA('&reg;', #174, Chaine ) ;
  RemplaceA('&macr;', #175, Chaine ) ;
  RemplaceA('&deg;', #176, Chaine ) ;
  RemplaceA('&plusmn;', #177, Chaine ) ; 
  RemplaceA('&sup2;', #178, Chaine ) ; 
  RemplaceA('&sup3;', #179, Chaine ) ; 
  RemplaceA('&acute;', #180, Chaine ) ;
  RemplaceA('&micro;', #181, Chaine ) ; 
  RemplaceA('&para;', #182, Chaine ) ; 
  RemplaceA('&middot;', #183, Chaine ) ; 
  RemplaceA('&cedil;', #184, Chaine ) ; 
  RemplaceA('&sup1;', #185, Chaine ) ; 
  RemplaceA('&ordm;', #186, Chaine ) ; 
  RemplaceA('&raquo;', #187, Chaine ) ; 
  RemplaceA('&frac14;', #188, Chaine ) ; 
  RemplaceA('&frac12;', #189, Chaine ) ; 
  RemplaceA('&frac34;', #190, Chaine ) ; 
  RemplaceA('&iquest;', #191, Chaine ) ; 
  RemplaceA('&Agrave;', #192, Chaine ) ; 
  RemplaceA('&Aacute;', #193, Chaine ) ; 
  RemplaceA('&Acirc;', #194, Chaine ) ; 
  RemplaceA('&Atilde;', #195, Chaine ) ; 
  RemplaceA('&Auml;', #196, Chaine ) ;
  RemplaceA('&Aring;', #197, Chaine ) ; 
  RemplaceA('&AElig;', #198, Chaine ) ; 
  RemplaceA('&Ccedil;', #199, Chaine ) ; 
  RemplaceA('&Egrave;', #200, Chaine ) ;
  RemplaceA('&Eacute;', #201, Chaine ) ; 
  RemplaceA('&Ecirc;', #202, Chaine ) ; 
  RemplaceA('&Euml;', #203, Chaine ) ; 
  RemplaceA('&Igrave;', #204, Chaine ) ; 
  RemplaceA('&Iacute;', #205, Chaine ) ; 
  RemplaceA('&Icirc;', #206, Chaine ) ; 
  RemplaceA('&Iuml;', #207, Chaine ) ; 
  RemplaceA('&ETH;', #208, Chaine ) ; 
  RemplaceA('&Ntilde;', #209, Chaine ) ; 
  RemplaceA('&Ograve;', #210, Chaine ) ; 
  RemplaceA('&Oacute;', #211, Chaine ) ; 
  RemplaceA('&Ocirc;', #212, Chaine ) ; 
  RemplaceA('&Otilde;', #213, Chaine ) ; 
  RemplaceA('&Ouml;', #214, Chaine ) ; 
  RemplaceA('&times;', #215, Chaine ) ; 
  RemplaceA('&Oslash;', #216, Chaine ) ;
  RemplaceA('&Ugrave;', #217, Chaine ) ; 
  RemplaceA('&Uacute;', #218, Chaine ) ; 
  RemplaceA('&Ucirc;', #219, Chaine ) ; 
  RemplaceA('&Uuml;', #220, Chaine ) ;
  RemplaceA('&Yacute;', #221, Chaine ) ; 
  RemplaceA('&THORN;', #222, Chaine ) ; 
  RemplaceA('&szlig;', #223, Chaine ) ; 
  RemplaceA('&agrave;', #224, Chaine ) ; 
  RemplaceA('&aacute;', #225, Chaine ) ; 
  RemplaceA('&acirc;', #226, Chaine ) ; 
  RemplaceA('&atilde;', #227, Chaine ) ; 
  RemplaceA('&auml;', #228, Chaine ) ; 
  RemplaceA('&aring;', #229, Chaine ) ; 
  RemplaceA('&aelig;', #230, Chaine ) ; 
  RemplaceA('&ccedil;', #231, Chaine ) ; 
  RemplaceA('&egrave;', #232, Chaine ) ; 
  RemplaceA('&eacute;', #233, Chaine ) ; 
  RemplaceA('&ecirc;', #234, Chaine ) ; 
  RemplaceA('&euml;', #235, Chaine ) ; 
  RemplaceA('&igrave;', #236, Chaine ) ;
  RemplaceA('&iacute;', #237, Chaine ) ; 
  RemplaceA('&icirc;', #238, Chaine ) ; 
  RemplaceA('&iuml;', #239, Chaine ) ; 
  RemplaceA('&eth;', #240, Chaine ) ;
  RemplaceA('&ntilde;', #241, Chaine ) ; 
  RemplaceA('&ograve;', #242, Chaine ) ; 
  RemplaceA('&oacute;', #243, Chaine ) ;
  RemplaceA('&ocirc;', #244, Chaine ) ; 
  RemplaceA('&otilde;', #245, Chaine ) ; 
  RemplaceA('&ouml;', #246, Chaine ) ; 
  RemplaceA('&divide;', #247, Chaine ) ; 
  RemplaceA('&oslash;', #248, Chaine ) ; 
  RemplaceA('&ugrave;', #249, Chaine ) ; 
  RemplaceA('&uacute;', #250, Chaine ) ; 
  RemplaceA('&ucirc;', #251, Chaine ) ; 
  RemplaceA('&uuml;', #252, Chaine ) ; 
  RemplaceA('&yacute;', #253, Chaine ) ; 
  RemplaceA('&thorn;', #254, Chaine ) ; 
  RemplaceA('&yuml;', #255, Chaine ) ;
  RemplaceA('&lt;','<',Chaine) ;
  RemplaceA('&gt;','>',Chaine) ;
  While Pos('&#',Chaine)>0 Do
  Begin
    SS := Copy(Chaine,Pos('&#',Chaine),255) ;
    If Pos(';',SS)>1 then Delete(SS,Pos(';',SS),255) ;
    RemplaceA(SS+';',Chr(StrToInt(Copy(SS,3,255))),Chaine) ;
  End ;
  Result := LengthIni - Length(Chaine) ;
End ;

Function TextHTMLOut ( CanvasCible : TCanvas ;  X, Y, Largeur : Integer ; Chaine : String ; AvecMarques : Boolean = False ) : Integer ;
Var Car, Car2 : String[1] ;
    W, xx, Xc, i, iPrec, II, iii, J, HMax, HMin, HH, DX : Integer ;
    Balise, SB : ShortString ;
    FS : TFontStyles ;
    ExCL : TColor ;
    DW : DWord ;
    Count : Byte ;
    TelQuel : String ;
    SS : ShortString ;
    Alignement : Char ;
    Rect, Rect2 : Trect ;
    BitMap : TBitMap ;
    Image : TJpegImage ;
    Mots : Array of ShortString ;
    XEspace : Integer ;
    CursorPos, MotLength, Ajouter : Integer ;
    ExName  : ShortString ;
    ExStyle : TFontStyles ;
    ExColor : Tcolor ;
    ExSize  : Integer ;
    Dernxx : Integer ;
Begin
  DernXX := 0 ;
  SetLength(TableauDesLiens,0) ;
  SetLength(TableauDesCursorPos,0) ;
  SetLength(Fontes,0) ;
  Xc := X ;
  Largeur := xc +Largeur ;
  I := 1 ;
  Alignement := 'L' ;
  HMin := CanvasCible.TextHeight('W') ;
  CanvasCible.Brush.Style := bsClear ;
  TelQuel := '' ;
  While I<=Length(Chaine) do
  Begin
    Car := Copy(Chaine,I,1) ;
    If Car = '<' then
    Begin
      If Telquel<>'' then
      Begin
        CursorPos := I-Length(TelQuel) ;
        SetLength(Mots,0) ;
        While Pos(' ',TelQuel)>0 do
        Begin
          SetLength(Mots,Length(Mots)+1) ;
          Mots[Length(Mots)-1] := Copy(TelQuel,1,Pos(' ',TelQuel));
          Delete(TelQuel,1,Pos(' ',TelQuel)) ;
        End ;
        If Telquel<>'' then
        Begin
          SetLength(Mots,Length(Mots)+1) ;
          Mots[Length(Mots)-1] := Telquel ;
          TelQuel := '' ;
        End ;
        For Ii := 1 to Length(Mots) do
        Begin
          MotLength := Length(Mots[ii-1]) ;
          Ajouter := HTMLVersTxt(Mots[ii-1]) ;
          If (X+CanvasCible.TextWidth(Mots[ii-1])>Largeur) and
             (X<>XC) then
          Begin
            If XEspace>XC then
            Begin
              Rect.Left := XEspace ;
              Rect.Right := X ;
              Rect.Top := Y ;
              Rect.Bottom := Y + Hmax ;
              Rect2.Left := XC ;
              Rect2.Right := X + Xc - Xespace ;
              Rect2.Top := Rect.Bottom ;
              Rect2.Bottom := Rect2.Top+ Hmax  ;
              CanvasCible.CopyRect(Rect2,CanvasCible,Rect);
              CanvasCible.Pen.color := CanvasCible.Pixels[x,y] ;
              CanvasCible.Brush.color := CanvasCible.Pixels[x,y] ;
              CanvasCible.Brush.style := bsSolid ;
              CanvasCible.Rectangle(Rect) ;
              CanvasCible.Brush.style := bsClear ;
            End ;
            Rect.Left := Xc ;
            Rect.Right := X ;
            If XEspace>XC then
            Begin
              X := Rect2.Right ;
              XEspace := Rect2.Right ;
            End Else
            Begin
              X := Xc ;
              XEspace := XC ;
            End ;
            Rect.Top := Y ;
            If HMax=0 then Y := Y + Hmin else Y := Y + Hmax ;
            Hmax := 0 ;
            Rect.Bottom := Y ;
            DX := 0 ;
            If Alignement='R' then DX := Largeur - Rect.Right ;
            If Alignement='C' then DX := (Largeur - Rect.Right) div 2 ;
            Rect2 := Rect ;
            Rect2.Left := Rect2.Left + DX ;
            Rect2.Right := Rect2.Right + DX ;
            If Alignement<>'L' then
            Begin
              CanvasCible.CopyRect(Rect2,CanvasCible,Rect);
              CanvasCible.Pen.color := CanvasCible.Pixels[x,y] ;
              CanvasCible.Brush.color := CanvasCible.Pixels[x,y] ;
              CanvasCible.Brush.style := bsSolid ;
              Rect.Right := Rect.Left + DX ;
              CanvasCible.Rectangle(Rect) ;
              CanvasCible.Brush.style := bsClear ;
              For iii := 1 to Length(TableauDesCursorPos) do
              Begin
                If TableauDesCursorPos[iii-1].Yd=Rect.Top then
                Begin
                  TableauDesCursorPos[iii-1].Xd := TableauDesCursorPos[iii-1].Xd + DX ;
                  TableauDesCursorPos[iii-1].Xf := TableauDesCursorPos[iii-1].Xf + DX ;
                End ;
              End ;
            End ;
          End ;
          SetLength(TableauDesCursorPos,Length(TableauDesCursorPos)+1) ;
          TableauDesCursorPos[Length(TableauDesCursorPos)-1].Name := CanvasCible.Font.Name ;
          TableauDesCursorPos[Length(TableauDesCursorPos)-1].Size := CanvasCible.Font.Size ;
          TableauDesCursorPos[Length(TableauDesCursorPos)-1].Color := CanvasCible.Font.Color ;
          TableauDesCursorPos[Length(TableauDesCursorPos)-1].Style := CanvasCible.Font.Style ;
          TableauDesCursorPos[Length(TableauDesCursorPos)-1].xd := x ;
          TableauDesCursorPos[Length(TableauDesCursorPos)-1].yd := y ;
          TableauDesCursorPos[Length(TableauDesCursorPos)-1].CursorPos := CursorPos ;
          CursorPos := CursorPos + MotLength ;
          iPrec := i ;
          CanvasCible.TextOut(X,Y,Mots[ii-1]);
          X := X  +  CanvasCible.TextWidth(Mots[ii-1]);
          If Pos(' ',Mots[ii-1])>0 then XEspace := X-1 ;
          If HMax < CanvasCible.TextHeight(Mots[ii-1])
                                       then HMax := CanvasCible.TextHeight(Mots[ii-1]) ;
          TableauDesCursorPos[Length(TableauDesCursorPos)-1].xf := x ;
          TableauDesCursorPos[Length(TableauDesCursorPos)-1].yf := Y + HMax ;
        End ;
      End ;
      If AvecMarques  and (DernXX<>x)then
      Begin
        Balise := Copy(Chaine,i+1,6) ;
        Car2 := Copy(Chaine,I+1,1) ;
        CanvasCible.Brush.Color := clYellow ;
        If car2='/' then
        Begin
          xx := x-1 ;
          Car2 := Copy(Chaine,I+2,1) ;
          Balise := Copy(Chaine,i+2,6) ;
        End else
        Begin
          xx := x ;
          Balise := Majuscule(Balise) ;
          If (Pos('HEAD',Balise)<>1) and
             (Pos('HTML',Balise)<>1) and
             (Pos('HR',Balise)<>1) then
          Begin
            // Trait
            DernXX := X ;
            ExColor := CanvasCible.Pen.Color ;
            CanvasCible.Pen.Color := clGray ;
            CanvasCible.MoveTo(xx,Y) ;
            CanvasCible.Lineto(xx,Y+HMax) ;
            CanvasCible.Pen.Color := ExColor ;
            // Balise
            if xx<>x then xx := xx - 5 else xx := x +1;
            ExName  := CanvasCible.Font.Name  ;
            ExStyle := CanvasCible.Font.Style ;
            ExColor := CanvasCible.Font.Color ;
            ExSize  := CanvasCible.Font.Size  ;
            CanvasCible.Font.Name  := 'Tahoma'  ;
            CanvasCible.Font.Style := [] ;
            CanvasCible.Font.Color := clBlack ;
            CanvasCible.Font.Size  := 6  ;
            Case Car2[1] of
              'B' : If Pos('B>',Balise)=1 then CanvasCible.Font.Style := [fsBold] else CanvasCible.Font.Color := clPurple ;
              'U' : CanvasCible.Font.Style := [fsUnderline] ;
              'I' : if Pos('IMG',Balise)=1 then CanvasCible.Font.Color := clGreen else CanvasCible.Font.Style := [fsItalic] ;
              'F' : CanvasCible.Font.Color := clBlue ;
              'P' : CanvasCible.Font.Color := clPurple ;
              'A' : CanvasCible.Font.Color := clRed ;
            end ;
            CanvasCible.TextOut(xx,y,Car2) ;
            CanvasCible.Font.Name  := ExName  ;
            CanvasCible.Font.Style := ExStyle ;
            CanvasCible.Font.Color := ExColor ;
            CanvasCible.Font.Size  := ExSize  ;
            CanvasCible.Brush.Style := bsClear ;
          End ;
        End ;
      End ;
      Balise := Car ;
      While Car<>'>' do
      Begin
        Inc(I) ;
        Car := Copy(Chaine,I,1) ;
        Balise := Balise + Car ;
      End ;
      Inc(i) ;
      While Pos('< ',Balise)>0 do RemplaceA('< ','<',Balise) ;
      While Pos(' >',Balise)>0 do RemplaceA(' >','>',Balise) ;
      // Fonte
      If (Pos('<FONT',Majuscule(Balise))=1) then
      Begin
        SetLength(Fontes,Length(Fontes)+1) ;
        Fontes[Length(Fontes)-1].Name := CanvasCible.Font.Name ;
        Fontes[Length(Fontes)-1].Style := CanvasCible.Font.Style ;
        Fontes[Length(Fontes)-1].Color := CanvasCible.Font.Color ;
        Fontes[Length(Fontes)-1].Size := CanvasCible.Font.Size ;
        Delete(Balise,1,5) ;
        RemplaceA('>',' ',Balise) ;
        While Pos(' =',Balise)>0 do RemplaceA(' =','=',Balise) ;
        While Pos('= ',Balise)>0 do RemplaceA('= ','=',Balise) ;
        ElagueLesEspaces(Balise) ;
        While Balise<>'' do
        Begin
          If Pos('COLOR=',Majuscule(Balise))=1 then
          Begin
            Delete(Balise,1,6) ;
            If Pos(' ',Balise)>0 then
            Begin
              SB := Copy(Balise,1,Pos(' ',Balise)-1) ;
              Delete(Balise,1,Pos(' ',Balise)) ;
            End Else
            Begin
              SB := Balise ;
              Balise := '' ;
            End ;
            If Pos('#',SB)=1 then
            Begin
              SB[1] := '$' ;
              DW := StrToInt(SB) ;
              DW := (DW and $FF) shl 16
                  + (DW and $FF00)
                  + (DW and $FF0000) shr 16 ;
              CanvasCible.Font.Color := TColor(DW) ;
            End Else
            Begin
              //  implmenter SB = Blue Red Yellow etc...
            End ;
          End else
          If (Pos('FACE=',Majuscule(Balise))=1) or
             (Pos('NAME=',Majuscule(Balise))=1) then
          Begin
            Delete(Balise,1,5) ;
            Count := 0 ;
            SB := '' ;
            While Count<2 do
            Begin
              Car := Copy(Balise,1,1) ;
              Delete(Balise,1,1) ;
              If Car='"' then Inc(Count) ;
              SB := SB + Car ;
              If Balise='' then Count := 2 ;
            End ;
            Delete(SB,1,1)  ;
            Dec(SB[0]) ;
            CanvasCible.Font.Name := SB ;
          End else
          If (Pos('SIZE=',Majuscule(Balise))=1)  then
          Begin
            Delete(Balise,1,5) ;
            Count := 0 ;
            SB := '' ;
            If Balise[1]<>'"' then
            Begin
              Insert('"',Balise,1) ;
              If Pos(' ',Balise)>1 then Insert('"',Balise,Pos(' ',Balise)) else Balise := Balise + '"' ;
            End ;
            While Count<2 do
            Begin
              Car := Copy(Balise,1,1) ;
              Delete(Balise,1,1) ;
              If Car='"' then Inc(Count) ;
              SB := SB + Car ;
              If Balise='' then Count := 2 ;
            End ;
            Delete(SB,1,1)  ;
            Dec(SB[0]) ;
            If StrToInt(SB)<8 then CanvasCible.Font.Size := StrToInt(SB) * 4 else CanvasCible.Font.Size := StrToInt(SB) ;
          End else
          While Balise[1]<>' ' do
          Begin
            Balise[1] := ' ';
            Delete(Balise,1,1) ;
          End ;
          ElagueLesEspaces(Balise) ;
        End ;
      End Else
      If (Pos('</FONT',Majuscule(Balise))=1) then
      // Fin de FONTE
      Begin
        If Length(Fontes)>0 then
        Begin
          CanvasCible.Font.Name  := Fontes[Length(Fontes)-1].Name ;
          CanvasCible.Font.Style := Fontes[Length(Fontes)-1].Style ;
          CanvasCible.Font.Color := Fontes[Length(Fontes)-1].Color ;
          CanvasCible.Font.Size  := Fontes[Length(Fontes)-1].Size ;
          SetLength(Fontes,Length(Fontes)-1) ;
        End ;
      End else
      // Lien
      If (Pos('<A',Majuscule(Balise))=1) then
      Begin
        SetLength(Fontes,Length(Fontes)+1) ;
        Fontes[Length(Fontes)-1].Name := CanvasCible.Font.Name ;
        Fontes[Length(Fontes)-1].Style := CanvasCible.Font.Style ;
        Fontes[Length(Fontes)-1].Color := CanvasCible.Font.Color ;
        Fontes[Length(Fontes)-1].Size := CanvasCible.Font.Size ;
        Delete(Balise,1,2) ;
        RemplaceA('>',' ',Balise) ;
        While Pos(' =',Balise)>0 do RemplaceA(' =','=',Balise) ;
        While Pos('= ',Balise)>0 do RemplaceA('= ','=',Balise) ;
        ElagueLesEspaces(Balise) ;
        While Balise<>'' do
        Begin
          If Pos('HREF=',Majuscule(Balise))=1 then
          Begin
            Delete(Balise,1,5) ;
            Count := 0 ;
            SB := '' ;
            While Count<2 do
            Begin
              Car := Copy(Balise,1,1) ;
              Delete(Balise,1,1) ;
              If Car='"' then Inc(Count) ;
              SB := SB + Car ;
              If Balise='' then Count := 2 ;
            End ;
            Delete(SB,1,1)  ;
            Dec(SB[0]) ;
            SetLength(TableauDesLiens,Length(TableauDesLiens)+1) ;
            With TableauDesLiens[Length(TableauDesLiens)-1] do
            Begin
              X1 := X ;
              Y1 := Y ;
              Lien := SB ;
            End ;
            CanvasCible.Font.Color := clBlue ;
            FS := CanvasCible.Font.Style ;
            Include(FS,fsUnderline) ;
            CanvasCible.Font.Style := fs ;
          End else
          While Balise[1]<>' ' do
          Begin
            Balise[1] := ' ';
            Delete(Balise,1,1) ;
          End ;
          ElagueLesEspaces(Balise) ;
        End ;
      End Else
      If (Pos('</A',Majuscule(Balise))=1) then
      // Fin de Lien
      Begin
        With TableauDesLiens[Length(TableauDesLiens)-1] do
        Begin
          X2 := X ;
          Y2 := Y + HMax ;
          Lien := SB ;
        End ;
        If Length(Fontes)>0 then
        Begin
          CanvasCible.Font.Name  := Fontes[Length(Fontes)-1].Name ;
          CanvasCible.Font.Style := Fontes[Length(Fontes)-1].Style ;
          CanvasCible.Font.Color := Fontes[Length(Fontes)-1].Color ;
          CanvasCible.Font.Size  := Fontes[Length(Fontes)-1].Size ;
          SetLength(Fontes,Length(Fontes)-1) ;
        End ;
      End else
      // Lien
      If (Pos('<IMG',Majuscule(Balise))=1) then
      Begin
        Image := Nil ;
        SS := '' ;
        Delete(Balise,1,4) ;
        RemplaceA('>',' ',Balise) ;
        While Pos(' =',Balise)>0 do RemplaceA(' =','=',Balise) ;
        While Pos('= ',Balise)>0 do RemplaceA('= ','=',Balise) ;
        ElagueLesEspaces(Balise) ;
        While Balise<>'' do
        Begin
          If Pos('SRC=',Majuscule(Balise))=1 then
          Begin
            Delete(Balise,1,4) ;
            Count := 0 ;
            SB := '' ;
            While Count<2 do
            Begin
              Car := Copy(Balise,1,1) ;
              Delete(Balise,1,1) ;
              If Car='"' then Inc(Count) ;
              SB := SB + Car ;
              If Balise='' then Count := 2 ;
            End ;
            Delete(SB,1,1)  ;
            Dec(SB[0],5) ;
            If FileExists(SB+'.jpg') then Image := GetImage(SB) ;
          End else
          If Pos('WIDTH=',Majuscule(Balise))=1 then
          Begin
            Delete(Balise,1,6) ;
            If Balise[1]<>'"' then
            Begin
              Insert('"',Balise,1) ;
              If Pos(' ',Balise)>1 then Insert('"',Balise,Pos(' ',Balise)) else Balise := Balise + '"' ;
            End ;
            Count := 0 ;
            SB := '' ;
            While Count<2 do
            Begin
              Car := Copy(Balise,1,1) ;
              Delete(Balise,1,1) ;
              If Car='"' then Inc(Count) ;
              SB := SB + Car ;
              If Balise='' then Count := 2 ;
            End ;
            delete(SB,1,1) ;
            If SB<>'' then Dec(SB[0]) ;
            SS := SB ;
          End else
          While Balise[1]<>' ' do
          Begin
            Balise[1] := ' ';
            Delete(Balise,1,1) ;
          End ;
          ElagueLesEspaces(Balise) ;
        End ;
        If Image<>Nil then
        Begin
          Rect.Left := X ;
          Rect.Top := Y ;
          If SS<>'' then
          If Pos('%',SS)>0 then
          Begin
            RemplaceA('%','',SS) ;
            W :=  StrToInt(SS) ;
            Rect.Right := Round(Image.Width * W / 100) + x;
            Rect.Bottom := Round(Image.Height * W / 100) + y ;
          End else
          Begin
            W :=  StrToInt(SS) ;
            Rect.Right := W + x ;
            Rect.Bottom := Round(W * Image.Height / Image.Width) + y ;
          End else
          Begin
            Rect.Right := Image.Width  + x;
            Rect.Bottom := Image.Height + y ;
          End ;
          ImprimeGraphicDansCanvas( CanvasCible,Rect,Image) ;
          If Rect.Bottom-Rect.Top>HMax then HMax := Rect.Bottom-Rect.Top ;
          X := Rect.Right + 1 ;
        End ;
      End Else
      // Titres
      If (Pos('<HR',Majuscule(Balise))=1) then
      Begin
        X := Xc ; XEspace := XC ;
        If HMax=0 then  Y := Y + HMin else Y := Y + HMax ;
        CanvasCible.Pen.Color := clBlack ;
        CanvasCible.MoveTo(X,Y) ;
        CanvasCible.LineTo(Largeur,Y) ;
        X := Xc ; XEspace := XC ;
        If HMax=0 then  Y := Y + HMin else Y := Y + HMax ;
        HMax := 0 ;
      End else
      If (Pos('<H',Majuscule(Balise))=1) then
      Begin
        If (Pos('<HTML',Majuscule(Balise))<>1) and
           (Pos('<HEAD',Majuscule(Balise))<>1)then
        Begin
          SetLength(Fontes,Length(Fontes)+1) ;
          Fontes[Length(Fontes)-1].Name := CanvasCible.Font.Name ;
          Fontes[Length(Fontes)-1].Style := CanvasCible.Font.Style ;
          Fontes[Length(Fontes)-1].Color := CanvasCible.Font.Color ;
          Fontes[Length(Fontes)-1].Size := CanvasCible.Font.Size ;
          Delete(Balise,1,2) ;
          CanvasCible.Font.Size := (5-StrToInt(Balise[1]))*4 ;
          CanvasCible.Font.Style := [fsBold] ;
        End ;
      End Else
      If (Pos('</H',Majuscule(Balise))=1) then
      // Fin de Titre
      Begin
        If (Pos('</HTML',Majuscule(Balise))<>1) and
           (Pos('</HEAD',Majuscule(Balise))<>1)then
        If Length(Fontes)>0 then
        Begin
          CanvasCible.Font.Name  := Fontes[Length(Fontes)-1].Name ;
          CanvasCible.Font.Style := Fontes[Length(Fontes)-1].Style ;
          CanvasCible.Font.Color := Fontes[Length(Fontes)-1].Color ;
          CanvasCible.Font.Size  := Fontes[Length(Fontes)-1].Size ;
          SetLength(Fontes,Length(Fontes)-1) ;
        End ;
      End else
      // BLOCKQUOTE
      If (Pos('<BLOCKQUOTE',Majuscule(Balise))=1) or (Pos('<DIR',Majuscule(Balise))=1) then
      Begin
        If Xc<>X then
        Begin
          Rect.Left := Xc ;
          Rect.Right := X ;
          X := Xc ; XEspace := XC ;
          Rect.Top := Y ;
          If HMax=0 then Y := Y + Hmin else Y := Y + Hmax ;
          Hmax := 0 ;
          Rect.Bottom := Y ;
          DX := 0 ;
          If Alignement='R' then DX := Largeur - Rect.Right ;
          If Alignement='C' then DX := (Largeur - Rect.Right) div 2 ;
          Rect2 := Rect ;
          Rect2.Left := Rect2.Left + DX ;
          Rect2.Right := Rect2.Right + DX ;
          If Alignement<>'L' then
          Begin
            CanvasCible.CopyRect(Rect2,CanvasCible,Rect);
            CanvasCible.Pen.color := CanvasCible.Pixels[x,y] ;
            CanvasCible.Brush.color := CanvasCible.Pixels[x,y] ;
            CanvasCible.Brush.style := bsSolid ;
            Rect.Right := Rect.Left + DX ;
            CanvasCible.Rectangle(Rect) ;
            CanvasCible.Brush.style := bsClear ;
            For iii := 1 to Length(TableauDesCursorPos) do
            Begin
              If TableauDesCursorPos[iii-1].Yd=Rect.Top then
              Begin
                TableauDesCursorPos[iii-1].Xd := TableauDesCursorPos[iii-1].Xd + DX ;
                TableauDesCursorPos[iii-1].Xf := TableauDesCursorPos[iii-1].Xf + DX ;
              End ;
            End ;
          End ;
        End ;
        Xc := Xc + 30 ;
        X := Xc ; XEspace := XC ;
      End else
      // Fin BLOCKQUOTE
      If (Pos('</BLOCKQUOTE',Majuscule(Balise))=1) or (Pos('</DIR',Majuscule(Balise))=1) then
      Begin
        If Xc<>X then
        Begin
          Rect.Left := Xc ;
          Rect.Right := X ;
          X := Xc ; XEspace := XC ;
          Rect.Top := Y ;
          If HMax=0 then Y := Y + Hmin else Y := Y + Hmax ;
          Hmax := 0 ;
          Rect.Bottom := Y ;
          If Alignement='R' then DX := Largeur - Rect.Right ;
          If Alignement='C' then DX := (Largeur - Rect.Right) div 2 ;
          Rect2 := Rect ;
          Rect2.Left := Rect2.Left + DX ;
          Rect2.Right := Rect2.Right + DX ;
          If Alignement<>'L' then
          Begin
            CanvasCible.CopyRect(Rect2,CanvasCible,Rect);
            CanvasCible.Pen.color := CanvasCible.Pixels[x,y] ;
            CanvasCible.Brush.color := CanvasCible.Pixels[x,y] ;
            CanvasCible.Brush.style := bsSolid ;
            Rect.Right := Rect.Left + DX ;
            CanvasCible.Rectangle(Rect) ;
            CanvasCible.Brush.style := bsClear ;
            For iii := 1 to Length(TableauDesCursorPos) do
            Begin
              If TableauDesCursorPos[iii-1].Yd=Rect.Top then
              Begin
                TableauDesCursorPos[iii-1].Xd := TableauDesCursorPos[iii-1].Xd + DX ;
                TableauDesCursorPos[iii-1].Xf := TableauDesCursorPos[iii-1].Xf + DX ;
              End ;
            End ;
          End ;
        End ;
        Xc := Xc - 30 ;
        X := Xc ; XEspace := XC ;
      End else
      // Paragraphe-------------------------------------------------------------
      If (Pos('<P',Majuscule(Balise))=1) or (Pos('<BR',Majuscule(Balise))=1) then
      Begin
        Rect.Left := Xc ;
        Rect.Right := X ;
        X := Xc ; XEspace := XC ;
        Rect.Top := Y ;
        If HMax=0 then Y := Y + Hmin else Y := Y + Hmax ;
        Hmax := 0 ;
        Rect.Bottom := Y ;
        If Alignement='R' then DX := Largeur - Rect.Right ;
        If Alignement='C' then DX := (Largeur - Rect.Right) div 2 ;
        Rect2 := Rect ;
        Rect2.Left := Rect2.Left + DX ;
        Rect2.Right := Rect2.Right + DX ;
        If Alignement<>'L' then
        Begin
          CanvasCible.CopyRect(Rect2,CanvasCible,Rect);
          CanvasCible.Pen.color := CanvasCible.Pixels[x,y] ;
          CanvasCible.Brush.color := CanvasCible.Pixels[x,y] ;
          CanvasCible.Brush.style := bsSolid ;
          Rect.Right := Rect.Left + DX ;
          CanvasCible.Rectangle(Rect) ;
          CanvasCible.Brush.style := bsClear ;
          For iii := 1 to Length(TableauDesCursorPos) do
          Begin
            If TableauDesCursorPos[iii-1].Yd=Rect.Top then
            Begin
              TableauDesCursorPos[iii-1].Xd := TableauDesCursorPos[iii-1].Xd + DX ;
              TableauDesCursorPos[iii-1].Xf := TableauDesCursorPos[iii-1].Xf + DX ;
            End ;
          End ;
        End ;
        If Pos('CENTER',Majuscule(Balise))>0 then Alignement := 'C' ;
        If Pos('LEFT',Majuscule(Balise))>0 then Alignement := 'L' ;
        If Pos('RIGHT',Majuscule(Balise))>0 then Alignement := 'R' ;
      End else
      // GRAS ------------------------------------------------------------------
      If (Balise='<B>') or (Balise='<b>') then
      Begin
        If Not(fsBold in CanvasCible.Font.Style) then
        Begin
          HH := CanvasCible.TextHeight('W') ;
          FS := CanvasCible.Font.Style ;
          Include(FS,fsBold) ;
          CanvasCible.Font.Style := FS ;
          If HH> CanvasCible.TextHeight('W') then CanvasCible.Font.Size := CanvasCible.Font.Size + 1 ;
        End ;
      End else
      // NON GRAS
      If (Balise='</B>') or (Balise='</b>') then
      Begin
        If fsBold in CanvasCible.Font.Style then
        Begin
          HH := CanvasCible.TextHeight('W') ;
          FS := CanvasCible.Font.Style ;
          Exclude(FS,fsBold) ;
          CanvasCible.Font.Style := FS ;
          If HH< CanvasCible.TextHeight('W') then CanvasCible.Font.Size := CanvasCible.Font.Size - 1 ;
        End ;
      End else
      // Italique --------------------------------------------------------------
      If (Balise='<I>') or (Balise='<i>') then
      Begin
        If Not(fsItalic in CanvasCible.Font.Style) then
        Begin
          FS := CanvasCible.Font.Style ;
          Include(FS,fsItalic) ;
          CanvasCible.Font.Style := FS ;
          Dec(X) ;
        End ;
      End else
      // NON Italique ----------------------------------------------------------
      If (Balise='</I>') or (Balise='</i>') then
      Begin
        If fsItalic in CanvasCible.Font.Style then
        Begin
          FS := CanvasCible.Font.Style ;
          Exclude(FS,fsItalic) ;
          CanvasCible.Font.Style := FS ;
          Inc(X) ;
        end ;
      End Else
      // Soulign --------------------------------------------------------------
      If (Balise='<U>') or (Balise='<u>') then
      Begin
        FS := CanvasCible.Font.Style ;
        Include(FS,fsUnderline) ;
        CanvasCible.Font.Style := FS ;
      End else
      // NON Soulign
      If (Balise='</U>') or (Balise='</u>') then
      Begin
        FS := CanvasCible.Font.Style ;
        Exclude(FS,fsUnderline) ;
        CanvasCible.Font.Style := FS ;
      End else
      //------------------------------------------------------------------------
      // Balise non reconnue  !
      Begin
        Excl := CanvasCible.Font.Color ;
        FS := CanvasCible.Font.Style ;
        CanvasCible.Font.Style := [] ;
        CanvasCible.Font.Color := clBlack ;
        For J := 1 to Length(Balise) do
        Begin
          Car := Copy(Balise,J,1) ;
          If J = Length(Balise) then CanvasCible.Font.Style := [] ;
          If CanvasCible.TextWidth(Car)+X>Largeur then
          Begin
          Rect.Left := Xc ;
          Rect.Right := X ;
          X := Xc ; XEspace := XC ;
          Rect.Top := Y ;
          If HMax=0 then Y := Y + Hmin else Y := Y + Hmax ;
          Hmax := 0 ;
          Rect.Bottom := Y ;
          If Alignement='R' then DX := Largeur - Rect.Right ;
          If Alignement='C' then DX := (Largeur - Rect.Right) div 2 ;
          Rect2 := Rect ;
          Rect2.Left := Rect2.Left + DX ;
          Rect2.Right := Rect2.Right + DX ;
          If Alignement<>'L' then
          Begin
            CanvasCible.CopyRect(Rect2,CanvasCible,Rect);
            CanvasCible.Pen.color := CanvasCible.Pixels[x,y] ;
            CanvasCible.Brush.color := CanvasCible.Pixels[x,y] ;
            CanvasCible.Brush.style := bsSolid ;
            Rect.Right := Rect.Left + DX ;
            CanvasCible.Rectangle(Rect) ;
            CanvasCible.Brush.style := bsClear ;
            For iii := 1 to Length(TableauDesCursorPos) do
            Begin
              If TableauDesCursorPos[iii-1].Yd=Rect.Top then
              Begin
                TableauDesCursorPos[iii-1].Xd := TableauDesCursorPos[iii-1].Xd + DX ;
                TableauDesCursorPos[iii-1].Xf := TableauDesCursorPos[iii-1].Xf + DX ;
              End ;
            End ;
          End ;
          End ;
          CanvasCible.TextOut(X,Y,Car) ;
          Inc(X,CanvasCible.TextWidth(Car)) ;
          if J=1 then CanvasCible.Font.Style := [fsBold,FsItalic] ;
        End ;
        CanvasCible.Font.Color := ExCl ;
        CanvasCible.Font.Style := FS ;
      End ;
      // Balise non reconnue  !
      //------------------------------------------------------------------------
    End Else
    Begin
      Telquel := Telquel + Car ;
      Inc(I) ;
    End ;
  End ;
  While Telquel<>'' do
  Begin
    SS := Telquel ;
    While (SS[0]>#0) and (X+CanvasCible.TextWidth(SS)>Largeur) do Dec(SS[0]) ;
    If SS<>Telquel then
    If Pos(' ',SS)>0 then
    While SS[Ord(SS[0])]<>' ' do Dec(SS[0]) ;
    Delete(Telquel,1,Ord(SS[0])) ;
    CanvasCible.TextOut(X,Y,SS);
    X := X  +  CanvasCible.TextWidth(SS);
    If HMax < CanvasCible.TextHeight(SS) then HMax := CanvasCible.TextHeight(SS) ;
    ElagueLesEspacesS(TelQuel) ;
    If Telquel<>'' then
    Begin
      Rect.Left := Xc ;
      Rect.Right := X ;
      X := Xc ; XEspace := XC ;
      Rect.Top := Y ;
      If HMax=0 then Y := Y + Hmin else Y := Y + Hmax ;
      Hmax := 0 ;
      Rect.Bottom := Y ;
      If Alignement='R' then DX := Largeur - Rect.Right ;
      If Alignement='C' then DX := (Largeur - Rect.Right) div 2 ;
      Rect2 := Rect ;
      Rect2.Left := Rect2.Left + DX ;
      Rect2.Right := Rect2.Right + DX ;
      If Alignement<>'L' then
      Begin
        CanvasCible.CopyRect(Rect2,CanvasCible,Rect);
        CanvasCible.Pen.color := CanvasCible.Pixels[x,y] ;
        CanvasCible.Brush.color := CanvasCible.Pixels[x,y] ;
        CanvasCible.Brush.style := bsSolid ;
        Rect.Right := Rect.Left + DX ;
        CanvasCible.Rectangle(Rect) ;
        CanvasCible.Brush.style := bsClear ;
        For iii := 1 to Length(TableauDesCursorPos) do
        Begin
          If TableauDesCursorPos[iii-1].Yd=Rect.Top then
          Begin
            TableauDesCursorPos[iii-1].Xd := TableauDesCursorPos[iii-1].Xd + DX ;
            TableauDesCursorPos[iii-1].Xf := TableauDesCursorPos[iii-1].Xf + DX ;
          End ;
        End ;
      End ;
    End ;
  End ;
  Rect.Left := Xc ;
  Rect.Right := X ;
  X := Xc ; XEspace := XC ;
  Rect.Top := Y ;
  If HMax=0 then Y := Y + Hmin else Y := Y + Hmax ;
  Hmax := 0 ;
  Rect.Bottom := Y ;
  DX := 0 ;
  If Alignement='R' then DX := Largeur - Rect.Right ;
  If Alignement='C' then DX := (Largeur - Rect.Right) div 2 ;
  Rect2 := Rect ;
  Rect2.Left := Rect2.Left + DX ;
  Rect2.Right := Rect2.Right + DX ;
  If Alignement<>'L' then
  Begin
    CanvasCible.CopyRect(Rect2,CanvasCible,Rect);
    CanvasCible.Pen.color := CanvasCible.Pixels[x,y] ;
    CanvasCible.Brush.color := CanvasCible.Pixels[x,y] ;
    CanvasCible.Brush.style := bsSolid ;
    Rect.Right := Rect.Left + DX ;
    CanvasCible.Rectangle(Rect) ;
    CanvasCible.Brush.style := bsClear ;
    For iii := 1 to Length(TableauDesCursorPos) do
    Begin
      If TableauDesCursorPos[iii-1].Yd=Rect.Top then
      Begin
        TableauDesCursorPos[iii-1].Xd := TableauDesCursorPos[iii-1].Xd + DX ;
        TableauDesCursorPos[iii-1].Xf := TableauDesCursorPos[iii-1].Xf + DX ;
      End ;
    End ;
  End ;
  Result := Y ;
End ;


  var date : dates ;
      i : integer ;
initialization
  DossierInitial := GetCurrentDir ;
  LangueWindows := GetSystemDefaultLangID ;
  LangueUtilisee := LangueWindows ;
  NomOption := DossierInitial+'\'+ExtractFileName(ParamStr(0)) ;
  NomOption := Copy(NomOption,1,Pos('.',NomOption))+'INI' ;
  Date := Aujourdhui ;
  DateVide.jour := 0 ;
  DateVide.Mois := 0 ;
  DateVide.Annee := 0 ;
  LongVide := LongVide +LongVide +LongVide +LongVide +LongVide  ;
  LongWWW := LongWWW +LongWWW +LongWWW +LongWWW +LongWWW  ;
  ExFonte := 0 ;
  SetLength(TableauDesDecalages,0) ;
  For I := 1 to 7500 do Silence[i] := 0 ;
  DX[1] :=0 ;
  DX[2] :=0 ;
  DX[3] :=0 ;
  DX[4] :=1 ;
  DX[5] :=-1 ;
  DX[6] :=-1 ;
  DX[7] :=1 ;
  DX[8] :=1 ;
  DX[9] :=-1 ;
  DX[10] :=0 ;
  DX[11] :=0 ;
  DX[12] :=1 ;
  DX[13] :=-1 ;
  DX[14] :=1 ;
  DX[15] :=-1 ;
  DX[16] :=2 ;
  DX[17] :=-2 ;
  DX[18] :=-2 ;
  DX[19] :=2 ;
  DX[20] :=2 ;
  DX[21] :=-2 ;
  DX[22] :=-2 ;
  DX[23] :=2 ;
  DX[24] :=-2 ;
  DX[25] :=2 ;
  DY[1] :=0 ;
  DY[2] :=1 ;
  DY[3] :=-1 ;
  DY[4] :=-1 ;
  DY[5] :=1 ;
  DY[6] :=-1 ;
  DY[7] :=1 ;
  DY[8] :=0 ;
  DY[9] :=0 ;
  DY[10] :=2 ;
  DY[11] :=-2 ;
  DY[12] :=-2 ;
  DY[13] :=2 ;
  DY[14] :=2 ;
  DY[15] :=-2 ;
  DY[16] :=0 ;
  DY[17] :=0 ;
  DY[18] :=1 ;
  DY[19] :=-1 ;
  DY[20] :=1 ;
  DY[21] :=-1 ;
  DY[22] :=2 ;
  DY[23] :=-2 ;
  DY[24] :=-2 ;
  DY[25] :=2 ;
  Finalization
  For i := 1 to Length(Images) do Images[i-1].Image.Free ;
  SetLength(Images,0) ;
end.




