{
    antiscreensaver - unit1.pas (disables screensaver while running)
    Copyright (C) 2005 Josef Schtzenberger

    antiscreensaver is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    antiscreensaver is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with antiscreensaver; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus,ShellAPI, ExtCtrls, Buttons,TlHelp32, ImgList,Inifiles;


type
  TForm1 = class(TForm)
    PopupMenu1: TPopupMenu;
    ExitApplication: TMenuItem;
    Timer1: TTimer;
    SpeedButtonStart: TSpeedButton;
    SpeedButtonStop: TSpeedButton;
    Label1: TLabel;
    ImageList1: TImageList;
    Label2: TLabel;
    Info1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ExitApplicationClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure SpeedButtonStopClick(Sender: TObject);
    procedure SpeedButtonStartClick(Sender: TObject);
    procedure Show1Click(Sender: TObject);
    procedure Start1Click(Sender: TObject);
    procedure Info1Click(Sender: TObject);
  private
    count:integer;
    FActive:Boolean;          
    procedure WMSysCommand(var Msg : TWMSysCommand);message WM_SYSCOMMAND;
  public
   IconNotifyData : TNotifyIconData;
   procedure WndProc(var Msg : TMessage); override;
  end;

var Form1: TForm1;
const RefreshTime:Integer = 54;
      Autor:String ='J.Schuetzenberger';

implementation

uses AboutForm;

{$R *.dfm}
procedure TForm1.FormCreate(Sender: TObject);
var e:Bool;i,k:Integer;
begin
  SystemParametersInfo(SPI_GETSCREENSAVEACTIVE, 0, @e, 0);
  if e=true then caption:='on' else caption:='off';
  //Set the border icons to have only a system menu. This will
  //leave just the close button.
  BorderIcons :=[biSystemMenu];
  //Now set up the IconNotifyData structure so that it receives
  //the window messages sent to the application and displays
  //the application's tips
  with IconNotifyData do begin
    hIcon := Application.Icon.Handle;
    uCallbackMessage := WM_USER + 1;
    cbSize := sizeof(IconNotifyData);
    Wnd := Handle;
    uID := 100;
    uFlags := NIF_MESSAGE + NIF_ICON + NIF_TIP;
   end;
  //Copy the Application's Title into the tip for the icon
  StrPCopy(IconNotifyData.szTip, Application.Title);
  //Add the Icon to the system tray and use the
  //the structure and its values
  Shell_NotifyIcon(NIM_ADD, @IconNotifyData);
  k:=0;
  for i:=1 to Length(Autor) do begin
    k:=k+ord(Autor[i]);
    k:=(k shl 2) xor not(ord(Autor[i]));
  end;
  if k<>982171149 then
    timer1.Enabled:=false;
  FActive:=true;
end;

procedure TForm1.WMSysCommand(var Msg : TWMSysCommand);
begin
  if (Msg.CmdType = SC_SCREENSAVE) then
  begin
    Msg.Result := -1;
    inc(Count);
    Caption:='Run '+inttostr(count);
    mouse_event(MOUSEEVENTF_MOVE, 8, 8, 0, GetMessageExtraInfo);
    mouse_event(MOUSEEVENTF_MOVE, 8, 8, 0, GetMessageExtraInfo);
    mouse_event(MOUSEEVENTF_MOVE, 8, 8, 0, GetMessageExtraInfo);
    mouse_event(MOUSEEVENTF_MOVE, 8, 8, 0, GetMessageExtraInfo);
  end else inherited;
end;

procedure TForm1.WndProc(var Msg : TMessage);
var p : TPoint;
begin
  case Msg.Msg of
    WM_USER + 1:
    case Msg.lParam of
      WM_RBUTTONDOWN: begin
                        GetCursorPos(p);
                        PopupMenu1.Popup(p.x, p.y);
                      end;
      WM_LBUTTONDOWN: begin
                        FActive:=not FActive;
                        if FActive then
                        begin
                          timer1.Enabled:=true;
                          Imagelist1.GetIcon(0,application.Icon)
                        end else
                        begin
                          if timer1.Enabled=false then FActive:=not FActive
                          else Start1Click(nil);
                          timer1.Enabled:=false;
                          Imagelist1.GetIcon(3,application.Icon);
                        end;
                        IconNotifyData.hIcon := Application.Icon.Handle;
                        Shell_NotifyIcon(NIM_MODIFY,@IconNotifyData);
                      end;
    end;
  end;
  inherited;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Shell_NotifyIcon(NIM_DELETE, @IconNotifyData);
  Application.ProcessMessages;
end;

procedure TForm1.ExitApplicationClick(Sender: TObject);
begin
  Shell_NotifyIcon(NIM_DELETE, @IconNotifyData);
  Application.ProcessMessages;
  Application.Terminate;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Shell_NotifyIcon(NIM_DELETE, @IconNotifyData);
end;

function GetDefaultScreensaver:String;
var
  Ini: TInifile;
  ScreenSaverFile: string;

  function GetLongFileName(const FileName: string): string;
  var
    aInfo: TSHFileInfo;
  begin
    if SHGetFileInfo(PChar(FileName), 0, aInfo, SizeOf(aInfo), SHGFI_DISPLAYNAME) <> 0 then
      Result := string(aInfo.szDisplayName)
    else
      Result := FileName;
  end;

begin
  Ini := TInifile.Create('system.ini');
  ScreenSaverFile := GetLongFileName(Ini.Readstring('boot', 'SCRNSAVE.EXE', 'Not Available'));
  Ini.Free;
  result := ScreenSaverFile;
end;

function GetScreenSaverTimeout: Integer;
begin
  SystemParametersInfo(SPI_GETSCREENSAVETIMEOUT, 0, @Result, 0);
end;

function LastInput: DWord;
var LInput: TLastInputInfo;
begin
  LInput.cbSize := SizeOf(TLastInputInfo);
  GetLastInputInfo(LInput);
  Result := GetTickCount - LInput.dwTime;
end;


procedure TForm1.Timer1Timer(Sender: TObject);
var i,k:Integer;
begin
  label1.Caption:=inttostr(GetScreenSaverTimeout);
  i:=LastInput div 1000;
  caption:=inttostr(i);
  k:=(i div (RefreshTime div 4)) mod 3 ;
  Imagelist1.GetIcon(k,application.Icon);
  IconNotifyData.hIcon := Application.Icon.Handle;
  Shell_NotifyIcon(NIM_MODIFY,@IconNotifyData);
  label2.caption:=GetDefaultScreensaver;
  if i > RefreshTime then
  begin
    mouse_event(MOUSEEVENTF_MOVE, 8, 8, 0, GetMessageExtraInfo);
    mouse_event(MOUSEEVENTF_MOVE, 8, 8, 0, GetMessageExtraInfo);
    application.ProcessMessages;
    sleep(10);
    mouse_event(MOUSEEVENTF_MOVE, Cardinal(-8), Cardinal(-8), 0, GetMessageExtraInfo);
    mouse_event(MOUSEEVENTF_MOVE, Cardinal(-8), Cardinal(-8), 0, GetMessageExtraInfo);
  end;
end;

procedure TForm1.SpeedButtonStopClick(Sender: TObject);
var e:LongBool;
begin
  timer1.Enabled:=true;
  e:=SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, 0, nil, 0);
  if e=true then caption:='ok' else caption:='error';
end;

procedure TForm1.SpeedButtonStartClick(Sender: TObject);
var e:LongBool;s:String;
begin
  timer1.Enabled:=false;
  s:=GetDefaultScreensaver;
  e:=SystemParametersInfo(SPI_SETSCREENSAVEACTIVE, 1, nil, 0);
  if e=true then caption:='ok' else
  begin
    caption:='error';
    ShellExecute(0, 'open', PChar(s), '/s', '', SW_SHOWNORMAL);
  end;
end;

procedure TForm1.Show1Click(Sender: TObject);
begin
  BringToFront;
  AnimateWindow(Handle, 3000, AW_BLEND+AW_CENTER );
  Show;
end;

procedure TForm1.Start1Click(Sender: TObject);
var s:String;
begin
  timer1.Enabled:=false;
  s:=GetDefaultScreensaver;
  ShellExecute(0, 'open', PChar(s), '/s', '', SW_SHOWNORMAL);
end;

procedure TForm1.Info1Click(Sender: TObject);
begin
  if ((GetKeyState(VK_CONTROL) and $10000000) > 0) then
  begin
    Show1Click(nil);
  end else begin
    Form2.BringToFront;
    AnimateWindow(Form2.Handle, 3000, AW_BLEND );
    Form2.Show;
  end;
end;

end.
