{******************************************************************************}
{                             Only Internal Use                                }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                                                                              }
{******************************************************************************}
{$I igOptions.Inc}
unit igTypeInfo;

interface

uses TypInfo, Classes, SysUtils;

function GetPropInfo(const Instance: TPersistent; const PropName: string; const TypeKinds: TTypeKinds): PPropInfo;
function GetPropertyClass(Instance: TPersistent; const PropName: string): TPersistent;
function GetStringByPropInfo (Instance: TPersistent; const PropInfo: PPropInfo): string;
function GetBooleanByPropInfo(const Instance: TPersistent; const PropInfo: PPropInfo): Boolean;
procedure SetBooleanByPropInfo(const Instance: TPersistent; const PropInfo: PPropInfo; const Value:Boolean);
function GetMethodByPropInfo(const Instance: TPersistent; const PropInfo: PPropInfo): TMethod;
procedure SetMethodByPropInfo(const Instance: TPersistent; const PropInfo: PPropInfo; const Value: TMethod);

implementation

function GetPropInfo(const Instance: TPersistent; const PropName: string; const TypeKinds: TTypeKinds): PPropInfo;
begin
  Result := TypInfo.GetPropInfo(Instance.ClassInfo, PropName);
  if (Result <> nil) and (not (Result^.PropType^.Kind in TypeKinds)) then Result := nil;
end;

function GetPropertyClass(Instance: TPersistent; const PropName: string): TPersistent;
var
  PropInfo: PPropInfo;
begin
  Result := nil;
  PropInfo := GetPropInfo(Instance, PropName, [tkClass]);
  if (PropInfo <> nil) then Result := TObject(GetOrdProp(Instance, PropInfo)) as TPersistent;
end;

function GetStringByPropInfo (Instance: TPersistent; const PropInfo: PPropInfo): string;
begin
  if PropInfo <> nil then result := GetStrProp(Instance, PropInfo)
  else result:='';
end;

function GetBooleanByPropInfo(const Instance: TPersistent; const PropInfo: PPropInfo): Boolean;
begin
  if PropInfo <> nil then result:=Boolean(GetOrdProp(Instance, PropInfo))
  else result := False;
end;

procedure SetBooleanByPropInfo(const Instance: TPersistent; const PropInfo: PPropInfo; const Value:Boolean);
begin
  if PropInfo <> nil then SetOrdProp(Instance, PropInfo, Integer(Value));
end;

function GetMethodByPropInfo(const Instance: TPersistent; const PropInfo: PPropInfo): TMethod;
begin
  if PropInfo <> nil then result := GetMethodProp(Instance, PropInfo)
  else begin
    result.Code := nil;
    result.Data := nil;
  end;
end;

procedure SetMethodByPropInfo(const Instance: TPersistent; const PropInfo: PPropInfo; const Value: TMethod);
begin
  if PropInfo <> nil then SetMethodProp(Instance, PropInfo, Value);
end;

end.
