{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                              All rights reserved.                            }
{                                                                              }
{******************************************************************************}
{$I igOptions.inc}
unit igStrUtils;

interface
uses SysUtils {$IFDEF MSWINDOWS}, Windows {$ENDIF};

function AnsiStartsText(const ASubText, AText: string): Boolean;
function AnsiStartsStr(const ASubText, AText: string): Boolean;

function AnsiEndsText(const ASubText, AText: string): Boolean;
function AnsiEndsStr(const ASubText, AText: string): Boolean;

function AnsiContainsText(const AText, ASubText: string): Boolean;
function AnsiContainsStr(const AText, ASubText: string): Boolean;
{$IFNDEF V5_MORE}
function AnsiSameStr(const S1, S2: string): Boolean;
{$ENDIF}
implementation

function AnsiStartsText(const ASubText, AText: string): Boolean;
var
  {$IFDEF MSWINDOWS} P: PChar; {$ENDIF}
  L, L2: Integer;
begin
  L := Length(ASubText);
  L2 := Length(AText);
  if L > L2 then
    Result := False
  else begin
  {$IFDEF MSWINDOWS}
    P := PChar(AText);
    Result := CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE,
      P, L, PChar(ASubText), L) = 2;
  {$ENDIF}
  {$IFDEF LINUX}
    Result := AnsiCompareText(ASubText, Copy(AText, 1, L)) = 0;
  {$ENDIF}
  end;
end;

function AnsiEndsText(const ASubText, AText: string): Boolean; 
var
  P: PChar;
  L, L2: Integer;
begin
  P := PChar(AText);
  L := Length(ASubText);
  L2 := Length(AText);
  Inc(P, L2 - L);
  if L > L2 then
    Result := False
  else
  {$IFDEF MSWINDOWS}
    Result := CompareString(LOCALE_USER_DEFAULT, NORM_IGNORECASE,
      P, L, PChar(ASubText), L) = 2;
  {$ENDIF}
  {$IFDEF LINUX}
    Result := AnsiCompareText(ASubText, Copy(AText, L2 - L + 1, L)) = 0;
  {$ENDIF}
end;

function AnsiEndsStr(const ASubText, AText: string): Boolean;
begin
  Result := AnsiSameStr(ASubText,
                        Copy(AText, Length(AText) - Length(ASubText) + 1,
                                    Length(ASubText)));
end;

function AnsiStartsStr(const ASubText, AText: string): Boolean;
begin
  Result := AnsiSameStr(ASubText, Copy(AText, 1, Length(ASubText)));
end;

function AnsiContainsText(const AText, ASubText: string): Boolean;
begin
  Result := AnsiPos(AnsiUppercase(ASubText), AnsiUppercase(AText)) > 0;
end;

function AnsiContainsStr(const AText, ASubText: string): Boolean;
begin
  Result := AnsiPos(ASubText, AText) > 0;
end;

{$IFNDEF V5_MORE}
function AnsiSameStr(const S1, S2: string): Boolean;
begin
  Result := AnsiCompareStr(S1, S2) = 0;
end;
{$ENDIF}

end.
