{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                              All rights reserved.                            }
{                                                                              }
{******************************************************************************}
{$I igOptions.inc}
unit igPropertyEditors;

interface

uses
  Classes, Db
  {$IFDEF V6_MORE}, DesignIntf, DesignEditors {$ELSE}, DsgnIntf {$ENDIF};

type
  TigNamesProperty = class(TStringProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure GetValueList(List: TStrings); virtual; abstract;
  end;

  TigFieldNameProperty = class(TigNamesProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

  TigCompareKeyProperty = class(TigNamesProperty)
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValueList(List: TStrings); override;
    function GetValue: string; override;
    procedure SetValue(const Value: string); override;
  end;

  TigItemNameProperty = class(TigNamesProperty)
  public
    procedure GetValueList(List: TStrings); override;
  end;

implementation

uses igBaseModel, igDBBaseModel, igModelSource;

type
  TigCrackBaseModel = class(TigBaseModel)
  end;

  TigCrackDBBaseModel = class(TigDBBaseModel)
  end;

{ TNamesProperty }

function TigNamesProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paSortList, paMultiSelect];
end;

procedure TigNamesProperty.GetValues(Proc: TGetStrProc);
var
  I: Integer;
  Values: TStringList;
begin
  Values := TStringList.Create;
  try
    GetValueList(Values);
    for I := 0 to Values.Count - 1 do Proc(Values[I]);
  finally
    Values.Free;
  end;
end;

{ TFieldNameProperty }

procedure TigFieldNameProperty.GetValueList(List: TStrings);
var
  DataSource: TDataSource;
begin
  DataSource := TigCrackDBBaseModel(TigCompareItem(GetComponent(0)).BaseModel).DataSource;
  if (DataSource <> nil) and (DataSource.DataSet <> nil) then
    DataSource.DataSet.GetFieldNames(List);
end;

{ TCompareKeyProperty }

function TigCompareKeyProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList];
end;

procedure TigCompareKeyProperty.GetValueList(List: TStrings);
var
  i : Integer;
begin
  with  TigCrackBaseModel(TigCompareItem(GetComponent(0)).BaseModel) do
  begin
    List.BeginUpdate;
    try
      List.Clear;
      for i := 0 to CompareModelList.Count - 1 do
        List.Add(CompareModelList.GetValue(i).Caption);
    finally
      List.EndUpdate;
    end;
  end;
end;

function TigCompareKeyProperty.GetValue: string;
var
  CompareItem: TigCompareItem;
begin
  CompareItem := TigCompareItem(GetComponent(0));
  with  TigCrackDBBaseModel(TigCompareItem(GetComponent(0)).BaseModel) do
  begin
    result := CompareModelList.Get(CompareItem.CompareKey).Caption;  
  end;
end;

procedure TigCompareKeyProperty.SetValue(const Value: string);
var
  i: Integer;
begin
  with  TigCrackDBBaseModel(TigCompareItem(GetComponent(0)).BaseModel) do
  begin
    for i := 0 to CompareModelList.Count - 1 do
      if CompareModelList.GetValue(i).Caption = Value then
      begin
        SetOrdValue(CompareModelList.GetKey(i));
        break;
      end;
  end;
end;

{ TItemNameProperty }

type
  TigCompareItemCrack = class(TigCompareItem)
  end;

procedure TigItemNameProperty.GetValueList(List: TStrings);
var
  IgBaseModel: TIgBaseModel;
  I: Integer;
begin
  IgBaseModel := TIgModelSource(GetComponent(0)).BaseModel;
  List.BeginUpdate;
  try
    List.Clear;
    if IgBaseModel <> nil then
      for I := 0 to IgBaseModel.CompareItems.Count-1 do
        List.Add(TigCompareItemCrack(IgBaseModel.CompareItems[i]).GetDisplayName)
  finally
    List.EndUpdate;
  end;
end;

end.
