{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                              All rights reserved.                            }
{                                                                              }
{******************************************************************************}
{$I igOptions.inc}
unit igModelStdCtrls;

interface

uses
  Messages, Controls, Classes, StdCtrls, igBaseModel, igModelSource;

type
  TigModelEditSource = class(TigModelSource)
  protected
    function GetControlValue: Variant; override;
    procedure SetControlValue(CompareItem: TigCompareItem); override;
  end;

  {::This is designed for the input of values that are to be used for data searches and filtering by TxxxFindModel or TxxxFilterModel components. A component is stemmed from the Tedit component and fully possesses its functionality. With the help of sub-properties of the ModelSource property, you select a required TXXXFindModel or TXXXFilterModel component and a compare option (TigCompareItem), for which the value is to be input (TigCompareItem.Value will be edited).
  @component
  }
  TigModelEdit = class(TEdit)
  private
    FModelSource: TigModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure Change; override;
    procedure DoExit; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
  end;

implementation

{ TigModelEdit }

constructor TigModelEdit.Create(AOwner: TComponent);
begin
  FModelSource := TigModelEditSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigModelEdit.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigModelEdit.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigModelEditSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigModelEdit.Change;
begin
  inherited;
  TigModelEditSource(FModelSource).ChangeNotification;
end;

procedure TigModelEdit.CMTextChanged(var Message: TMessage);
begin
  inherited;
  TigModelEditSource(FModelSource).ChangeNotification;
end;

procedure TigModelEdit.DoExit;
begin
  inherited;
  TigModelEditSource(FModelSource).ExitNotification;
end;

{ TigModelEditSource }

function TigModelEditSource.GetControlValue: Variant;
begin
  result := TEdit(Owner).Text;
end;

procedure TigModelEditSource.SetControlValue(CompareItem: TigCompareItem);
begin
  TEdit(Owner).Text := CompareItem.AsString;
end;

end.
