{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                              All rights reserved.                            }
{                                                                              }
{******************************************************************************}
{$I igOptions.inc}
unit igModelMask;

interface

uses Classes, Messages, Controls, Mask, StdCtrls{$IFDEF V6_MORE}, MaskUtils {$ENDIF},
  igBaseModel, igModelSource, igMask;

type
  TigModelMaskEditSource = class(TigModelSource)
  protected
    function GetControlValue: Variant; override;
    procedure SetControlValue(CompareItem: TigCompareItem); override;
  end;

  {::This is designed for the input of values that are to be used for data searches and filtering by TxxxFindModel or TxxxFilterModel components. A component is stemmed from the TMaskEdit component and fully possesses its functionality. With the help of sub-properties of the ModelSource property, you select a required TXXXFindModel or TXXXFilterModel component and a compare option (TigCompareItem), for which the value is to be input (TigCompareItem.Value will be edited).
  @component
  }
  TigModelMaskEdit = class(TMaskEdit)
  private
    FModelSource: TigModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure Change; override;
    procedure DoExit; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
  end;

  { TigModelBtnEdit }

  TigModelBtnEdit = class(TigMaskEdit)
  private
    FModelSource: TigModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure Change; override;
    procedure DoExit; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
  end;

implementation

{ TigModelMaskEditSource }

function TigModelMaskEditSource.GetControlValue: Variant;
begin
  result := TMaskEdit(Owner).Text;
end;

procedure TigModelMaskEditSource.SetControlValue(CompareItem: TigCompareItem);
begin
  TMaskEdit(Owner).Text := CompareItem.AsString;
end;

{ TigModelMaskEdit }

constructor TigModelMaskEdit.Create(AOwner: TComponent);
begin
  FModelSource := TigModelMaskEditSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigModelMaskEdit.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigModelMaskEdit.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigModelMaskEditSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigModelMaskEdit.Change;
begin
  inherited;
  TigModelMaskEditSource(FModelSource).ChangeNotification;
end;

procedure TigModelMaskEdit.CMTextChanged(var Message: TMessage);
begin
  inherited;
  TigModelMaskEditSource(FModelSource).ChangeNotification;
end;

procedure TigModelMaskEdit.DoExit;
begin
  inherited;
  TigModelMaskEditSource(FModelSource).ExitNotification;
end;

{ TigModelBtnEdit }

constructor TigModelBtnEdit.Create(AOwner: TComponent);
begin
  FModelSource := TigModelMaskEditSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigModelBtnEdit.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigModelBtnEdit.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigModelMaskEditSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigModelBtnEdit.Change;
begin
  inherited;
  TigModelMaskEditSource(FModelSource).ChangeNotification;
end;

procedure TigModelBtnEdit.CMTextChanged(var Message: TMessage);
begin
  inherited;
  TigModelMaskEditSource(FModelSource).ChangeNotification;
end;

procedure TigModelBtnEdit.DoExit;
begin
  inherited;
  TigModelMaskEditSource(FModelSource).ExitNotification;
end;


end.
