{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                              All rights reserved.                            }
{                                                                              }
{******************************************************************************}
{$I igOptions.inc}
unit igModelDBCtrls;

interface

uses DB, DBCtrls, Classes, SysUtils, Controls, StdCtrls, igDBModelSource,
  igModelSource, igBaseModel;

type
  TigDBModelEditSource = class(TigDBModelSource)
  protected
    function GetControlValue: Variant; override;
    procedure SetControlValue(CompareItem: TigCompareItem); override;
    procedure SetControlDataSource(DataSource: TDataSource); override;
    procedure SetControlDataField(FieldName: String); override;
  end;

  {::This is designed for the input of values that are to be used for data searches
   and filtering by TxxxFindModel or TxxxFilterModel components. A component
   is stemmed from the TDBEdit component and fully possesses its functionality.
   With the help of sub-properties of the ModelSource property, you select a
   required TXXXFindModel or TXXXFilterModel component and a compare option
   (TigCompareItem), for which the value is to be input (TigCompareItem.Value
   will be edited).
   @component}
  TigDBModelEdit = class(TDBEdit)
  private
    FHideProperty: String;
    FModelSource: TigModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Change; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
    property DataSource: String read FHideProperty;
    property DataField: String read FHideProperty;
  end;

  TigDBModelListBoxSource = class(TigDBModelSource)
  protected
    function GetControlValue: Variant; override;
    procedure SetControlValue(CompareItem: TigCompareItem); override;
    procedure SetControlDataSource(DataSource: TDataSource); override;
    procedure SetControlDataField(FieldName: String); override;
  end;

  {::This is designed for the input of values that are to be used for data searches
   and filtering by TxxxFindModel or TxxxFilterModel components. A component
   is stemmed from the TDBListBox component and fully possesses its functionality.
   With the help of sub-properties of the ModelSource property, you select a
   required TXXXFindModel or TXXXFilterModel component and a compare option
   (TigCompareItem), for which the value is to be input (TigCompareItem.Value
   will be edited).
   :@component}
  TigDBModelListBox = class(TDBListBox)
  private
    FHideProperty: String;
    FModelSource: TIgModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Click; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
    property DataSource: String read FHideProperty;
    property DataField: String read FHideProperty;
  end;

  TigDBModelComboBoxSource = class(TigDBModelSource)
  protected
    function GetControlValue: Variant; override;
    procedure SetControlValue(CompareItem: TigCompareItem); override;
    procedure SetControlDataSource(DataSource: TDataSource); override;
    procedure SetControlDataField(FieldName: String); override;
  end;

  {::This is designed for the input of values that are to be used for data searches
   and filtering by TxxxFindModel or TxxxFilterModel components. A component
   is stemmed from the TDBComboBox component and fully possesses its functionality.
   With the help of sub-properties of the ModelSource property, you select a
   required TXXXFindModel or TXXXFilterModel component and a compare option
   (TigCompareItem), for which the value is to be input (TigCompareItem.Value
   will be edited).
   :@component}
  TigDBModelComboBox = class(TDBComboBox)
  private
    FHideProperty: String;
    FModelSource: TIgModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Change; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
    property DataSource: String read FHideProperty;
    property DataField: String read FHideProperty;
  end;

  TigDBModelCheckBoxSource = class(TigDBModelSource)
  private
    function GetFieldState: TCheckBoxState;
    function ValueMatch(const ValueList, Value: string): Boolean;
  protected
    function GetControlValue: Variant; override;
    procedure SetControlValue(CompareItem: TigCompareItem); override;
    procedure SetControlDataSource(DataSource: TDataSource); override;
    procedure SetControlDataField(FieldName: String); override;
  end;

  {::This is designed for the input of values that are to be used for data searches
   and filtering by TxxxFindModel or TxxxFilterModel components. A component
   is stemmed from the TDBCheckBox component and fully possesses its functionality.
   With the help of sub-properties of the ModelSource property, you select a
   required TXXXFindModel or TXXXFilterModel component and a compare option
   (TigCompareItem), for which the value is to be input (TigCompareItem.Value
   will be edited).
   :@component}
  TigDBModelCheckBox = class(TDBCheckBox)
  private
    FHideProperty: String;
    FModelSource: TigModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Click; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
    property DataSource: String read FHideProperty;
    property DataField: String read FHideProperty;
  end;

  TigDBModelRadioGroupSource = class(TigDBModelSource)
  protected
    function GetControlValue: Variant; override;
    procedure SetControlValue(CompareItem: TigCompareItem); override;
    procedure SetControlDataSource(DataSource: TDataSource); override;
    procedure SetControlDataField(FieldName: String); override;
  end;

  {::This is designed for the input of values that are to be used for data searches
   and filtering by TxxxFindModel or TxxxFilterModel components. A component
   is stemmed from the TDBRadioGroup component and fully possesses its functionality.
   With the help of sub-properties of the ModelSource property, you select a
   required TXXXFindModel or TXXXFilterModel component and a compare option
   (TigCompareItem), for which the value is to be input (TigCompareItem.Value
   will be edited).
   :@component}
  TigDBModelRadioGroup = class(TDBRadioGroup)
  private
    FHideProperty: String;
    FModelSource: TigModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure Change; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
    property DataSource: String read FHideProperty;
    property DataField: String read FHideProperty;
  end;

  TigDBModelLookupListBoxSource = class(TigDBModelSource)
  protected
    function GetControlValue: Variant; override;
    procedure SetControlValue(CompareItem: TigCompareItem); override;
    procedure SetControlDataSource(DataSource: TDataSource); override;
    procedure SetControlDataField(FieldName: String); override;
  end;

  {::This is designed for the input of values that are to be used for data searches
   and filtering by TxxxFindModel or TxxxFilterModel components. A component
   is stemmed from the TDBLookupListBox component and fully possesses its functionality.
   With the help of sub-properties of the ModelSource property, you select a
   required TXXXFindModel or TXXXFilterModel component and a compare option
   (TigCompareItem), for which the value is to be input (TigCompareItem.Value
   will be edited).
   :@component}
  TigDBModelLookupListBox = class(TDBLookupListBox)
  private
    FHideProperty: String;
    FModelSource: TigModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure SelectKeyValue(const Value: Variant); override;
    procedure KeyValueChanged; override;
    procedure DoExit; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
    property DataSource: String read FHideProperty;
    property DataField: String read FHideProperty;
  end;

  TigDBModelLookupComboBoxSource = class(TigDBModelSource)
  protected
    function GetControlValue: Variant; override;
    procedure SetControlValue(CompareItem: TigCompareItem); override;
    procedure SetControlDataSource(DataSource: TDataSource); override;
    procedure SetControlDataField(FieldName: String); override;
  end;

  {::This is designed for the input of values that are to be used for data searches
   and filtering by TxxxFindModel or TxxxFilterModel components. A component
   is stemmed from the TDBLookupComboBox component and fully possesses its functionality.
   With the help of sub-properties of the ModelSource property, you select a
   required TXXXFindModel or TXXXFilterModel component and a compare option
   (TigCompareItem), for which the value is to be input (TigCompareItem.Value
   will be edited).
   :@component}
  TigDBModelLookupComboBox = class(TDBLookupComboBox)
  private
    FHideProperty: String;
    FModelSource: TIgModelSource;
  protected
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
    procedure SelectKeyValue(const Value: Variant); override;
    procedure KeyValueChanged; override;
    procedure DoExit; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property ModelSource: TIgModelSource read FModelSource write FModelSource;
    property DataSource: String read FHideProperty;
    property DataField: String read FHideProperty;
  end;

implementation

{$IFDEF V6_MORE}uses  Variants;{$ENDIF}

{ TigDBModelEditSource }

function TigDBModelEditSource.GetControlValue: Variant;
begin
  result := TDBEdit(Owner).Text;
end;

procedure TigDBModelEditSource.SetControlValue(CompareItem: TigCompareItem);
begin
  TDBEdit(Owner).Text := CompareItem.AsString;
end;

procedure TigDBModelEditSource.SetControlDataSource(DataSource: TDataSource);
begin
  TDBEdit(Owner).DataSource := DataSource;
end;

procedure TigDBModelEditSource.SetControlDataField(FieldName: String);
begin
  TDBEdit(Owner).DataField := FieldName;
end;

{ TigDBModelEdit }

constructor TigDBModelEdit.Create(AOwner: TComponent);
begin
  FModelSource := TIgDBModelEditSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigDBModelEdit.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigDBModelEdit.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigDBModelEditSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigDBModelEdit.Change;
begin
  inherited;
  TigDBModelEditSource(FModelSource).ChangeNotification;
end;

{ TigDBModelListBoxSource }

function TigDBModelListBoxSource.GetControlValue: Variant;
begin
  with TDBListBox(Owner) do
    if ItemIndex >= 0 then
    result := Items[ItemIndex] else
    result := '';
end;

procedure TigDBModelListBoxSource.SetControlValue(CompareItem: TigCompareItem);
begin
  with TDBListBox(Owner) do
    ItemIndex := Items.IndexOf(CompareItem.AsString)
end;

procedure TigDBModelListBoxSource.SetControlDataSource(DataSource: TDataSource);
begin
  TDBListBox(Owner).DataSource := DataSource;
end;

procedure TigDBModelListBoxSource.SetControlDataField(FieldName: String);
begin
  TDBListBox(Owner).DataField := FieldName;
end;

{ TigDBModelListBox }

constructor TigDBModelListBox.Create(AOwner: TComponent);
begin
  FModelSource := TIgDBModelListBoxSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigDBModelListBox.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigDBModelListBox.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigDBModelListBoxSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigDBModelListBox.Click;
begin
  inherited;
  try
    TigDBModelListBoxSource(FModelSource).ChangeNotification;
  except
    ItemIndex := -1;
    raise;
  end;
end;

{ TigDBModelComboBoxSource }

function TigDBModelComboBoxSource.GetControlValue: Variant;
begin
  result := TDBComboBox(Owner).Text;
end;

procedure TigDBModelComboBoxSource.SetControlValue(CompareItem: TigCompareItem);
begin
  TDBComboBox(Owner).Text := CompareItem.AsString;
end;

procedure TigDBModelComboBoxSource.SetControlDataSource(DataSource: TDataSource);
begin
  TDBComboBox(Owner).DataSource := DataSource;
end;

procedure TigDBModelComboBoxSource.SetControlDataField(FieldName: String);
begin
  TDBComboBox(Owner).DataField := FieldName;
end;

{ TigDBModelComboBox }

constructor TigDBModelComboBox.Create(AOwner: TComponent);
begin
  FModelSource := TIgDBModelComboBoxSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigDBModelComboBox.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigDBModelComboBox.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigDBModelComboBoxSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigDBModelComboBox.Change;
begin
  inherited;
//  if Focused then
    TigDBModelComboBoxSource(FModelSource).ChangeNotification;
end;

{ TigDBModelCheckBoxSource }

function TigDBModelCheckBoxSource.GetControlValue: Variant;
var
  Pos: Integer;
  S: string;
begin
  with TDBCheckBox(Owner) do
  if State = cbGrayed then
    result := null
  else
    if Field.DataType = ftBoolean then
      result := Checked
    else
    begin
      if Checked then S := ValueChecked else S := ValueUnchecked;
      Pos := 1;
      result := ExtractFieldName(S, Pos);
    end;
end;

function TigDBModelCheckBoxSource.GetFieldState: TCheckBoxState;
var
  Text: string;
begin
  with TDBCheckBox(Owner) do
  if Field <> nil then
    if Field.IsNull then
      Result := cbGrayed
    else if Field.DataType = ftBoolean then
      if Field.AsBoolean then
        Result := cbChecked
      else
        Result := cbUnchecked
    else
    begin
      Result := cbGrayed;
      Text := Field.Text;
      if ValueMatch(ValueChecked, Text) then Result := cbChecked else
        if ValueMatch(ValueUnchecked, Text) then Result := cbUnchecked;
    end
  else
    Result := cbUnchecked;
end;

function TigDBModelCheckBoxSource.ValueMatch(const ValueList, Value: string): Boolean;
var
  Pos: Integer;
begin
  Result := False;
  Pos := 1;
  while Pos <= Length(ValueList) do
    if AnsiCompareText(ExtractFieldName(ValueList, Pos), Value) = 0 then
    begin
      Result := True;
      Break;
    end;
end;

procedure TigDBModelCheckBoxSource.SetControlValue(CompareItem: TigCompareItem);
begin
  TDBCheckBox(Owner).State := GetFieldState;
end;

procedure TigDBModelCheckBoxSource.SetControlDataSource(DataSource: TDataSource);
begin
  TDBCheckBox(Owner).DataSource := DataSource;
end;

procedure TigDBModelCheckBoxSource.SetControlDataField(FieldName: String);
begin
  TDBCheckBox(Owner).DataField := FieldName;
end;

{ TigDBModelCheckBox }

constructor TigDBModelCheckBox.Create(AOwner: TComponent);
begin
  FModelSource := TigDBModelCheckBoxSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigDBModelCheckBox.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigDBModelCheckBox.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigDBModelCheckBoxSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigDBModelCheckBox.Click;
begin
  inherited;
  TigDBModelCheckBoxSource(FModelSource).ChangeNotification;
end;

{ TigDBModelRadioGroupSource }

function TigDBModelRadioGroupSource.GetControlValue: Variant;
begin
  result := TDBRadioGroup(Owner).Value;
end;

procedure TigDBModelRadioGroupSource.SetControlValue(CompareItem: TigCompareItem);
begin
  TDBRadioGroup(Owner).Value := CompareItem.AsString;
end;

procedure TigDBModelRadioGroupSource.SetControlDataSource(DataSource: TDataSource);
begin
  TDBRadioGroup(Owner).DataSource := DataSource;
end;

procedure TigDBModelRadioGroupSource.SetControlDataField(FieldName: String);
begin
  TDBRadioGroup(Owner).DataField := FieldName;
end;

{ TigDBModelRadioGroup }

constructor TigDBModelRadioGroup.Create(AOwner: TComponent);
begin
  FModelSource := TIgDBModelRadioGroupSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigDBModelRadioGroup.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigDBModelRadioGroup.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigDBModelRadioGroupSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigDBModelRadioGroup.Change;
begin
  inherited;
  if (ItemIndex >= 0) then
    TigDBModelRadioGroupSource(FModelSource).ChangeNotification;
end;

{ TigDBModelLookupListBoxSource }

function TigDBModelLookupListBoxSource.GetControlValue: Variant;
begin
  result := TDBLookupListBox(Owner).KeyValue;
end;

procedure TigDBModelLookupListBoxSource.SetControlValue(CompareItem: TigCompareItem);
begin
  TDBLookupListBox(Owner).KeyValue := CompareItem.AsVariant;
end;

procedure TigDBModelLookupListBoxSource.SetControlDataSource(DataSource: TDataSource);
begin
  TDBLookupListBox(Owner).DataSource := DataSource;
end;

procedure TigDBModelLookupListBoxSource.SetControlDataField(FieldName: String);
begin
  TDBLookupListBox(Owner).DataField := FieldName;
end;

{ TigDBModelLookupListBox }

constructor TigDBModelLookupListBox.Create(AOwner: TComponent);
begin
  FModelSource := TIgDBModelLookupListBoxSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigDBModelLookupListBox.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigDBModelLookupListBox.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigDBModelLookupListBoxSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigDBModelLookupListBox.SelectKeyValue(const Value: Variant);
begin
  KeyValue := Value;
  Repaint;
  Click;
end;

procedure TigDBModelLookupListBox.KeyValueChanged;
begin
  inherited;
  TigDBModelLookupListBoxSource(FModelSource).ChangeNotification;
end;

procedure TigDBModelLookupListBox.DoExit;
var
  TempKeyValue: Variant;
begin
  if FModelSource.UpdateValue <> uvAuto then
  begin
    TempKeyValue := KeyValue;
    inherited SelectKeyValue(TempKeyValue);
  end;
  inherited;
end;

{ TigDBModelLookupComboBoxSource }

function TigDBModelLookupComboBoxSource.GetControlValue: Variant;
begin
  result := TDBLookupComboBox(Owner).KeyValue;
end;

procedure TigDBModelLookupComboBoxSource.SetControlValue(CompareItem: TigCompareItem);
begin
  TDBLookupComboBox(Owner).KeyValue := CompareItem.AsVariant;
end;

procedure TigDBModelLookupComboBoxSource.SetControlDataSource(DataSource: TDataSource);
begin
  TDBLookupComboBox(Owner).DataSource := DataSource;
end;

procedure TigDBModelLookupComboBoxSource.SetControlDataField(FieldName: String);
begin
  TDBLookupComboBox(Owner).DataField := FieldName;
end;

{ TigDBModelLookupComboBox }

constructor TigDBModelLookupComboBox.Create(AOwner: TComponent);
begin
  FModelSource := TigDBModelLookupComboBoxSource.Create(Self);
  inherited Create(AOwner);
end;

destructor TigDBModelLookupComboBox.Destroy;
begin
  inherited Destroy;
  FModelSource.Free;
end;

procedure TigDBModelLookupComboBox.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;
  TigDBModelLookupComboBoxSource(FModelSource).Notification(AComponent, Operation);
end;

procedure TigDBModelLookupComboBox.SelectKeyValue(const Value: Variant);
begin
  KeyValue := Value;
  Repaint;
  Click;
end;

procedure TigDBModelLookupComboBox.KeyValueChanged;
begin
  inherited;
  TigDBModelLookupListBoxSource(FModelSource).ChangeNotification;
end;

procedure TigDBModelLookupComboBox.DoExit;
var
  TempKeyValue: Variant;
begin
  if FModelSource.UpdateValue <> uvAuto then
  begin
    TempKeyValue := KeyValue;
    inherited SelectKeyValue(TempKeyValue);
  end;
  inherited;
end;

end.
