{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                                                                              }
{******************************************************************************}
{$I IgOptions.inc}
unit igIBModel;

interface

uses Classes, Db, IBTable, IBQuery, IBSQL, IBCustomDataSet, igBaseModel, igDBBaseModel
  {$IFDEF V6_MORE}, Variants{$ENDIF};

type
  TigIBDataSetModel = class(TigExtDataSetModel)
  public
    function IsSupported(const Value: TDataSetSupportedOption): Boolean; override;
    function GetIndexDefs: TIndexDefs; override;
    function GetIndexFieldNames: String; override;
    function GetIndexName: String; override;

    function GetQuerySQL: String; override;
    procedure SetQuerySQL(Value: string); override;
    procedure SetParam(const Name: String; const Value: Variant); override;
  end;

  {::TigIBFindModel is component for the data searching in InterBase dataset components (TIBDataSet, TIBTable, TIBQuery and so on).
  Component uses specific properties and methods of TIBCustomDataSet object for quick searching with a current index.
  @component
  }
  TigIBFindModel = class(TigCustomDBFindModel)
  protected
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  {::TigIBFilterModel is component for the data filtering in InterBase dataset components (TIBDataSet, TIBTable, TIBQuery and so on).
  @component
  }
  TigIBFilterModel = class(TigCustomDBFilterModel)
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  procedure Register;


implementation

uses igModelConsts;

const
  DataSetName: String = 'TIBCustomDataSet';

  type
  TCrackDataSet = class(TIBCustomDataSet)
  end;

procedure Register;
begin
  RegisterComponents('Navigator Access', [TigIBFilterModel]);
  RegisterComponents('Navigator Access', [TigIBFindModel]);
end;

{ TigIBIndexModel }

function TigIBDataSetModel.GetIndexDefs: TIndexDefs;
begin
  if (DataSet is TIBTable) then
    result := TIBTable(DataSet).IndexDefs
  else
    result := nil;
end;

function TigIBDataSetModel.GetIndexFieldNames: String;
begin
  if DataSet is TIBTable then
    result := TIBTable(DataSet).IndexFieldNames
  else
    result := '';
end;

function TigIBDataSetModel.GetIndexName: String;
begin
  if DataSet is TIBTable then
    result := TIBTable(DataSet).IndexName
  else
    result := '';
end;

function TigIBDataSetModel.GetQuerySQL: String;
begin
  if DataSet is TIBQuery then
    Result := TIBQuery(DataSet).SQL.Text
  else if not (DataSet is TIBTable) then
    Result := TCrackDataSet(DataSet).SelectSQL.Text;
end;

procedure TigIBDataSetModel.SetQuerySQL(Value: string);
begin
  if DataSet is TIBQuery then
    TIBQuery(DataSet).SQL.Text := Value
  else if not (DataSet is TIBTable) then
    TCrackDataSet(DataSet).SelectSQL.Text := Value;
end;

procedure TigIBDataSetModel.SetParam(const Name: String; const Value: Variant);
var
  Param: TParam;
  IBParam: TIBXSQLVAR;
begin
  if DataSet is TIBQuery then
  begin
    Param := TIBQuery(DataSet).Params.FindParam(Name);
    if Param <> nil then Param.Value := Value;
  end else
  if not (DataSet is TIBTable) then
  begin
    IBParam := TCrackDataSet(DataSet).SQLParams.ByName(Name);
    IBParam.Value := Value;
  end;
end;

function TigIBDataSetModel.IsSupported(const Value: TDataSetSupportedOption): Boolean;
begin
  case Value of
    dsDefaultIndex: result := true;
    dsSQL: result := not (DataSet is TIBTable); 
    else result := inherited IsSupported(Value);
  end;
end;

{ TigIBFindModel }

procedure TigIBFindModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigIBDataSetModel.Create(Self);
end;

procedure TigIBFindModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TIBCustomDataSet) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

{ TigIBFilterModel }

procedure TigIBFilterModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TIBCustomDataSet) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

procedure TigIBFilterModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigIBDataSetModel.Create(Self);
end;


end.
