{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                                                                              }
{******************************************************************************}
{$I IgOptions.inc}
unit igClientModel;

interface

uses Classes, Db, DBClient, igBaseModel, igDBBaseModel
  {$IFDEF V6_MORE}, Variants{$ENDIF};

type
  TigClientDataSetModel = class(TigExtDataSetModel)
  public
    function IsSupported(const Value: TDataSetSupportedOption): Boolean; override;
    function GetIndexDefs: TIndexDefs; override;
    function GetIndexFieldNames: String; override;
    function GetIndexName: String; override;
    function FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean; override;
    procedure SetRange(StartValues, EndValues: Variant); override;
  end;

  {::TigClientFindModel is component for the data searching in Client dataset components (TClientDataSet, TSQLClientDataSet, TBDEClientDataSet, TIBClientDataSet and so on).
  Component uses specific properties and methods of TCustomClientDataSet object for quick searching with a current index.
  @component
  }
  TigClientFindModel = class(TigCustomDBFindModel)
  protected
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  {::TigClientFilterModel is component for the data filtering in Client dataset components (TClientDataSet, TSQLClientDataSet, TBDEClientDataSet, TIBClientDataSet and so on).
  @component
  }
  TigClientFilterModel = class(TigCustomDBFilterModel)
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  procedure Register;

implementation

uses igModelConsts;

const
  DataSetName = 'TCustomClientDataSet(TClientDataSet)';

type
{$IFDEF V6_MORE}
  TCrackClientDataSet = class(TCustomClientDataSet)
  end;
{$ELSE}
  TCrackClientDataSet = class(TClientDataSet)
  end;
{$ENDIF}

procedure Register;
begin
  RegisterComponents('Navigator Access', [TigClientFilterModel]);
  RegisterComponents('Navigator Access', [TigClientFindModel]);
end;

{ TigClientDataSetModel }

function TigClientDataSetModel.GetIndexDefs: TIndexDefs;
begin
  if (DataSet is {$IFDEF V6_MORE} TCustomClientDataSet {$ELSE} TClientDataSet {$ENDIF}) then
     result := TCrackClientDataSet(DataSet).IndexDefs
  else result := nil;
end;

function TigClientDataSetModel.GetIndexFieldNames: String;
begin
  if (DataSet is {$IFDEF V6_MORE} TCustomClientDataSet {$ELSE} TClientDataSet {$ENDIF}) then
     result := TCrackClientDataSet(DataSet).IndexFieldNames
  else result := '';
end;

function TigClientDataSetModel.GetIndexName: String;
begin
  if (DataSet is {$IFDEF V6_MORE} TCustomClientDataSet {$ELSE} TClientDataSet {$ENDIF}) then
     result:=TCrackClientDataSet(DataSet).IndexName
  else result := '';
end;

function TigClientDataSetModel.FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean;
var
  i, HighBound: Integer;
begin
  HighBound := VarArrayHighBound(KeyValues, 1);
  with TCrackClientDataSet(DataSet) do
  begin
    SetKey;
    for i := 0 to HighBound do Items[i].Field.Value := KeyValues[i];
    for i := HighBound + 1 to Count - 1 do Items[i].Field.Value := null;
    if Exact then result := GotoKey
    else
    begin
      GotoNearest;
      result:=true;
    end;
  end;
end;

function TigClientDataSetModel.IsSupported(const Value: TDataSetSupportedOption): Boolean;
begin
  case Value of
    dsDefaultIndex: result := true;
    dsMultiCaseInsIndexSearch, dsIndexRange: result := DataSet is {$IFDEF V6_MORE} TCustomClientDataSet {$ELSE} TClientDataSet {$ENDIF};
    else result := inherited IsSupported(Value);
  end;
end;

procedure TigClientDataSetModel.SetRange(StartValues, EndValues: Variant);
var
  HighBound, i: Integer;
begin
  if IsSupported(dsIndexRange) then
  with TCrackClientDataSet(DataSet) do
  begin
    if VarIsArray(StartValues) then
    begin
      HighBound := VarArrayHighBound(StartValues, 1);
      SetRangeStart;
//      KeyExclusive := false;
      for i := 0 to HighBound do
      begin
        if not VarIsEmpty(StartValues[i]) then
          Items[i].Field.Value := StartValues[i];
      end;
      SetRangeEnd;
//      KeyExclusive := false;
      for i := 0 to HighBound do
      begin
        if not VarIsEmpty(EndValues[i]) then
          Items[i].Field.Value := EndValues[i];
      end;
      ApplyRange;
    end else
    begin
      CancelRange;
    end;
  end;
end;

{ TigClientFindModel }

procedure TigClientFindModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigClientDataSetModel.Create(Self);
end;

procedure TigClientFindModel.CheckDataSet;
begin
  if not (DataLink.DataSet is {$IFDEF V6_MORE} TCustomClientDataSet {$ELSE} TClientDataSet {$ENDIF}) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

{ TigClientFilterModel }

procedure TigClientFilterModel.CheckDataSet;
begin
  if not (DataLink.DataSet is {$IFDEF V6_MORE} TCustomClientDataSet {$ELSE} TClientDataSet {$ENDIF}) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

procedure TigClientFilterModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigClientDataSetModel.Create(Self);
end;

end.
