{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                              All rights reserved.                            }
{                                                                              }
{******************************************************************************}
{$I IgOptions.inc}
unit igBDEModel;

interface

uses igBaseModel, igDBBaseModel, DB, DBTables{$IFDEF V6_MORE}, Variants {$ENDIF};

type
  TigBDEDataSetModel = class(TigExtDataSetModel)  
  public
    function IsSupported(const Value: TDataSetSupportedOption): Boolean; override;
    function GetIndexDef: TIndexDef; override;
    function GetIndexFieldNames: String; override;
    function GetIndexName: String; override;
    function FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean; override;
    
    procedure SetRange(StartValues, EndValues: Variant); override;

    function GetQuerySQL: String; override;
    procedure SetQuerySQL(Value: string); override;
//    function GetParams: TParams; override;
    procedure SetParam(const Name: String; const Value: Variant); override;
  end;

  {::TigBdeFindModel is component for the data searching in BDE dataset components (TTable, TQuery and so on).
  Component uses specific properties and methods of TBDEDataSet object for quick searching with a current index.
  @component
  }
  TigBdeFindModel = class(TigCustomDBFindModel)
  protected
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  {::TigBdeFilterModel is component for the data filtering in BDE dataset components (TTable, TQuery and so on).
  @component
  }
  TigBdeFilterModel = class(TigCustomDBFilterModel)
  protected
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

implementation


uses igModelConsts;

type
  TCrackDataSet = class(TDBDataSet)
  end;

const
  DataSetName: String = 'TBDEDataSet';

{ TigBDETableIndexModel }

function TigBDEDataSetModel.GetIndexDef: TIndexDef;
begin
  {$IFDEF V5_MORE}
  result := TCrackDataSet(DataSet).PSGetDefaultOrder;
  {$ELSE}
  result := inherited GetIndexDef;
  {$ENDIF}
end;

function TigBDEDataSetModel.GetIndexFieldNames: String;
begin
  if DataSet is TTable then
    result := TTable(DataSet).IndexFieldNames
  else
    result := '';
end;

function TigBDEDataSetModel.GetIndexName: String;
begin
  if DataSet is TTable then
    result := TTable(DataSet).IndexName
  else
    result := ''
end;

function TigBDEDataSetModel.FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean;
var
  i, HighBound: Integer;
begin
  if DataSet is TTable then
  begin
    HighBound := VarArrayHighBound(KeyValues, 1);
    with TTable(DataSet) do
    begin
      SetKey;
      for i := 0 to HighBound do
        Items[i].Field.Value := KeyValues[i];
      for i := HighBound + 1 to Count - 1 do
        Items[i].Field.Value := null;
      if Exact then result := GotoKey
      else
      begin
        GotoNearest;
        result:=true;
      end;
    end;
  end else
    Result := inherited FindRecord(KeyValues, Exact);
end;

function TigBDEDataSetModel.IsSupported(const Value: TDataSetSupportedOption): Boolean;
begin
  case Value of
    dsDefaultIndex: result := (DataSet is TTable) or (DataSet is TQuery);
    dsMultiCaseInsIndexSearch, dsIndexRange: result := DataSet is TTable;
    dsSQL: result := DataSet is TQuery;
    else result := inherited IsSupported(Value);
  end;
end;

procedure TigBDEDataSetModel.SetRange(StartValues, EndValues: Variant);
var
  HighBound, i: Integer;
begin
  if IsSupported(dsIndexRange) then
  with TTable(DataSet) do
  begin
    if VarIsArray(StartValues) then
    begin
      HighBound := VarArrayHighBound(StartValues, 1);
      SetRangeStart;
//      KeyExclusive := false;
      for i := 0 to HighBound do
      begin
        if not VarIsEmpty(StartValues[i]) then
          Items[i].Field.Value := StartValues[i];
      end;
      SetRangeEnd;
//      KeyExclusive := false;
      for i := 0 to HighBound do
      begin
        if not VarIsEmpty(EndValues[i]) then
          Items[i].Field.Value := EndValues[i];
      end;
      ApplyRange;
    end else
    begin
      CancelRange;
    end;
  end;
end;

function TigBDEDataSetModel.GetQuerySQL: String;
begin
  if DataSet is TQuery then result := TQuery(DataSet).SQL.Text
  else result := '';
end;

procedure TigBDEDataSetModel.SetQuerySQL(Value: string);
begin
  if DataSet is TQuery then TQuery(DataSet).SQL.Text := Value;
end;

procedure TigBDEDataSetModel.SetParam(const Name: String; const Value: Variant);
var
  Param: TParam;
begin
  if DataSet is TQuery then
  begin
    Param := TQuery(DataSet).Params.FindParam(Name);
    if Param <> nil then Param.Value := Value;
  end;
end;

{function TigBDEDataSetModel.GetParams: TParams;
begin
  if DataSet is TQuery then
    result := TQuery(DataSet).Params
  else
    result := nil;
end;}

{ TigBDEFindModel }

procedure TigBDEFindModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigBDEDataSetModel.Create(Self);
end;

procedure TigBdeFindModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TBDEDataSet) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

{ TigBdeFilterModel }

procedure TigBdeFilterModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TBDEDataSet) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

procedure TigBdeFilterModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigBDEDataSetModel.Create(Self);
end;

end.
