{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                                                                              }
{******************************************************************************}
{$I IgOptions.inc}
unit igAdoModel;

interface

uses Classes, Db, ADODB, igBaseModel, igDBBaseModel
  {$IFDEF V6_MORE}, Variants {$ENDIF};

type
  TigAdoDataSetModel = class(TigExtDataSetModel)
  public
    function IsSupported(const Value: TDataSetSupportedOption): Boolean; override;
    function GetIndexDef: TIndexDef; override;
    function GetIndexFieldNames: String; override;
    function GetIndexName: String; override;
    function FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean; override;

    function GetQuerySQL: String; override;
    procedure SetQuerySQL(Value: string); override;
    procedure SetParam(const Name: String; const Value: Variant); override;
  end;

  {::TigAdoFindModel is component for the data searching in ADO dataset components (TADODataSet, TADOTable, TADOQuery and so on).
  Component uses specific properties and methods of TCustomADODataSet object for quick searching with a current index.
  @component
  }
  TigAdoFindModel = class(TigCustomDBFindModel)
  protected
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  {::TigAdoFilterModel is component for the data filtering in ADO dataset components (TADODataSet, TADOTable, TADOQuery and so on).
  @component
  }
  TigAdoFilterModel = class(TigCustomDBFilterModel)
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  procedure Register;

implementation

uses igModelConsts;

const
  DataSetName: String = 'TCustomADODataSet';

type
  TCrackADODataSet = class(TCustomADODataSet)
  end;

procedure Register;
begin
  RegisterComponents('Navigator Access', [TigAdoFilterModel]);
  RegisterComponents('Navigator Access', [TigAdoFindModel]);
end;

{ TigAdoIndexModel }

function TigAdoDataSetModel.GetIndexDef: TIndexDef;
begin
  if (DataSet is TCustomADODataSet) and (TCrackADODataSet(DataSet).Supports([coSeek])) then
    Result := TCrackADODataSet(DataSet).PSGetDefaultOrder
  else
    Result := nil;
end;

function TigAdoDataSetModel.GetIndexFieldNames: String;
begin
  if DataSet is TCustomADODataSet then
    result := TCrackADODataSet(DataSet).IndexFieldNames
  else
    result := ''
end;

function TigAdoDataSetModel.GetIndexName: String;
begin
  if DataSet is TCustomADODataSet then
    result := TCrackADODataSet(DataSet).IndexName
  else
    result := ''
end;

function TigAdoDataSetModel.FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean;
begin
  if Exact then
    result:=TCustomADODataSet(DataSet).Seek(KeyValues, soFirstEQ)
  else
    result := TCustomADODataSet(DataSet).Seek(KeyValues, soAfterEQ)
end;

function TigAdoDataSetModel.IsSupported(const Value: TDataSetSupportedOption): Boolean;
begin
  case Value of
    dsDefaultIndex: result := true;
    dsMultiCaseInsIndexSearch: result := true;
    dsSQL: result := (DataSet is TADOQuery) or
      ((DataSet is TCustomADODataSet) and (TCrackADODataSet(DataSet).CommandType in [cmdUnknown, cmdText]));
    else result := inherited IsSupported(Value);
  end;
end;

function TigAdoDataSetModel.GetQuerySQL: String;
begin
  if DataSet is TADOQuery then
    result := TADOQuery(DataSet).SQL.Text
  else if (DataSet is TCustomADODataSet) and (TCrackADODataSet(DataSet).CommandType in [cmdUnknown, cmdText]) then
    result := TCrackADODataSet(DataSet).CommandText
  else
    result := '';
end;

procedure TigAdoDataSetModel.SetQuerySQL(Value: string);
begin
  if DataSet is TADOQuery then
    TADOQuery(DataSet).SQL.Text := Value
  else if (DataSet is TCustomADODataSet) and (TCrackADODataSet(DataSet).CommandType in [cmdUnknown, cmdText]) then
    TCrackADODataSet(DataSet).CommandText := Value
end;

procedure TigAdoDataSetModel.SetParam(const Name: String; const Value: Variant);
var
  Param: TParameter;
begin
  if DataSet is TCustomADODataSet then
  begin
    Param := TCrackADODataSet(DataSet).Parameters.FindParam(Name);
    if Param <> nil then Param.Value := Value;
  end;
end;

{ TigAdoFindModel }

procedure TigAdoFindModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigAdoDataSetModel.Create(Self);
end;

procedure TigAdoFindModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TCustomADODataSet) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

{ TigAdoFilterModel }

procedure TigAdoFilterModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigAdoDataSetModel.Create(Self);
end;

procedure TigAdoFilterModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TCustomADODataSet) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

end.

