{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                                                                              }
{******************************************************************************}
{$I IgOptions.inc}
unit igKbmModel;

interface

uses Classes, Db, kbmMemTable, igBaseModel, igDBBaseModel
  {$IFDEF V6_MORE}, Variants {$ENDIF};

type
  TigKbmDataSetModel = class(TigExtDataSetModel)
  public
    function IsSupported(const Value: TDataSetSupportedOption): Boolean; override;
    function GetIndexDefs: TIndexDefs; override;
    function GetIndexFieldNames: String; override;
    function GetIndexName: String; override;
    function FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean; override;
    procedure SetRange(StartValues, EndValues: Variant); override;
  end;

  {::TigKbmFindModel is component for the data searching in KBM dataset components (TKbmMemTable and so on).
  Component uses specific properties and methods of TkbmCustomMemTable object for quick searching with a current index.
  @component
  }
  TigKbmFindModel = class(TigCustomDBFindModel)
  protected
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  {::TigKbmFilterModel is component for the data filtering in KBM dataset components (TKbmMemTable and so on).
  @component
  }
  TigKbmFilterModel = class(TigCustomDBFilterModel)
  protected
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  procedure Register;

implementation

uses igModelConsts;

const
  DataSetName: String = 'TkbmCustomMemTable';

procedure Register;
begin
  RegisterComponents('Navigator Access', [TigKbmFilterModel]);
  RegisterComponents('Navigator Access', [TigKbmFindModel]);
end;

{ TigKbmIndexModel }

function TigKbmDataSetModel.GetIndexDefs: TIndexDefs;
begin
  if DataSet is TkbmCustomMemTable then
  begin
    result := TkbmCustomMemTable(DataSet).IndexDefs;
  end else
    result := nil;
end;

function TigKbmDataSetModel.GetIndexFieldNames: String;
begin
  if DataSet is TkbmCustomMemTable then
  begin
    result := TkbmCustomMemTable(DataSet).IndexFieldNames;
  end else
    result := '';
end;

function TigKbmDataSetModel.GetIndexName: String;
begin
  if DataSet is TkbmCustomMemTable then
  begin
    result := TkbmCustomMemTable(DataSet).IndexName;
  end else
    result := '';
end;


function TigKbmDataSetModel.FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean;
var
  HighBound: Integer;
begin
  if (DataSet is TkbmCustomMemTable) then
  with TkbmCustomMemTable(DataSet) do
  begin
    HighBound := VarArrayHighBound(KeyValues, 1);
    if Exact then
    begin
      case HighBound of
        0: Result := FindKey([KeyValues[0]]);
        1: Result := FindKey([KeyValues[0], KeyValues[1]]);
        2: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2]]);
        3: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3]]);
        4: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4]]);
        5: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5]]);
        6: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6]]);
        7: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7]]);
        8: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8]]);
        9: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8], KeyValues[9]]);
       10: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8], KeyValues[9], KeyValues[10]]);
       11: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8], KeyValues[9], KeyValues[10], KeyValues[11]]);
       12: Result := FindKey([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8], KeyValues[9], KeyValues[10], KeyValues[11], KeyValues[12]]);
        else begin
          Result := false;
          igBaseModelError('Too much fields in index');
        end;
      end;
    end else
    begin
      case HighBound of
        0: Result := FindNearest([KeyValues[0]]);
        1: Result := FindNearest([KeyValues[0], KeyValues[1]]);
        2: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2]]);
        3: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3]]);
        4: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4]]);
        5: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5]]);
        6: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6]]);
        7: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7]]);
        8: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8]]);
        9: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8], KeyValues[9]]);
       10: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8], KeyValues[9], KeyValues[10]]);
       11: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8], KeyValues[9], KeyValues[10], KeyValues[11]]);
       12: Result := FindNearest([KeyValues[0], KeyValues[1], KeyValues[2], KeyValues[3], KeyValues[4], KeyValues[5], KeyValues[6], KeyValues[7], KeyValues[8], KeyValues[9], KeyValues[10], KeyValues[11], KeyValues[12]]);
       else begin
        Result := false;
        igBaseModelError('Too much fields in index');
       end;
      end;
    end
  end else
    Result := inherited FindRecord(KeyValues, Exact);
end;

function TigKbmDataSetModel.IsSupported(const Value: TDataSetSupportedOption): Boolean;
begin
  case Value of
    dsDefaultIndex: result := (DataSet is TkbmCustomMemTable);
    dsMultiCaseInsIndexSearch, dsIndexRange: result := DataSet is TkbmCustomMemTable;
    else result := inherited IsSupported(Value);
  end;
end;

procedure TigKbmDataSetModel.SetRange(StartValues, EndValues: Variant);
var
  HighBound, i: Integer;
begin
  if IsSupported(dsIndexRange) then
  with TkbmCustomMemTable(DataSet) do
  begin
    if VarIsArray(StartValues) then
    begin
      HighBound := VarArrayHighBound(StartValues, 1);
      SetRangeStart;
      for i := 0 to HighBound do
      begin
        if not VarIsEmpty(StartValues[i]) then
          Items[i].Field.Value := StartValues[i];
      end;
      SetRangeEnd;
      for i := 0 to HighBound do
      begin
        if not VarIsEmpty(EndValues[i]) then
          Items[i].Field.Value := EndValues[i];
      end;
      ApplyRange;
    end else
    begin
      CancelRange;
    end;
  end;
end;

{ TigKbmFindModel }

procedure TigKbmFindModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigKbmDataSetModel.Create(Self);
end;

procedure TigKbmFindModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TkbmCustomMemTable) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

{ TigKbmFilterModel }

procedure TigKbmFilterModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TkbmCustomMemTable) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

procedure TigKbmFilterModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigKbmDataSetModel.Create(Self);
end;


end.
