{******************************************************************************}
{                                                                              }
{                           Data Navigator Library                             }
{                                                                              }
{                   Copyright (c) 2002 - 2003 IMG Software                     }
{                           http://www.imgsoft.com                             }
{                         e-mail: support@imgsoft.com                          }
{                                                                              }
{******************************************************************************}
{$I IgOptions.inc}
unit igDBISAMModel;

interface

uses Classes, Db, DBISAMTb, igBaseModel, igDBBaseModel
  {$IFDEF V6_MORE}, Variants {$ENDIF};

type
  TigDBISAMDataSetModel = class(TigExtDataSetModel)
  public
    function IsSupported(const Value: TDataSetSupportedOption): Boolean; override;
    function GetIndexDefs: TIndexDefs; override;
    function GetIndexFieldNames: String; override;
    function GetIndexName: String; override;
    function GetQuerySQL: String; override;
    procedure SetQuerySQL(Value: string); override;
    function FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean; override;
    procedure SetRange(StartValues, EndValues: Variant); override;
    procedure SetParam(const Name: String; const Value: Variant); override;
  end;

  {::TigDBISAMFindModel is component for the data searching in DBISAM dataset components (TDBISAMTable, TDBISAMQuery and so on).
  Component uses specific properties and methods of TDBISAMDataSet object for quick searching with a current index.
  @component
  }
  TigDBISAMFindModel = class(TigCustomDBFindModel)
  protected
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  {::TigDBISAMFilterModel is component for the data filtering in DBISAM dataset components (TDBISAMTable, TDBISAMQuery and so on).
  @component
  }
  TigDBISAMFilterModel = class(TigCustomDBFilterModel)
  protected
    procedure CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel); override;
    procedure CheckDataSet; override;
  end;

  procedure Register;

implementation

uses igModelConsts;

const
  DataSetName: String = 'TDBISAMDataSet';

procedure Register;
begin
  RegisterComponents('Navigator Access', [TigDBISAMFilterModel]);
  RegisterComponents('Navigator Access', [TigDBISAMFindModel]);
end;

{ TigDBISAMIndexModel }

function TigDBISAMDataSetModel.GetIndexDefs: TIndexDefs;
begin
  if DataSet is TDBISAMTable then
  begin
    result := TDBISAMTable(DataSet).IndexDefs;
  end else
    result := nil;
end;

function TigDBISAMDataSetModel.GetIndexFieldNames: String;
begin
  if DataSet is TDBISAMTable then
  begin
    result := TDBISAMTable(DataSet).IndexFieldNames;
  end else
    result := '';
end;

function TigDBISAMDataSetModel.GetIndexName: String;
begin
  if DataSet is TDBISAMTable then
  begin
    result := TDBISAMTable(DataSet).IndexName;
  end else
    result := '';
end;

function TigDBISAMDataSetModel.FindRecord(const KeyValues: Variant; const Exact: Boolean): Boolean;
var
  i, HighBound: Integer;
begin
  if (DataSet is TDBISAMTable) then
  begin
    HighBound := VarArrayHighBound(KeyValues, 1);
    with TDBISAMTable(DataSet) do
    begin
      SetKey;
      for i := 0 to HighBound do
        Items[i].Field.Value := KeyValues[i];
      for i := HighBound + 1 to Count - 1 do
        Items[i].Field.Value := null;
      if Exact then result := GotoKey
      else
      begin
        GotoNearest;
        result:=true;
      end;
    end;
  end else
    Result := inherited FindRecord(KeyValues, Exact);
end;

function TigDBISAMDataSetModel.GetQuerySQL: String;
begin
  if (DataSet is TDBISAMQuery) then
    result := TDBISAMQuery(DataSet).SQL.Text
  else
    result := '';
end;

procedure TigDBISAMDataSetModel.SetQuerySQL(Value: string);
begin
  if (DataSet is TDBISAMQuery) then
    TDBISAMQuery(DataSet).SQL.Text := Value;
end;

function TigDBISAMDataSetModel.IsSupported(const Value: TDataSetSupportedOption): Boolean;
begin
  case Value of
    dsDefaultIndex: result := (DataSet is TDBISAMTable) or (DataSet is TDBISAMQuery);
    dsMultiCaseInsIndexSearch, dsIndexRange: result := DataSet is TDBISAMTable;
    dsSQL: result := DataSet is TDBISAMQuery;
    else result := inherited IsSupported(Value);
  end;
end;

procedure TigDBISAMDataSetModel.SetRange(StartValues, EndValues: Variant);
var
  HighBound, i: Integer;
begin
  if IsSupported(dsIndexRange) then
  with TDBISAMTable(DataSet) do
  begin
    if VarIsArray(StartValues) then
    begin
      HighBound := VarArrayHighBound(StartValues, 1);
      SetRangeStart;
      for i := 0 to HighBound do
      begin
        if not VarIsEmpty(StartValues[i]) then
          Items[i].Field.Value := StartValues[i];
      end;
      SetRangeEnd;
      for i := 0 to HighBound do
      begin
        if not VarIsEmpty(EndValues[i]) then
          Items[i].Field.Value := EndValues[i];
      end;
      ApplyRange;
    end else
    begin
      CancelRange;
    end;
  end;
end;

procedure TigDBISAMDataSetModel.SetParam(const Name: String; const Value: Variant);
var
  Param: TParam;
begin
  if DataSet is TDBISAMQuery then
  begin
    Param := TDBISAMQuery(DataSet).Params.FindParam(Name);
    if Param <> nil then Param.Value := Value;
  end;
end;

{ TigDBISAMFindModel }

procedure TigDBISAMFindModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigDBISAMDataSetModel.Create(Self);
end;

procedure TigDBISAMFindModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TDBISAMDataSet) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

{ TigDBISAMFilterModel }

procedure TigDBISAMFilterModel.CheckDataSet;
begin
  if not (DataLink.DataSet is TDBISAMDataSet) then
    igBaseModelErrorFmt(SIsNotDataSet, [DataLink.DataSet.Name, DataSetName], Self);
end;

procedure TigDBISAMFilterModel.CreateExtDataSetModel(out ExtDataSetModel: TigExtDataSetModel);
begin
  ExtDataSetModel := TigDBISAMDataSetModel.Create(Self);
end;


end.
