{$I dbpOptions.Inc}
unit DbpIBSet;

interface

uses
  {SysUtils,} Classes, Db, DbpSet;

type
  TDPIBFindIndex=class(TDPFindIndex)
  private
    function TableFindKey(const KeyValues:Variant; const ExactFind:Boolean):Boolean;
  protected
    function FindKey(const KeyValues:Variant):Boolean; override;
    procedure FindNearest(const KeyValues:Variant); override;
  end;

  TDPIBFindPanel=class(TDBFindPanel)
  protected
    function CreateFindIndex:TDPFindIndex; override;
  end;

  TDPIBFindDialog=class(TDBFindDialog)
  protected
    function CreatePanelFieldsSet:TPanelFieldsSet; override;
  end;

  procedure Register;

implementation

uses DbpIndex, IBCustomDataSet {$IFDEF V6_MORE}, Variants {$ENDIF};


type
  TIBFindComponent=class(TDBFindComponent)
  protected
    function CreateFindIndex:TDPFindIndex; override;
  end;

procedure Register;
begin
  {$IFDEF V5_MORE}
     RegisterComponents('DP Addition', [TDPIBFindPanel]);
     RegisterComponents('DP Addition', [TDPIBFindDialog]);
  {$ENDIF}
end;

{ TDPIBFindIndex }

function TDPIBFindIndex.FindKey(const KeyValues:Variant):Boolean;
begin
  if DataSet is TIBCustomDataSet then result:=TableFindKey(KeyValues,true)
  else result:=inherited FindKey(KeyValues);
end;

procedure TDPIBFindIndex.FindNearest(const KeyValues:Variant);
begin
  if (DataSet is TIBCustomDataSet) and (not TableFindKey(KeyValues,false)) then
    inherited FindNearest(KeyValues);
end;


function TDPIBFindIndex.TableFindKey(const KeyValues:Variant; const ExactFind:Boolean):Boolean;
var
  i,HighBound:Integer;
  LocateOptions:TLocateOptions;
  KeyFields:String;
  Values:Variant;
begin
  HighBound:=VarArrayHighBound(KeyValues,1);
  if HighBound=0 then Values:=KeyValues[0]
  else Values:=KeyValues;
  LocateOptions:=[];
  KeyFields:='';
  for i:=0 to HighBound do
  begin
    KeyFields:=KeyFields+Items[i].Field.FieldName+';';
    if Items[i].CaseInsensitive and CaseSensitiveDependent(Items[i].Field.DataType) then
      LocateOptions:=[loCaseInsensitive];
  end;
  if not ExactFind then  LocateOptions:=LocateOptions+[loPartialKey];
  result:=TIBCustomDataSet(DataSet).Locate(KeyFields,Values,LocateOptions);
end;

{ TDPIBFindPanel }

function TDPIBFindPanel.CreateFindIndex:TDPFindIndex;
begin
  result:=TDPIBFindIndex.Create(Self);
end;

{ TIBFindComponent }

function TIBFindComponent.CreateFindIndex:TDPFindIndex;
begin
  result:=TDPIBFindIndex.Create(Self);
end;

{ TDPIBFindDialog }

function TDPIBFindDialog.CreatePanelFieldsSet:TPanelFieldsSet;
begin
  result:=TIBFindComponent.Create(Self);
end;

end.
