{!$DEFINE DEBUG}
{$I VCLInclude.pas}
unit AsciiTable;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  stdctrls, dsgnintf, AsciiForm;

type

  TWZAsciiTable = class(TComponent)
  private
    { Private declarations }
    FAuthor: string;
    FVersion: string;
    FEditor: TCustomEdit;
    FSavePosition: boolean;
    FGridColor: TColor;
    FToolbarFlat: boolean;
    FGridSize: TGridSize;
    FShowHint: boolean;
    FFontNamesUseFonts: boolean;
    FInvertSelection: boolean;
    FOnShow: TNotifyEvent;
    FOnClose: TNotifyEvent;
    function GetEditor(): TCustomEdit;
    procedure SetAuthor(Value: string);
    procedure SetVersion(Value: string);
    procedure SetEditor(Value: TCustomEdit);
   protected
    { Protected declarations }
    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    function Execute(): boolean;
  published
    { Published declarations }
    property Author: string read FAuthor write SetAuthor;
    property Version: string read FVersion write SetVersion;
    property Editor: TCustomEdit read GetEditor write SetEditor;
    property SavePosition: boolean read FSavePosition write FSavePosition;
    property GridColor: TColor read FGridColor write FGridColor;
    property ToolbarFlat: boolean read FToolbarFlat write FToolbarFlat;
    property GridSize: TGridSize read FGridSize write FGridSize;
    property ShowHint: boolean read FShowHint write FShowHint;
    property FontNamesUseFonts: boolean read FFontNamesUseFonts write FFontNamesUseFonts;
    property InvertSelection: boolean read FInvertSelection write FInvertSelection;
    property OnShow: TNotifyEvent read FOnShow write FOnShow;
    property OnClose: TNotifyEvent read FOnClose write FOnClose;
  end;

procedure Register;

implementation

const
  TheAuthor: string = 'Willem van de Zande, Almere - the Netherlands';
  TheVersion: string = 'Version 1.0 d.d. 05-05-2000';
  
var
  AsciiDlg: TAsciiDlg;

procedure Register;
begin
  RegisterComponents('WZ', [TWZAsciiTable]);
end;

constructor TWZAsciiTable.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FAuthor:= TheAuthor;
  FVersion:= TheVersion;
  FSavePosition:= true;
  FGridColor:= clWindow;
  FToolbarFlat:= true;
  FGridSize:= _16_x_16;
  FShowHint:= false;
  FFontNamesUseFonts:= false;
end;

function TWZAsciiTable.GetEditor(): TCustomEdit;
begin
  Result:= FEditor;
end;

procedure TWZAsciiTable.SetEditor(Value: TCustomedit);
begin
  if FEditor <> Value then
  begin
    FEditor := Value;
  end;
// zie 'Developing Custom Delphi 3 Components, p. 410
  if FEditor <> nil then
    FEditor.FreeNotification(self)
end;

procedure TWZAsciiTable.SetAuthor(Value: string);
begin
  FAuthor:= TheAuthor;
end;

procedure TWZAsciiTable.SetVersion(Value: string);
begin
  FVersion:= TheVersion;
end;

function TWZAsciiTable.Execute(): boolean;
begin
  if assigned(FOnShow) then
    FOnShow(self);
  if not assigned(FEditor) then
  begin
    ShowMessage('Ascii-table needs an editor;'#10#13 +
      'assign one in the Object Editor ...');
    Result:= false;
    exit;
  end;
  AsciiDlg:= TAsciidlg.CreateX(Application, FEditor);
  try
    AsciiDlg.SetGridColor(FGridColor);
    AsciiDlg.SetToolbarFlat(FToolbarFlat);
    AsciiDlg.SetGridSize(FGridSize);
    AsciiDlg.SetSavePosition(FSavePosition);
    AsciiDlg.SetShowHint(FShowHint);
    AsciiDlg.SetFontNamesUseFonts(FFontNamesUseFonts);
    Asciidlg.SetInvertSelection(FInvertSelection);
    Result:= (AsciiDlg.ShowModal() = idOK);
  finally
    if assigned(FOnClose) then
      FOnClose(self);
    AsciiDlg.Free();
  end;
end;

procedure TWZAsciiTable.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited Notification(AComponent, Operation);
  if Operation = opRemove then
  begin
    if (AComponent = FEditor) then
      FEditor:= nil;
  end;
end;

end.
