{!$DEBUGINFO ON}
unit AsciiIni;

interface

uses
  registry;

type
  TIniInfo = record
    AsciiLeft: integer;
    AsciiTop: integer;
    AsciiHeight: integer;
    AsciiWidth: integer;
    Is_16_x_16: boolean; // default size od char grid
  end;

  TIniVar = class(TObject)
  private
    IniFileName: string;
    Section: string;
    IniFile: TRegIniFile;
    procedure ReadIniFile();
    procedure WriteIniFile();
  protected
  public
    IniInfo: TIniInfo;
    constructor Create();
    destructor Destroy(); override;
  published
  end;

var
  IniVar: TIniVar;

implementation

uses
  sysutils, Forms;

constructor TIniVar.Create;
begin
  inherited Create();
  IniFileName := 'Software';
  Section := ExtractFileDir(Application.ExeName) + '_WZAscii';
  IniFile := TRegIniFile.Create(IniFileName);
  ReadIniFile();
  WriteIniFile();
end;

procedure TIniVar.ReadIniFile();
begin
  with IniInfo do
  begin
    AsciiLeft:= IniFile.ReadInteger(Section, 'AsciiLeft', 0);
    Asciitop:= IniFile.ReadInteger(Section, 'AsciiTop', 0);
    AsciiHeight:= IniFile.ReadInteger(Section, 'AsciiHeight', 500);
    AsciiWidth:= IniFile.ReadInteger(Section, 'AsciiWidth', 269);
    Is_16_x_16:= IniFile.ReadBool(Section, 'Is_16_x_16', true);
  end;
end;

procedure TIniVar.WriteIniFile();
begin
  with IniInfo do
  begin
    IniFile.WriteInteger(Section, 'AsciiLeft', AsciiLeft);
    IniFile.WriteInteger(Section, 'AsciiTop', AsciiTop);
    IniFile.WriteInteger(Section, 'AsciiHeighth', AsciiHeight);
    IniFile.WriteInteger(Section, 'AsciiWidth', AsciiWidth);
    IniFile.WriteBool(Section, 'Is_16_x_16', Is_16_x_16);
  end;
end;

destructor TIniVar.Destroy();
begin
  WriteIniFile();
  IniFile.Free();
  inherited Destroy();
end;

end.
