{!$DEFINE DEBUG}
unit AsciiForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Grids, RXCombos, ComCtrls, ToolWin, RXSpin,
  ActnList, ImgList, Buttons, RxRichEd, Menus;

type
  TGridSize = (_16_x_16, _32_x_8);
  TAsciiDlg = class(TForm)
    gdAscii: TStringGrid;
    pnSample: TPanel;
    pnChar: TPanel;
    ToolBar1: TToolBar;
    ToolBar2: TToolBar;
    ToolBar3: TToolBar;
    ActionList1: TActionList;
    ImageList1: TImageList;
    CharToClip: TAction;
    edDummy: TRxRichEdit;
    cbFontName: TFontComboBox;
    seFontSize: TRxSpinEdit;
    cbTxtColor: TColorComboBox;
    cbCharset: TComboBox;
    btBold: TToolButton;
    btItalic: TToolButton;
    btUnderline: TToolButton;
    btInsert: TToolButton;
    btInsAndClose: TToolButton;
    btCancel: TToolButton;
    btExit: TToolButton;
    btCopy: TToolButton;
    mnAscii: TPopupMenu;
    Copy1: TMenuItem;
    CharBold: TAction;
    CharItalic: TAction;
    CharUnderlined: TAction;
    CharInsert: TAction;
    CharInsAndClose: TAction;
    Cancel: TAction;
    Exit: TAction;
    Inserttoeditor1: TMenuItem;
    InsertandClose1: TMenuItem;
    Cancel1: TMenuItem;
    Exit1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    btOrientation: TToolButton;
    procedure FormDestroy(Sender: TObject);
    procedure gdAsciiClick(Sender: TObject);
    procedure gdAsciiSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure cbFontNameChange(Sender: TObject);
    procedure seFontSizeChange(Sender: TObject);
    function ShowModal: Integer; override;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure cbTxtColorChange(Sender: TObject);
    procedure cbCharsetChange(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure CharBoldExecute(Sender: TObject);
    procedure CharItalicExecute(Sender: TObject);
    procedure CharUnderlinedExecute(Sender: TObject);
    procedure CharToClipExecute(Sender: TObject);
    procedure CharInsertExecute(Sender: TObject);
    procedure CharInsAndCloseExecute(Sender: TObject);
    procedure CancelExecute(Sender: TObject);
    procedure ExitExecute(Sender: TObject);
    procedure btOrientationClick(Sender: TObject);
  private
    { Private declarations }
    FCol, FRow: integer;
    FOldFont: TFont;
    FSenderControl: TWinControl;
    FGridSize: TGridSize;
    FSavePosition: boolean;
    procedure ShowCharNum();
    function GetCharset(const Index: integer): TFontCharset;
    procedure DrawForm();
    procedure AssignToEditor();
  public
    { Public declarations }
    constructor CreateX(AOwner: TComponent; const SenderControl: TWincontrol);
    destructor Destroy(); override;
    procedure SetSavePosition(Value: boolean);
    procedure SetGridColor(Value: TColor);
    procedure SetGridSize(Value: TGridSize);
    procedure SetToolbarFlat(Value: boolean);
    procedure SetShowHint(Value: boolean);
    procedure SetFontNamesUseFonts(Value: boolean);
    procedure SetInvertSelection(Value: boolean);
  end;

implementation

uses
  clipbrd, AsciiIni;

{$R *.DFM}

constructor TAsciiDlg.CreateX(AOwner: TComponent; const SenderControl: TWincontrol);
begin
  FSenderControl:=SenderControl;
  inherited Create(AOwner);
  IniVar:= TIniVar.Create();
end;

destructor TAsciiDlg.Destroy();
begin
  if assigned(IniVar) then
    IniVar.Free();
  inherited Destroy();
end;

procedure TAsciiDlg.FormCreate(Sender: TObject);
begin
  FOldFont := TFont.Create();
  DrawForm();
end;

procedure TAsciiDlg.DrawForm();
var
  X, Y: integer;
begin
  Left:= 0;
  Top:= 0;
  if FGridSize = _16_x_16 then
  begin
    Height:= 500;
    Width:= 269;
    IniVar.IniInfo.AsciiHeight:= 500;
    IniVar.IniInfo.AsciiWidth:= 269;
    gdAscii.Height:= 323;
    gdAscii.Width:= 259;
    gdAscii.RowCount:= 16;
    gdAscii.ColCount:= 16;
    gdAscii.Left:= 1;
    Toolbar1.Width:= 259;
    Toolbar2.Width:= 259;
    Toolbar3.Width:= 259;
    Toolbar1.Left:= 1;
    Toolbar2.Left:= 1;
    Toolbar3.Left:= 1;
    pnSample.Left:= 1;
    pnChar.Left:= 140;
    gdAscii.Top:= 79;
    Toolbar1.Top:= 0;
    Toolbar2.Top:= 26;
    Toolbar3.Top:= 52;
    pnSample.Top:= 406;
    pnChar.Top:= 406;
    cbFontName.Width:= 193;
    cbTxtColor.Width:= 106;
    cbCharset.Width:= 147;
  end
  else if FGridSize = _32_x_8 then
  begin
    Height:= 225;
    Width:= 651;
    IniVar.IniInfo.AsciiHeight:= 225;
    IniVar.IniInfo.AsciiWidth:= 651;
    gdAscii.Height:= 163;
    gdAscii.Width:= 515;
    gdAscii.RowCount:= 8;
    gdAscii.ColCount:= 32;
    gdAscii.Left:= 1;
    Toolbar1.Width:= 216;
    Toolbar2.Width:= 207;
    Toolbar3.Width:= 214;
    Toolbar1.Left:= 1;
    Toolbar2.Left:= 219;
    Toolbar3.Left:= 427;
    pnSample.Left:= 521;
    pnChar.Left:= 521;
    gdAscii.Top:= 29;
    Toolbar1.Top:= 0;
    Toolbar2.Top:= 0;
    Toolbar3.Top:= 0;
    pnSample.Top:= 29;
    pnChar.Top:= 130;
    cbFontName.Width:= 151;
    cbTxtColor.Width:= 85;
    cbCharset.Width:= 115;
  end;
  ShowCharNum();
  for Y := 0 to (gdAscii.RowCount - 1) do
  begin
    for X := 0 to gdAscii.ColCount - 1 do
    begin
      gdAscii.Cells[X, Y] := char(Y * gdAscii.ColCount + X);
    end; // for Y
  end; // for X
end;

procedure TAsciiDlg.FormActivate(Sender: TObject);
begin
  if FSenderControl is TRXCustomRichEdit then
  begin
    with FSenderControl as TRXCustomRichEdit do
    begin
      gdAscii.Font.Assign(SelAttributes);
      pnSample.Font.Assign(SelAttributes);
      cbTxtColor.ColorValue := pnSample.Font.Color;
    end;
  end
  else if FSenderControl is TCustomRichEdit then
  begin
    with FSenderControl as TCustomRichEdit do
    begin
      gdAscii.Font.Assign(SelAttributes);
      pnSample.Font.Assign(SelAttributes);
      cbTxtColor.ColorValue := pnSample.Font.Color;
    end;
  end;
end;

procedure TAsciiDlg.FormDestroy(Sender: TObject);
begin
  FOldFont.Free();
  if FSavePosition then
  begin
    with IniVar.IniInfo do
    begin
      AsciiLeft:= Left;
      AsciiTop:= Top;
      AsciiHeight:= Height;
      AsciiWidth:= Width;
    end;
  end;
end;

procedure TAsciiDlg.gdAsciiClick(Sender: TObject);
begin
  ShowCharNum();
end;

procedure TAsciiDlg.gdAsciiSelectCell(Sender: TObject; ACol, ARow: Integer;
  var CanSelect: Boolean);
begin
  FCol := ACol;
  FRow := ARow;
  ShowCharNum();
end;

procedure TAsciiDlg.cbFontNameChange(Sender: TObject);
var
  FFontName: string;
begin
  FFontName := UpperCase(cbFontName.FontName);
  pnSample.Font.Name := cbFontName.FontName;
  if (FFontName = 'SYMBOL') or (FFontName = 'WINGDINGS') or
    (FFontName = 'WEBDINGS') or (FFontName = 'ARIAL ALTERNATIVE SYMBOL') then
    pnSample.Font.CharSet := SYMBOL_CHARSET
  else
  begin
    if (FFontName = 'TERMINAL') then
      pnSample.Font.CharSet := OEM_CHARSET
    else
      pnSample.Font.CharSet := ANSI_CHARSET;
  end;
  pnChar.Font.Assign(pnSample.Font);
  gdAscii.Font.Assign(pnSample.Font);
  AssignToEditor();
end;

procedure TAsciiDlg.seFontSizeChange(Sender: TObject);
begin
  pnSample.Font.Size := trunc(seFontSize.Value);
  pnChar.Font.Assign(pnSample.Font);
  gdAscii.Font.Assign(pnSample.Font);
  AssignToEditor();
end;

procedure TAsciiDlg.ShowCharNum();
begin
  if FGridSize = _16_x_16 then
    Caption := 'Character # ' +
      IntToStr(FRow * gdAscii.ColCount + FCol)
  else
    Caption := 'Ascii-table: character # ' +
      IntToStr(FRow * gdAscii.ColCount + FCol);
  pnChar.Caption := char(FRow * gdAscii.ColCount + FCol);
end;

function TAsciiDlg.ShowModal: Integer;
begin
  if FSenderControl is TRXCustomRichEdit then
  begin
    with FSenderControl as TRXCustomRichEdit do
    begin
      FOldFont.Name := SelAttributes.Name;
      FOldFont.Size := SelAttributes.Size;
      FOldFont.Color := SelAttributes.Color;
      FOldFont.Style := SelAttributes.Style;
      cbFontName.FontName := FOldFont.Name;
      pnSample.Font.Assign(FOldFont);
      pnChar.Font.Assign(FOldFont);
      seFontSize.Value := FOldFont.Size;
    end;
  end
  else if FSenderControl is TCustomRichEdit then
  begin
    with FSenderControl as TCustomRichEdit do
    begin
      FOldFont.Name := SelAttributes.Name;
      FOldFont.Size := SelAttributes.Size;
      FOldFont.Color := SelAttributes.Color;
      FOldFont.Style := SelAttributes.Style;
      cbFontName.FontName := FOldFont.Name;
      pnSample.Font.Assign(FOldFont);
      pnChar.Font.Assign(FOldFont);
      seFontSize.Value := FOldFont.Size;
    end;
  end
  else if FSenderControl is TCustomEdit then
  begin
    FOldFont.Name := 'tInfo';
    FOldFont.Size := 8;
    FOldFont.Color := clGray;
    cbFontName.FontName := FOldFont.Name;
    pnSample.Font.Assign(FOldFont);
    pnChar.Font.Assign(FOldFont);
    seFontSize.Value := FOldFont.Size;
  end;
  Result := inherited ShowModal;
end;

procedure TAsciiDlg.cbTxtColorChange(Sender: TObject);
begin
  pnSample.Font.Color := cbTxtColor.ColorValue;
  pnChar.Font.Assign(pnSample.Font);
  gdAscii.Font.Assign(pnSample.Font);
  AssignToEditor();
end;

procedure TAsciiDlg.cbCharsetChange(Sender: TObject);
begin
  pnSample.Font.Charset := GetCharSet(cbCharset.ItemIndex);
  pnChar.Font.Assign(pnSample.Font);
  gdAscii.Font.Assign(pnSample.Font);
  AssignToEditor();
end;

procedure TAsciiDlg.AssignToEditor();
begin
  if FSenderControl is TRXCustomRichEdit then
  begin
    with FSenderControl as TRXCustomRichEdit do
    begin
      SelAttributes.Assign(pnSample.Font)
    end;
  end
  else if FSenderControl is TCustomRichEdit then
  begin
    with FSenderControl as TCustomRichEdit do
    begin
      SelAttributes.Assign(pnSample.Font)
    end;
  end;
end;

function TAsciiDlg.GetCharset(const Index: integer): TFontCharset;
begin
  case Index of
    00: Result:= ANSI_CHARSET;        //  Ansi
    01: Result:= DEFAULT_CHARSET;     //  Default
    02: Result:= SYMBOL_CHARSET	;     //  Symbol
    03: Result:= MAC_CHARSET;         //  MAC
    04: Result:= SHIFTJIS_CHARSET;    //  Shift-jis
    05: Result:= HANGEUL_CHARSET;     //  Hangeul
    06: Result:= JOHAB_CHARSET;       //  Johab
    07: Result:= GB2312_CHARSET;      //  GB 2312
    08: Result:= CHINESEBIG5_CHARSET; //  Chinese big 5
    09: Result:= GREEK_CHARSET;       //  Greek
    10: Result:= TURKISH_CHARSET;     //  Turkish
    11: Result:= VIETNAMESE_CHARSET;  //  Vietnamese
    12: Result:= HEBREW_CHARSET;      //  Hebrew
    13: Result:= ARABIC_CHARSET	;     //  Arabic
    14: Result:= BALTIC_CHARSET	;     //  Baltic
    15: Result:= RUSSIAN_CHARSET;     //  Russian
    16: Result:= THAI_CHARSET;        //  Thai
    17: Result:= EASTEUROPE_CHARSET;  //  Eeast Europe
    18: Result:= OEM_CHARSET;         //  OEM
    else
      Result:= DEFAULT_CHARSET;
  end; // case
end;

procedure TAsciiDlg.SetSavePosition(Value: boolean);
begin
  FSavePosition:= Value;
  if FSavePosition then
  begin
    with IniVar.IniInfo do
    begin
      Left:= AsciiLeft;
      Top:= AsciiTop;
      Height:= AsciiHeight;
      Width:= AsciiWidth;
    end;
  end;
end;

procedure TAsciiDlg.SetGridColor(Value: TColor);
begin
  gdAscii.Color:= Value;
end;

procedure TAsciiDlg.SetGridSize(Value: TGridsize);
begin
  FGridSize:= Value;
  IniVar.IniInfo.Is_16_x_16:= (FGridSize = _16_x_16);
  DrawForm();
end;

procedure TAsciiDlg.SetToolbarFlat(Value: boolean);
begin
  ToolBar1.Flat:= Value;
  ToolBar2.Flat:= Value;
  ToolBar3.Flat:= Value;
end;

procedure TAsciiDlg.SetShowHint(Value: boolean);
var
  I: integer;
begin
  for I := 0 to ComponentCount - 1 do
  begin
    if (Components[I] is TControl) then
      TControl(Components[I]).ShowHint:= Value;
  end;
end;

procedure TAsciiDlg.SetFontNamesUseFonts(Value: boolean);
begin
  cbFontName.UseFonts:= Value;
end;

procedure TAsciiDlg.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #27 then    // Esc
    btCancel.Click();
  if Key = #13 then    // Enter
    btInsert.Click();
end;

procedure TAsciiDlg.SetInvertSelection(Value: boolean);
begin
  if Value then
    gdAscii.Options:= gdAscii.Options + [goDrawFocusSelected]
  else
    gdAscii.Options:= gdAscii.Options - [goDrawFocusSelected];
end;

procedure TAsciiDlg.CharBoldExecute(Sender: TObject);
begin
  if fsBold in pnSample.Font.Style then
    pnSample.Font.Style:= pnSample.Font.Style - [fsBold]
  else
    pnSample.Font.Style:= pnSample.Font.Style + [fsBold];
  pnChar.Font.Assign(pnSample.Font);
  gdAscii.Font.Assign(pnSample.Font);
  AssignToEditor();
end;

procedure TAsciiDlg.CharItalicExecute(Sender: TObject);
begin
  if fsItalic in pnSample.Font.Style then
    pnSample.Font.Style:= pnSample.Font.Style - [fsItalic]
  else
    pnSample.Font.Style:= pnSample.Font.Style + [fsItalic];
  pnChar.Font.Assign(pnSample.Font);
  gdAscii.Font.Assign(pnSample.Font);
  AssignToEditor();
end;

procedure TAsciiDlg.CharUnderlinedExecute(Sender: TObject);
begin
  if fsUnderline in pnSample.Font.Style then
    pnSample.Font.Style:= pnSample.Font.Style - [fsUnderline]
  else
    pnSample.Font.Style:= pnSample.Font.Style + [fsUnderline];
  pnChar.Font.Assign(pnSample.Font);
  gdAscii.Font.Assign(pnSample.Font);
  AssignToEditor();
end;

procedure TAsciiDlg.CharToClipExecute(Sender: TObject);
begin
  edDummy.Clear();
  edDummy.SelText := IntToStr(FRow * gdAscii.ColCount + FCol);
  edDummy.SelText := gdAscii.Cells[FCol, FRow];
  edDummy.SelAttributes.Assign(pnSample.Font);
  edDummy.CutToClipboard();
end;

procedure TAsciiDlg.CharInsertExecute(Sender: TObject);
begin
  if FSenderControl is TRXCustomRichEdit then
  begin
    with FSenderControl as TRXCustomRichEdit do
    begin
      SelText := gdAscii.Cells[FCol, FRow];
      SelAttributes.Assign(pnSample.Font);
      SelStart := SelStart + 1;
      SelLength := 0;
      Modified := true;
    end;
  end
  else if FSenderControl is TCustomRichEdit then
  begin
    with FSenderControl as TCustomRichEdit do
    begin
      SelText := gdAscii.Cells[FCol, FRow];
      SelAttributes.Assign(pnSample.Font);
      SelStart := SelStart + 1;
      SelLength := 0;
      Modified := true;
    end;
  end
  else if FSenderControl is TCustomEdit then
  begin
    with FSenderControl as TCustomEdit do
    begin
      SelText := gdAscii.Cells[FCol, FRow];
      SelStart := SelStart + 1;
      Modified := true;
    end;
  end;
  ShowCharNum();
end;

procedure TAsciiDlg.CharInsAndCloseExecute(Sender: TObject);
begin
  CharInsertExecute(Sender);
  Close();
end;

procedure TAsciiDlg.CancelExecute(Sender: TObject);
begin
  if FSenderControl is TRXCustomRichEdit then
  begin
    with FSenderControl as TRXCustomRichEdit do
    begin
      SelAttributes.Assign(FOldFont)
    end;
  end
  else if FSenderControl is TCustomRichEdit then
  begin
    with FSenderControl as TCustomRichEdit do
    begin
      SelAttributes.Assign(FOldFont)
    end;
  end;
  ModalResult:= mrCancel;
  Close();
end;

procedure TAsciiDlg.ExitExecute(Sender: TObject);
begin
  AssignToEditor();
  ModalResult:=mrOK;
  Close();
end;

procedure TAsciiDlg.btOrientationClick(Sender: TObject);
begin
  if FGridSize = _16_x_16 then
    FGridSize:= _32_x_8
  else
    FGridSize:= _16_x_16;
  DrawForm();
end;

end.

