unit Demo_;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, StdCtrls, VidGrab, Buttons, Menus;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Button1: TButton;
    Button2: TButton;
    RadioGroup3: TRadioGroup;
    GroupBox3: TGroupBox;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    GroupBox5: TGroupBox;
    GroupBox7: TGroupBox;
    ComboBox2: TComboBox;
    Label9: TLabel;
    Edit2: TEdit;
    Button10: TButton;
    RadioGroup1: TRadioGroup;
    Memo1: TMemo;
    Edit4: TEdit;
    Label4: TLabel;
    ComboBox1: TComboBox;
    Button11: TButton;
    ComboBox3: TComboBox;
    Label5: TLabel;
    ComboBox4: TComboBox;
    Edit6: TEdit;
    Label14: TLabel;
    Label3: TLabel;
    Edit9: TEdit;
    Label15: TLabel;
    Label12: TLabel;
    OpenDialog1: TOpenDialog;
    GroupBox2: TGroupBox;
    Label8: TLabel;
    Edit8: TEdit;
    UpDown1: TUpDown;
    TrackBar1: TTrackBar;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    SendDVcommands1: TMenuItem;
    Play1: TMenuItem;
    Stop1: TMenuItem;
    Freeze1: TMenuItem;
    FF1: TMenuItem;
    Rew1: TMenuItem;
    Record1: TMenuItem;
    Recordfreeze1: TMenuItem;
    StepFwd1: TMenuItem;
    StepRev1: TMenuItem;
    Playfastestfwd1: TMenuItem;
    Playslowestfwd1: TMenuItem;
    Playfastestrev1: TMenuItem;
    Playslowestrev1: TMenuItem;
    CheckBox10: TCheckBox;
    CheckBox9: TCheckBox;
    Options1: TMenuItem;
    RefreshPreviewOnParamChange1: TMenuItem;
    RadioGroup7: TRadioGroup;
    RadioGroup5: TRadioGroup;
    RadioGroup6: TRadioGroup;
    RadioGroup2: TRadioGroup;
    CheckBox1: TCheckBox;
    SpeedButton4: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton1: TSpeedButton;
    AutoPlayClip1: TMenuItem;
    ComboBox6: TComboBox;
    Edit5: TEdit;
    Label7: TLabel;
    Label13: TLabel;
    Edit7: TEdit;
    Label11: TLabel;
    Label1: TLabel;
    ComboBox5: TComboBox;
    Label6: TLabel;
    Label16: TLabel;
    Button4: TButton;
    GroupBox4: TGroupBox;
    Edit3: TEdit;
    Label10: TLabel;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    Button14: TButton;
    Button15: TButton;
    FrameGrabberEnabled1: TMenuItem;
    FrameGrabberOnCaptureStream1: TMenuItem;
    CheckBox3: TCheckBox;
    Button16: TButton;
    Edit10: TEdit;
    GroupBox6: TGroupBox;
    Button8: TButton;
    Button9: TButton;
    Button17: TButton;
    UpDown2: TUpDown;
    Label17: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Button12: TButton;
    ComboBox7: TComboBox;
    Label18: TLabel;
    ComboBox8: TComboBox;
    CheckBox2: TCheckBox;
    Label19: TLabel;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    VideoGrabber1: TVideoGrabber;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure RadioGroup3Click(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure CheckBox7Click(Sender: TObject);
    procedure CheckBox8Click(Sender: TObject);
    procedure Edit3Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox4Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure VideoGrabber1CaptureReadyToStart(Sender: TObject;
      var OkToStart: Boolean);
    procedure VideoGrabber1CaptureStarted(Sender: TObject);
    procedure VideoGrabber1ComponentLoaded(Sender: TObject);
    procedure VideoGrabber1DeviceLost(Sender: TObject);
    procedure VideoGrabber1DiskFull(Sender: TObject);
    procedure VideoGrabber1RecompressCompleted(Sender: TObject;
      Success: Boolean);
    procedure VideoGrabber1RecompressStarted(Sender: TObject);
    procedure VideoGrabber1PreviewStarted(Sender: TObject);
    procedure ComboBox6Change(Sender: TObject);
    procedure VideoGrabber1CopyPreallocDataCompleted(Sender: TObject;
      Success: Boolean);
    procedure VideoGrabber1CopyPreallocDataStarted(Sender: TObject);
    procedure VideoGrabber1CreatePreallocFileStarted(Sender: TObject);
    procedure VideoGrabber1CreatePreallocFileCompleted(Sender: TObject;
      Success: Boolean);
    procedure RadioGroup5Click(Sender: TObject);
    procedure RadioGroup6Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure ComboBox5Change(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure Edit5Change(Sender: TObject);
    procedure Edit7Change(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Edit6Change(Sender: TObject);
    procedure CheckBox9Click(Sender: TObject);
    procedure VideoGrabber1ChangeVideoDevice(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure RadioGroup7Click(Sender: TObject);
    procedure Edit9Change(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure VideoGrabber1PlayerProgress(SampleTime: Double);
    procedure VideoGrabber1CaptureProgress(SampleTime: Double;
      DeliveredFrames, DroppedFrames: Integer);
    procedure VideoGrabber1CaptureCompleted(Sender: TObject;
      FileName: String; Success: Boolean);
    procedure VideoGrabber1FrameCaptureCompleted(Sender: TObject;
      MemoryBitmap: TBitmap; DestType: TFrameCaptureDest; FileName: String;
      Success: Boolean);
    procedure VideoGrabber1DirectX8Required(Sender: TObject);
    procedure SendDvCommand (Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure CheckBox10Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure VideoGrabber1NewDeviceList(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure VideoGrabber1PlayerStarted(Sender: TObject);
    procedure VideoGrabber1ErrorLog(Sender: TObject; ErrorCode: Integer;
      ErrorMsg: String);
    procedure AutoPlayClip1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure VideoGrabber1PlayerEndOfStream(Sender: TObject);
    procedure VideoGrabber1PlayerFileNotFound(Sender: TObject;
      FileName: String);
    procedure Button14Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure FrameGrabberEnabled1Click(Sender: TObject);
    procedure FrameGrabberOnCaptureStream1Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure VideoGrabber1DeviceArrival(Sender: TObject);
    procedure VideoGrabber1DeviceRemoval(Sender: TObject);
    procedure VideoGrabber1TimeCodeReader(Sender: TObject; TrackNum, hh,
      mm, ss, ff: Integer);
    procedure UpDown2Click(Sender: TObject; Button: TUDBtnType);
    procedure ComboBox7Change(Sender: TObject);
    procedure ComboBox8Change(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure RefreshPreviewOnParamChange1Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    procedure EnableDisableOptions;
  public
  end;

var
  Form1: TForm1;
  SnapForm: TForm = nil;
  SnapImage: TImage = nil;

implementation

{$R *.DFM}

procedure AssignListToComboBox (ComboBox: TComboBox; List: String; Index: integer);
begin
   ComboBox.Items.Text := List;
   if ComboBox.Items.Count > 0 then begin
      ComboBox.ItemIndex := Index;
   end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   CheckBox1.Checked := VideoGrabber1.DVReduceFrameRate;
   CheckBox2.Checked := VideoGrabber1.Visible;
   CheckBox3.Checked := VideoGrabber1.CaptureAudio;
   CheckBox4.Checked := VideoGrabber1.AutoSize;
   CheckBox5.Checked := VideoGrabber1.RenderAudio;
   CheckBox7.Checked := VideoGrabber1.PreallocCapFileEnabled;
   CheckBox8.Checked := VideoGrabber1.PreallocCapRecreate;
   CheckBox9.Checked := VideoGrabber1.BurstMode;

   RadioGroup1.ItemIndex := integer (VideoGrabber1.CompressionType);
   RadioGroup2.ItemIndex := integer (VideoGrabber1.DVCaptureMode);
   RadioGroup3.ItemIndex := integer (VideoGrabber1.CompressionMode);
   RadioGroup5.ItemIndex := integer (VideoGrabber1.DVPreviewResolution);
   RadioGroup6.ItemIndex := integer (VideoGrabber1.DVCaptureResolution);
   RadioGroup7.ItemIndex := integer (VideoGrabber1.AutoFileName);

   Edit1.Text := FloatToStr (VideoGrabber1.FrameRate);
   Edit2.Text := VideoGrabber1.StoragePath;
   Edit3.Text := IntToStr (VideoGrabber1.PreallocCapFileSizeInMB);
   Edit6.Text := IntToStr (VideoGrabber1.BurstCount);
   Edit8.Text := FloatToStr (VideoGrabber1.PlayerRate);
   Edit9.Text := IntToStr (VideoGrabber1.BurstInterval);

   UpDown1.Position := Trunc (VideoGrabber1.PlayerRate * 1000);

   AssignListToComboBox (ComboBox2, VideoGrabber1.VideoDevices, 0);
   AssignListToComboBox (ComboBox3, VideoGrabber1.AudioDevices, 0);
   AssignListToComboBox (ComboBox4, VideoGrabber1.AudioFormats, 0);
   AssignListToComboBox (ComboBox5, VideoGrabber1.AudioCompressors, VideoGrabber1.AudioCompressor);
   AssignListToComboBox (ComboBox6, VideoGrabber1.VideoCompressors, VideoGrabber1.VideoCompressor);
   AssignListToComboBox (ComboBox8, VideoGrabber1.AnalogVideoStandards, integer (VideoGrabber1.AnalogVideoStandard));

   RefreshPreviewOnParamChange1.Checked := VideoGrabber1.RefreshPreviewOnParamChange;
   AutoPlayClip1.Checked := VideoGrabber1.PlayerAutoStart;

   FrameGrabberEnabled1.Checked := VideoGrabber1.FrameGrabberEnabled;
   FrameGrabberOnCaptureStream1.Checked := VideoGrabber1.FrameGrabberOnCaptureStream;
end;

procedure TForm1.EnableDisableOptions;
begin
   CheckBox1.Enabled := VideoGrabber1.IsDigitalVideoIn;

   RadioGroup2.Enabled := VideoGrabber1.IsDigitalVideoIn;
   RadioGroup5.Enabled := VideoGrabber1.IsDigitalVideoIn;
   RadioGroup6.Enabled := VideoGrabber1.IsDigitalVideoIn;
   ComboBox1.Enabled := not VideoGrabber1.IsDigitalVideoIn;

   Button5.Enabled := VideoGrabber1.FrameGrabberEnabled;
   Button6.Enabled := VideoGrabber1.FrameGrabberEnabled;
   Button7.Enabled := VideoGrabber1.FrameGrabberEnabled;
   Edit6.Enabled := VideoGrabber1.FrameGrabberEnabled;
   Edit9.Enabled := VideoGrabber1.FrameGrabberEnabled;
   CheckBox9.Enabled := VideoGrabber1.FrameGrabberEnabled;
   CheckBox10.Enabled := VideoGrabber1.FrameGrabberEnabled;

   ComboBox3.Enabled := VideoGrabber1.CaptureAudio;
   ComboBox4.Enabled := VideoGrabber1.CaptureAudio;
   Button11.Enabled := VideoGrabber1.CaptureAudio;

   ComboBox8.Enabled := VideoGrabber1.AnalogVideoStandardAvailable;

   RadioGroup3.Enabled := True;
   RadioGroup1.Enabled := True;
   if not VideoGrabber1.CaptureAudio then begin
      RadioGroup1.ItemIndex := 0;
      RadioGroup1.Enabled := False;
   end;
   if VideoGrabber1.IsDigitalVideoIn then begin
      if VideoGrabber1.DVCaptureMode = dv_CaptureType1 then begin
         RadioGroup3.ItemIndex := 0;
         RadioGroup1.Enabled := False;
         RadioGroup3.Enabled := False;
         RadioGroup6.Enabled := False;
      end;
   end;
   Button14.Enabled := VideoGrabber1.IsDialogAvailable (dlg_Crossbar);
   Button15.Enabled := VideoGrabber1.IsDialogAvailable (dlg_TVTuner);
   UpDown2.Enabled := Button15.Enabled;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
   VideoGrabber1.StartCapture;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   VideoGrabber1.StopCapture;
end;

procedure TForm1.RadioGroup3Click(Sender: TObject);
begin
   VideoGrabber1.CompressionMode := TCompressionMode (RadioGroup3.ItemIndex);
end;

procedure TForm1.ComboBox6Change(Sender: TObject);
begin
   VideoGrabber1.VideoCompressor := ComboBox6.ItemIndex;
end;

procedure TForm1.Edit2Change(Sender: TObject);
begin
   VideoGrabber1.StoragePath := Edit2.Text;
end;

procedure TForm1.CheckBox7Click(Sender: TObject);
begin
   VideoGrabber1.PreallocCapFileEnabled := CheckBox7.Checked;
end;

procedure TForm1.CheckBox8Click(Sender: TObject);
begin
   VideoGrabber1.PreallocCapRecreate := CheckBox8.Checked;
end;

procedure TForm1.Edit3Change(Sender: TObject);
begin
   VideoGrabber1.PreallocCapFileSizeInMB := StrToIntDef (Edit3.Text, 100);
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
   VideoGrabber1.VideoSize := ComboBox1.ItemIndex;
end;

procedure TForm1.ComboBox4Change(Sender: TObject);
begin
   VideoGrabber1.AudioFormat := TAudioFormat (ComboBox4.ItemIndex);
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
begin
   VideoGrabber1.VideoDevice := ComboBox2.ItemIndex;
end;

procedure TForm1.ComboBox3Change(Sender: TObject);
begin
   VideoGrabber1.AudioDevice := ComboBox3.ItemIndex;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
   VideoGrabber1.CaptureFrameTo (fc_TBitmap, '');
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
   VideoGrabber1.CaptureFrameTo (fc_BmpFile, '');
   // a file name will be created automatically, but you can force a file name
   // e.g.: VideoGrabber1.CaptureFrameTo (fc_BmpFile, 'c:\mypath\myfile.bmp');
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
   VideoGrabber1.CaptureFrameTo (fc_JpegFile, '');
   // a file name will be created automatically, but you can force a file name
   // e.g.: VideoGrabber1.CaptureFrameTo (fc_JpegFile, 'c:\mypath\myfile.jpg');
end;

procedure TForm1.Edit5Change(Sender: TObject);
begin
   VideoGrabber1.VCompKeyFrameRate := StrToIntDef (Edit5.Text, -1);
end;

procedure TForm1.Edit7Change(Sender: TObject);
begin
   VideoGrabber1.VCompQuality := StrToIntDef (Edit7.Text, -1);
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
   VideoGrabber1.DVCaptureMode := TDVCaptureMode (RadioGroup2.ItemIndex);
   EnableDisableOptions;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
   VideoGrabber1.DVReduceFrameRate := CheckBox1.Checked;
end;

procedure TForm1.Edit6Change(Sender: TObject);
begin
   VideoGrabber1.BurstCount := StrToIntDef (Edit6.Text, 1);
end;

procedure TForm1.Edit9Change(Sender: TObject);
begin
   VideoGrabber1.BurstInterval := StrToIntDef (Edit9.Text, 1);
end;

procedure TForm1.CheckBox9Click(Sender: TObject);
begin
   VideoGrabber1.BurstMode := CheckBox9.Checked;
end;

procedure TForm1.RadioGroup5Click(Sender: TObject);
begin
   VideoGrabber1.DVPreviewResolution := TDVResolution (RadioGroup5.ItemIndex);
end;

procedure TForm1.RadioGroup6Click(Sender: TObject);
begin
   VideoGrabber1.DVCaptureResolution := TDVResolution (RadioGroup6.ItemIndex);
end;

procedure TForm1.Button11Click(Sender: TObject);
begin
   VideoGrabber1.ShowDialog (dlg_Audio);
end;

procedure TForm1.ComboBox5Change(Sender: TObject);
begin
   VideoGrabber1.AudioCompressor := ComboBox5.ItemIndex;
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
   VideoGrabber1.CompressionType := TCompressionType (RadioGroup1.ItemIndex);
end;

procedure TForm1.VideoGrabber1CaptureReadyToStart(Sender: TObject;
  var OkToStart: Boolean);
begin
   if MessageDlg ('Ready to start capture!', mtInformation, [MbOk, MbCancel], 0) = MrOk then begin
      OkToStart := true;
   end
   else begin
      OkToStart := false;
   end;
end;

procedure TForm1.VideoGrabber1CaptureStarted(Sender: TObject);
begin
   Memo1.Lines.Add ('capture running...');
end;

procedure TForm1.VideoGrabber1ComponentLoaded(Sender: TObject);
begin
   Memo1.lines.Add ('component loaded and ready.');
end;

procedure TForm1.VideoGrabber1DeviceLost(Sender: TObject);
begin
   Memo1.Lines.Add ('DEVICE LOST!');
   AssignListToComboBox (ComboBox2, VideoGrabber1.VideoDevices, VideoGrabber1.VideoDevice);
   AssignListToComboBox (ComboBox3, VideoGrabber1.AudioDevices, VideoGrabber1.AudioDevice);
end;

procedure TForm1.VideoGrabber1DiskFull(Sender: TObject);
begin
   Memo1.Lines.Add ('DISK FULL!');
end;

procedure TForm1.VideoGrabber1RecompressCompleted(Sender: TObject;
  Success: Boolean);
begin
   if Success then begin
      Memo1.Lines.Add ('recompression successful.');
   end
   else begin
      Memo1.Lines.Add ('recompression failed.');
   end;
end;

procedure TForm1.VideoGrabber1RecompressStarted(Sender: TObject);
begin
   Memo1.lines.Add ('recompressing...');
end;

procedure TForm1.VideoGrabber1PreviewStarted(Sender: TObject);
begin
   Memo1.lines.Add ('preview restarted');
end;

procedure TForm1.VideoGrabber1CopyPreallocDataCompleted(Sender: TObject;
  Success: Boolean);
begin
   if Success then begin
      Memo1.Lines.Add ('preallocated file copy successful.');
   end
   else begin
      Memo1.Lines.Add ('preallocated file copy failed.');
   end;
end;

procedure TForm1.VideoGrabber1CopyPreallocDataStarted(Sender: TObject);
begin
   Memo1.Lines.Add ('copying data from preallocated file...');
end;

procedure TForm1.VideoGrabber1CreatePreallocFileStarted(Sender: TObject);
begin
   Memo1.Lines.Add ('creating prealloc file...');
end;

procedure TForm1.VideoGrabber1CreatePreallocFileCompleted(Sender: TObject;
  Success: Boolean);
begin
   if Success then begin
      Memo1.Lines.Add ('preallocated file successfully created.');
   end
   else begin
      Memo1.Lines.Add ('creation of preallocated file failed.');
   end;
end;

procedure TForm1.VideoGrabber1ChangeVideoDevice(Sender: TObject);
begin
   EnableDisableOptions;
   ComboBox2.ItemIndex := VideoGrabber1.VideoDevice; // to be sure the index matchs the current video device
   AssignListToComboBox (ComboBox1, VideoGrabber1.VideoSizes, 0);
   AssignListToComboBox (ComboBox7, VideoGrabber1.VideoSubTypes, 0);
end;

procedure TForm1.UpDown1Click(Sender: TObject; Button: TUDBtnType);
var
   Rate: Double;
begin
   Rate := UpDown1.Position / 1000;
   Edit8.Text := FloatToStr (Rate);
   VideoGrabber1.PlayerRate := Rate;
end;

procedure TForm1.RadioGroup7Click(Sender: TObject);
begin
   VideoGrabber1.AutoFileName := TAutoFileName (RadioGroup7.ItemIndex);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   OpenDialog1.FileName := '*.mpg;*.mpeg;*.avi;*.wav;*.mp3;*.asf;*.wmv';
   if OpenDialog1.Execute then begin
      VideoGrabber1.PlayerFileName := OpenDialog1.FileName;
      VideoGrabber1.OpenPlayer;
      Memo1.Lines.Add ('Duration: ' + FormatFloat ('0.00', VideoGrabber1.PlayerClipDuration));
      Memo1.Lines.Add ('Frame Rate: ' + FormatFloat ('0.00', VideoGrabber1.PlayerClipFrameRate));
   end;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
   if TrackBar1.Tag = 0 then begin
      VideoGrabber1.SetPlayerPosition (VideoGrabber1.PlayerClipDuration * TrackBar1.Position / (TrackBar1.Max - 2));
   end;
end;

procedure TForm1.VideoGrabber1PlayerProgress(SampleTime: Double);
begin
   Edit4.Text := FormatFloat ('0.00', SampleTime) + ' / ' + FormatFloat ('0.00', VideoGrabber1.PlayerClipDuration);
   TrackBar1.Tag := 1;
   TrackBar1.Position := Trunc (SampleTime / VideoGrabber1.PlayerClipDuration * (TrackBar1.Max));
   TrackBar1.Tag := 0;
end;

procedure TForm1.VideoGrabber1CaptureProgress(SampleTime: Double;
  DeliveredFrames, DroppedFrames: Integer);
begin
   Edit4.Text := IntToStr (DeliveredFrames) + ' frames delivered, ' + IntToStr (DroppedFrames) + ' dropped, t=' + FormatFloat ('0.00', SampleTime);
end;

procedure TForm1.VideoGrabber1CaptureCompleted(Sender: TObject;
  FileName: String; Success: Boolean);
begin
   if Success then begin
      Memo1.Lines.Add (FileName + ' successfully created.');
   end
   else begin
      Memo1.Lines.Add ('capture failed.');
   end;
end;

procedure TForm1.VideoGrabber1FrameCaptureCompleted(Sender: TObject;
  MemoryBitmap: TBitmap; DestType: TFrameCaptureDest; FileName: String;
  Success: Boolean);
var
   DestForm: TForm;
   DestImage: TImage;
begin
   Case DestType of
      // ------ bmp or jpeg file
      fc_BmpFile, fc_JpegFile: begin
         if Success then begin
             Memo1.Lines.Add (FileName + ' successfully created.');
          end
          else begin
             Memo1.Lines.Add ('Unable to write ' + FileName);
          end;
       end;

      // ------ memory bitmap
      fc_TBitmap: begin
         if (not VideoGrabber1.BurstMode) or (VideoGrabber1.BurstMode and (VideoGrabber1.BurstCount = 0)) then begin // reuse the same form
            if not assigned (SnapForm) then begin
               Application.CreateForm (TForm, SnapForm);
               SnapForm.Position := poDefault;
               SnapForm.Formstyle := fsStayOnTop;
            end;
            if assigned (SnapImage) then SnapImage.Free;
            SnapImage := TImage.Create (nil);
            DestForm := SnapForm;
            DestImage := SnapImage;
         end
         else begin // create a form for each image
            Application.CreateForm (TForm, DestForm);
            DestForm.Position := poDefault;
            DestForm.Formstyle := fsStayOnTop;
            DestImage := TImage.Create (DestForm);
            DestImage.Parent := DestForm;
         end;

         DestForm.ClientWidth := MemoryBitmap.Width;
         DestForm.ClientHeight := MemoryBitmap.Height;
         DestImage.AutoSize := true;
         DestImage.Picture.Bitmap.Width := MemoryBitmap.Width;
         DestImage.Picture.Bitmap.Height := MemoryBitmap.Height;
         DestImage.Picture.Bitmap.Canvas.StretchDraw (Rect (0, 0, MemoryBitmap.Width, MemoryBitmap.Height), MemoryBitmap);
         DestImage.Parent := DestForm;

         if not DestForm.Visible then begin
            DestForm.Show;
            Show;
         end;
      end;
    end;
end;

procedure TForm1.VideoGrabber1DirectX8Required(Sender: TObject);
begin
   ShowMessage ('DirectX 8 required!');
end;

procedure TForm1.SendDvCommand (Sender: TObject);
begin
   if VideoGrabber1.SendDvCommand (TDvCommand (TMenuItem (Sender).Tag)) then begin
      Memo1.Lines.Add ('DV Command successful.');
   end
   else begin
      Memo1.Lines.Add ('DV Command failed.');
   end;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.CheckBox10Click(Sender: TObject);
begin
   if CheckBox10.Checked then begin
      CheckBox10.Tag := VideoGrabber1.BurstCount; // keeps the previous value
      Edit6.Text := '0'; // to grab non-stop set BurstCount = 0 and BurstMode = true
      CheckBox9.Checked := True;
   end
   else begin
      CheckBox9.Checked := False;
      Edit6.Text := IntToStr (CheckBox10.Tag); // restores the previous value
   end;
end;

procedure TForm1.Button12Click(Sender: TObject);
var
   Value: Double;
begin
   Value := StrToFloatDef (Edit1.Text, -1);
   if Value <> -1 then begin
      VideoGrabber1.FrameRate := Value;
   end
   else begin
      Showmessage ('invalid value');
   end;
end;

procedure TForm1.Button13Click(Sender: TObject);
begin
   VideoGrabber1.FullScreenMode;
end;

procedure TForm1.VideoGrabber1NewDeviceList(Sender: TObject);
begin
   AssignListToComboBox (ComboBox2, VideoGrabber1.VideoDevices, VideoGrabber1.VideoDevice);
   AssignListToComboBox (ComboBox3, VideoGrabber1.AudioDevices, VideoGrabber1.AudioDevice);
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
   VideoGrabber1.ClosePlayer;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
   VideoGrabber1.PausePlayer;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
   VideoGrabber1.RunPlayer;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
   VideoGrabber1.FastReversePlayer (10);
end;

procedure TForm1.SpeedButton6Click(Sender: TObject);
begin
   VideoGrabber1.FastForwardPlayer (10);
end;

procedure TForm1.SpeedButton7Click(Sender: TObject);
begin
   if VideoGrabber1.LastCaptureFileName <> '' then begin
      VideoGrabber1.PlayerFileName := VideoGrabber1.LastCaptureFileName;
      VideoGrabber1.OpenPlayer;
      Memo1.Lines.Add ('Duration: ' + FormatFloat ('0.00', VideoGrabber1.PlayerClipDuration));
      Memo1.Lines.Add ('Frame Rate: ' + FormatFloat ('0.00', VideoGrabber1.PlayerClipFrameRate));
   end;
end;

procedure TForm1.VideoGrabber1PlayerStarted(Sender: TObject);
begin
   Memo1.Lines.Add ('playing ' + VideoGrabber1.PlayerFileName);
end;

procedure TForm1.VideoGrabber1ErrorLog(Sender: TObject; ErrorCode: Integer;
  ErrorMsg: String);
begin
   Memo1.Lines.Add ('[' + IntToStr (ErrorCode) + '] ' + ErrorMsg);
end;

procedure TForm1.AutoPlayClip1Click(Sender: TObject);
begin
   AutoPlayClip1.Checked := not AutoPlayClip1.Checked;
   VideoGrabber1.PlayerAutoStart := AutoPlayClip1.Checked;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
   VideoGrabber1.ShowDialog (dlg_Compressor);
end;

procedure TForm1.VideoGrabber1PlayerEndOfStream(Sender: TObject);
begin
   Memo1.Lines.Add ('end of stream.');
end;

procedure TForm1.VideoGrabber1PlayerFileNotFound(Sender: TObject;
  FileName: String);
begin
   Memo1.Lines.Add ('file not found: ' + FileName);
end;

procedure TForm1.Button14Click(Sender: TObject);
begin
   VideoGrabber1.ShowDialog (dlg_Crossbar);
end;

procedure TForm1.Button15Click(Sender: TObject);
begin
   VideoGrabber1.ShowDialog (dlg_TVTuner);
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
   VideoGrabber1.Visible := CheckBox2.Checked;
end;

procedure TForm1.CheckBox3Click(Sender: TObject);
begin
   VideoGrabber1.CaptureAudio := CheckBox3.Checked;
   EnableDisableOptions;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
   VideoGrabber1.StopPreview;
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
   VideoGrabber1.StartPreview;
end;

procedure TForm1.FrameGrabberEnabled1Click(Sender: TObject);
begin
   FrameGrabberEnabled1.Checked := not FrameGrabberEnabled1.Checked;
   VideoGrabber1.FrameGrabberEnabled := FrameGrabberEnabled1.Checked;
   EnableDisableOptions;
end;

procedure TForm1.FrameGrabberOnCaptureStream1Click(Sender: TObject);
begin
   FrameGrabberOnCaptureStream1.Checked := not FrameGrabberOnCaptureStream1.Checked;
   VideoGrabber1.FrameGrabberOnCaptureStream := FrameGrabberOnCaptureStream1.Checked;
end;

procedure TForm1.Button16Click(Sender: TObject);
begin
   VideoGrabber1.ClosePlayer;
end;

procedure TForm1.VideoGrabber1DeviceArrival(Sender: TObject);
begin
   Memo1.Lines.Add ('Device arrival.');
   AssignListToComboBox (ComboBox2, VideoGrabber1.VideoDevices, VideoGrabber1.VideoDevice);
   AssignListToComboBox (ComboBox3, VideoGrabber1.AudioDevices, VideoGrabber1.AudioDevice);
end;

procedure TForm1.VideoGrabber1DeviceRemoval(Sender: TObject);
begin
   Memo1.Lines.Add ('Device removal.');
   AssignListToComboBox (ComboBox2, VideoGrabber1.VideoDevices, VideoGrabber1.VideoDevice);
   AssignListToComboBox (ComboBox3, VideoGrabber1.AudioDevices, VideoGrabber1.AudioDevice);
end;

procedure TForm1.VideoGrabber1TimeCodeReader(Sender: TObject; TrackNum, hh,
  mm, ss, ff: Integer);
begin
   if ff = -1 then begin
      Edit10.Text := '                     - - : - - : - -   - -';
   end
   else begin
       Edit10.Text := Format ('                     %.2d:%.2d:%.2d %.2d', [hh, mm, ss, ff]);
   end;
end;

procedure TForm1.UpDown2Click(Sender: TObject; Button: TUDBtnType);
begin
   VideoGrabber1.TVTuner.put_Channel (UpDown2.Position, 0, 0);
end;

procedure TForm1.ComboBox7Change(Sender: TObject);
begin
   VideoGrabber1.VideoSubType := ComboBox7.ItemIndex;
end;

procedure TForm1.ComboBox8Change(Sender: TObject);
begin
   VideoGrabber1.AnalogVideoStandard := TAnalogVideoStandard (ComboBox8.ItemIndex);
end;

procedure TForm1.CheckBox4Click(Sender: TObject);
begin
   VideoGrabber1.AutoSize := CheckBox4.Checked;
end;

procedure TForm1.RefreshPreviewOnParamChange1Click(Sender: TObject);
begin
   RefreshPreviewOnParamChange1.Checked := not RefreshPreviewOnParamChange1.Checked;
   VideoGrabber1.RefreshPreviewOnParamChange := RefreshPreviewOnParamChange1.Checked;
end;

procedure TForm1.CheckBox5Click(Sender: TObject);
begin
   VideoGrabber1.RenderAudio := CheckBox5.Checked;
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
   VideoGrabber1.ShowDialog (dlg_Capture);

   ComboBox8.ItemIndex := integer (VideoGrabber1.AnalogVideoStandard);
   // now the AnalogVideoStandard matches the current setting, if modified in the dialog
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
   // WARNING: USUALLY, THIS DIALOG ALLOWS TO CHANGE ONLY 1 PARAMETER AT THE SAME TIME

   VideoGrabber1.ShowDialog (dlg_StreamConfig);

   Edit1.Text := FloatToStr (VideoGrabber1.FrameRate);
   ComboBox1.ItemIndex := VideoGrabber1.VideoSize;
   ComboBox7.ItemIndex := VideoGrabber1.VideoSubType;
   // now the frame rate, video size and video sub type match the current settings,
   // if any changed in the dialog
end;

end.
