//---------------------------------------------------------------------------

#include <vcl.h>
#include <math.h>
#pragma hdrstop

#include "Demo_.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "VidGrab"
#pragma resource "*.dfm"
TForm1 *Form1;
TForm *SnapForm = NULL;
TImage *SnapImage = NULL;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall AssignListToComboBox (TComboBox* ComboBox, AnsiString List, int Index)
{
   ComboBox->Items->Text = List;
   if (ComboBox->Items->Count > 0) {
      ComboBox->ItemIndex = Index;
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SendDVCommand(TObject *Sender)
{
   if (VideoGrabber1->SendDVCommand (TDVCommand (((TMenuItem*) Sender)->Tag))) {
      Memo1->Lines->Add ("DV command successful.");
   }
   else {
      Memo1->Lines->Add ("DV command failed.");
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EnableDisableOptions (void)
{
   CheckBox1->Enabled = VideoGrabber1->IsDigitalVideoIn;

   RadioGroup2->Enabled = VideoGrabber1->IsDigitalVideoIn;
   RadioGroup5->Enabled = VideoGrabber1->IsDigitalVideoIn;
   RadioGroup6->Enabled = VideoGrabber1->IsDigitalVideoIn;
   ComboBox1->Enabled = ! VideoGrabber1->IsDigitalVideoIn;

   Button5->Enabled = VideoGrabber1->FrameGrabberEnabled;
   Button6->Enabled = VideoGrabber1->FrameGrabberEnabled;
   Button7->Enabled = VideoGrabber1->FrameGrabberEnabled;
   Edit6->Enabled = VideoGrabber1->FrameGrabberEnabled;
   Edit9->Enabled = VideoGrabber1->FrameGrabberEnabled;
   CheckBox9->Enabled = VideoGrabber1->FrameGrabberEnabled;
   CheckBox10->Enabled = VideoGrabber1->FrameGrabberEnabled;

   ComboBox3->Enabled = VideoGrabber1->CaptureAudio;
   ComboBox4->Enabled = VideoGrabber1->CaptureAudio;
   Button11->Enabled = VideoGrabber1->CaptureAudio;

   ComboBox8->Enabled = VideoGrabber1->AnalogVideoStandardAvailable;

   RadioGroup3->Enabled = True;
   RadioGroup1->Enabled = True;
   if (VideoGrabber1->CaptureAudio) {
      RadioGroup1->ItemIndex = 0;
      RadioGroup1->Enabled = False;
   }
   if (VideoGrabber1->IsDigitalVideoIn) {
      if (VideoGrabber1->DVCaptureMode == dv_CaptureType1) {
         RadioGroup3->ItemIndex = 0;
         RadioGroup1->Enabled = False;
         RadioGroup3->Enabled = False;
         RadioGroup6->Enabled = False;
      }
   }
   Button14->Enabled = VideoGrabber1->IsDialogAvailable (dlg_Crossbar);
   Button15->Enabled = VideoGrabber1->IsDialogAvailable (dlg_TVTuner);
   UpDown2->Enabled = Button15->Enabled;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
   CheckBox1->Checked = VideoGrabber1->DVReduceFrameRate;
   CheckBox2->Checked = VideoGrabber1->Visible;
   CheckBox3->Checked = VideoGrabber1->CaptureAudio;
   CheckBox4->Checked = VideoGrabber1->AutoSize;
   CheckBox5->Checked = VideoGrabber1->RenderAudio;
   CheckBox7->Checked = VideoGrabber1->PreallocCapFileEnabled;
   CheckBox8->Checked = VideoGrabber1->PreallocCapRecreate;
   CheckBox9->Checked = VideoGrabber1->BurstMode;

   RadioGroup1->ItemIndex = int (VideoGrabber1->CompressionType);
   RadioGroup2->ItemIndex = int (VideoGrabber1->DVCaptureMode);
   RadioGroup3->ItemIndex = int (VideoGrabber1->CompressionMode);
   RadioGroup5->ItemIndex = int (VideoGrabber1->DVPreviewResolution);
   RadioGroup6->ItemIndex = int (VideoGrabber1->DVCaptureResolution);
   RadioGroup7->ItemIndex = int (VideoGrabber1->AutoFileName);

   Edit1->Text = FloatToStr (VideoGrabber1->FrameRate);
   Edit2->Text = VideoGrabber1->StoragePath;
   Edit3->Text = IntToStr (VideoGrabber1->PreallocCapFileSizeInMB);
   Edit6->Text = IntToStr (VideoGrabber1->BurstCount);
   Edit8->Text = FloatToStr (VideoGrabber1->PlayerRate);
   Edit9->Text = IntToStr (VideoGrabber1->BurstInterval);

   UpDown1->Position = floorl (VideoGrabber1->PlayerRate * 1000);

   AssignListToComboBox (ComboBox2, VideoGrabber1->VideoDevices, 0);
   AssignListToComboBox (ComboBox3, VideoGrabber1->AudioDevices, 0);
   AssignListToComboBox (ComboBox4, VideoGrabber1->AudioFormats, 0);
   AssignListToComboBox (ComboBox5, VideoGrabber1->AudioCompressors, VideoGrabber1->AudioCompressor);
   AssignListToComboBox (ComboBox6, VideoGrabber1->VideoCompressors, VideoGrabber1->VideoCompressor);
   AssignListToComboBox (ComboBox8, VideoGrabber1->AnalogVideoStandards, VideoGrabber1->AnalogVideoStandard);

   RefreshPreviewOnParamChange1->Checked = VideoGrabber1->RefreshPreviewOnParamChange;
   AutoPlayClip1->Checked = VideoGrabber1->PlayerAutoStart;

   FrameGrabberEnabled1->Checked = VideoGrabber1->FrameGrabberEnabled;
   FrameGrabberOnCaptureStream1->Checked = VideoGrabber1->FrameGrabberOnCaptureStream;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::Exit1Click(TObject *Sender)
{
   Close();
}

//---------------------------------------------------------------------------


void __fastcall TForm1::Button5Click(TObject *Sender)
{
   VideoGrabber1->CaptureFrameTo (fc_TBitmap, "");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{
   VideoGrabber1->CaptureFrameTo (fc_BmpFile, "");
   // a file name will be created automatically, but you can force a file name
   // e->g->: VideoGrabber1->CaptureFrameTo (fc_BmpFile, 'c:\mypath\myfile->bmp');
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button7Click(TObject *Sender)
{
   VideoGrabber1->CaptureFrameTo (fc_JpegFile, "");
   // a file name will be created automatically, but you can force a file name
   // e->g->: VideoGrabber1->CaptureFrameTo (fc_JpegFile, 'c:\mypath\myfile->jpg');
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit6Change(TObject *Sender)
{
   VideoGrabber1->BurstCount = StrToIntDef (Edit6->Text, 1);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit9Change(TObject *Sender)
{
   VideoGrabber1->BurstInterval = StrToIntDef (Edit9->Text, 1);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox9Click(TObject *Sender)
{
   VideoGrabber1->BurstMode = CheckBox9->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox10Click(TObject *Sender)
{
   if (CheckBox10->Checked) {
      CheckBox10->Tag = VideoGrabber1->BurstCount; // keeps the previous value
      Edit6->Text = '0'; // to grab non-stop set BurstCount = 0 and BurstMode = true
      CheckBox9->Checked = True;
   }
   else {
      CheckBox9->Checked = False;
      Edit6->Text = IntToStr (CheckBox10->Tag); // restores the previous value
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
   VideoGrabber1->StartCapture();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button2Click(TObject *Sender)
{
   VideoGrabber1->StopCapture();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RadioGroup7Click(TObject *Sender)
{
   VideoGrabber1->AutoFileName = TAutoFileName (RadioGroup7->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RadioGroup3Click(TObject *Sender)
{
   VideoGrabber1->CompressionMode = TCompressionMode (RadioGroup3->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RadioGroup1Click(TObject *Sender)
{
   VideoGrabber1->CompressionType = TCompressionType (RadioGroup1->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox6Change(TObject *Sender)
{
   VideoGrabber1->VideoCompressor = ComboBox6->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{
   VideoGrabber1->ShowDialog(dlg_Compressor);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit5Change(TObject *Sender)
{
   VideoGrabber1->VCompKeyFrameRate = StrToIntDef (Edit5->Text, -1);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit7Change(TObject *Sender)
{
   VideoGrabber1->VCompQuality = StrToIntDef (Edit7->Text, -1);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox5Change(TObject *Sender)
{
   VideoGrabber1->AudioCompressor = ComboBox5->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit2Change(TObject *Sender)
{
   VideoGrabber1->StoragePath = Edit2->Text;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Edit3Change(TObject *Sender)
{
   VideoGrabber1->PreallocCapFileSizeInMB = StrToIntDef (Edit3->Text, 100);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox7Click(TObject *Sender)
{
   VideoGrabber1->PreallocCapFileEnabled = CheckBox7->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox8Click(TObject *Sender)
{
   VideoGrabber1->PreallocCapRecreate = CheckBox8->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox3Change(TObject *Sender)
{
   VideoGrabber1->AudioDevice = ComboBox3->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button11Click(TObject *Sender)
{
   VideoGrabber1->ShowDialog(dlg_Audio);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox4Change(TObject *Sender)
{
   VideoGrabber1->AudioFormat = TAudioFormat (ComboBox4->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox2Change(TObject *Sender)
{
   VideoGrabber1->VideoDevice = ComboBox2->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button12Click(TObject *Sender)
{
   Double Value;

   Value = StrToFloatDef (Edit1->Text, -1);
   if (Value != -1) {
      VideoGrabber1->FrameRate = Value;
   }
   else {
      ShowMessage ("invalid value");
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox1Change(TObject *Sender)
{
   VideoGrabber1->VideoSize = ComboBox1->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button13Click(TObject *Sender)
{
   VideoGrabber1->FullScreenMode();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RadioGroup2Click(TObject *Sender)
{
   VideoGrabber1->DVCaptureMode = TDVCaptureMode (RadioGroup2->ItemIndex);
   EnableDisableOptions();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RadioGroup5Click(TObject *Sender)
{
   VideoGrabber1->DVPreviewResolution = TDVResolution (RadioGroup5->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RadioGroup6Click(TObject *Sender)
{
   VideoGrabber1->DVCaptureResolution = TDVResolution (RadioGroup6->ItemIndex);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
   VideoGrabber1->DVReduceFrameRate = CheckBox1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton7Click(TObject *Sender)
{
   if (VideoGrabber1->LastCaptureFileName != "") {
      VideoGrabber1->PlayerFileName = VideoGrabber1->LastCaptureFileName;
      VideoGrabber1->OpenPlayer();
      Memo1->Lines->Add ("Duration: " + FormatFloat ("0->00", VideoGrabber1->PlayerClipDuration));
      Memo1->Lines->Add ("Frame Rate: " + FormatFloat ("0->00", VideoGrabber1->PlayerClipFrameRate));
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
   OpenDialog1->FileName = "*->mpg;*->mpeg;*->avi;*->wav;*->mp3;*->asf;*->wmv";
   if (OpenDialog1->Execute()) {
      VideoGrabber1->PlayerFileName = OpenDialog1->FileName;
      VideoGrabber1->OpenPlayer();
      Memo1->Lines->Add ("Duration: " + FormatFloat ("0->00", VideoGrabber1->PlayerClipDuration));
      Memo1->Lines->Add ("Frame Rate: " + FormatFloat ("0->00", VideoGrabber1->PlayerClipFrameRate));
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton4Click(TObject *Sender)
{
   VideoGrabber1->RunPlayer();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton2Click(TObject *Sender)
{
   VideoGrabber1->PausePlayer();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton3Click(TObject *Sender)
{
   VideoGrabber1->ClosePlayer();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton5Click(TObject *Sender)
{
   VideoGrabber1->FastReversePlayer (10);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SpeedButton6Click(TObject *Sender)
{
   VideoGrabber1->FastForwardPlayer (10);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UpDown1Click(TObject *Sender, TUDBtnType Button)
{
   VideoGrabber1->PlayerRate = Extended (UpDown1->Position) / 1000;
   Edit8->Text = FormatFloat("0->0", VideoGrabber1->PlayerRate);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrackBar1Change(TObject *Sender)
{
   if (TrackBar1->Tag == 0) {
      VideoGrabber1->SetPlayerPosition (VideoGrabber1->PlayerClipDuration * TrackBar1->Position / (TrackBar1->Max - 2));
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1CaptureCompleted(TObject *Sender,
      AnsiString FileName, bool Success)
{
   if (Success) {
      Memo1->Lines->Add ("capture successful.");
   }
   else {
      Memo1->Lines->Add ("capture failed.");
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1CaptureProgress(double SampleTime,
      int DeliveredFrames, int DroppedFrames)
{
   Edit4->Text = IntToStr (DeliveredFrames) + " frames delivered, " + IntToStr (DroppedFrames) + " dropped, t=" + FormatFloat ("0->00", SampleTime);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1CaptureReadyToStart(TObject *Sender,
      bool &OkToStart)
{
   if (MessageDlg ("Ready to start capture!", mtInformation, TMsgDlgButtons() << mbOK << mbCancel, 0) == mrOk ) {
      OkToStart = true;
   }
   else {
      OkToStart = false;
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1CaptureStarted(TObject *Sender)
{
   Memo1->Lines->Add ("capture running.");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1ChangeVideoDevice(TObject *Sender)
{
   EnableDisableOptions();
   ComboBox2->ItemIndex = VideoGrabber1->VideoDevice; // to be sure the index correspond to the current video device
   AssignListToComboBox (ComboBox1, VideoGrabber1->VideoSizes, 0);
   AssignListToComboBox (ComboBox7, VideoGrabber1->VideoSubTypes, 0);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1ComponentLoaded(TObject *Sender)
{
   Memo1->Lines->Add ("component loaded and ready.");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1CopyPreallocDataCompleted(
      TObject *Sender, bool Success)
{
   if (Success) {
      Memo1->Lines->Add ("preallocated file copy successful.");
   }
   else {
      Memo1->Lines->Add ("preallocated file copy failed.");
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1CopyPreallocDataStarted(
      TObject *Sender)
{
   Memo1->Lines->Add ("copying data from preallocated file...");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1CreatePreallocFileCompleted(
      TObject *Sender, bool Success)
{
   if (Success) {
      Memo1->Lines->Add ("preallocated file successfully created.");
   }
   else {
      Memo1->Lines->Add ("creation of preallocated file failed.");
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1CreatePreallocFileStarted(
      TObject *Sender)
{
   Memo1->Lines->Add ("creating prealloc file...");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1DeviceLost(TObject *Sender)
{
   Memo1->Lines->Add ("DEVICE LOST!");
   AssignListToComboBox (ComboBox2, VideoGrabber1->VideoDevices, VideoGrabber1->VideoDevice);
   AssignListToComboBox (ComboBox3, VideoGrabber1->AudioDevices, VideoGrabber1->AudioDevice);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1DirectX8Required(TObject *Sender)
{
   ShowMessage ("DirectX 8 required!");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1DiskFull(TObject *Sender)
{
   Memo1->Lines->Add ("DISK FULL!");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1ErrorLog(TObject *Sender,
      int ErrorCode, AnsiString ErrorMsg)
{
   Memo1->Lines->Add ("[" + IntToStr (ErrorCode) + "] " + ErrorMsg);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1NewDeviceList(TObject *Sender)
{
   AssignListToComboBox (ComboBox2, VideoGrabber1->VideoDevices, VideoGrabber1->VideoDevice);
   AssignListToComboBox (ComboBox3, VideoGrabber1->AudioDevices, VideoGrabber1->AudioDevice);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1PlayerEndOfStream(TObject *Sender)
{
   Memo1->Lines->Add ("end of stream.");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1PlayerFileNotFound(TObject *Sender,
      AnsiString FileName)
{
   Memo1->Lines->Add ("file not found: " + FileName);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1PlayerProgress(double SampleTime)
{
   Edit4->Text = FormatFloat ("0->00", SampleTime) + " / " + FormatFloat ("0->00", VideoGrabber1->PlayerClipDuration);
   TrackBar1->Tag = 1;
   TrackBar1->Position = floorl (SampleTime / VideoGrabber1->PlayerClipDuration * (TrackBar1->Max));
   TrackBar1->Tag = 0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1PlayerStarted(TObject *Sender)
{
   Memo1->Lines->Add ("playing " + VideoGrabber1->PlayerFileName);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1PreviewStarted(TObject *Sender)
{
   Memo1->Lines->Add ("preview restarted");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1RecompressCompleted(TObject *Sender,
      bool Success)
{
   if (Success) {
      Memo1->Lines->Add ("recompression successful.");
   }
   else {
      Memo1->Lines->Add ("recompression failed.");
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1RecompressStarted(TObject *Sender)
{
   Memo1->Lines->Add ("recompressing...");
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1FrameCaptureCompleted(TObject *Sender,
      Pointer MemoryBitmap, TFrameCaptureDest DestType,
      AnsiString FileName, bool Success)
{
   TForm *DestForm;
   TImage *DestImage;
   Graphics::TBitmap *Captured_Bitmap; // redeclaration caused by the ambiguity between windows::Bitmap and Graphics::Bitmap

   (void*) Captured_Bitmap = MemoryBitmap;

   // ------ bmp or jpeg file
   if ((DestType == fc_BmpFile) || (DestType == fc_JpegFile)) {
      if (Success) {
          Memo1->Lines->Add (FileName + " successfully created.");
       }
       else {
          Memo1->Lines->Add ("Unable to write " + FileName);
       }
   }
   // ------ memory bitmap
   else if (DestType == fc_TBitmap) {
      if ((! VideoGrabber1->BurstMode) || (VideoGrabber1->BurstMode && (VideoGrabber1->BurstCount == 0)) ) { // reuse the same form
         if (SnapForm == NULL) {
            Application->CreateForm (__classid (TForm), &SnapForm);
            SnapForm->Position = poDefault;
            SnapForm->FormStyle = fsStayOnTop;
         }
         if (SnapImage != NULL) {
            SnapImage->Free();
         }
         SnapImage = new TImage (NULL);
         DestForm = SnapForm;
         DestImage = SnapImage;
      }
      else { // create a form for each image
         Application->CreateForm (__classid (TForm), &DestForm);
         DestForm->Position = poDefault;
         DestForm->FormStyle = fsStayOnTop;
         DestImage = new TImage (DestForm);
         DestImage->Parent = DestForm;
      }
      DestForm->ClientWidth = Captured_Bitmap->Width;
      DestForm->ClientHeight = Captured_Bitmap->Height;
      DestImage->AutoSize = true;
      DestImage->Picture->Bitmap->Width = Captured_Bitmap->Width;
      DestImage->Picture->Bitmap->Height = Captured_Bitmap->Height;
      DestImage->Picture->Bitmap->Canvas->StretchDraw (Rect (0, 0, Captured_Bitmap->Width, Captured_Bitmap->Height), Captured_Bitmap);
      DestImage->Parent = DestForm;
      if (! DestForm->Visible ) {
         DestForm->Show();
         Show();
      }
   }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button15Click(TObject *Sender)
{
   VideoGrabber1->ShowDialog (dlg_TVTuner);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button14Click(TObject *Sender)
{
   VideoGrabber1->ShowDialog (dlg_Crossbar);
}
//---------------------------------------------------------------------------




void __fastcall TForm1::AutoPlayClip1Click(TObject *Sender)
{
   AutoPlayClip1->Checked = ! AutoPlayClip1->Checked;
   VideoGrabber1->PlayerAutoStart = AutoPlayClip1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox3Click(TObject *Sender)
{
   VideoGrabber1->CaptureAudio = CheckBox3->Checked;
   EnableDisableOptions();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox2Click(TObject *Sender)
{
   VideoGrabber1->Visible = CheckBox2->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button8Click(TObject *Sender)
{
   VideoGrabber1->StopPreview();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button9Click(TObject *Sender)
{
   VideoGrabber1->StartPreview();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FrameGrabberEnabled1Click(TObject *Sender)
{
   FrameGrabberEnabled1->Checked = ! FrameGrabberEnabled1->Checked;
   VideoGrabber1->FrameGrabberEnabled = FrameGrabberEnabled1->Checked;
   EnableDisableOptions();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FrameGrabberOnCaptureStream1Click(TObject *Sender)
{
   FrameGrabberOnCaptureStream1->Checked = ! FrameGrabberOnCaptureStream1->Checked;
   VideoGrabber1->FrameGrabberOnCaptureStream = FrameGrabberOnCaptureStream1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button16Click(TObject *Sender)
{
   VideoGrabber1->ClosePlayer();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1DeviceArrival(TObject *Sender)
{
   Memo1->Lines->Add ("Device arrival.");
   AssignListToComboBox (ComboBox2, VideoGrabber1->VideoDevices, VideoGrabber1->VideoDevice);
   AssignListToComboBox (ComboBox3, VideoGrabber1->AudioDevices, VideoGrabber1->AudioDevice);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::VideoGrabber1DeviceRemoval(TObject *Sender)
{
   Memo1->Lines->Add ("Device removal.");
   AssignListToComboBox (ComboBox2, VideoGrabber1->VideoDevices, VideoGrabber1->VideoDevice);
   AssignListToComboBox (ComboBox3, VideoGrabber1->AudioDevices, VideoGrabber1->AudioDevice);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::VideoGrabber1TimeCodeReader(TObject *Sender,
      int TrackNum, int hh, int mm, int ss, int ff)
{
   AnsiString str;

   if (ff == -1) {
      Edit10->Text = "                     - - : - - : - -   - -";
   }
   else {
       TVarRec v[] = {hh, mm, ss, ff};
       Edit10->Text = Format ("                     %.2d:%.2d:%.2d %.2d", v, (ARRAYSIZE(v) - 1));
   }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::UpDown2Click(TObject *Sender, TUDBtnType Button)
{
   VideoGrabber1->TVTuner->put_Channel (UpDown2->Position, 0, 0);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox4Click(TObject *Sender)
{
   VideoGrabber1->AutoSize = CheckBox4->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox7Change(TObject *Sender)
{
   VideoGrabber1->VideoSubType = ComboBox7->ItemIndex;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBox8Change(TObject *Sender)
{
   VideoGrabber1->AnalogVideoStandard = TAnalogVideoStandard (ComboBox8->ItemIndex);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::RefreshPreviewOnParamChange1Click(TObject *Sender)
{
   RefreshPreviewOnParamChange1->Checked = ! RefreshPreviewOnParamChange1->Checked;
   VideoGrabber1->RefreshPreviewOnParamChange = RefreshPreviewOnParamChange1->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::CheckBox5Click(TObject *Sender)
{
   VideoGrabber1->RenderAudio = CheckBox5->Checked;        
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{
   // WARNING: USUALLY, THIS DIALOG ALLOWS TO CHANGE ONLY 1 PARAMETER AT THE SAME TIME

   VideoGrabber1->ShowDialog (dlg_StreamConfig);

   Edit1->Text = FloatToStr (VideoGrabber1->FrameRate);
   ComboBox1->ItemIndex = VideoGrabber1->VideoSize;
   ComboBox7->ItemIndex = VideoGrabber1->VideoSubType;
   // now the frame rate, video size and video sub type match the current settings,
   // if any changed in the dialog
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button10Click(TObject *Sender)
{
   VideoGrabber1->ShowDialog(dlg_Capture);

   ComboBox8->ItemIndex = int (VideoGrabber1->AnalogVideoStandard);
   // now the AnalogVideoStandard matches the current setting, if modified in the dialog
}
//---------------------------------------------------------------------------


