unit AllFram_;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, VidGrab, ComCtrls, Menus;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Button1: TButton;
    Button2: TButton;
    Edit1: TEdit;
    VideoGrabber1: TVideoGrabber;
    ComboBox1: TComboBox;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure VideoGrabber1FrameCaptureCompleted(Sender: TObject;
      MemoryBitmap: TBitmap; DestType: TFrameCaptureDest; FileName: String;
      Success: Boolean);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure VideoGrabber1DeviceArrival(Sender: TObject);
    procedure VideoGrabber1ChangeVideoDevice(Sender: TObject);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;
  FrameCount: integer = 0;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
   VideoGrabber1.BurstCount := 0;
   VideoGrabber1.BurstMode := True;
   VideoGrabber1.CaptureFrameTo (fc_TBitmap, '');
end;

procedure TForm1.VideoGrabber1FrameCaptureCompleted(Sender: TObject;
  MemoryBitmap: TBitmap; DestType: TFrameCaptureDest; FileName: String;
  Success: Boolean);
begin
   Image1.Width := MemoryBitmap.Width;
   Image1.Height := MemoryBitmap.Height;
   Image1.Picture.Assign (MemoryBitmap);
   inc (FrameCount);
   Edit1.Text := '  ' + inttostr (FrameCount);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
   VideoGrabber1.BurstMode := False;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   ComboBox1.Items.Text := VideoGrabber1.VideoDevices;
   ComboBox1.ItemIndex := VideoGrabber1.VideoDevice;
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
   VideoGrabber1.VideoDevice := ComboBox1.ItemIndex;
   VideoGrabber1.BurstCount := 0;
   VideoGrabber1.BurstMode := True;
   VideoGrabber1.CaptureFrameTo (fc_TBitmap, '');
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
   Close;
end;

procedure TForm1.VideoGrabber1DeviceArrival(Sender: TObject);
begin
   ComboBox1.Items.Text := VideoGrabber1.VideoDevices;
end;

procedure TForm1.VideoGrabber1ChangeVideoDevice(Sender: TObject);
begin
   ComboBox1.Items.Text := VideoGrabber1.VideoDevices;
   ComboBox1.ItemIndex := VideoGrabber1.VideoDevice;
end;

end.
