Unit UltimDBSort;

Interface

{$I OPTIONS.INC}

Uses
   Windows, Forms, StdCtrls, Classes, Controls, Buttons;

{$I LANG_STR.INC}

Type
   TFUltimDBSort = Class(TForm)
      LB_Fields: TListBox;
      SortField1: TEdit;
      SortField2: TEdit;
      SortField3: TEdit;
      SortField4: TEdit;
      SortField5: TEdit;
      Label1: TLabel;
      Label2: TLabel;
      Label3: TLabel;
      Label4: TLabel;
      Label5: TLabel;
      CB_Desc1: TCheckBox;
      CB_Desc2: TCheckBox;
      CB_Desc3: TCheckBox;
      CB_Desc4: TCheckBox;
      CB_Desc5: TCheckBox;
      B_Clear1: TBitBtn;
      B_Clear2: TBitBtn;
      B_Clear3: TBitBtn;
      B_Clear4: TBitBtn;
      B_Clear5: TBitBtn;
      B_OK: TBitBtn;
      B_Cancel: TBitBtn;
      Procedure SortFieldDragDrop(Sender, Source: TObject; X, Y: Integer);
      Procedure SortFieldDragOver(Sender, Source: TObject; X, Y: Integer; State: TDragState;
         Var Accept: Boolean);
      Procedure B_Clear1Click(Sender: TObject);
      Procedure B_Clear2Click(Sender: TObject);
      Procedure B_Clear3Click(Sender: TObject);
      Procedure B_Clear4Click(Sender: TObject);
      Procedure B_Clear5Click(Sender: TObject);
      Procedure B_OKClick(Sender: TObject);
   Private
      Procedure AcceptFieldName(Destination: TEdit);
   Public
      SortFields: Array[1..5] Of String;
      Descending: Array[1..5] Of Boolean;
      SortFieldCount: Byte;
      Procedure DisplayControls(Count: Byte);
      Procedure SetValues(Index: Byte; Text: String; Checked: Boolean);
   End;

Var
   FUltimDBSort: TFUltimDBSort;

Implementation

{$R *.DFM}

Procedure TFUltimDBSort.DisplayControls(Count: Byte);
Var
   I: Integer;
Begin
   For I := 0 To ComponentCount - 1 Do
   Begin
      If (Components[I] Is TControl) And (Components[I].Tag <= Count) Then
         TControl(Components[I]).Visible := True;
   End;
   If Count < 2 Then
      Label1.Visible := False;
End;

Procedure TFUltimDBSort.SetValues(Index: Byte; Text: String; Checked: Boolean);
Var
   I: Integer;
Begin
   For I := 0 To ComponentCount - 1 Do
      If Components[I].Tag = Index Then 
      Begin
         If Components[I] Is TEdit Then
            TEdit(Components[I]).Text := Text
         Else If Components[I] Is TCheckBox Then
            TCheckBox(Components[I]).Checked := Checked;
      End;
End;

Procedure TFUltimDBSort.AcceptFieldName(Destination: TEdit);
Var
   NewSortField: String;
Begin
   If LB_Fields.ItemIndex = -1 Then
      Exit;
   NewSortField := LB_Fields.Items[LB_Fields.ItemIndex];
   If ((Destination <> SortField1) And (NewSortField = SortField1.Text)) Or
      ((Destination <> SortField2) And (NewSortField = SortField2.Text)) Or
      ((Destination <> SortField3) And (NewSortField = SortField3.Text)) Or
      ((Destination <> SortField4) And (NewSortField = SortField4.Text)) Or
      ((Destination <> SortField5) And (NewSortField = SortField5.Text)) Then
      Application.MessageBox(lsIndexFound, lsError, MB_ICONWARNING)
   Else
      Destination.Text := NewSortField;
End;

Procedure TFUltimDBSort.SortFieldDragDrop(Sender, Source: TObject; X, Y: Integer);
Begin
   AcceptFieldName(TEdit(Sender));
End;

Procedure TFUltimDBSort.SortFieldDragOver(Sender, Source: TObject; X, Y: Integer;
   State: TDragState; Var Accept: Boolean);
Begin
   Accept := (TComponent(Source).Name = 'LB_Fields');
End;

Procedure TFUltimDBSort.B_Clear1Click(Sender: TObject);
Begin
   SortField1.Text := '';
   CB_Desc1.Checked := False;
End;

Procedure TFUltimDBSort.B_Clear2Click(Sender: TObject);
Begin
   SortField2.Text := '';
   CB_Desc2.Checked := False;
End;

Procedure TFUltimDBSort.B_Clear3Click(Sender: TObject);
Begin
   SortField3.Text := '';
   CB_Desc3.Checked := False;
End;

Procedure TFUltimDBSort.B_Clear4Click(Sender: TObject);
Begin
   SortField4.Text := '';
   CB_Desc4.Checked := False;
End;

Procedure TFUltimDBSort.B_Clear5Click(Sender: TObject);
Begin
   SortField5.Text := '';
   CB_Desc5.Checked := False;
End;

Procedure TFUltimDBSort.B_OKClick(Sender: TObject);
Begin
   SortFieldCount := 0;
   If SortField1.Text <> '' Then
      Inc(SortFieldCount);
   SortFields[1] := SortField1.Text;
   Descending[1] := CB_Desc1.Checked;
   If SortField2.Text <> '' Then
      Inc(SortFieldCount);
   SortFields[2] := SortField2.Text;
   Descending[2] := CB_Desc2.Checked;
   If SortField3.Text <> '' Then
      Inc(SortFieldCount);
   SortFields[3] := SortField3.Text;
   Descending[3] := CB_Desc3.Checked;
   If SortField4.Text <> '' Then
      Inc(SortFieldCount);
   SortFields[4] := SortField4.Text;
   Descending[4] := CB_Desc4.Checked;
   If SortField5.Text <> '' Then
      Inc(SortFieldCount);
   SortFields[5] := SortField5.Text;
   Descending[5] := CB_Desc5.Checked;
End;

End.