Unit UltimDBReport;

{
-----------------------------------------------------------------------------

                              UltimDBReport 1.1

                       (C) Frdric Leneuf-Magaud 2001

-----------------------------------------------------------------------------

 Please read ReadMe.txt for conditions of use

 This unit is provided 'as-is', without any express or implied warranty.
 In no event shall the author be held liable for any damages arising from the
 use of this unit.

 Veuillez lire le fichier LisezMoi.txt pour les conditions d'utilisation

 Cette unit est fournie en l'tat, sans aucune garantie.
 En aucun cas, l'auteur ne pourra tre tenu pour responsable des dommages
 rsultant de l'utilisation de cette unit.

-----------------------------------------------------------------------------

History of changes / Historique des modifications:

   1.1 : 07/03/2001
         - Added copyright notice
           Ajout des infos de copyright
         - Fixed bad font assignments
           Correction des mauvaises assignations de police

-----------------------------------------------------------------------------
}

Interface

{$I OPTIONS.INC}

Uses SysUtils, Classes, Graphics, Controls, Printers, QuickRpt, QRCtrls, DB, DBGrids;

Procedure PreviewReport(Grid: TDBGrid; RepTitle: String; DefaultHeaderBandHeight,
   DefaultDetailBandHeight: Integer);

Implementation

Procedure PreviewReport;
Const
   RowSpacing = 8;
Var
   Etat: TQuickRep;
   I, Largeur: Integer;
Begin
   If (Grid <> Nil) And (Grid.DataSource <> Nil) And (Grid.DataSource.DataSet <> Nil) Then
   Begin
      { Cration de l'tat }
      Etat := TQuickRep.Create(Grid);
      Try
         With Etat Do
         Begin
            Parent := TWinControl(Grid);
            Visible := False;
            DataSet := Grid.DataSource.DataSet;
            ReportTitle := Trim(RepTitle);
            Page.Orientation := poPortrait;
            Bands.HasTitle := (ReportTitle <> '');
            If Bands.HasTitle Then
               With TQRLabel(Bands.TitleBand.AddPrintable(TQRLabel)) Do
               Begin
                  Alignment := taCenter;
                  AlignToBand := True;
                  AutoSize := True;
                  Caption := ReportTitle;
                  Font.Assign(Grid.TitleFont); //1.1
                  Font.Color := clBlack;
                  Font.Size := Font.Size + 4;
                  Font.Style := Font.Style + [fsBold];
                  Bands.TitleBand.Height := Round(Height * 1.5);
               End;
            Bands.HasColumnHeader := True;
            Etat.Bands.ColumnHeaderBand.Height := DefaultHeaderBandHeight + RowSpacing;
            Bands.HasDetail := True;
            Etat.Bands.DetailBand.Height := DefaultDetailBandHeight + RowSpacing;
            Bands.HasPageFooter := True;
            With TQRExpr(Bands.PageFooterBand.AddPrintable(TQRExpr)) Do
            Begin
               Alignment := taRightJustify;
               AlignToBand := True;
               Expression := 'PageNumber';
               Font.Assign(Grid.Font); //1.1
               Font.Color := clBlack;
               Font.Style := [];
               Top := Round(Height / 2);
               Bands.PageFooterBand.Height := Round(Height * 1.5);
            End;
         End;
         { Cration des zones d'impression }
         For I := 0 To Grid.Columns.Count - 1 Do
         Begin
            If Grid.Columns[I].Visible Then
            Begin
               Largeur := Grid.Columns[I].Width;
               { Noms des champs }
               With TQRLabel(Etat.Bands.ColumnHeaderBand.AddPrintable(TQRLabel)) Do
               Begin
                  If (Left + Largeur) > Etat.Bands.ColumnHeaderBand.Width Then
                  Begin
                     If Etat.Page.Orientation = poPortrait Then
                     Begin
                        Etat.Page.Orientation := poLandscape;
                        If (Left + Largeur) > Etat.Bands.ColumnHeaderBand.Width Then
                           Break; // Manque de place! On sort
                     End
                     Else
                        Break; // Manque de place! On sort
                  End;
                  Alignment := Grid.Columns[I].Title.Alignment;
                  AutoSize := False;
                  Caption := Grid.Columns[I].Title.Caption;
                  Font.Assign(Grid.Columns[I].Title.Font); //1.1
                  Font.Color := clBlack;
                  Frame.DrawRight := True;
                  Frame.DrawBottom := True;
                  Height := Etat.Bands.ColumnHeaderBand.Height - RowSpacing;
                  Width := Largeur;
               End;
               If Grid.Columns[I].Field Is TBlobField Then
               Begin
                  If (Grid.Columns[I].Field.DataType = ftMemo) Or
                     (Grid.Columns[I].Field.DataType = ftFmtMemo) Then
                  Begin
                     { Champs mmos }
                     With TQRDBRichText(Etat.Bands.DetailBand.AddPrintable(TQRDBRichText)) Do
                     Begin
                        DataSet := Etat.DataSet;
                        DataField := Grid.Columns[I].FieldName;
                        Alignment := Grid.Columns[I].Alignment;
                        AutoStretch := True;
                        Font.Assign(Grid.Columns[I].Font); //1.1
                        Font.Color := clBlack;
                        Height := Etat.Bands.DetailBand.Height - RowSpacing;
                        Width := Largeur;
                     End;
                  End
                  Else If Grid.Columns[I].Field.DataType = ftGraphic Then
                  Begin
                     { Champs graphiques }
                     With TQRDBImage(Etat.Bands.DetailBand.AddPrintable(TQRDBImage)) Do
                     Begin
                        DataSet := Etat.DataSet;
                        DataField := Grid.Columns[I].FieldName;
                        Center := True;
                        Stretch := False;
                        Height := Etat.Bands.DetailBand.Height - RowSpacing;
                        Width := Largeur;
                     End;
                  End
                  Else
                     { Autres champs binaires }
                     With TQRLabel(Etat.Bands.DetailBand.AddPrintable(TQRLabel)) Do
                     Begin
                        Alignment := Grid.Columns[I].Alignment;
                        AutoSize := False;
                        Caption := '(BLOB)';
                        Font.Assign(Grid.Columns[I].Font); //1.1
                        Font.Color := clBlack;
                        Height := Etat.Bands.DetailBand.Height - RowSpacing;
                        Width := Largeur;
                     End;
               End
               Else
                  { Champs numriques ou textuels }
                  With TQRDBText(Etat.Bands.DetailBand.AddPrintable(TQRDBText)) Do
                  Begin
                     DataSet := Etat.DataSet;
                     DataField := Grid.Columns[I].FieldName;
                     Alignment := Grid.Columns[I].Alignment;
                     AutoSize := False;
                     Font.Assign(Grid.Columns[I].Font); //1.1
                     Font.Color := clBlack;
                     Height := Etat.Bands.DetailBand.Height - RowSpacing;
                     Width := Largeur;
                  End;
            End;
         End;
         { Prvisualisation }
         Etat.Preview;
      Finally
         Etat.Free;
      End;
   End;
End;

End.