Unit UltimDBGridProp;

Interface

{$I OPTIONS.INC}

Uses
   SysUtils, Classes, Controls, Forms, Dialogs, DsgnIntf, StdCtrls, Buttons, Graphics, FileUtil,
   UltimDBGrid;

{$I LANG_STR.INC}

Type 
   TUltimControlsEditor = Class(TPropertyEditor)
   Public
      Procedure Edit; Override;
      Function GetAttributes: TPropertyAttributes; Override;
      Function GetValue: String; Override;
   End;

   TfmGridProp = Class(TForm)
      GroupBoxFields: TGroupBox;
      lbFields: TListBox;
      GroupBoxSelected: TGroupBox;
      lbSelected: TListBox;
      sbAdd: TSpeedButton;
      sbDelete: TSpeedButton;
      LabelControl: TLabel;
      cbControl: TComboBox;
      btnOK: TButton;
      btnCancel: TButton;
      Procedure FormCreate(Sender: TObject);
      Procedure lbSelectedClick(Sender: TObject);
      Procedure cbControlClick(Sender: TObject);
      Procedure sbAddClick(Sender: TObject);
      Procedure sbDeleteClick(Sender: TObject);
      Procedure FormDestroy(Sender: TObject);
   Private
      Procedure SetControl(Name: String);
   Public
      UltimControls: TUltimControls;
      Grid: TUltimDBGrid;
      Procedure Initialize;
   End;

Type
   TFilenameProperty = Class(TStringProperty)
   Protected
      Function GetFilter: String; Virtual;
   Public
      Procedure Edit; Override;
      Function GetAttributes: TPropertyAttributes; Override;
   End;

Var
   fmGridProp: TfmGridProp;

Implementation

{$R *.DFM}

Procedure TUltimControlsEditor.Edit;
Var
   Dlg: TfmGridProp;
   CloseDataset: Boolean;
Begin
   CloseDataset := False;
   If TUltimDBGrid(GetComponent(0)).DataSource = Nil Then
      Raise Exception.Create(lsDataSourceNeeded);
   If TUltimDBGrid(GetComponent(0)).DataSource.DataSet = Nil Then
      Raise Exception.Create(lsDataSetNeeded);
   If Not TUltimDBGrid(GetComponent(0)).DataSource.DataSet.Active Then
   Begin
      TUltimDBGrid(GetComponent(0)).DataSource.DataSet.Open;
      CloseDataset := True;
   End;

   Dlg := TfmGridProp.Create(Application);
   Try
      Dlg.UltimControls.Assign(TUltimControls(GetOrdValue));
      Dlg.Grid := TUltimDBGrid(GetComponent(0));
      Dlg.Initialize;
      Dlg.Caption := lsFormCaption;
      Dlg.ShowModal;
      If Dlg.ModalResult = mrOk Then 
      Begin
         TUltimControls(GetOrdValue).Assign(Dlg.UltimControls);
         Modified;
      End;
   Finally
      Dlg.Free;
      If CloseDataset Then
      Begin
         TUltimDBGrid(GetComponent(0)).DataSource.DataSet.Close;
      End;
   End;
End;

Function TUltimControlsEditor.GetAttributes: TPropertyAttributes;
Begin
   Result := [paDialog, paReadOnly];
End;

Function TUltimControlsEditor.GetValue: String;
Begin
   Result := '(' + GetPropType^.Name +')';
End;

Procedure TfmGridProp.FormCreate(Sender: TObject);
Begin
   UltimControls := TUltimControls.Create(Nil);
   GroupBoxFields.Caption := lsCurrentFields;
   GroupBoxSelected.Caption := lsSelectedFields;
   LabelControl.Caption := lsLabelControl;
   btnCancel.Caption := lsBtnCancel;
End;

Procedure TfmGridProp.Initialize;
Var 
   i: Integer;
Begin
   For i := 0 To Grid.Columns.Count - 1 Do
      lbFields.Items.Add(Grid.Columns.Items[i].FieldName);
   For i := 0 To UltimControls.Count - 1 Do
      lbSelected.Items.Add(UltimControls.Items[i].FieldName);
   For i := 0 To Grid.Owner.ComponentCount - 1 Do
      If Grid.Owner.Components[i] Is TWinControl Then
         cbControl.Items.Add(Grid.Owner.Components[i].Name);
   lbSelectedClick(lbSelected);      
End;

Procedure TfmGridProp.SetControl(Name: String);
Var 
   i: Integer;
Begin
   For i := 0 To cbControl.Items.Count - 1 Do
      If CompareText(Name, cbControl.Items[i]) = 0 Then
      Begin
         cbControl.ItemIndex := i;
         Exit;
      End;
   cbControl.ItemIndex := -1;
End;

Procedure TfmGridProp.lbSelectedClick(Sender: TObject);
Begin
   If lbSelected.ItemIndex >= 0 Then
   Begin
      cbControl.Enabled := True; 
      cbControl.Color := clWindow;
      SetControl(UltimControls.Items[lbSelected.ItemIndex].ControlName);
   End
   Else
   Begin
      cbControl.Enabled := False;
      cbControl.Color := clBtnface;
   End;
End;

Procedure TfmGridProp.cbControlClick(Sender: TObject);
Begin
   If lbSelected.ItemIndex >= 0 Then
      UltimControls.Items[lbSelected.ItemIndex].ControlName := cbControl.Text;
End;

Procedure TfmGridProp.sbAddClick(Sender: TObject);
Begin
   If (lbFields.ItemIndex >= 0) Then
   Begin
      If (lbSelected.Items.Indexof(lbFields.Items[lbFields.ItemIndex]) < 0) Then
      Begin
         lbSelected.Items.Add(lbFields.Items[lbFields.ItemIndex]);
         With UltimControls.Add Do
            FieldName := lbFields.Items[lbFields.ItemIndex];
      End
      Else
         MessageDlg(Format(lsAlreadyAdded, [lbFields.Items[lbFields.ItemIndex]]),
            mtWarning, [mbOK], 0);
   End;
End;

Procedure TfmGridProp.sbDeleteClick(Sender: TObject);
Begin
   If lbSelected.ItemIndex >= 0 Then
   Begin
      UltimControls.Items[lbSelected.ItemIndex].Free;
      lbSelected.Items.Delete(lbSelected.ItemIndex);
   End;
End;

Procedure TfmGridProp.FormDestroy(Sender: TObject);
Begin
   UltimControls.Free;
End;

Function TFilenameProperty.GetFilter: String;
Begin
   Result := lsDefaultFilter;
End;

Procedure TFilenameProperty.Edit;
Var
   FileOpen: TOpenDialog;
Begin
   FileOpen := TOpenDialog.Create(Application);
   Try
      FileOpen.Filename := GetValue;
      FileOpen.InitialDir := ExtractFilePath(FileOpen.Filename);
      If (ExtractFileName(FileOpen.Filename) = '') Or
         Not ValidFileName(ExtractFileName(FileOpen.Filename)) Then
         FileOpen.Filename := '';
      FileOpen.Filter := GetFilter;
      FileOpen.Options := FileOpen.Options + [ofHideReadOnly];
      If FileOpen.Execute Then
         SetValue(FileOpen.Filename);
   Finally
      FileOpen.Free;
   End;
End;

Function TFilenameProperty.GetAttributes: TPropertyAttributes;
Begin
   Result := [paDialog, paRevertable];
End;

End.
