Unit UltimDBGrid;

{
-----------------------------------------------------------------------------

                               UltimDBGrid 1.1

                        VCL for Delphi and C++Builder
                       (C) Frdric Leneuf-Magaud 2001

-----------------------------------------------------------------------------

 Please read ReadMe.txt for conditions of use

 This component is provided 'as-is', without any express or implied warranty.
 In no event shall the author be held liable for any damages arising from the
 use of this component.

 Veuillez lire le fichier LisezMoi.txt pour les conditions d'utilisation

 Ce composant est fourni tel quel, sans aucune garantie.
 En aucun cas, l'auteur ne pourra tre tenu pour responsable des dommages
 rsultant de l'utilisation de ce composant.

 Special thanks go to / remerciements :
 - Giles Lindsay (ExDBGrid)
 - Gerald Nunn (GXDBGrid)

-----------------------------------------------------------------------------

History of changes / Historique des modifications:

   1.1 : 07/03/2001
         - Fixed display bug in DrawColumnCell & PopUpHint
           Correction d'un bogue d'affichage dans DrawColumnCell & PopUpHint
         - Fixed loading bug in AutoWidth
           Correction d'un bogue de chargement dans AutoWidth
         - Fixed bad font assignments
           Correction des mauvaises assignations de police
         - Fixed bad index in CanEditField
           Correction du mauvais index dans CanEditField

-----------------------------------------------------------------------------
}

Interface

{$I OPTIONS.INC}

Uses
   Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Menus, Dialogs, Grids, DB,
   DBGrids, RxDBCtrl, RxMemDS, StrUtils, UltimDBSelect, UltimDBSort, UltimDBFilter, UltimDBConfig,
   AppUtils, IniFiles, UltimDBExport
   {$IFDEF QREPORT}, UltimDBReport{$ENDIF}
   {$IFDEF ADO}, ADODb{$ENDIF}
   {$IFDEF BDE}, BDE, DBTables{$ENDIF};

{$I LANG_STR.INC}

Type
   TOptionMenuItem = (mnuAutoWidth, mnuAutoWidthOnResize, mnuAllowColResizing, mnuAllowRowResizing,
      mnuSetFixedColumns, mnuShowHideColumns, mnuSortColumns, mnuSetFilter, mnuUseFilter,
      mnuAddCurrentFilter, mnuDisplayBooleans, mnuDisplayImages, mnuDisplayMemo, mnuFullSizeMemo,
      mnuUseRowColors, mnuShowCellHints, mnuShowTextEllipsis, mnuMultiLinesCell, mnuEnterKeyAsTab,
      mnuExportGrid, mnuPrintGrid, mnuReadOnly, mnuSaveConfiguration, mnuRestoreConfiguration);
   TOptionsMenuItems = Set Of TOptionMenuItem;

Const
   CheckBoxSize = 13;
   clRowColor1 = clInfoBk;
   clRowColor2 = clWhite;
   soSortASC = True;
   soSortUP = True;
   soSortDESC = False;
   soSortDOWN = False;
   DefaultMenuItems = [mnuAutoWidth, mnuAutoWidthOnResize, mnuSetFixedColumns, mnuShowHideColumns,
      mnuSortColumns, mnuSetFilter, mnuUseFilter, mnuAddCurrentFilter, mnuDisplayImages,
      mnuDisplayMemo, mnuFullSizeMemo, mnuShowCellHints, mnuMultiLinesCell, mnuExportGrid,
      mnuPrintGrid, mnuSaveConfiguration, mnuRestoreConfiguration];
   DefaultDelimiter = ';';
   DefaultExportName = 'UGExport.htm';
   DefaultIniName = 'UGConfig.ini';
   tagSAVE = 0;
   tagRESTORE = 1;

Type
   TSortField = Record
      Name: String;
      Order: Boolean;
   End;
   TSortFields = Array Of TSortField;

   TUltimFilter = Record
      Name: String;
      Filter: String;
   End;
   TFilterList = Array Of TUltimFilter;

   TConfigOptions = (cfgLayout, cfgSortSettings, cfgFilters);
   TExportFormat = (efHTML, efSYLK, efText);

   TUltimDBGrid = Class;

   TUltimControl = Class(TCollectionItem)
   Private
      FControlName: String;
      FFieldName: String;
   Public
      Procedure Assign(Source: TPersistent); Override;
   Published
      Property ControlName: String Read FControlName Write FControlName;
      Property FieldName: String Read FFieldName Write FFieldName;
   End;

   TUltimControls = Class(TCollection)
   Private
      FUltimGrid: TUltimDBGrid;
      Function GetItem(Index: Integer): TUltimControl;
      Procedure SetItem(Index: Integer; Value: TUltimControl);
   Protected
      Function GetOwner: TPersistent; Override;
   Public
      Constructor Create(UltimGrid: TUltimDBGrid);
      Function Add: TUltimControl;
      Function ControlByField(FieldName: String): TUltimControl;
      Property Items[Index: Integer]: TUltimControl Read GetItem Write SetItem;
   End;

   TAutoWidth = (awNone, awDefault, awProportional, awUniform, awWidestValue, awWidestValueTitle);
   TAutoWidthEvent = Procedure(Sender: TObject; Var NewValue: TAutoWidth) Of Object;

   TUltimDBGrid = Class(TRxDBGrid)
   Private
      FBackBuffer: TBitmap;
      FNoFlickering: Boolean;
      FControls: TUltimControls;
      FCurrentControl: TWinControl;
      FOldControlWndProc: TWndMethod;
      FCustomEditor: Boolean;
      FBooleanEditor: Boolean;
      FOnMouseDown: TMouseEvent;
      FOnMouseUp: TMouseEvent;
      FOnMouseMove: TMouseMoveEvent;
      FAutoWidth: TAutoWidth;
      FOnAutoWidthChange: TAutoWidthEvent;
      FAutoWidthOnResize: Boolean;
      FDisplayBoolean: Boolean;
      FDisplayImages: Boolean;
      FDisplayMemo: Boolean;
      FFullSizeMemo: Boolean;
      FUseRowColors: Boolean;
      FRowColors: Array[0..1] Of TColor;
      FRowSizingAllowed: Boolean;
      FLockedHeight: Word;
      FTitleRowHeight: Integer;
      FNewDefRowHeight: Integer;
      FLockedWidth: Boolean;
      FHintWnd: THintWindow;
      FCellHints: Boolean;
      FShowTextEllipsis: Boolean;
      FMultiLines: Boolean;
      FSortOnTitleClick: Boolean;
      FSortedFields: TSortFields;
      FOldGetBtnParams: TGetBtnParamsEvent;
      FEnterAsTab: Boolean;
      FGridPopUpMenu: TPopUpMenu;
      FOptionsMenu: Boolean;
      FOptionsMenuItems: TOptionsMenuItems;
      FSavedBookmark: TBookmarkStr;
      FSavedRowPos: Integer;
      FValueToSearch: Variant;
      FSearchFields: TStringList;
      FOnMenuPrintGrid: TNotifyEvent;
      FReportTitle: String;
      FFooter: TWinControl;
      Procedure SendSizeMessage;
      Function CanEditField: Boolean;
      Procedure ChangeBoolean(Field: TField);
      Procedure WMChar(Var Msg: TWMChar); Message WM_CHAR;
      Procedure SetNoFlickering(Value: Boolean);
      Procedure SetControls(Value: TUltimControls);
      Procedure HideCurrentControl;
      Procedure ControlWndProc(Var Message: TMessage);
      Function MaxColIndex: Integer;
      Procedure SetAutoWidth(Value: TAutoWidth);
      Procedure SetAutoWidthOnResize(Value: Boolean);
      Procedure SetDisplayBoolean(Value: Boolean);
      Procedure SetDisplayImages(Value: Boolean);
      Procedure SetDisplayMemo(Value: Boolean);
      Procedure SetFullSizeMemo(Value: Boolean);
      Procedure SetUseRowColors(Value: Boolean);
      Procedure SetRowColor(Index: Integer; Value: TColor);
      Procedure SetRowSizingAllowed(Value: Boolean);
      Procedure LockHeight;
      Procedure UnLockHeight;
      Procedure CalcTitleHeight;
      Function GetDefaultRowHeight: Integer;
      Procedure SetDefaultRowHeight(Value: Integer);
      Procedure PopUpHint(ClientX, ClientY: Integer);
      Procedure SetCellHints(Value: Boolean);
      Procedure SetShowTextEllipsis(Value: Boolean);
      Procedure SetMultiLines(Value: Boolean);
      Procedure SetSortOnTitleClick(Value: Boolean);
      Procedure ShowPopUpMenu(X, Y: Integer);
      Procedure SetOptionsMenu(Value: Boolean);
      Procedure MenuAWDefault(Sender: TObject);
      Procedure MenuAWProportional(Sender: TObject);
      Procedure MenuAWUniform(Sender: TObject);
      Procedure MenuAWWidestValue(Sender: TObject);
      Procedure MenuAWWidestValueTitle(Sender: TObject);
      Procedure MenuAWOnResize(Sender: TObject);
      Procedure MenuAllowColResizing(Sender: TObject);
      Procedure MenuAllowRowResizing(Sender: TObject);
      Procedure MenuSetFixedCols(Sender: TObject);
      Procedure MenuShowHideColumns(Sender: TObject);
      Procedure MenuSortColumns(Sender: TObject);
      Procedure MenuActivateFilter(Sender: TObject);
      Procedure MenuAddFilter(Sender: TObject);
      Procedure MenuDisplayBoolean(Sender: TObject);
      Procedure MenuDisplayImages(Sender: TObject);
      Procedure MenuDisplayMemo(Sender: TObject);
      Procedure MenuFullSizeMemo(Sender: TObject);
      Procedure MenuUseRowColors(Sender: TObject);
      Procedure MenuSetCellHints(Sender: TObject);
      Procedure MenuShowTextEllipsis(Sender: TObject);
      Procedure MenuSetMultiLines(Sender: TObject);
      Procedure MenuSetEnterAsTab(Sender: TObject);
      Procedure MenuSetReadOnly(Sender: TObject);
      Procedure MenuConfig(Sender: TObject);
      Function PrivateSearch(Var ResultCol, ResultRecord: Integer; Next: Boolean): Boolean;
      Procedure SendFooterMsg(Msg: Integer);
   Protected
      Procedure Loaded; Override;
      Function CanEditShow: Boolean; Override;
      Procedure PlaceControl(Control: TWinControl; ACol, ARow: Integer); Virtual;
      Procedure GetCellProps(Field: TField; AFont: TFont; Var Background: TColor;
         Highlight: Boolean); Override;
      Procedure DrawColumnCell(Const Rect: TRect; DataCol: Integer; Column: TColumn;
         State: TGridDrawState); Override;
      Procedure DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState); Override;
      Procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); Override;
      Procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); Override;
      Procedure MouseMove(Shift: TShiftState; X, Y: Integer); Override;
      Procedure CellClick(Column: TColumn); Override;
      Procedure DblClick; Override;
      Procedure CMMouseLeave(Var Msg: TMessage); Message CM_MouseLeave;
      Procedure Scroll(Distance: Integer); Override;
      Procedure WMSize(Var Message: TWMSize); Message WM_SIZE;
      Procedure LinkActive(Value: Boolean); Override;
      Procedure LayoutChanged; Override;
      Procedure ColWidthsChanged; Override;
      Procedure RowHeightsChanged; Override;
      Procedure DoTitleClick(ACol: LongInt; AField: TField); Override;
      Procedure RedirectGetBtnParams(Sender: TObject; Field: TField; AFont: TFont;
         Var Background: TColor; Var SortMarker: TSortMarker; IsDown: Boolean);
      Procedure TopLeftChanged; Override;
   Public
      FilterList: TFilterList;
      ConfigFileName: String;
      ConfigOptions: Set Of TConfigOptions;
      Constructor Create(AOwner: TComponent); Override;
      Destructor Destroy; Override;
      Procedure Invalidate; Override;
      Function Sort(FieldsToSort: TSortFields): Boolean;
      Property SortedFields: TSortFields Read FSortedFields;
      Procedure ExportToFile(FileName: String; Format: TExportFormat; Titles: Boolean;
         Delimiter: Char);
      Procedure SaveGridConfig(IniFileName: String; SaveLayout: Boolean = True;
         SaveSort: Boolean = True; SaveFilter: Boolean = True);
      Procedure RestoreGridConfig(IniFileName: String; RestLayout: Boolean = True;
         RestSort: Boolean = True; RestFilter: Boolean = True);
      Procedure SaveGridPosition;
      Procedure RestoreGridPosition;
      Function Search(ValueToSearch: Variant; Const SearchFields: TStringList;
         Var ResultCol, ResultRecord: Integer; Focus: Boolean): Boolean;
      Function SearchNext(Var ResultCol, ResultRecord: Integer; Focus: Boolean): Boolean;
      Procedure MenuSetFilter(Sender: TObject);
      Procedure MenuExportGrid(Sender: TObject);
      Procedure MenuPrintGrid(Sender: TObject);
      { To be used only by UltimDBFooter }
      Procedure RegisterFooter(Footer: TWinControl);
      Procedure UnregisterFooter(Footer: TWinControl);
   Published
      { NoFlickering: supprime l'effet de clignotement mais ralentit beaucoup l'affichage }
      Property NoFlickering: Boolean Read FNoFlickering Write SetNoFlickering Default False;
      { Controls: liste des contrles utiliss pour la modification des donnes }
      Property Controls: TUltimControls Read FControls Write SetControls;
      { OnMouse...: vnement dclench par l'utilisation de la souris }
      Property OnMouseDown Read FOnMouseDown Write FOnMouseDown;
      Property OnMouseUp Read FOnMouseUp Write FOnMouseUp;
      Property OnMouseMove Read FOnMouseMove Write FOnMouseMove;
      { AutoWidth: modifie automatiquement la largeur des colonnes
        - awNone: pas de modification
        - awDefault: chaque colonne est dimensionne  sa largeur par dfaut
        - awWidestValue: chaque colonne prend la taille de sa donne la plus longue
        - awWidestValueTitle: pareil que awWidestValue mais les titres sont aussi pris en compte
        - awProportional: les colonnes occupent toute la partie visible de la grille
        - awUniform: pareil que awProportional mais les colonnes ont la mme largeur }
      Property AutoWidth: TAutoWidth Read FAutoWidth Write SetAutoWidth Default awNone;
      { AutoWidthOnResize: la largeur des colonnes est recalcule  chaque redimensionnement }
      Property AutoWidthOnResize: Boolean Read FAutoWidthOnResize Write SetAutoWidthOnResize
         Default False;
      { OnAutoWidthChange: vnement dclench par un changement de la valeur d'AutoWidth }
      Property OnAutoWidthChange: TAutoWidthEvent Read FOnAutoWidthChange Write FOnAutoWidthChange;
      { DisplayBoolean: affiche une case  cocher plutt que Vrai ou Faux }
      Property DisplayBoolean: Boolean Read FDisplayBoolean Write SetDisplayBoolean Default True;
      { DisplayImages: affiche l'image plutt que (GRAPHIC), (BLOB) ou un glyphe }
      Property DisplayImages: Boolean Read FDisplayImages Write SetDisplayImages Default True;
      { DisplayMemo: affiche le texte du mmo plutt que (MEMO) ou un glyphe }
      Property DisplayMemo: Boolean Read FDisplayMemo Write SetDisplayMemo Default True;
      { FullSizeMemo: affiche le mmo entier si l'cran est assez large }
      Property FullSizeMemo: Boolean Read FFullSizeMemo Write SetFullSizeMemo Default False;
      { UseRowColors: colorie une ligne sur deux avec les couleurs RowColor1 et 2 }
      Property UseRowColors: Boolean Read FUseRowColors Write SetUseRowColors Default False;
      Property RowColor1: TColor Index 0 Read FRowColors[0] Write SetRowColor Default clRowColor1;
      Property RowColor2: TColor Index 1 Read FRowColors[1] Write SetRowColor Default clRowColor2;
      { RowSizingAllowed: autorise le redimensionnement des lignes }
      Property RowSizingAllowed: Boolean Read FRowSizingAllowed Write SetRowSizingAllowed
         Default False;
      { DefaultRowHeight: hauteur par dfaut des lignes de la grille }
      Property DefaultRowHeight: Integer Read GetDefaultRowHeight Write SetDefaultRowHeight;
      { CellHints: affiche le contenu des cellules tronques au passage de la souris }
      Property CellHints: Boolean Read FCellHints Write SetCellHints Default False;
      { ShowTextEllipsis: affiche '...'  la fin des textes tronqus }
      Property ShowTextEllipsis: Boolean Read FShowTextEllipsis Write SetShowTextEllipsis
         Default True;
      { MultiLines: affiche plusieurs lignes dans une cellule }
      Property MultiLines: Boolean Read FMultiLines Write SetMultiLines Default False;
      { SortOnTitleClick: trie une colonne lorsqu'on clique sur son titre }
      Property SortOnTitleClick: Boolean Read FSortOnTitleClick Write SetSortOnTitleClick
         Default False;
      { EnterAsTab: transforme la touche Entre en touche Tab }
      Property EnterAsTab: Boolean Read FEnterAsTab Write FEnterAsTab Default False;
      { OptionsMenu: ajoute un menu permettant de modifier les options de la grille }
      Property OptionsMenu: Boolean Read FOptionsMenu Write SetOptionsMenu Default False;
      { OptionsMenuItems: liste des lments du menu des options }
      Property OptionsMenuItems: TOptionsMenuItems Read FOptionsMenuItems Write FOptionsMenuItems
         Default DefaultMenuItems;
      { OnMenuPrintGrid: vnement dclench par l'appel de la fonction MenuPrintGrid }
      Property OnMenuPrintGrid: TNotifyEvent Read FOnMenuPrintGrid Write FOnMenuPrintGrid;
      { ReportTitle: titre de l'tat  imprimer }
      Property ReportTitle: String Read FReportTitle Write FReportTitle;
   End;

Implementation

Uses UltimDBFooter;

{------------------------------------------- CONTROLS --------------------------------------------}

Procedure TUltimControl.Assign(Source: TPersistent);
Begin
   If Source Is TUltimControl Then
   Begin
      ControlName := TUltimControl(Source).ControlName;
      FieldName := TUltimControl(Source).FieldName;
   End
   Else
      Inherited Assign(Source);
End;

Constructor TUltimControls.Create(UltimGrid: TUltimDBGrid);
Begin
   Inherited Create(TUltimControl);
   FUltimGrid := UltimGrid;
End;

Function TUltimControls.GetOwner: TPersistent;
Begin
   Result := FUltimGrid;
End;

Function TUltimControls.Add: TUltimControl;
Begin
   Result := TUltimControl(Inherited Add);
End;

Function TUltimControls.GetItem(Index: Integer): TUltimControl;
Begin
   Result := TUltimControl(Inherited GetItem(Index));
End;

Procedure TUltimControls.SetItem(Index: Integer; Value: TUltimControl);
Begin
   Inherited SetItem(Index, Value);
End;

Function TUltimControls.ControlByField(FieldName: String): TUltimControl;
Var
   Ctrl_Idx: Integer;
Begin
   Result := Nil;
   For Ctrl_Idx := 0 To Count - 1 Do
      If SameText(Items[Ctrl_Idx].FieldName, FieldName) Then
      Begin
         Result := Items[Ctrl_Idx];
         Break;
      End;
End;

{-------------------------------------------- PUBLIC ---------------------------------------------}

Constructor TUltimDBGrid.Create(AOwner: TComponent);
Begin
   Inherited;
   FBackBuffer := TBitmap.Create;
   FNoFlickering := False;
   FControls := TUltimControls.Create(Self);
   FCurrentControl := Nil;
   FOldControlWndProc := Nil;
   FCustomEditor := False;
   FBooleanEditor := False;
   FAutoWidth := awNone;
   FAutoWidthOnResize := False;
   FDisplayBoolean := True;
   FDisplayImages := True;
   FDisplayMemo := True;
   FFullSizeMemo := False;
   FUseRowColors := False;
   FRowColors[0] := clRowColor1;
   FRowColors[1] := clRowColor2;
   FRowSizingAllowed := False;
   FLockedHeight := 0;
   FTitleRowHeight := 0;
   FNewDefRowHeight := 0;
   FLockedWidth := False;
   FHintWnd := THintWindow.Create(Self);
   FHintWnd.Color := clInfoBk;
   FHintWnd.Font.Color := clInfoText;
   FCellHints := False;
   FShowTextEllipsis := True;
   FMultiLines := False;
   FSortOnTitleClick := False;
   FSortedFields := Nil;
   FilterList := Nil;
   FOldGetBtnParams := Nil;
   FEnterAsTab := False;
   FGridPopUpMenu := TPopUpMenu.Create(Self);
   FOptionsMenu := False;
   FOptionsMenuItems := DefaultMenuItems;
   ConfigFileName := ExtractFilePath(ParamStr(0)) + DefaultIniName;
   ConfigOptions := [cfgLayout, cfgSortSettings, cfgFilters];
   FValueToSearch := Null;
   FSearchFields := Nil;
   FOnMenuPrintGrid := Nil;
   FReportTitle := '';
   FFooter := Nil;
End;

Destructor TUltimDBGrid.Destroy;
Begin
   HideCurrentControl;
   FGridPopUpMenu.Free;
   FHintWnd.Free;
   FControls.Free;
   FBackBuffer.Free;
   Inherited;
End;

Procedure TUltimDBGrid.Invalidate;
Begin
   If (FCurrentControl <> Nil) And (DataLink <> Nil) And (DataLink.Active) And
      Not (DataLink.DataSet.State In [dsEdit, dsInsert]) Then
      HideCurrentControl;
   // In some cases, [goRowSizing] is lost and have to be set again
   If FRowSizingAllowed And Not (goRowSizing In TDrawGrid(Self).Options) Then
      TDrawGrid(Self).Options := TDrawGrid(Self).Options + [goRowSizing];
   Inherited;
End;

Function TUltimDBGrid.Sort(FieldsToSort: TSortFields): Boolean;
Var
   DSet: TDataSet;
   FTS, MaxFTS: Integer;
   SortString: String;
   SortField: TField;
{$IFDEF BDE}
   IndexDefBDE: TIndexDefs;
   I: Integer;
{$ENDIF}
Begin
   Result := False;
   If (DataLink <> Nil) And DataLink.Active Then
   Begin
      DSet := DataLink.DataSet;
      If DSet.State In [dsEdit, dsInsert] Then
      Begin // On doit quitter le mode dition/insertion avant de trier
         If (dgCancelOnExit In Options) And (DSet.State = dsInsert) And Not DSet.Modified Then
            DSet.Cancel
         Else
            Try
               DSet.Post;
            Except
               On E: Exception Do
               Begin
                  Application.MessageBox(PChar(E.Message + '.'), lsError, MB_ICONSTOP);
                  Exit;
               End;
            End;
      End;
      // Tri des enregistrements
      Screen.Cursor := crHourGlass;
      DSet.DisableControls;
      Try
         SortString := '';
         MaxFTS := Length(FieldsToSort) - 1;
         For FTS := 0 To MaxFTS Do
         Begin
            FieldsToSort[FTS].Name := Trim(FieldsToSort[FTS].Name);
            SortField := DSet.FieldByName(FieldsToSort[FTS].Name);
            If (SortField Is TBlobField) Or (SortField Is TBytesField) Then
            Begin
               Application.MessageBox(PChar(Format(lsNoBlobSort, [FieldsToSort[FTS].Name])),
                  lsError, MB_ICONWARNING);
               Break;
            End
            Else {$IFDEF ADO}
            If DSet Is TCustomADODataSet Then
            Begin // Table ou requte ADO
               If SortString <> '' Then
                  SortString := SortString + ',';
               If Pos(' ', FieldsToSort[FTS].Name) = 0 Then
                  SortString := SortString + FieldsToSort[FTS].Name
               Else
                  SortString := SortString + '[' + FieldsToSort[FTS].Name + ']';
               If FieldsToSort[FTS].Order = soSortDESC Then
                  SortString := SortString + ' DESC';
               If FTS = MaxFTS Then
               Begin
                  TCustomADODataSet(DSet).Sort := SortString;
                  FSortedFields := FieldsToSort;
                  Result := True;
               End;
            End
            Else {$ENDIF}
            {$IFDEF BDE}
            If DSet Is TTable Then
            Begin // Table BDE
               If SortString <> '' Then
                  SortString := SortString + ';';
               SortString := SortString + FieldsToSort[FTS].Name;
               FieldsToSort[FTS].Order := soSortASC;
               If FTS = MaxFTS Then
               Begin
                  IndexDefBDE := TTable(DSet).IndexDefs;
                  IndexDefBDE.Update;
                  For I := 0 To IndexDefBDE.Count - 1 Do
                     If SameText(SortString, IndexDefBDE.Items[I].Fields) Then
                     Begin
                        TTable(DSet).IndexFieldNames := IndexDefBDE.Items[I].Fields;
                        FSortedFields := FieldsToSort;
                        Result := True;
                     End;
                  If Not Result Then 
                  Begin
                     If MaxFTS = 0 Then
                        Application.MessageBox(PChar(Format(lsNoBDEIndex1, [SortString])), lsError,
                           MB_ICONWARNING)
                     Else
                        Application.MessageBox(PChar(Format(lsNoBDEIndex2, [SortString])), lsError,
                           MB_ICONWARNING)
                  End;
               End;
            End
            Else {$ENDIF}
            If DSet Is TRxMemoryData Then
            Begin // Table en mmoire
               If SortString <> '' Then
                  SortString := SortString + ';';
               SortString := SortString + FieldsToSort[FTS].Name;
               If FieldsToSort[FTS].Order <> FieldsToSort[0].Order Then
                  FieldsToSort[FTS].Order := FieldsToSort[0].Order;
               If FTS = MaxFTS Then
               Begin
                  TRxMemoryData(DSet).SortOnFields(SortString, True, Not FieldsToSort[0].Order);
                  TRxMemoryData(DSet).First;
                  FSortedFields := FieldsToSort;
                  Result := True;
               End;
            End
            Else
            Begin // DataSet non gr
               Application.MessageBox(lsDSNotSupported, lsError, MB_ICONWARNING);
               Break;
            End;
         End;
      Finally
         DSet.EnableControls;
         Screen.Cursor := crDefault;
      End;
   End;
End;

Procedure TUltimDBGrid.ExportToFile(FileName: String; Format: TExportFormat; Titles: Boolean;
   Delimiter: Char);

   Function HTMLConvert(Chaine: String): String;
   Begin
      { Conversion des caractres spciaux }
      Result := StringReplace(Chaine, '&', '&amp;', [rfReplaceAll]);
      Result := StringReplace(Result, '"', '&quot;', [rfReplaceAll]);
      Result := StringReplace(Result, '<', '&lt;', [rfReplaceAll]);
      Result := StringReplace(Result, '>', '&gt;', [rfReplaceAll]);
   End;

Const
   SylkMarkX = 'X';
   SylkMarkY = 'Y';
Var
   GridContent: TStringList;
   Delim,
   FieldText,
   GridLine: String;
   I, Cols, Rows: Integer;
Begin
   If (DataLink <> Nil) And DataLink.Active Then
   Begin
      GridContent := TStringList.Create;
      Screen.Cursor := crHourGlass;
      Try
         DataLink.DataSet.DisableControls;
         Try
            { Initialisations }
            Cols := 0;
            Rows := 0;
            If Format = efHTML Then
            Begin
               GridContent.Add('<HTML><HEAD><TITLE>' + ExtractFileName(FileName) + ' ' +
                  DateTimeToStr(Now) + '</TITLE></HEAD>');
               GridContent.Add('<BODY TEXT="Black" BGCOLOR="White"><TABLE BORDER="1">');
               Delim := '</TD><TD>';
            End
            Else If Format = efSylk Then
            Begin
               GridContent.Add('ID;PUltimDBGrid');
               GridContent.Add('B;X' + SylkMarkX + ';Y' + SylkMarkY);
               Delim := #13#10;
            End
            Else
               Delim := Delimiter;
            { Rcupration des titres des colonnes visibles }
            If Titles Then
            Begin
               If Format = efHTML Then
                  GridLine := '<TR BGCOLOR="#CCCCCC"><TD>'
               Else
                  GridLine := '';
               For I := 0 To Columns.Count - 1 Do
                  If Columns[I].Visible Then
                  Begin
                     If Format = efHTML Then
                     Begin
                        If Columns[I].Title.Caption = '' Then
                           GridLine := GridLine + '&nbsp;'
                        Else
                           GridLine := GridLine + HTMLConvert(Columns[I].Title.Caption);
                     End
                     Else If Format = efSylk Then
                     Begin
                        Rows := 1;
                        Inc(Cols);
                        GridLine := GridLine + 'F;W' + IntToStr(Cols) + ' ' + IntToStr(Cols) +
                           ' ' + IntToStr(Columns[I].Field.DisplayWidth) + #13#10 +
                           'C;X' + IntToStr(Cols) + ';Y1;K"' + Columns[I].Title.Caption + '"';
                     End
                     Else
                        GridLine := GridLine + Columns[I].Title.Caption;
                     If I < Columns.Count - 1 Then
                        GridLine := GridLine + Delim;
                  End;
               If Format = efHTML Then                
               Begin
                  GridLine := GridLine + '</TD></TR>';
                  // Remove the last empty column (occurs when last column is invisible)
                  GridLine := StringReplace(GridLine, '<TD></TD>', '', [rfIgnoreCase]);
               End;
               GridContent.Add(GridLine);
            End;
            { Rcupration du contenu des colonnes visibles }
            DataLink.DataSet.First;
            While Not DataLink.DataSet.EOF Do
            Begin
               If Format = efHTML Then
                  GridLine := '<TR><TD>'
               Else
               Begin
                  GridLine := '';
                  If Format = efSylk Then
                  Begin
                     Inc(Rows);
                     Cols := 0;
                  End;
               End;
               For I := 0 To Columns.Count - 1 Do
               Begin
                  FieldText := Columns[I].Field.DisplayText;
                  If Columns[I].Visible Then
                  Begin
                     If Format = efHTML Then
                     Begin
                        If Columns[I].Field.DataType = ftMemo Then 
                           FieldText := Columns[I].Field.AsString;
                        If FieldText = '' Then
                           GridLine := GridLine + '&nbsp;'
                        Else
                           GridLine := GridLine + HTMLConvert(FieldText);
                     End
                     Else If Format = efSylk Then
                     Begin
                        Inc(Cols);
                        GridLine := GridLine + 'C;X' + IntToStr(Cols) + ';Y' + IntToStr(Rows) +
                           ';K"' + FieldText + '"';
                     End
                     Else
                        GridLine := GridLine + FieldText;
                     If I < Columns.Count - 1 Then
                        GridLine := GridLine + Delim;
                  End;
               End;
               If Format = efHTML Then
               Begin
                  GridLine := GridLine + '</TD></TR>';
                  // Remove the last empty column (occurs when last column is invisible)
                  GridLine := StringReplace(GridLine, '<TD></TD>', '', [rfIgnoreCase]);
               End;
               GridContent.Add(GridLine);
               DataLink.DataSet.Next;
            End;
            DataLink.DataSet.First;
            If Format = efHTML Then
               GridContent.Add('</TABLE></BODY></HTML>')
            Else If Format = efSylk Then
            Begin
               // Update the boundaries definition
               GridContent.Strings[1] := StringReplace(GridContent.Strings[1], SylkMarkX,
                  IntToStr(Cols), []);
               GridContent.Strings[1] := StringReplace(GridContent.Strings[1], SylkMarkY,
                  IntToStr(Rows), []);
               GridContent.Add('E');
            End;
            { Enregistrement dans un fichier }
            GridContent.SaveToFile(FileName);
         Finally
            DataLink.DataSet.EnableControls;
         End;
      Finally
         Screen.Cursor := crDefault;
         GridContent.Free;
      End;
   End;
End;

Procedure TUltimDBGrid.SaveGridConfig;
Var
   IniFile: TIniFile;
   ID: String;

   Procedure WriteLayout(Key, Value: String);
   Begin
      IniWriteString(IniFile, 'Layout', ID + Key, Value);
   End;

   Procedure WriteSort(Key, Value: String);
   Begin
      IniWriteString(IniFile, 'Sort', ID + Key, Value);
   End;

   Procedure WriteFilter(Key, Value: String);
   Begin
      IniWriteString(IniFile, 'Filter', ID + Key, Value);
   End;

Var
   I: Integer;
Begin
   DeleteFile(IniFileName);
   IniFile := TIniFile.Create(IniFileName);
   Enabled := False;
   Screen.Cursor := crHourGlass;
   Try
      If SaveLayout Then
      Begin
         { Sauvegarde des proprits de la grille }
         ID := 'Grid.';
         WriteLayout('Color', IntToStr(Color));
         WriteLayout('FixedColor', IntToStr(FixedColor));
         WriteLayout('FixedCols', IntToStr(FixedCols));
         If FUseRowColors Then
            WriteLayout('UseRowColors', 'Yes')
         Else
            WriteLayout('UseRowColors', 'No');
         WriteLayout('RowColor1', IntToStr(FRowColors[0]));
         WriteLayout('RowColor2', IntToStr(FRowColors[1]));
         WriteLayout('FontName', Font.Name);
         WriteLayout('FontSize', IntToStr(Font.Size));
         WriteLayout('FontColor', IntToStr(Font.Color));
         WriteLayout('TitleFontName', TitleFont.Name);
         WriteLayout('TitleFontSize', IntToStr(TitleFont.Size));
         WriteLayout('TitleFontColor', IntToStr(TitleFont.Color));
         If ParentColor Then
            WriteLayout('ParentColor', 'Yes')
         Else
            WriteLayout('ParentColor', 'No');
         If ParentFont Then
            WriteLayout('ParentFont', 'Yes')
         Else
            WriteLayout('ParentFont', 'No');
         WriteLayout('DefaultRowHeight', IntToStr(DefaultRowHeight));
         If dgIndicator In Options Then
            WriteLayout('dgIndicator', 'Yes')
         Else
            WriteLayout('dgIndicator', 'No');
         If dgTitles In Options Then
            WriteLayout('dgTitles', 'Yes')
         Else
            WriteLayout('dgTitles', 'No');
         If dgColLines In Options Then
            WriteLayout('dgColLines', 'Yes')
         Else
            WriteLayout('dgColLines', 'No');
         If dgRowLines In Options Then
            WriteLayout('dgRowLines', 'Yes')
         Else
            WriteLayout('dgRowLines', 'No');
         If ShowGlyphs Then
            WriteLayout('ShowGlyphs', 'Yes')
         Else
            WriteLayout('ShowGlyphs', 'No');
         If FDisplayBoolean Then
            WriteLayout('DisplayBoolean', 'Yes')
         Else
            WriteLayout('DisplayBoolean', 'No');
         If FDisplayImages Then
            WriteLayout('DisplayImages', 'Yes')
         Else
            WriteLayout('DisplayImages', 'No');
         If FDisplayMemo Then
            WriteLayout('DisplayMemo', 'Yes')
         Else
            WriteLayout('DisplayMemo', 'No');
         If FFullSizeMemo Then
            WriteLayout('FullSizeMemo', 'Yes')
         Else
            WriteLayout('FullSizeMemo', 'No');
         If FShowTextEllipsis Then
            WriteLayout('ShowTextEllipsis', 'Yes')
         Else
            WriteLayout('ShowTextEllipsis', 'No');
         If FMultiLines Then
            WriteLayout('MultiLines', 'Yes')
         Else
            WriteLayout('MultiLines', 'No');
         With Columns Do
         Begin
            { Sauvegarde du nombre de colonnes }
            WriteLayout('ColCount', IntToStr(Count));
            { Sauvegarde des proprits des colonnes }
            For I := 0 To Count - 1 Do
            Begin
               ID := 'Col[' + IntToStr(I) + '].';
               WriteLayout('FieldName', Items[I].FieldName);
               WriteLayout('Alignment', IntToStr(Ord(Items[I].Alignment)));
               WriteLayout('Color', IntToStr(Items[I].Color));
               WriteLayout('FontName', Items[I].Font.Name);
               WriteLayout('FontSize', IntToStr(Items[I].Font.Size));
               WriteLayout('FontColor', IntToStr(Items[I].Font.Color));
               WriteLayout('Title', Items[I].Title.Caption);
               WriteLayout('TitleAlignment', IntToStr(Ord(Items[I].Title.Alignment)));
               WriteLayout('TitleColor', IntToStr(Items[I].Title.Color));
               WriteLayout('TitleFontName', Items[I].Title.Font.Name);
               WriteLayout('TitleFontSize', IntToStr(Items[I].Title.Font.Size));
               WriteLayout('TitleFontColor', IntToStr(Items[I].Title.Font.Color));
               WriteLayout('Width', IntToStr(Items[I].Width));
               If Items[I].ReadOnly Then
                  WriteLayout('ReadOnly', 'Yes')
               Else
                  WriteLayout('ReadOnly', 'No');
               If Items[I].Visible Then
                  WriteLayout('Visible', 'Yes')
               Else
                  WriteLayout('Visible', 'No');
            End;
         End;
         { Sauvegarde du type d'auto-ajustement }
         IniWriteString(IniFile, 'Layout', 'Grid.AutoWidth', IntToStr(Ord(FAutoWidth)));
      End;
      If SaveSort Then
      Begin
         { Sauvegarde des critres de tri }
         ID := 'Sort.';
         WriteSort('Count', IntToStr(Length(FSortedFields)));
         For I := 0 To Length(FSortedFields) - 1 Do
         Begin
            ID := 'SF[' + IntToStr(I) + '].';
            WriteSort('Name', FSortedFields[I].Name);
            If FSortedFields[I].Order Then
               WriteSort('Order', 'A')
            Else
               WriteSort('Order', 'D');
         End;
      End;
      If SaveFilter Then
      Begin
         { Sauvegarde du filtre en cours et de la liste des filtres }
         ID := 'Filter.';
         If DataLink.DataSet <> Nil Then
            WriteFilter('Current', DataLink.DataSet.Filter);
         WriteFilter('Count', IntToStr(Length(FilterList)));
         For I := 0 To Length(FilterList) - 1 Do
         Begin
            ID := 'FL[' + IntToStr(I) + '].';
            WriteFilter('Name', FilterList[I].Name);
            WriteFilter('Filter', FilterList[I].Filter);
         End;
      End;
   Finally
      Screen.Cursor := crDefault;
      Enabled := True;
      IniFile.Free;
   End;
End;

Procedure TUltimDBGrid.RestoreGridConfig;
Var
   IniFile: TIniFile;
   ID: String;

   Function ReadLayoutStr(Key, Default: String): String;
   Begin
      Result := IniReadString(IniFile, 'Layout', ID + Key, Default);
   End;

   Function ReadLayoutInt(Key: String; Default: Int64): Int64;
   Begin
      Result := IniReadInteger(IniFile, 'Layout', ID + Key, Default);
   End;

   Function ReadSortStr(Key, Default: String): String;
   Begin
      Result := IniReadString(IniFile, 'Sort', ID + Key, Default);
   End;

   Function ReadFilterStr(Key, Default: String): String;
   Begin
      Result := IniReadString(IniFile, 'Filter', ID + Key, Default);
   End;

Var
   ReOpen: Boolean;
   I, NbCol,
   NbItems: Integer;
Begin
   IniFile := TIniFile.Create(IniFileName);
   Enabled := False;
   Screen.Cursor := crHourGlass;
   Try
      { Fermeture de l'ensemble de donnes }
      If (DataLink.DataSet <> Nil) And DataLink.Active Then
      Begin
         DataLink.DataSet.Close;
         ReOpen := True;
      End
      Else
         ReOpen := False;
      If RestLayout And IniFile.SectionExists('Layout') Then
      Begin
         { Destruction des colonnes existantes }
         SetAutoWidthOnResize(False);
         SetAutoWidth(awNone);
         Columns.Clear;
         { Rcupration des proprits de la grille }
         ID := 'Grid.';
         Color := TColor(ReadLayoutInt('Color', clWindow));
         FixedColor := TColor(ReadLayoutInt('FixedColor', clBtnFace));
         FixedCols := ReadLayoutInt('FixedCols', 0);
         FUseRowColors := (ReadLayoutStr('UseRowColors', 'No') = 'Yes');
         FRowColors[0] := ReadLayoutInt('RowColor1', clRowColor1);
         FRowColors[1] := ReadLayoutInt('RowColor2', clRowColor2);
         Font.Name := ReadLayoutStr('FontName', 'MS Sans Serif');
         Font.Size := ReadLayoutInt('FontSize', 8);
         Font.Color := ReadLayoutInt('FontColor', clWindowText);
         TitleFont.Name := ReadLayoutStr('TitleFontName', 'MS Sans Serif');
         TitleFont.Size := ReadLayoutInt('TitleFontSize', 8);
         TitleFont.Color := ReadLayoutInt('TitleFontColor', clWindowText);
         ParentColor := (ReadLayoutStr('ParentColor', 'No') = 'Yes');
         ParentFont := (ReadLayoutStr('ParentFont', 'Yes') = 'Yes');
         DefaultRowHeight := ReadLayoutInt('DefaultRowHeight', 17);
         If ReadLayoutStr('dgIndicator', 'Yes') = 'Yes' Then
            Options := Options + [dgIndicator]
         Else
            Options := Options - [dgIndicator];
         If ReadLayoutStr('dgTitles', 'Yes') = 'Yes' Then
            Options := Options + [dgTitles]
         Else
            Options := Options - [dgTitles];
         If ReadLayoutStr('dgColLines', 'Yes') = 'Yes' Then
            Options := Options + [dgColLines]
         Else
            Options := Options - [dgColLines];
         If ReadLayoutStr('dgRowLines', 'Yes') = 'Yes' Then
            Options := Options + [dgRowLines]
         Else
            Options := Options - [dgRowLines];
         ShowGlyphs := (ReadLayoutStr('ShowGlyphs', 'Yes') = 'Yes');
         FDisplayBoolean := (ReadLayoutStr('DisplayBoolean', 'Yes') = 'Yes');
         FDisplayImages := (ReadLayoutStr('DisplayImages', 'Yes') = 'Yes');
         FDisplayMemo := (ReadLayoutStr('DisplayMemo', 'Yes') = 'Yes');
         FFullSizeMemo := (ReadLayoutStr('FullSizeMemo', 'No') = 'Yes');
         FShowTextEllipsis := (ReadLayoutStr('ShowTextEllipsis', 'Yes') = 'Yes');
         FMultiLines := (ReadLayoutStr('MultiLines', 'No') = 'Yes');
         { Lecture du nombre de colonnes  crer }
         NbCol := ReadLayoutInt('ColCount', 0);
         If NbCol > 0 Then
         Begin
            { Reconstruction des colonnes }
            With Columns Do
            Begin
               For I := 0 To NbCol - 1 Do
               Begin
                  Columns.Add;
                  ID := 'Col[' + IntToStr(I) + '].';
                  Items[I].FieldName := ReadLayoutStr('FieldName', '');
                  Items[I].Alignment := TAlignment(ReadLayoutInt('Alignment', Ord(taLeftJustify)));
                  Items[I].Color := TColor(ReadLayoutInt('Color', clWindow));
                  Items[I].Font.Name := ReadLayoutStr('FontName', 'MS Sans Serif');
                  Items[I].Font.Size := ReadLayoutInt('FontSize', 8);
                  Items[I].Font.Color := TColor(ReadLayoutInt('FontColor', clWindowText));
                  Items[I].Title.Caption := ReadLayoutStr('Title', '');
                  Items[I].Title.Alignment := TAlignment(ReadLayoutInt('TitleAlignment',
                     Ord(taLeftJustify)));
                  Items[I].Title.Color := TColor(ReadLayoutInt('TitleColor', clBtnFace));
                  Items[I].Title.Font.Name := ReadLayoutStr('TitleFontName', 'MS Sans Serif');
                  Items[I].Title.Font.Size := ReadLayoutInt('TitleFontSize', 8);
                  Items[I].Title.Font.Color := TColor(ReadLayoutInt('TitleFontColor', clWindowText));
                  Items[I].Width := ReadLayoutInt('Width', 64);
                  Items[I].ReadOnly := (ReadLayoutStr('ReadOnly', 'No') = 'Yes');
                  Items[I].Visible := (ReadLayoutStr('Visible', 'Yes') = 'Yes');
               End;
            End;
         End;
         { Rcupration du type d'auto-ajustement }
         SetAutoWidth(TAutoWidth(IniReadInteger(IniFile, 'Layout', 'Grid.AutoWidth', Ord(awNone))));
      End;
      { Rouverture de l'ensemble de donnes }
      If ReOpen Then 
         DataLink.DataSet.Open;
      { Rcupration des critres de tri }
      If RestSort And IniFile.SectionExists('Sort') Then
      Begin
         FSortedFields := Nil;
         NbItems := IniReadInteger(IniFile, 'Sort', 'Sort.Count', 0);
         If NbItems > 0 Then
         Begin
            SetLength(FSortedFields, NbItems);
            For I := 0 To NbItems - 1 Do
            Begin
               ID := 'SF[' + IntToStr(I) + '].';
               FSortedFields[I].Name := ReadSortStr('Name', '');
               If ReadSortStr('Order', 'A') = 'A' Then
                  FSortedFields[I].Order := soSortASC
               Else
                  FSortedFields[I].Order := soSortDESC;
            End;
            Sort(FSortedFields);
         End;
      End;
      { Rcupration du filtre  appliquer et de la liste des filtres }
      If RestFilter And IniFile.SectionExists('Filter') Then
      Begin
         If DataLink.DataSet <> Nil Then
         Begin
            DataLink.DataSet.Filter := IniReadString(IniFile, 'Filter', 'Filter.Current', '');
            DataLink.DataSet.Filtered := (DataLink.DataSet.Filter <> '');
         End;
         FilterList := Nil;
         NbItems := IniReadInteger(IniFile, 'Filter', 'Filter.Count', 0);
         If NbItems > 0 Then
         Begin
            SetLength(FilterList, NbItems);
            For I := 0 To NbItems - 1 Do
            Begin
               ID := 'FL[' + IntToStr(I) + '].';
               FilterList[I].Name := ReadFilterStr('Name', '');
               FilterList[I].Filter := ReadFilterStr('Filter', '');
            End;
         End;
      End;
   Finally
      Screen.Cursor := crDefault;
      Enabled := True;
      IniFile.Free;
   End;
End;

Procedure TUltimDBGrid.SaveGridPosition;
Begin
   FSavedBookmark := DataLink.DataSet.Bookmark;
   FSavedRowPos := DataLink.ActiveRecord;
End;

Procedure TUltimDBGrid.RestoreGridPosition;
Var
   Bookmark: TBookmark;
Begin
   // Reset the current row (this also moves the record pointer) then goto the original record
   {$IFDEF ADO}
   If DataLink.DataSet Is TCustomADODataSet Then
   Begin
      DataLink.ActiveRecord := FSavedRowPos;
      BookMark := Pointer(FSavedBookmark);
      If DataLink.DataSet.BookmarkValid(Bookmark) Then
         TCustomADODataSet(DataLink.DataSet).Recordset.Bookmark := POleVariant(Bookmark)^;
   End
   Else {$ENDIF}
   {$IFDEF BDE}
   If DataLink.DataSet Is TBDEDataSet Then
   Begin
      DataLink.ActiveRecord := FSavedRowPos;
      BookMark := Pointer(FSavedBookmark);
      If DataLink.DataSet.BookmarkValid(Bookmark) Then
         Check(DbiSetToBookmark(TBDEDataSet(DataLink.DataSet).Handle, Bookmark));
   End
   Else
   {$ENDIF}
   Begin
      Application.MessageBox(lsDSNotSupportedByFooter, lsError, MB_ICONSTOP);
      Exit;
   End;
   // Force a reread of the record buffer with the current settings
   Try
      DataLink.DataSet.Resync([rmExact]);
   Except
   End;
End;

Function TUltimDBGrid.PrivateSearch(Var ResultCol, ResultRecord: Integer; Next: Boolean): Boolean;
Const
   GUpcaseLUT: Pointer = Nil;
Var
   GUpcaseTable: Array[0..255] Of Char;

   Function FindText(Const aFindString, aSourceString: String): Boolean;
   { This is a tuned version of FastPosNoCase/FastMemPosNC from FastStrings of Peter Morris }

   Const
      aFindLen: Integer = 0;
      aSourceLen: Integer = 0;

      Function FastMemPosNC(Const aSource, aFind): Pointer;
      Asm
         push ESI
         push EDI
         push EBX
         mov  ESI, aFind
         mov  EDI, aSource
         mov  ECX, aSourceLen
         mov  Result, 0
         cmp  ECX, aFindLen
         jl   @TheEnd
         cmp  aFindLen, 1
         jl   @TheEnd
         sub  ECX, aFindLen
         inc  ECX
         mov  EDX, GUpcaseLUT
         xor  EBX, EBX
         jmp  @FindFirst
      @FindNext:
         inc  EDI
         dec  ECX
         jz   @NotFound
      @FindFirst:
         mov  Bl, [ESI]
         mov  AL, [EDX+EBX]
      @ScaSB:
         mov  Bl, [EDI]
         cmp  Al, [EDX+EBX]
         jz   @CompareStrings
         inc  EDI
         dec  ECX
         jnz  @ScaSB
         jmp  @NotFound
      @CompareStrings:
         push ECX
         mov  ECX, aFindLen
      @CompareNext:
         dec  ECX
         jz   @FullMatch
         mov  Bl, [ESI+ECX]
         mov  Al, [EDX+EBX]
         mov  Bl, [EDI+ECX]
         cmp  Al, [EDX+EBX]
         jz   @KeepChecking
         POP  ECX
         jmp  @FindNext
      @KeepChecking:
         Jmp  @CompareNext
      @FullMatch:
         pop  ECX
         mov  Result, EDI
         jmp  @TheEnd
      @NotFound:
         mov  Result, 0
      @TheEnd:
         pop  EBX
         pop  EDI
         pop  ESI
      End;

   Begin
      aFindLen := Length(aFindString);
      aSourceLen := Length(aSourceString);
      Result := (Integer(FastMemPosNC(aSourceString[1], aFindString[1])) > 0);
   End;

Var
   I, ColNo, Start: Integer;
Begin
   Result := False;
   If (DataLink <> Nil) And DataLink.Active Then
   Begin
      DataLink.DataSet.DisableControls;
      Screen.Cursor := crHourGlass;
      Try
         { Cration de la table des caractres majuscules }
         For I := 0 To 255 Do
            GUpcaseTable[I] := Chr(I);
         CharUpperBuff(@GUpcaseTable[0], 256);
         GUpcaseLUT := @GUpcaseTable[0];
         { Positionnement dans le dataset }
         SaveGridPosition;
         If Next Then
         Begin
            Start := Col;
            If Not (dgIndicator In Options) Then 
               Inc(Start);
         End
         Else
         Begin
            Start := 0;
            DataLink.DataSet.First;
         End;
         { Parcours du dataset }
         While Not DataLink.DataSet.EOF Do
         Begin
            For ColNo := Start To Columns.Count - 1 Do
               For I := 0 TO FSearchFields.Count - 1 Do
               Begin
                  { Champ dans la liste ? }
                  If SameText(FSearchFields[I], Columns[ColNo].FieldName) And
                     (Columns[ColNo].Field.Value <> Null) Then
                  Begin
                     { Recherche du texte dans le champ }
                     If FindText(String(FValueToSearch), Columns[ColNo].Field.AsString) Then
                     Begin
                        ResultCol := ColNo;
                        If dgIndicator In Options Then 
                           Inc(ResultCol);
                        ResultRecord := DataLink.ActiveRecord;
                        Result := True;
                        Exit;
                     End;
                  End;
               End;
            Start := 0;
            DataLink.DataSet.Next;
         End;
      Finally
         Screen.Cursor := crDefault;
         DataLink.DataSet.EnableControls;
      End;
   End;
End;

Function TUltimDBGrid.Search(ValueToSearch: Variant; Const SearchFields: TStringList;
   Var ResultCol, ResultRecord: Integer; Focus: Boolean): Boolean;
Begin
   Result := False;
   If (SearchFields <> Nil) And (ValueToSearch <> Null) And (ValueToSearch <> '') Then
   Begin
      FValueToSearch := ValueToSearch;
      FSearchFields := SearchFields;
      Result := PrivateSearch(ResultCol, ResultRecord, False);
      If Result And Focus Then
      Begin
         Self.Col := ResultCol;
         If Visible Then
            SetFocus;
      End
      Else
         RestoreGridPosition;
   End;
End;

Function TUltimDBGrid.SearchNext(Var ResultCol, ResultRecord: Integer; Focus: Boolean): Boolean;
Begin
   Result := False;
   If (FSearchFields <> Nil) And (FValueToSearch <> Null) And (FValueToSearch <> '') Then
   Begin
      Result := PrivateSearch(ResultCol, ResultRecord, True);
      If Result And Focus Then
      Begin
         Self.Col := ResultCol;
         If Visible Then
            SetFocus;
      End
      Else
         RestoreGridPosition;
   End;
End;

{------------------------------------------- PROTECTED -------------------------------------------}

Procedure TUltimDBGrid.Loaded;
Var
   Ctrl_Idx: Integer;
   WinControl: TWinControl;
Begin
   Inherited Loaded;
   // Dissimulation des contrles
   For Ctrl_Idx := 0 To FControls.Count - 1 Do
   Begin
      WinControl := TWinControl(Owner.FindComponent(FControls.Items[Ctrl_Idx].ControlName));
      If WinControl <> Nil Then
         WinControl.Visible := False;
   End;
   // Interception de l'vnement OnGetBtnParams
   If Not (csDesigning In ComponentState) Then
   Begin
      FOldGetBtnParams := OnGetBtnParams;
      OnGetBtnParams := RedirectGetBtnParams;
   End;
End;

Function TUltimDBGrid.CanEditField: Boolean;

   Function IsActiveControl: Boolean;
   Var
      H: Hwnd;
      ParentForm: TCustomForm;
   Begin
      Result := False;
      ParentForm := GetParentForm(Self);
      If Assigned(ParentForm) Then
      Begin
         If (ParentForm.ActiveControl = Self) Then
            Result := True
      End
      Else
      Begin
         H := GetFocus;
         While IsWindow(H) And (Result = False) Do
            Begin
               If H = WindowHandle Then
               Result := True
            Else
               H := GetParent(H);
         End;
      End;
   End;

Var
   F: TField;
   Control: TUltimControl;
Begin
   FCustomEditor := False;
   FBooleanEditor := False;

   Result := (dgEditing In Options) And Not (csDesigning In ComponentState) And
      HandleAllocated And (LayoutLock = 0) And ((dgAlwaysShowEditor In Options) Or IsActiveControl);

   If Not Result Then
      Exit;

   Result := (DataLink <> Nil) And DataLink.Active And (SelectedIndex >= 0) And
      (SelectedIndex < Columns.Count); //1.1

   If Not Result Then
      Exit;

   F := SelectedField; //1.1
   Result := (F <> Nil);

   If Not Result Then
      Exit;

   Control := FControls.ControlByField(F.FieldName);
   Result := (Control <> Nil);
   If Not Result Then
      Result := Not (F.DataType In [ftUnknown, ftBytes, ftVarBytes, ftBlob,
         ftMemo, ftFmtMemo, ftGraphic, ftTypedBinary, ftParadoxOle, ftDBaseOle,
         ftCursor, ftReference, ftDataSet, ftOraClob, ftOraBlob]);
   Result := Result And F.CanModify And Not Columns[SelectedIndex].ReadOnly; //1.1

   If Not Result Then
      Exit;

   If Assigned(OnShowEditor) Then
   Begin
      OnShowEditor(Self, F, Result);
      If Not Result Then
         Exit;
   End;

   // Utilisation des diteurs personnaliss ?
   If Control <> Nil Then
   Begin
      PlaceControl(TWinControl(Owner.FindComponent(Control.ControlName)), Col, Row);
      FCustomEditor := True;
      Result := False;
   End
   Else If (F.DataType = ftBoolean) And FDisplayBoolean Then
   Begin
      FBooleanEditor := True;
      Result := False;
   End;
End;

Function TUltimDBGrid.CanEditShow: Boolean;
Begin
   // To bypass TRxDBGrid.CanEditShow, there's no inheritance
   Result := EditorMode And CanEditField;
End;

Procedure TUltimDBGrid.PlaceControl(Control: TWinControl; ACol, ARow: Integer);
Var
   R: TRect;
   frmParent: TCustomForm;
   OldOptions: TDBGridOptions;
Begin
   If Not DataLink.Edit Then 
      Exit;

   If (Control <> FCurrentControl) Then
   Begin
      HideCurrentControl;
      FCurrentControl := Control;
      FOldControlWndProc := FCurrentControl.WindowProc;
      FCurrentControl.WindowProc := ControlWndProc;
   End;

   If Control.Parent <> Self.Parent Then
      Control.Parent := Self.Parent;
   R := CellRect(ACol, ARow);
   R.TopLeft := ClientToScreen(R.TopLeft);
   R.TopLeft := TControl(Control.Parent).ScreenToClient(R.TopLeft);
   R.BottomRight := ClientToScreen(R.BottomRight);
   R.BottomRight := TControl(Control.Parent).ScreenToClient(R.BottomRight);
   Control.BringToFront;
   Control.Show;
   Control.BoundsRect := R;

   frmParent := GetParentForm(Self);
   If (dgCancelOnExit In Options) Then
   Begin
      OldOptions := Options;
      Options := Options - [dgCancelOnExit];
      If (Self.Visible) And (Control.Visible) And (Self.Parent.Visible) And
         (frmParent.Visible) Then
         Control.SetFocus;
      Options := Options + [dgCancelOnExit];
      Options := OldOptions;
   End
   Else If (Self.Visible) And (Control.Visible) And (Self.Parent.Visible) And
      (frmParent.Visible) Then
      Control.SetFocus;
End;

Procedure TUltimDBGrid.GetCellProps(Field: TField; AFont: TFont; Var Background: TColor;
   Highlight: Boolean);

   Function IsFixedCol: Boolean;
   Var 
      FC: Integer;
   Begin
      Result := False;
      For FC := 0 To FixedCols - 1 Do
         If Columns[FC].FieldName = Field.FieldName Then 
         Begin
            Result := True;
            Break;
         End;
   End;

Begin
   If IsFixedCol Then
      Background := FixedColor
   Else If FUseRowColors And Not Highlight Then
      Background := FRowColors[DataLink.ActiveRecord Mod 2];
   Inherited;
End;

Procedure TUltimDBGrid.DrawColumnCell(Const Rect: TRect; DataCol: Integer; Column: TColumn;
   State: TGridDrawState);

   Function BackBufferRect: TRect;
   Begin
      Result := Classes.Rect(0, 0, FBackBuffer.Width, FBackBuffer.Height);
   End;

Var
   TmpRect: TRect;

   Function BackBufferTmpRect: TRect;
   Var
      XOffset,
      YOffset: Integer;
   Begin
      XOffset := TmpRect.Left - Rect.Left;
      YOffset := TmpRect.Top - Rect.Top;
      Result := Classes.Rect(XOffset, YOffset, XOffset + TmpRect.Right - TmpRect.Left,
         YOffset + TmpRect.Bottom - TmpRect.Top);
   End;

   Procedure CenterRect(ObjWidth, ObjHeight: Integer);
   Begin
      TmpRect.Left := TmpRect.Left + ((TmpRect.Right - TmpRect.Left - ObjWidth) SHR 1);
      If TmpRect.Left < Rect.Left Then
         TmpRect.Left := Rect.Left;
      TmpRect.Right := TmpRect.Left + ObjWidth;
      TmpRect.Top := TmpRect.Top + ((TmpRect.Bottom - TmpRect.Top - ObjHeight) SHR 1);
      If TmpRect.Top < Rect.Top Then
         TmpRect.Top := Rect.Top;
      TmpRect.Bottom := TmpRect.Top + ObjHeight;
   End;

Var
   CellSelected: Boolean;

   Procedure FillCellBkgrd;
   Var
      NewBackgrnd: TColor;
   Begin
      NewBackgrnd := Self.Canvas.Brush.Color;
      GetCellProps(Column.Field, Self.Canvas.Font, NewBackgrnd, CellSelected);
      Self.Canvas.Brush.Color := NewBackgrnd;
      If FNoFlickering Then
      Begin
         FBackBuffer.Height := Rect.Bottom - Rect.Top;
         FBackBuffer.Width := Rect.Right - Rect.Left;
         FBackBuffer.Canvas.Brush.Color := NewBackgrnd;
         FBackBuffer.Canvas.FillRect(BackBufferRect);
      End
      Else
         Self.Canvas.FillRect(Rect);
   End;

Var
   Image: TBitmap;

   Procedure DrawImage;
   Var
      RatioH, RatioW: Single;
   Begin
      Self.Canvas.Lock;
      Try
         FillCellBkgrd;

         TmpRect := Rect;
         Inc(TmpRect.Left);
         Dec(TmpRect.Right, 2);
         Inc(TmpRect.Top);
         Dec(TmpRect.Bottom, 2);
         RatioH := (TmpRect.Bottom - TmpRect.Top + 1) / Image.Height;
         RatioW := (TmpRect.Right - TmpRect.Left + 1) / Image.Width;
         If RatioW < RatioH Then
            CenterRect(Round(Image.Width * RatioW), Round(Image.Height * RatioW))
         Else
            CenterRect(Round(Image.Width * RatioH), Round(Image.Height * RatioH));
         If FNoFlickering Then
         Begin
            FBackBuffer.Canvas.StretchDraw(BackBufferTmpRect, Image);
            Self.Canvas.Draw(Rect.Left, Rect.Top, FBackBuffer);
         End
         Else
            Self.Canvas.StretchDraw(TmpRect, Image);

         If (gdFocused In State) And Not (csDesigning In ComponentState) And
            Not (dgRowSelect In Options) Then
            Self.Canvas.DrawFocusRect(Rect);
      Finally
         Self.Canvas.Unlock;
      End;
   End;

Var
   Index: Integer;
   BackBufTmpRect: TRect;
   MemStream: TMemoryStream;
   DrawOptions: Integer;
Begin
   FBooleanEditor := False;
   If Not (DataLink.Active And DefaultDrawing And HandleAllocated) Then
   Begin
      Inherited;
      Exit;
   End;
   CellSelected := ((gdSelected In State) And ((dgAlwaysShowSelection In Options) Or Focused));
   If MultiSelect Then
      CellSelected := CellSelected Or SelectedRows.Find(DataLink.DataSet.Bookmark, Index);
   If (Column.Field.DataType = ftMemo) Or (Column.Field.DataType = ftFmtMemo) Then
   Begin
      If FDisplayMemo And (Column.Field.Value <> Null) Then
      Begin // Affichage du texte du mmo
         Self.Canvas.Lock;
         Try
            FillCellBkgrd;

            TmpRect := Rect;
            Inc(TmpRect.Top, 2);
            Inc(TmpRect.Left, 2);
            If FMultiLines Then
               DrawOptions := DT_LEFT Or DT_WORDBREAK
            Else
               DrawOptions := DT_LEFT;
            If FNoFlickering Then
            Begin
               FBackBuffer.Canvas.Font.Assign(Self.Canvas.Font); //1.1
               BackBufTmpRect := BackBufferTmpRect;
               DrawText(FBackBuffer.Canvas.Handle, PChar(Column.Field.AsString),
                  Length(Column.Field.AsString), BackBufTmpRect, DT_NOPREFIX Or DrawOptions);
               Self.Canvas.Draw(Rect.Left, Rect.Top, FBackBuffer);
            End
            Else
               DrawText(Self.Canvas.Handle, PChar(Column.Field.AsString),
                  Length(Column.Field.AsString), TmpRect, DT_NOPREFIX Or DrawOptions);

            If (gdFocused In State) And Not (csDesigning In ComponentState) And
               Not (dgRowSelect In Options) Then
               Self.Canvas.DrawFocusRect(Rect);
         Finally
            Self.Canvas.Unlock;
         End;
      End
      Else
         Inherited;
   End
   Else If Column.Field.DataType = ftBoolean Then
   Begin
      If FDisplayBoolean Then
      Begin // Affichage d'une case  cocher
         Self.Canvas.Lock;
         Try
            FillCellBkgrd;

            TmpRect := Rect;
            CenterRect(CheckBoxSize, CheckBoxSize);
            If FNoFlickering Then
            Begin
               BackBufTmpRect := BackBufferTmpRect;
               If Column.Field.AsBoolean = True Then
                  DrawFrameControl(FBackBuffer.Canvas.Handle, BackBufTmpRect, DFC_BUTTON,
                     DFCS_CHECKED Or DFCS_FLAT)
               Else
                  DrawFrameControl(FBackBuffer.Canvas.Handle, BackBufTmpRect, DFC_BUTTON,
                     DFCS_BUTTONCHECK Or DFCS_FLAT);
               Self.Canvas.Draw(Rect.Left, Rect.Top, FBackBuffer);
            End
            Else If Column.Field.AsBoolean = True Then
               DrawFrameControl(Self.Canvas.Handle, TmpRect, DFC_BUTTON, DFCS_CHECKED Or DFCS_FLAT)
            Else
               DrawFrameControl(Self.Canvas.Handle, TmpRect, DFC_BUTTON,
                  DFCS_BUTTONCHECK Or DFCS_FLAT);

            If (gdFocused In State) And Not (csDesigning In ComponentState) And
               Not (dgRowSelect In Options) Then
               Self.Canvas.DrawFocusRect(Rect);
         Finally
            Self.Canvas.Unlock;
         End;
      End
      Else
         Inherited;
   End
   Else If Column.Field Is TBlobField Then
   Begin
      If FDisplayImages Then
      Begin // Affichage de l'image bitmap
         Image := TBitmap.Create;
         Try
            Try
               Image.Assign(Column.Field As TBlobField);
            Except
               If Copy(Column.Field.AsString, 79, 2) = 'BM' Then
               Begin // Access OLE Bitmap
                  MemStream := TMemoryStream.Create;
                  Try
                     (Column.Field As TBlobField).SaveToStream(MemStream);
                     MemStream.Seek(78, soFromBeginning);
                     Image.LoadFromStream(MemStream);
                  Finally
                     MemStream.Free;
                  End;
               End;
            End;
            IF Image.Empty Then
               Inherited
            Else
               DrawImage;
         Finally
            Image.Free;
         End;
      End
      Else
         Inherited;
   End
   Else If FShowTextEllipsis Or FMultiLines Or FNoFlickering Then
   Begin // Affichage personnalis du texte (ellipses, multilignes, sans clignotement)
      Self.Canvas.Lock;
      Try
         FillCellBkgrd;

         TmpRect := Rect;
         Inc(TmpRect.Top, 2);
         Case Column.Alignment Of
            taLeftJustify:
            Begin
               Inc(TmpRect.Left, 2);
               DrawOptions := DT_LEFT;
            End;
            taRightJustify:
            Begin
               Dec(TmpRect.Right, 3);
               DrawOptions := DT_RIGHT;
            End;
            Else
               DrawOptions := DT_CENTER;
         End;
         If FShowTextEllipsis Then  
            DrawOptions := DrawOptions Or DT_END_ELLIPSIS;
         If FMultiLines Then
            DrawOptions := DrawOptions Or DT_WORDBREAK;
         If FNoFlickering Then
         Begin
            FBackBuffer.Canvas.Font.Assign(Self.Canvas.Font); //1.1
            BackBufTmpRect := BackBufferTmpRect;
            DrawText(FBackBuffer.Canvas.Handle, PChar(Column.Field.DisplayText), //1.1
               Length(Column.Field.DisplayText), BackBufTmpRect, DT_NOPREFIX Or DrawOptions); //1.1
            Self.Canvas.Draw(Rect.Left, Rect.Top, FBackBuffer);
         End
         Else
            DrawText(Self.Canvas.Handle, PChar(Column.Field.DisplayText), //1.1
               Length(Column.Field.DisplayText), TmpRect, DT_NOPREFIX Or DrawOptions); //1.1

         If (gdFocused In State) And Not (csDesigning In ComponentState) And
            Not (dgRowSelect In Options) Then
            Self.Canvas.DrawFocusRect(Rect);
      Finally
         Self.Canvas.Unlock;
      End;
   End
   Else
      Inherited;
End;

Procedure TUltimDBGrid.DrawCell(ACol, ARow: Longint; ARect: TRect; AState: TGridDrawState);
Var
   OldPenColor: TColor;
Begin
   Inherited;
   If FOptionsMenu And (ACol = 0) And (ARow = 0) And (dgIndicator In Options) And
      (dgTitles In Options) Then
   Begin
      Canvas.Lock;
      Try
         OldPenColor := Canvas.Pen.Color;
         Canvas.Pen.Color := clBlack;
         Canvas.Brush.Color := clMenu;
         Canvas.Rectangle(ARect.Left + 2, ARect.Top + 3, ARect.Right - 2, ARect.Top + 14);
         Canvas.Pen.Color := OldPenColor; // needed to display correctly the column moving bar
      Finally
         Canvas.Unlock;
      End;
   End;
End;

Procedure TUltimDBGrid.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
Var
   CellX, CellY: Integer;
Begin
   If Assigned(FOnMouseDown) Then
      FOnMouseDown(Self, Button, Shift, X, Y);
   Inherited;
   { Affichage du menu des options ? }
   If FOptionsMenu And (DataLink <> Nil) And DataLink.Active And (dgIndicator In Options) And
      (dgTitles In Options) Then
   Begin
      MouseToCell(X, Y, CellX, CellY);
      If (CellX = 0) And (CellY = 0) Then
         ShowPopUpMenu(X, Y);
   End;
End;

Procedure TUltimDBGrid.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
Begin
   If Assigned(FOnMouseUp) Then
      FOnMouseUp(Self, Button, Shift, X, Y);
   Inherited;
End;

Procedure TUltimDBGrid.MouseMove(Shift: TShiftState; X, Y: Integer);
Begin
   If Assigned(FOnMouseMove) Then
      FOnMouseMove(Self, Shift, X, Y);
   Inherited;
   If FCellHints Then
      PopUpHint(X, Y);
End;

Procedure TUltimDBGrid.CellClick(Column: TColumn);
Begin
   Inherited;
   If FBooleanEditor Then
      ChangeBoolean(Column.Field);
End;
        
Procedure TUltimDBGrid.DblClick; 
Begin
   Inherited;
   If FDisplayBoolean And (SelectedField Is TBooleanField) Then
      // Activation de l'diteur boolen?
      CanEditField;
End;

Procedure TUltimDBGrid.CMMouseLeave(Var Msg: TMessage);
Begin
   Inherited;
   If FCellHints And Assigned(FHintWnd) Then
      FHintWnd.ReleaseHandle;
End;

Procedure TUltimDBGrid.Scroll(Distance: Integer);
Begin
   If FUseRowColors Then
      Invalidate;
   Inherited;
   If FCellHints And Assigned(FHintWnd) Then
      FHintWnd.ReleaseHandle;
End;

Procedure TUltimDBGrid.WMSize(Var Message: TWMSize);
Begin
   Inherited;
   If Not FLockedWidth Then
   Begin
      If (FAutoWidth <> awNone) And FAutoWidthOnResize Then
         SetAutoWidth(FAutoWidth);

      If FCurrentControl <> Nil Then
         If FCurrentControl.Visible Then
            PlaceControl(FCurrentControl, Col, Row);
   End;
End;

Procedure TUltimDBGrid.LinkActive(Value: Boolean);
Begin
   Inherited;
   FSortedFields := Nil;
   RowHeightsChanged;
   SendFooterMsg(FTR_ACTIVE);
End;

Procedure TUltimDBGrid.LayoutChanged;
Begin
   Inherited;
   If FLockedHeight = 0 Then
   Begin
      FTitleRowHeight := 0;
      SetDefaultRowHeight(FNewDefRowHeight);
   End;
   SendSizeMessage;
End;

Procedure TUltimDBGrid.ColWidthsChanged;
Begin
   Inherited;
   SendSizeMessage;
   SendFooterMsg(FTR_COLWIDTHS);
End;

Procedure TUltimDBGrid.RowHeightsChanged;
Var
   RowNo: Integer;
Begin
   Inherited;
   For RowNo := 1 To VisibleRowCount + 1 Do
      If RowHeights[RowNo] <> DefaultRowHeight Then
      Begin
         DefaultRowHeight := RowHeights[RowNo];
         Break;
      End;
   SendSizeMessage;
End;

Procedure TUltimDBGrid.DoTitleClick(ACol: LongInt; AField: TField);
Var
   Found: Boolean;
   I: Integer;
   ClickedField: TSortFields;
Begin
   If FSortOnTitleClick And (AField <> Nil) Then
   Begin
      Found := False;
      For I := 0 To Length(FSortedFields) - 1 Do
         If SameText(AField.FieldName, FSortedFields[I].Name) Then
         Begin
            Found := True;
            FSortedFields[I].Order := Not FSortedFields[I].Order;
            Sort(FSortedFields);
            Break;
         End;
      If Not Found Then 
      Begin
         SetLength(ClickedField, 1);
         ClickedField[0].Name := AField.FieldName;
         ClickedField[0].Order := soSortASC;
         Sort(ClickedField);
      End;
   End;
   Inherited;
End;

Procedure TUltimDBGrid.RedirectGetBtnParams(Sender: TObject; Field: TField; AFont: TFont;
   Var Background: TColor; Var SortMarker: TSortMarker; IsDown: Boolean);

Var
   SortOrder: Boolean;

   Function IsSortedField: Boolean;
   Var
      I: Integer;
   Begin
      Result := False;
      For I := 0 To Length(FSortedFields) - 1 Do
         If SameText(Field.FieldName, FSortedFields[I].Name) Then
         Begin
            SortOrder := FSortedFields[I].Order;
            Result := True;
            Break;
         End;
   End;

Begin
   If (Field <> Nil) And IsSortedField Then
   Begin
      If SortOrder = soSortUP Then
         SortMarker := smUP
      Else
         SortMarker := smDOWN;
   End
   Else
      SortMarker := smNONE;
   If Assigned(FOldGetBtnParams) Then
      FOldGetBtnParams(Sender, Field, AFont, Background, SortMarker, IsDown);
End;

Procedure TUltimDBGrid.TopLeftChanged;
Begin
   Inherited;
   SendFooterMsg(FTR_SCROLL);
End;

{-------------------------------------------- PRIVATE --------------------------------------------}

Procedure TUltimDBGrid.SendSizeMessage;
Var
   Message: TMessage;
Begin
   If HandleAllocated And (FNewDefRowHeight <> 0) Then
   Begin
      // Awful hack to get inherited grid to call private UpdateRowCount
      Message.Msg := WM_Size;
      Message.WParam := SIZE_RESTORED;
      Message.lParamLo := Width;
      Message.lParamHi := Height;
      Perform(Message.Msg, Message.wParam, Message.lParam);
   End;
End;

Procedure TUltimDBGrid.ChangeBoolean(Field: TField);
Begin
   DataLink.Edit;
   If Field.Value = Null Then
      Field.Value := True
   Else
      Field.Value := Not Field.Value;
   DrawCell(Col, Row, CellRect(Col, Row), [gdSelected, gdFocused]);
End;

Procedure TUltimDBGrid.WMChar(Var Msg: TWMChar);
Var
   Tab: Word;
Begin
   If FEnterAsTab And (Msg.CharCode = VK_RETURN) Then
   Begin
      Tab := VK_TAB;
      KeyDown(Tab, []);
      Exit;
   End;
   If (Char(Msg.CharCode) In [^H, #32..#255]) Then
   Begin
      If CanEditField Then
         Inherited
      Else If FBooleanEditor Then
         ChangeBoolean(Fields[SelectedIndex]);
   End
   Else
      Inherited;
End;

Procedure TUltimDBGrid.SetNoFlickering(Value: Boolean);
Begin
   If FNoFlickering <> Value Then
   Begin
      FNoFlickering := Value;
      Invalidate;
   End;
End;

Procedure TUltimDBGrid.SetControls(Value: TUltimControls);
Begin
   FControls.Assign(Value);
End;

Procedure TUltimDBGrid.HideCurrentControl;
Begin
   If (FCurrentControl <> Nil) Then
   Begin
      FCurrentControl.WindowProc := FOldControlWndProc;
      FCurrentControl.Hide;
      FCurrentControl := Nil;
   End;
   FOldControlWndProc := Nil;
End;

Procedure TUltimDBGrid.ControlWndProc(Var Message: TMessage);
Begin
   FOldControlWndProc(Message);
   If Message.Msg = WM_KEYUP Then
      // If you test KeyDown, the Escape key does not cancel your changes
      Case TWMKey(Message).CharCode Of
         VK_ESCAPE:
            If Not (dgAlwaysShowEditor In Options) Then
            Begin
               HideCurrentControl;
               If Self.Visible Then
                  Self.SetFocus;
            End;
      End;
   If Message.Msg = CM_EXIT Then
      HideCurrentControl;
End;

Function TUltimDBGrid.MaxColIndex: Integer;
Begin
   Result := ColCount - 1;
   If dgIndicator In Options Then
      Dec(Result);
End;

Procedure TUltimDBGrid.SetAutoWidth(Value: TAutoWidth);
Var
   ColNo, MaxColNo, ColumnCount: Integer;
   NewWidth, MaxWidth: Integer;
   Total, Available, OldAvail: Integer;
Begin
   FAutoWidth := Value;
   If Assigned(FOnAutoWidthChange) Then 
      FOnAutoWidthChange(Self, FAutoWidth);
   If FAutoWidth <> awNone Then
   Begin
      If (FAutoWidth <> awWidestValue) And (FAutoWidth <> awWidestValueTitle) Then
         SetFullSizeMemo(False);
      If DataLink.Active Then
      Begin
         FLockedWidth := True;
         Screen.Cursor := crHourGlass;
         BeginUpdate;
         Try
            MaxColNo := MaxColIndex;

            If (FAutoWidth = awWidestValue) Or (FAutoWidth = awWidestValueTitle) Then
            Begin // Widest value / Wv title
               For ColNo := 0 To MaxColNo Do
                  If Columns[ColNo].Visible Then
                  Begin
                     If FAutoWidth = awWidestValue Then
                        MaxWidth := 0
                     Else
                     Begin
                        Canvas.Font.Assign(Columns[ColNo].Title.Font); //1.1
                        MaxWidth := Canvas.TextWidth(Columns[ColNo].Title.Caption) + 2;
                     End;
                     Canvas.Font.Assign(Columns[ColNo].Font); //1.1
                     DataLink.DataSet.DisableControls;
                     Try
                        DataLink.DataSet.Last;
                        While Not DataLink.DataSet.BOF Do
                        Begin
                           If Fields[ColNo].Value <> Null Then
                           Begin
                              If FFullSizeMemo = False Then
                                 NewWidth := Canvas.TextWidth(Fields[ColNo].DisplayText)
                              Else
                              Begin
                                 If (Fields[ColNo].DataType = ftMemo) Or
                                    (Fields[ColNo].DataType = ftFmtMemo) Then
                                    NewWidth := Canvas.TextWidth(Fields[ColNo].Value)
                                 Else
                                    NewWidth := Canvas.TextWidth(Fields[ColNo].DisplayText);
                              End;
                              If NewWidth > MaxWidth Then
                                 MaxWidth := NewWidth;
                           End;
                           DataLink.DataSet.Prior;
                        End;
                     Finally
                        DataLink.DataSet.EnableControls;
                     End;
                     If MaxWidth = 0 Then
                        Columns[ColNo].Width := Columns[ColNo].DefaultWidth
                     Else
                     Begin
                        Inc(MaxWidth, 5);
                        If MaxWidth > Self.ClientWidth Then
                           Columns[ColNo].Width := Self.ClientWidth
                        Else
                           Columns[ColNo].Width := MaxWidth;
                     End;
                  End;
            End

            Else If FAutoWidth = awDefault Then
            Begin // Default
               For ColNo := 0 To MaxColNo Do
                  If Columns[ColNo].Visible Then
                     Columns[ColNo].Width := Columns[ColNo].DefaultWidth;
            End

            Else
            Begin // Proportional & uniform
               ColumnCount := 0;
               Available := Self.ClientWidth;
               Total := 0;
               For ColNo := 0 To MaxColNo Do
                  If Columns[ColNo].Visible Then
                  Begin
                     Inc(ColumnCount);
                     If dgColLines In Options Then
                        Dec(Available, GridLineWidth);
                     Inc(Total, Columns[ColNo].Width);
                  End;
               If dgIndicator In Options Then
               Begin
                  Dec(Available, IndicatorWidth);
                  If dgColLines In Options Then
                     Dec(Available, GridLineWidth);
               End;
               OldAvail := Available;
               For ColNo := 0 To MaxColNo Do
                  If Columns[ColNo].Visible Then
                  Begin
                     If FAutoWidth = awProportional Then
                     Begin // Proportional
                        NewWidth := Round((Columns[ColNo].Width / Total) * OldAvail);
                        Dec(Available, NewWidth);
                        Dec(ColumnCount);
                        If ColumnCount = 0 Then
                           Columns[ColNo].Width := NewWidth + Available
                        Else
                           Columns[ColNo].Width := NewWidth;
                     End
                     Else
                     Begin // Uniform
                        NewWidth := Available Div ColumnCount;
                        If ColNo < (Available Mod ColumnCount) Then
                           Columns[ColNo].Width := NewWidth + 1
                        Else
                           Columns[ColNo].Width := NewWidth;
                     End;
                  End;
            End;

         Finally
            EndUpdate;
            Screen.Cursor := crDefault;
            FLockedWidth := False;
         End;
      End;
      If Not ((csLoading In ComponentState) Or FAutoWidthOnResize) Then //1.1
         SetAutoWidth(awNone);
   End;
End;

Procedure TUltimDBGrid.SetAutoWidthOnResize(Value: Boolean);
Begin
   If FAutoWidthOnResize <> Value Then
   Begin
      FAutoWidthOnResize := Value;
      If FAutoWidthOnResize Then
         SetAutoWidth(FAutoWidth);
   End;
End;

Procedure TUltimDBGrid.SetDisplayBoolean(Value: Boolean);
Begin
   If FDisplayBoolean <> Value Then
   Begin
      FDisplayBoolean := Value;
      Invalidate;
   End;
End;

Procedure TUltimDBGrid.SetDisplayImages(Value: Boolean);
Begin
   If FDisplayImages <> Value Then
   Begin
      FDisplayImages := Value;
      Invalidate;
   End;
End;

Procedure TUltimDBGrid.SetDisplayMemo(Value: Boolean);
Begin
   If FDisplayMemo <> Value Then
   Begin
      FDisplayMemo := Value;
      If FDisplayMemo = False Then
         SetFullSizeMemo(False);
      Invalidate;
   End;
End;

Procedure TUltimDBGrid.SetFullSizeMemo(Value: Boolean);
Var
   ColNo: Integer;
   NewWidth, MaxWidth: Integer;
Begin
   If FFullSizeMemo <> Value Then
   Begin
      FFullSizeMemo := Value;
      If FFullSizeMemo = True Then
      Begin
         SetDisplayMemo(True);
         If Not (FAutoWidth In [awNone, awWidestValue, awWidestValueTitle]) Then
            SetAutoWidth(awNone);
      End;
      If DataLink.Active Then
      Begin
         FLockedWidth := True;
         BeginUpdate;
         Try
            For ColNo := 0 To MaxColIndex Do
               If ((Fields[ColNo].DataType = ftMemo) Or (Fields[ColNo].DataType = ftFmtMemo)) And
                  Columns[ColNo].Visible Then
               Begin
                  Canvas.Font.Assign(Columns[ColNo].Font); //1.1

                  If FFullSizeMemo = False Then
                     MaxWidth := Canvas.TextWidth(Fields[ColNo].DisplayText)
                  Else
                  Begin
                     MaxWidth := 0;
                     DataLink.DataSet.DisableControls;
                     Try
                        DataLink.DataSet.Last;
                        While Not DataLink.DataSet.BOF Do
                        Begin
                           If Fields[ColNo].Value <> Null Then
                           Begin
                              NewWidth := Canvas.TextWidth(Fields[ColNo].Value);
                              If NewWidth > MaxWidth Then
                                 MaxWidth := NewWidth;
                           End;
                           DataLink.DataSet.Prior;
                        End;
                     Finally
                        DataLink.DataSet.EnableControls;
                     End;
                  End;

                  If MaxWidth = 0 Then
                     Columns[ColNo].Width := Columns[ColNo].DefaultWidth
                  Else
                  Begin
                     Inc(MaxWidth, 5);
                     If MaxWidth > Self.ClientWidth Then
                        Columns[ColNo].Width := Self.ClientWidth
                     Else
                        Columns[ColNo].Width := MaxWidth;
                  End;
               End;
         Finally
            EndUpdate;
            FLockedWidth := False;
         End;
      End;
   End;
End;

Procedure TUltimDBGrid.SetUseRowColors(Value: Boolean);
Begin
   If FUseRowColors <> Value Then
   Begin
      FUseRowColors := Value;
      Invalidate;
   End;
End;

Procedure TUltimDBGrid.SetRowColor(Index: Integer; Value: TColor);
Begin
   If FRowColors[Index] <> Value Then
   Begin
      FRowColors[Index] := Value;
      If FUseRowColors Then
         Invalidate;
   End;
End;

Procedure TUltimDBGrid.SetRowSizingAllowed(Value: Boolean);
Begin
   If FRowSizingAllowed <> Value Then
   Begin
      FRowSizingAllowed := Value;
      If FRowSizingAllowed Then
         TDrawGrid(Self).Options := TDrawGrid(Self).Options + [goRowSizing]
      Else
         TDrawGrid(Self).Options := TDrawGrid(Self).Options - [goRowSizing];
   End;
End;

Procedure TUltimDBGrid.LockHeight;
Begin
   Inc(FLockedHeight);
End;

Procedure TUltimDBGrid.UnLockHeight;
Begin
   Dec(FLockedHeight);
End;

Procedure TUltimDBGrid.CalcTitleHeight;
Var
   ColNo, NewHeight: Integer;
Begin
   If dgTitles In Options Then
   Begin
      If FTitleRowHeight = 0 Then
      Begin
         If (Columns.Count > 0) And HandleAllocated Then
         Begin
            For ColNo := 0 To MaxColIndex Do
               If Columns[ColNo].Visible Then
               Begin
                  Canvas.Font.Assign(Columns[ColNo].Title.Font); //1.1
                  NewHeight := Canvas.TextHeight('_');
                  If NewHeight > FTitleRowHeight Then
                     FTitleRowHeight := NewHeight;
               End;
         End;

         If FTitleRowHeight = 0 Then
            FTitleRowHeight := DefaultRowHeight
         Else
            Inc(FTitleRowHeight, 4);
      End;
      RowHeights[0] := FTitleRowHeight;
   End;
End;

Function TUltimDBGrid.GetDefaultRowHeight: Integer;
Begin
   Result := Inherited DefaultRowHeight;
End;

Procedure TUltimDBGrid.SetDefaultRowHeight(Value: Integer);
Begin
   If (Value <> FNewDefRowHeight) Or (Value <> Inherited DefaultRowHeight) Then
   Begin
      LockHeight;
      Try
         If Value = 0 Then
            FNewDefRowHeight := Inherited DefaultRowHeight
         Else
         Begin
            FNewDefRowHeight := Value;
            BeginUpdate;
            Try
               Inherited DefaultRowHeight := Value;
               CalcTitleHeight;
            Finally
               EndUpdate;
            End;
         End;
      Finally
         UnLockHeight;
      End;
   End;
End;

Procedure TUltimDBGrid.PopUpHint(ClientX, ClientY: Integer);
Var
   CellX, CellY: Integer;
   Field: TField;
   OldActive: Integer;
   HintMsg: String;
   HintRect: TRect;
   Pt: TPoint;
Begin
   If Assigned(FHintWnd) And HandleAllocated And DataLink.Active Then
   Begin
      MouseToCell(ClientX, ClientY, CellX, CellY);
      If dgIndicator In Options Then
         Dec(CellX);
      If dgTitles In Options Then
         Dec(CellY);
      If (CellX >= 0) And (CellY >= 0) Then
      Begin
         Field := Columns[CellX].Field;
         If (Field.DataType = ftMemo) Or (Field.DataType = ftFmtMemo) Or
            Not (Field Is TBlobField) Then
         Begin
            OldActive := DataLink.ActiveRecord;
            Try
               DataLink.ActiveRecord := CellY;
               If (Field.DataType = ftMemo) Or (Field.DataType = ftFmtMemo) Then //1.1
                  HintMsg := Field.AsString
               Else //1.1
                  HintMsg := Field.DisplayText;
               {End;} //1.1
            Finally
               DataLink.ActiveRecord := OldActive;
            End;
            If HintMsg <> '' Then
            Begin
               Canvas.Font.Assign(Columns[CellX].Font); //1.1
               If (Canvas.TextWidth(HintMsg) + 2) > Columns[CellX].Width Then
               Begin
                  HintRect := FHintWnd.CalcHintRect(Screen.Width SHR 1, HintMsg, Nil);
                  Pt.X := ClientX;
                  Pt.Y := ClientY;
                  Pt := ClientToScreen(Pt);
                  OffsetRect(HintRect, Pt.X, Pt.Y + 16);
                  FHintWnd.ActivateHint(HintRect, HintMsg);
               End
               Else
                  FHintWnd.ReleaseHandle;
            End
            Else
               FHintWnd.ReleaseHandle;
         End
         Else
            FHintWnd.ReleaseHandle;
      End
      Else
         FHintWnd.ReleaseHandle;
   End;
End;

Procedure TUltimDBGrid.SetCellHints(Value: Boolean);
Begin
   If FCellHints <> Value Then
   Begin
      FCellHints := Value;
      If (FCellHints = False) And Assigned(FHintWnd) Then
         FHintWnd.ReleaseHandle;
   End;
End;

Procedure TUltimDBGrid.SetShowTextEllipsis(Value: Boolean);
Begin
   If FShowTextEllipsis <> Value Then
   Begin
      FShowTextEllipsis := Value;
      Invalidate;
   End;
End;

Procedure TUltimDBGrid.SetMultiLines(Value: Boolean);
Begin
   If FMultiLines <> Value Then
   Begin
      FMultiLines := Value;
      Invalidate;
   End;
End;

Procedure TUltimDBGrid.SetSortOnTitleClick(Value: Boolean);
Begin
   If FSortOnTitleClick <> Value Then
   Begin
      FSortOnTitleClick := Value;
      If FSortOnTitleClick Then
         TitleButtons := True;
      Invalidate;
   End;
End;

Procedure TUltimDBGrid.ShowPopUpMenu(X, Y: Integer);
Const
   NbFixedCols = 7;
Var
   Itm: Integer;
   NewItem, NewSubItem: TMenuItem;
   Pt: TPoint;
Begin
   If Not (csDesigning In ComponentState) Then
   Begin
      With FGridPopUpMenu Do
      Begin
         { Cration du menu ? }
         If Items.Count = 0 Then
         Begin
            PopupComponent := Self;

            NewItem := TMenuItem.Create(FGridPopUpMenu);
            NewItem.Caption := lsMenus[0];
            For Itm := 0 To 4 Do
            Begin
               NewSubItem := TMenuItem.Create(FGridPopUpMenu);
               NewSubItem.Caption := lsMenusAW[Itm];
               NewItem.Add(NewSubItem);
            End;
            NewItem.Items[0].OnClick := MenuAWDefault;
            NewItem.Items[1].OnClick := MenuAWProportional;
            NewItem.Items[2].OnClick := MenuAWUniform;
            NewItem.Items[3].OnClick := MenuAWWidestValue;
            NewItem.Items[4].OnClick := MenuAWWidestValueTitle;
            Items.Add(NewItem);

            For Itm := 1 To 5 Do
            Begin
               NewItem := TMenuItem.Create(FGridPopUpMenu);
               NewItem.Caption := lsMenus[Itm];
               Items.Add(NewItem);
            End;
            Items[1].OnClick := MenuAWOnResize;
            Items[2].OnClick := MenuAllowColResizing;
            Items[3].OnClick := MenuAllowRowResizing;

            NewItem := TMenuItem.Create(FGridPopUpMenu);
            NewItem.Caption := lsMenus[6];
            For Itm := 0 To NbFixedCols Do
            Begin
               NewSubItem := TMenuItem.Create(FGridPopUpMenu);
               If Itm < 2 Then
                  NewSubItem.Caption := IntToStr(Itm) + lsMenusFC[0]
               Else
                  NewSubItem.Caption := IntToStr(Itm) + lsMenusFC[1];
               NewSubItem.Tag := Itm;
               NewSubItem.OnClick := MenuSetFixedCols;
               NewItem.Add(NewSubItem);
            End;
            Items.Add(NewItem);

            For Itm := 7 To 37 Do
            Begin
               NewItem := TMenuItem.Create(FGridPopUpMenu);
               NewItem.Caption := lsMenus[Itm];
               Items.Add(NewItem);
            End;
            Items[7].OnClick := MenuShowHideColumns;
            Items[8].OnClick := MenuSortColumns;
            Items[11].OnClick := MenuSetFilter;
            Items[12].OnClick := MenuActivateFilter;
            Items[13].OnClick := MenuAddFilter;
            Items[16].OnClick := MenuDisplayBoolean;
            Items[17].OnClick := MenuDisplayImages;
            Items[18].OnClick := MenuDisplayMemo;
            Items[19].OnClick := MenuFullSizeMemo;
            Items[20].OnClick := MenuUseRowColors;
            Items[21].OnClick := MenuSetCellHints;
            Items[22].OnClick := MenuShowTextEllipsis;
            Items[23].OnClick := MenuSetMultiLines;
            Items[26].OnClick := MenuSetEnterAsTab;
            Items[29].OnClick := MenuExportGrid;
            Items[30].OnClick := MenuPrintGrid;
            Items[33].OnClick := MenuSetReadOnly;
            Items[36].OnClick := MenuConfig;
            Items[36].Tag := tagSAVE;
            Items[37].OnClick := MenuConfig;
            Items[37].Tag := tagRESTORE;
         End;
         { Mise  jour des valeurs }
         Items[0].Items[0].Checked := (FAutoWidth = awDefault);
         Items[0].Items[1].Checked := (FAutoWidth = awProportional);
         Items[0].Items[2].Checked := (FAutoWidth = awUniform);
         Items[0].Items[3].Checked := (FAutoWidth = awWidestValue);
         Items[0].Items[4].Checked := (FAutoWidth = awWidestValueTitle);
         Items[0].Visible := mnuAutoWidth In FOptionsMenuItems;
         Items[1].Checked := FAutoWidthOnResize;
         Items[1].Visible := mnuAutoWidthOnResize In FOptionsMenuItems;
         Items[2].Checked := (dgColumnResize In Options);
         Items[2].Visible := mnuAllowColResizing In FOptionsMenuItems;
         Items[3].Checked := FRowSizingAllowed;
         Items[3].Visible := mnuAllowRowResizing In FOptionsMenuItems;
         For Itm := 0 To NbFixedCols Do
            Items[6].Items[Itm].Checked := (FixedCols = Itm);
         Items[6].Visible := mnuSetFixedColumns In FOptionsMenuItems;
         Items[7].Visible := mnuShowHideColumns In FOptionsMenuItems;
         Items[8].Visible := mnuSortColumns In FOptionsMenuItems;
         Items[11].Visible := mnuSetFilter In FOptionsMenuItems;
         If DataLink.DataSet.Filter = '' Then
            Items[12].Visible := False
         Else
         Begin
            If Length(DataLink.DataSet.Filter) > 40 Then
               Items[12].Caption := lsMenus[12] + ': ' + Copy(DataLink.DataSet.Filter, 1, 37) +
                  '...'
            Else
               Items[12].Caption := lsMenus[12] + ': ' + DataLink.DataSet.Filter;
            Items[12].Checked := DataLink.DataSet.Filtered;
            Items[12].Visible := mnuUseFilter In FOptionsMenuItems;
         End;
         Items[13].Visible := Items[12].Visible And (mnuAddCurrentFilter In FOptionsMenuItems);
         Items[16].Checked := FDisplayBoolean;
         Items[16].Visible := mnuDisplayBooleans In FOptionsMenuItems;
         Items[17].Checked := FDisplayImages;
         Items[17].Visible := mnuDisplayImages In FOptionsMenuItems;
         Items[18].Checked := FDisplayMemo;
         Items[18].Visible := mnuDisplayMemo In FOptionsMenuItems;
         Items[19].Checked := FFullSizeMemo;
         Items[19].Visible := mnuFullSizeMemo In FOptionsMenuItems;
         Items[20].Checked := FUseRowColors;
         Items[20].Visible := mnuUseRowColors In FOptionsMenuItems;
         Items[21].Checked := FCellHints;
         Items[21].Visible := mnuShowCellHints In FOptionsMenuItems;
         Items[22].Checked := FShowTextEllipsis;
         Items[22].Visible := mnuShowTextEllipsis In FOptionsMenuItems;
         Items[23].Checked := FMultiLines;
         Items[23].Visible := mnuMultiLinesCell In FOptionsMenuItems;
         Items[26].Checked := FEnterAsTab;
         Items[26].Visible := mnuEnterKeyAsTab In FOptionsMenuItems;
         Items[29].Visible := mnuExportGrid In FOptionsMenuItems;
         Items[30].Visible := mnuPrintGrid In FOptionsMenuItems;
         Items[33].Checked := Self.ReadOnly;
         Items[33].Visible := mnuReadOnly In FOptionsMenuItems;
         Items[36].Visible := mnuSaveConfiguration In FOptionsMenuItems;
         Items[37].Visible := mnuRestoreConfiguration In FOptionsMenuItems;
         { Affichage du menu }
         Pt.X := X;
         Pt.Y := Y;
         Pt := ClientToScreen(Pt);
         Popup(Pt.X, Pt.Y);
      End;
   End;
End;

Procedure TUltimDBGrid.SetOptionsMenu(Value: Boolean);
Begin
   If FOptionsMenu <> Value Then
   Begin
      FOptionsMenu := Value;
      If FOptionsMenu Then
         Options := Options + [dgIndicator, dgTitles];
      InvalidateTitles;   
   End;
End;

Procedure TUltimDBGrid.MenuAWDefault;
Begin
   If TMenuItem(Sender).Checked Then
      SetAutoWidth(awNone)
   Else
      SetAutoWidth(awDefault);
End;

Procedure TUltimDBGrid.MenuAWProportional;
Begin
   If TMenuItem(Sender).Checked Then
      SetAutoWidth(awNone)
   Else
      SetAutoWidth(awProportional);
End;

Procedure TUltimDBGrid.MenuAWUniform;
Begin
   If TMenuItem(Sender).Checked Then
      SetAutoWidth(awNone)
   Else
      SetAutoWidth(awUniform);
End;

Procedure TUltimDBGrid.MenuAWWidestValue;
Begin
   If TMenuItem(Sender).Checked Then
      SetAutoWidth(awNone)
   Else
      SetAutoWidth(awWidestValue);
End;

Procedure TUltimDBGrid.MenuAWWidestValueTitle;
Begin
   If TMenuItem(Sender).Checked Then
      SetAutoWidth(awNone)
   Else
      SetAutoWidth(awWidestValueTitle);
End;

Procedure TUltimDBGrid.MenuAWOnResize;
Begin
   SetAutoWidthOnResize(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuAllowColResizing;
Begin
   If TMenuItem(Sender).Checked Then
      Options := Options - [dgColumnResize]
   Else
      Options := Options + [dgColumnResize];
End;

Procedure TUltimDBGrid.MenuAllowRowResizing;
Begin
   SetRowSizingAllowed(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuSetFixedCols;
Begin
   FixedCols := TMenuItem(Sender).Tag;
End;

Procedure TUltimDBGrid.MenuShowHideColumns;
Var
   frmSelect: TFUltimDBSelect;
   I: Integer;
Begin
   frmSelect := TFUltimDBSelect.Create(Self);
   With frmSelect Do
      Try
         Icon := TForm(GetParentForm(Self)).Icon;
         Color := GetParentForm(Self).Color;
         Caption := StringReplace(TMenuItem(Sender).Caption, '&', '', []);
         Caption := StringReplace(Caption, '...', '', []);
         B_Cancel.Caption := lsBtnCancel;
         For I := 0 To Columns.Count - 1 Do
         Begin
            UltimCLB.Items.Add(Columns[I].Title.Caption);
            UltimCLB.Checked[I] := Columns[I].Visible;
         End;
         If ShowModal = mrOk Then
         Begin
            For I := 0 To Columns.Count - 1 Do
               Columns[I].Visible := UltimCLB.Checked[I];
         End;
      Finally
         frmSelect.Free;
      End;
End;

Procedure TUltimDBGrid.MenuSortColumns;
Var
   frmSort: TFUltimDBSort;
   FTS, Sep: Integer;
   FieldsToSort: TSortFields;

   Procedure Fill_FTS_And_Sort;
   Var
      SF: Integer;
   Begin
      With frmSort Do
      Begin
         SetLength(FieldsToSort, SortFieldCount);
         FTS := 0;
         For SF := 1 To 5 Do
            If SortFields[SF] <> '' Then
            Begin
               Sep := Pos('|', SortFields[SF]);
               If Sep > 0 Then
                  FieldsToSort[FTS].Name := Copy(SortFields[SF], Sep + 2, Length(SortFields[SF]))
               Else
                  FieldsToSort[FTS].Name := SortFields[SF];
               FieldsToSort[FTS].Order := Not Descending[SF];
               Inc(FTS);
            End;
         Sort(FieldsToSort);
      End;
   End;

Var
   DSet: TDataSet;
   I, DC: Integer;
   Key: String;
{$IFDEF ADO}
   SynNo: Integer;
   Syntagme,
   Order: String;
{$ENDIF}
{$IFDEF BDE}
   TableBDE: TTable;
   IndexDefBDE: TIndexDefs;
{$ENDIF}
   ShowForm: Boolean;

Begin
   frmSort := TFUltimDBSort.Create(Self);
   With frmSort Do
      Try
         Icon := TForm(GetParentForm(Self)).Icon;
         Color := GetParentForm(Self).Color;
         Caption := StringReplace(TMenuItem(Sender).Caption, '&', '', []);
         CB_Desc1.Caption := lsDescSort;
         CB_Desc2.Caption := lsDescSort;
         CB_Desc3.Caption := lsDescSort;
         CB_Desc4.Caption := lsDescSort;
         CB_Desc5.Caption := lsDescSort;
         B_Cancel.Caption := lsBtnCancel;
         DSet := DataLink.DataSet;
         {$IFDEF ADO}
         If DSet Is TCustomADODataSet Then
         Begin // Table ou requte ADO
            DC := 0;
            For I := 0 To Columns.Count - 1 Do
               If Not ((Columns[I].Field Is TBlobField) Or (Columns[I].Field Is TBytesField)) Then
               Begin
                  If Columns[I].Title.Caption = Columns[I].FieldName Then
                     LB_Fields.Items.Add(Columns[I].FieldName)
                  Else
                     LB_Fields.Items.Add('"' + Columns[I].Title.Caption + '" | ' +
                        Columns[I].FieldName);
                  Inc(DC);
               End;
            DisplayControls(DC);
            SynNo := 1;
            Repeat
               // Dcoupage et analyse des critres de tri
               Syntagme := Trim(ExtractWord(SynNo, TCustomADODataSet(DSet).Sort, [',']));
               If Syntagme <> '' Then
               Begin
                  If Syntagme[1] = '[' Then
                  Begin
                     Key := ExtractWord(1, Syntagme, ['[', ']']);
                     Order := Trim(Copy(Syntagme, Length(Key) + 4, Length(Syntagme)));
                  End
                  Else
                  Begin
                     Key := ExtractWord(1, Syntagme, [' ']);
                     Order := Trim(Copy(Syntagme, Length(Key) + 2, Length(Syntagme)));
                  End;
                  For I := 0 To LB_Fields.Items.Count - 1 Do
                  Begin // On recherche dans la liste l'item correspondant au critre de tri
                     Sep := Pos('|', LB_Fields.Items[I]);
                     If Sep = 0 Then
                     Begin
                        If SameText(Key, LB_Fields.Items[I]) Then
                           Key := LB_Fields.Items[I];
                     End
                     Else If SameText(Key, Copy(LB_Fields.Items[I], Sep + 2,
                        Length(LB_Fields.Items[I]))) Then
                        Key := LB_Fields.Items[I];
                  End;
                  SetValues(SynNo, Key, (Order = 'DESC'));
                  Inc(SynNo);
               End;
            Until Syntagme = '';
            ShowForm := True;
         End
         Else {$ENDIF}
         {$IFDEF BDE}
         If DSet Is TTable Then
         Begin // Table BDE
            DisplayControls(1);
            CB_Desc1.Visible := False;
            TableBDE := TTable(DSet);
            IndexDefBDE := TableBDE.IndexDefs;
            IndexDefBDE.Update;
            For I := 0 To IndexDefBDE.Count - 1 Do
            Begin
               If IndexDefBDE.Items[I].Name = '' Then
               Begin
                  LB_Fields.Items.Add(IndexDefBDE.Items[I].Fields);
                  If TableBDE.IndexFieldNames = IndexDefBDE.Items[I].Fields Then
                     SortField1.Text := LB_Fields.Items[I];
               End
               Else
               Begin
                  If SameText(IndexDefBDE.Items[I].Name, IndexDefBDE.Items[I].Fields) Then
                     LB_Fields.Items.Add(IndexDefBDE.Items[I].Fields)
                  Else
                     LB_Fields.Items.Add('"' + IndexDefBDE.Items[I].Name + '" | ' +
                        IndexDefBDE.Items[I].Fields);
                  If (TableBDE.IndexName = IndexDefBDE.Items[I].Name) Or
                     (TableBDE.IndexFieldNames = IndexDefBDE.Items[I].Fields) Then
                     SortField1.Text := LB_Fields.Items[I];
               End;
            End;
            ShowForm := True;
         End
         Else {$ENDIF}
         If DSet Is TRxMemoryData Then
         Begin // Table en mmoire
            DC := 0;
            For I := 0 To Columns.Count - 1 Do
               If Not ((Columns[I].Field Is TBlobField) Or (Columns[I].Field Is TBytesField)) Then
               Begin
                  If Columns[I].Title.Caption = Columns[I].FieldName Then
                     LB_Fields.Items.Add(Columns[I].FieldName)
                  Else
                     LB_Fields.Items.Add('"' + Columns[I].Title.Caption + '" | ' +
                        Columns[I].FieldName);
                  Inc(DC);
               End;
            DisplayControls(DC);
            CB_Desc2.Visible := False;
            CB_Desc3.Visible := False;
            CB_Desc4.Visible := False;
            CB_Desc5.Visible := False;
            DC := 0;
            For FTS := 0 To Length(FSortedFields) - 1 Do
            Begin
               Key := FSortedFields[FTS].Name;
               For I := 0 To LB_Fields.Items.Count - 1 Do
               Begin // On recherche dans la liste l'item correspondant au critre de tri
                  Sep := Pos('|', LB_Fields.Items[I]);
                  If Sep = 0 Then
                  Begin
                     If SameText(Key, LB_Fields.Items[I]) Then
                        Key := LB_Fields.Items[I];
                  End
                  Else If SameText(Key, Copy(LB_Fields.Items[I], Sep + 2,
                     Length(LB_Fields.Items[I]))) Then
                     Key := LB_Fields.Items[I];
               End;
               Inc(DC);
               SetValues(DC, Key, Not FSortedFields[0].Order);
            End;
            ShowForm := True;
         End
         Else
         Begin // DataSet non gr
            Application.MessageBox(lsDSNotSupported, lsError, MB_ICONWARNING);
            ShowForm := False;
         End;
         If ShowForm = True Then
            If ShowModal = mrOk Then
            Begin
               {$IFDEF ADO}
               If DSet Is TCustomADODataSet Then
               Begin // Table ou requte ADO
                  If SortFieldCount = 0 Then
                  Begin
                     FSortedFields := Nil;
                     TCustomADODataSet(DSet).Sort := '';
                  End
                  Else
                     Fill_FTS_And_Sort;
               End
               Else {$ENDIF}
               {$IFDEF BDE}
               If DSet Is TTable Then
               Begin // Table BDE
                  If SortFieldCount = 0 Then
                  Begin
                     FSortedFields := Nil;
                     TTable(DSet).IndexName := '';
                     TTable(DSet).IndexFieldNames := '';
                  End
                  Else
                  Begin
                     Sep := Pos('|', SortFields[1]);
                     If Sep > 0 Then
                        Key := Copy(SortFields[1], Sep + 2, Length(SortFields[1]))
                     Else
                        Key := SortFields[1];
                     I := WordCount(Key, [';']);
                     SetLength(FieldsToSort, I);
                     For FTS := 1 To I Do
                        FieldsToSort[Pred(FTS)].Name := ExtractWord(FTS, Key, [';']);
                     Sort(FieldsToSort);
                  End;
               End
               Else {$ENDIF}
               If DSet Is TRxMemoryData Then
               Begin // Table en mmoire
                  If SortFieldCount = 0 Then
                  Begin
                     FSortedFields := Nil;
                     TRxMemoryData(DSet).SortOnFields('');
                     TRxMemoryData(DSet).First;
                  End
                  Else
                     Fill_FTS_And_Sort;
               End;
            End;
      Finally
         frmSort.Free;
      End;
End;

Procedure TUltimDBGrid.MenuSetFilter;
Var
   frmFilter: TFUltimDBFilter;
   I, Sep: Integer;
   FilterField,
   ListField: String;
   Trouve: Boolean;
Begin
   frmFilter := TFUltimDBFilter.Create(Self);
   With frmFilter Do
      Try
         Icon := TForm(GetParentForm(Self)).Icon;
         Color := GetParentForm(Self).Color;
         Caption := StringReplace(lsMenus[11], '&', '', []);
         LblField.Caption := lsField;
         LblFilter.Caption := lsFilterCond;
         LblORExpr.Caption := lsORCompleteExpr;
         LblORPreset.Caption := lsORPreset;
         B_Cancel.Caption := lsBtnCancel;
         { Remplissage de la liste des champs }
         For I := 0 To Columns.Count - 1 Do
            If Not ((Columns[I].Field Is TBlobField) Or (Columns[I].Field Is TBytesField)) Then
            Begin
               If Columns[I].Title.Caption = Columns[I].FieldName Then
                  CB_Field.Items.Add(Columns[I].FieldName)
               Else
                  CB_Field.Items.Add('"' + Columns[I].Title.Caption + '" | ' + Columns[I].FieldName);
            End;
         { Remplissage de la liste des filtres prdfinis }
         For I := 0 To Length(FilterList) - 1 Do
            CB_Presets.Items.Add('"' + Trim(FilterList[I].Name) + '" | ' +
               Trim(FilterList[I].Filter));
         { Initialisation des valeurs du formulaire }
         If DataLink.DataSet.Filter <> '' Then
         Begin
            Filter := Trim(DataLink.DataSet.Filter);
            If Filter[1] = '[' Then
            Begin
               FilterField := ExtractWord(1, Filter, ['[', ']']);
               Filter := Trim(Copy(Filter, Length(FilterField) + 3, Length(Filter)));
            End
            Else
            Begin
               FilterField := ExtractWord(1, Filter, [' ']);
               Filter := Trim(Copy(Filter, Length(FilterField) + 1, Length(Filter)));
            End;
            Trouve := False;
            For I := 0 To CB_Field.Items.Count - 1 Do 
            Begin
               Sep := Pos('|', CB_Field.Items[I]);
               If Sep > 0 Then
                  ListField := Copy(CB_Field.Items[I], Sep + 2, Length(CB_Field.Items[I]))
               Else
                  ListField := CB_Field.Items[I];
               If SameText(FilterField, ListField) Then
               Begin
                  Trouve := True;
                  CB_Field.ItemIndex := I;
                  FilterCond.Text := Filter;
                  Break;
               End;
            End;
            If Not Trouve Then
               ExprCompl.Text := Trim(DataLink.DataSet.Filter);
         End;
         { dition/slection du filtre }
         If ShowModal = mrOk Then
         Begin
            DataLink.DataSet.Filter := Filter;
            DataLink.DataSet.Filtered := True;
         End;
      Finally
         frmFilter.Free;
      End;
End;

Procedure TUltimDBGrid.MenuActivateFilter;
Begin
   DataLink.DataSet.Filtered := Not TMenuItem(Sender).Checked;
End;

Procedure TUltimDBGrid.MenuAddFilter;
Var
   Title,
   FilterName: String;
Begin
   If (DataLink.DataSet <> Nil) And (DataLink.DataSet.Filter <> '') Then
   Begin
      Title := StringReplace(TMenuItem(Sender).Caption, '&', '', []);
      Title := StringReplace(Title, '...', '', []);
      Repeat
         If Not InputQuery(Title, lsAskFilterName, FilterName) Then
            Exit;
         FilterName := Trim(FilterName);
      Until FilterName <> '';
      SetLength(FilterList, Length(FilterList) + 1);
      FilterList[Length(FilterList) - 1].Name := FilterName;
      FilterList[Length(FilterList) - 1].Filter := DataLink.DataSet.Filter;
   End;
End;

Procedure TUltimDBGrid.MenuDisplayBoolean;
Begin
   SetDisplayBoolean(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuDisplayImages;
Begin
   SetDisplayImages(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuDisplayMemo;
Begin
   SetDisplayMemo(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuFullSizeMemo;
Begin
   SetFullSizeMemo(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuUseRowColors;
Begin
   SetUseRowColors(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuSetCellHints;
Begin
   SetCellHints(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuShowTextEllipsis;
Begin
   SetShowTextEllipsis(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuSetMultiLines;
Begin
   SetMultiLines(Not TMenuItem(Sender).Checked);
End;

Procedure TUltimDBGrid.MenuSetEnterAsTab;
Begin
   FEnterAsTab := Not TMenuItem(Sender).Checked;
End;

Procedure TUltimDBGrid.MenuExportGrid;
Var
   frmExport: TFUltimDBExport;
Begin
   frmExport := TFUltimDBExport.Create(Self);
   With frmExport Do
      Try
         Icon := TForm(GetParentForm(Self)).Icon;
         Color := GetParentForm(Self).Color;
         Caption := StringReplace(lsMenus[29], '&', '', []);
         Caption := StringReplace(Caption, '...', '', []);
         ExportFileName.FileName := ExtractFilePath(ParamStr(0)) + DefaultExportName;
         ExportFileName.DialogTitle := Caption;
         CB_Titles.Caption := lsWithTitles;
         LblDelim.Caption := lsDelimiter;
         E_Delim.Text := DefaultDelimiter;
         B_Cancel.Caption := lsBtnCancel;
         If ShowModal = mrOk Then
         Begin
            If RB_FormatHTML.Checked Then
               ExportToFile(ExportFileName.FileName, efHTML, CB_Titles.Checked, DefaultDelimiter)
            Else If RB_FormatSYLK.Checked Then
               ExportToFile(ExportFileName.FileName, efSYLK, CB_Titles.Checked, DefaultDelimiter)
            Else
               ExportToFile(ExportFileName.FileName, efText, CB_Titles.Checked, E_Delim.Text[1]);
         End;
      Finally
         frmExport.Free;
      End;
End;

Procedure TUltimDBGrid.MenuPrintGrid;
Begin
   If Assigned(FOnMenuPrintGrid) Then
      FOnMenuPrintGrid(Self)
   {$IFDEF QREPORT}
   Else
   Begin
      SaveGridPosition;
      GetParentForm(Self).Enabled := False;
      Try
         PreviewReport(Self, FReportTitle, RowHeights[0], DefaultRowHeight);
      Finally
         GetParentForm(Self).Enabled := True;
         RestoreGridPosition;
      End;
   End
   {$ENDIF};
End;

Procedure TUltimDBGrid.MenuSetReadOnly;
Begin
   ReadOnly := Not TMenuItem(Sender).Checked;
   If ReadOnly And (DataLink <> Nil) And DataLink.Active And
      (DataLink.DataSet.State In [dsEdit, dsInsert]) Then
      DataLink.DataSet.Cancel;
End;

Procedure TUltimDBGrid.MenuConfig;
Var
   frmConfig: TFUltimDBConfig;
Begin
   frmConfig := TFUltimDBConfig.Create(Self);
   With frmConfig Do
      Try
         Icon := TForm(GetParentForm(Self)).Icon;
         Color := GetParentForm(Self).Color;
         Caption := StringReplace(TMenuItem(Sender).Caption, '&', '', []);
         Caption := StringReplace(Caption, '...', '', []);
         SaveForm := (TMenuItem(Sender).Tag = tagSAVE);
         INIFileName.FileName := ConfigFileName;
         INIFileName.DefaultExt := 'INI';
         INIFileName.Filter := lsINIFilter + '|' + lsDefaultFilter;
         INIFileName.DialogTitle := Caption;
         INIFileName.DirectInput := SaveForm;
         CB_Layout.Caption := lsCfgLayout;
         CB_Layout.Checked := (cfgLayout In ConfigOptions);
         CB_SortSettings.Caption := lsCfgSortSettings;
         CB_SortSettings.Checked := (cfgSortSettings In ConfigOptions);
         CB_Filters.Caption := lsCfgFilters;
         CB_Filters.Checked := (cfgFilters In ConfigOptions);
         B_Cancel.Caption := lsBtnCancel;
         If ShowModal = mrOk Then
         Begin
            { Mmorisation des choix de l'utilisateur }
            ConfigFileName := INIFileName.FileName;
            If CB_Layout.Checked Then
               ConfigOptions := ConfigOptions + [cfgLayout]
            Else
               ConfigOptions := ConfigOptions - [cfgLayout];
            If CB_SortSettings.Checked Then
               ConfigOptions := ConfigOptions + [cfgSortSettings]
            Else
               ConfigOptions := ConfigOptions - [cfgSortSettings];
            If CB_Filters.Checked Then
               ConfigOptions := ConfigOptions + [cfgFilters]
            Else
               ConfigOptions := ConfigOptions - [cfgFilters];
            { Sauvegarde/chargement }
            If SaveForm Then
               SaveGridConfig(ConfigFileName, CB_Layout.Checked, CB_SortSettings.Checked,
                  CB_Filters.Checked)
            Else
               RestoreGridConfig(ConfigFileName, CB_Layout.Checked, CB_SortSettings.Checked,
                  CB_Filters.Checked);
         End;
      Finally
         frmConfig.Free;
      End;
End;

{-------------------------------------------- FOOTER ---------------------------------------------}

Procedure TUltimDBGrid.RegisterFooter(Footer: TWinControl);
Begin
   If Footer Is TUltimDBFooter Then
   Begin
      FFooter := TUltimDBFooter(Footer);
      If (DataSource <> Nil) And (DataSource.DataSet <> Nil) And DataSource.DataSet.Active Then
         TUltimDBFooter(FFooter).FooterMessage(FTR_ACTIVE);
   End
   Else
      FFooter := Nil;
End;

Procedure TUltimDBGrid.UnregisterFooter(Footer: TWinControl);
Begin
   FFooter := Nil;
End;

Procedure TUltimDBGrid.SendFooterMsg(Msg: Integer);
Begin
   If FFooter <> Nil Then
      TUltimDBFooter(FFooter).FooterMessage(Msg);
End;

End.