Unit Unit1;

Interface

Uses
   Windows, SysUtils, Forms, Graphics, Controls, ExtCtrls, Classes, DB, DBTables, DBCtrls, Grids,
   DBGrids, RXDBCtrl, UltimDBGrid, UltimDBFooter, StdCtrls;

Type
   TForm1 = Class(TForm)
      DataSource1: TDataSource;
      Query1: TQuery;
      Panel1: TPanel;
      UltimDBGrid: TUltimDBGrid;
      DBNavigator1: TDBNavigator;
      UltimDBFooter: TUltimDBFooter;
      B_Filtre: TButton;
      Image1: TImage;
      Procedure FormShow(Sender: TObject);
      Procedure UltimDBFooterBeforeDisplayText(FooterBar: TUltimDBFooter; Column: TFooterColumn;
         Const Value: Variant; Var Text: String; Var Style: TFooterPanelStyle);
      Procedure UltimDBFooterDrawPanel(FooterBar: TUltimDBFooter; Panel: TFooterPanel;
         Const Rect: TRect);
      Procedure B_FiltreClick(Sender: TObject);
      Procedure DataSource1DataChange(Sender: TObject; Field: TField);
   Private
   Public
   End;

Var
   Form1: TForm1;

Implementation

{$R *.DFM}

Procedure TForm1.FormShow(Sender: TObject);
Begin
   Query1.Open;
End;

Var
   GreaterThan100k: String;

Procedure TForm1.UltimDBFooterBeforeDisplayText(FooterBar: TUltimDBFooter; Column: TFooterColumn;
   Const Value: Variant; Var Text: String; Var Style: TFooterPanelStyle);
Begin
   If (Column.FieldName = 'Qty') Or (Column.FieldName = 'Description') Then
      Style := psOwnerDraw;
   If Column.FieldName = 'Cost' Then
   Begin
      If (Value = Null) Or (String(Value) = FTR_ERROR) Then
         GreaterThan100k := ''
      Else If Trunc(Currency(Value)) > 100000 Then
         GreaterThan100k := '> 100 000'
      Else
         GreaterThan100k := '< 100 000';
      Style := psOwnerDraw;
   End;
End;

Procedure TForm1.UltimDBFooterDrawPanel(FooterBar: TUltimDBFooter; Panel: TFooterPanel;
   Const Rect: TRect);
Var
   DrawRect: TRect;
   DispParams: Integer;
   DispText: String;
Begin
   With FooterBar Do
   Begin
      DrawRect := Rect;
      DispParams := DT_NOPREFIX Or DT_END_ELLIPSIS;

      // Remplissage du fond
      Canvas.Brush.Color := UltimDBFooter.Color;
      If Panel.FieldName <> 'Description' Then
         Canvas.Brush.Color := Canvas.Brush.Color + $101010;
      Canvas.FillRect(DrawRect);

      If Panel.FieldName = 'Qty' Then
      Begin
         // Nombre
         Canvas.Font.Color := clBlack;
         DispText := 'Count = ' + IntToStr(Query1.RecordCount);
         DrawText(Canvas.Handle, PChar(DispText), Length(DispText), DrawRect,
            DispParams Or DT_CENTER);
         // Somme
         Inc(DrawRect.Top, 15);
         Canvas.Font.Color := clBlue;
         DispText := 'Sum = ' + Panel.Text;
         DrawText(Canvas.Handle, PChar(DispText), Length(DispText), DrawRect,
            DispParams Or DT_CENTER);
      End

      Else If Panel.FieldName = 'Description' Then
      Begin
         // Affichage d'une image
         Inc(DrawRect.Top, 4);
         DrawRect.Left := DrawRect.Left + ((DrawRect.Right - DrawRect.Left - Image1.Width) SHR 1);
         If DrawRect.Left < Rect.Left Then
            DrawRect.Left := Rect.Left;
         DrawRect.Right := DrawRect.Left + Image1.Width;
         Canvas.Draw(DrawRect.Left, DrawRect.Top, Image1.Picture.Bitmap)
      End

      Else If Panel.FieldName = 'Cost' Then
      Begin
         // > 100k ?
         If GreaterThan100k = '> 100 000' Then
            Canvas.Font.Color := clBlack
         Else
            Canvas.Font.Color := clRed;
         DrawText(Canvas.Handle, PChar(GreaterThan100k), Length(GreaterThan100k), DrawRect,
            DispParams Or DT_RIGHT);
         // Somme
         Inc(DrawRect.Top, 15);
         Canvas.Font.Color := clBlue;
         DrawText(Canvas.Handle, PChar(Panel.Text), Length(Panel.Text), DrawRect,
            DispParams Or DT_RIGHT);
      End;
   End;
End;

Procedure TForm1.B_FiltreClick(Sender: TObject);
Begin
   If Query1.Filtered Then
   Begin
      Query1.Filtered := False;
      UltimDBFooter.UpdateDataPanels(True);
   End
   Else
   Begin
      Query1.Filtered := True;
      UltimDBFooter.UpdateDataPanels(True);
   End;
End;

Procedure TForm1.DataSource1DataChange(Sender: TObject; Field: TField);
Const
   clGREEN = TColor($C0DCC0);
   clPINK = TColor($DCC0DC);
Begin
   If Query1.Filtered Then
   Begin
      If UltimDBGrid.FixedColor <> clPINK Then
      Begin
         UltimDBGrid.FixedColor := clPINK;
         UltimDBFooter.Color := clPINK;
         B_Filtre.Caption := 'Without/sans filter';
      End;
   End
   Else
   Begin
      If UltimDBGrid.FixedColor <> clGREEN Then
      Begin
         UltimDBGrid.FixedColor := clGREEN;
         UltimDBFooter.Color := clGREEN;
         B_Filtre.Caption := 'With/avec filter';
      End;
   End;
End;

End.