Unit Unit1;

Interface

Uses
   Windows, SysUtils, Forms, Graphics, Controls, ExtCtrls, Classes, DB, DBTables, ADODB, DBCtrls,
   Grids, DBGrids, RXDBCtrl, UltimDBGrid, UltimDBFooter;

Type
   TForm1 = Class(TForm)
      ADOTable1: TADOTable;
      DataSource2: TDataSource;
      Panel1: TPanel;
      UltimDBGrid1: TUltimDBGrid;
      DBNavigator2: TDBNavigator;
      UltimDBFooter1: TUltimDBFooter;
      Splitter1: TSplitter;
      BDETable2: TTable;
      DataSource1: TDataSource;
      Panel2: TPanel;
      UltimDBGrid2: TUltimDBGrid;
      DBNavigator1: TDBNavigator;
      UltimDBFooter2: TUltimDBFooter;
      Procedure FormShow(Sender: TObject);
      Procedure UltimDBFooter1BeforeReadFields(FooterBar: TUltimDBFooter);
      Procedure UltimDBFooter1ReadFieldValue(FooterBar: TUltimDBFooter; Column: TFooterColumn;
         Const Value: Variant);
      Procedure UltimDBFooter1BeforeDisplayText(FooterBar: TUltimDBFooter; Column: TFooterColumn;
         Const Value: Variant; Var Text: String; Var Style: TFooterPanelStyle);
      Procedure UltimDBFooter2BeforeDisplayText(FooterBar: TUltimDBFooter; Column: TFooterColumn;
         Const Value: Variant; Var Text: String; Var Style: TFooterPanelStyle);
      Procedure UltimDBFooterDrawPanel(FooterBar: TUltimDBFooter; Panel: TFooterPanel;
         Const Rect: TRect);
      Procedure UltimDBGrid1GetCellProps(Sender: TObject; Field: TField; AFont: TFont;
         Var Background: TColor);
      Procedure ADOTable1AfterRefresh(DataSet: TDataSet);
      Procedure BDETable2AfterRefresh(DataSet: TDataSet);
      Procedure PanelResize(Sender: TObject);
   Private
   Public
   End;

Var
   Form1: TForm1;

Implementation

{$R *.DFM}

Var
   RepCount,
   OthCount,
   NulCount: Integer;
   GridCol,
   GridRow: Longint;

Procedure TForm1.FormShow(Sender: TObject);
Begin
   ADOTable1.Open;
   BDETable2.Open;
End;

Procedure TForm1.UltimDBFooter1BeforeReadFields(FooterBar: TUltimDBFooter);
Begin
   RepCount := 0;
   OthCount := 0;
   NulCount := 0;
End;

Procedure TForm1.UltimDBFooter1ReadFieldValue(FooterBar: TUltimDBFooter; Column: TFooterColumn;
   Const Value: Variant);
Begin
   If Column.FieldName = 'Fonction' Then
   Begin
      If (Value = Null) Or (String(Value) = FTR_ERROR) Then
         Inc(NulCount)
      Else If Value = 'Reprsentant(e)' Then
         Inc(RepCount)
      Else
         Inc(OthCount);
   End;
   (*
   // Pour voir toutes les valeurs lues:
   If Value = Null Then
      Application.MessageBox(PChar(FooterBar.Name + '.' + Column.FieldName + ' = Null'), '', 0)
   Else
      Application.MessageBox(PChar(FooterBar.Name + '.' + Column.FieldName + ' = ' + String(Value)), '', 0);
   *)
End;

Procedure TForm1.UltimDBFooter1BeforeDisplayText(FooterBar: TUltimDBFooter; Column: TFooterColumn;
   Const Value: Variant; Var Text: String; Var Style: TFooterPanelStyle);
Begin
   If Column.FieldName = 'N employ' Then
      Style := psOwnerDraw
   Else If Column.FieldName = 'Pays' Then 
      Text := 'C=' + IntToStr(GridCol) + ', R=' + IntToStr(GridRow)
   Else If Column.FieldName = 'Fonction' Then
      Text := 'Rep:' + IntToStr(RepCount) + ' | Oth:' + IntToStr(OthCount) +
         ' | Nul:' + IntToStr(NulCount);
   (*
   // Pour voir tous les textes avant leur affichage:
   If Value = Null Then
      Application.MessageBox(PChar(FooterBar.Name + '.' + Column.FieldName + ' = Null | ' + Text), '', 0)
   Else
      Application.MessageBox(PChar(FooterBar.Name + '.' + Column.FieldName + ' = ' + String(Value) + ' | ' + Text), '', 0);
   *)
End;

Procedure TForm1.UltimDBFooter2BeforeDisplayText(FooterBar: TUltimDBFooter; Column: TFooterColumn;
   Const Value: Variant; Var Text: String; Var Style: TFooterPanelStyle);
Begin
   If Column.FieldName = 'Species no' Then
      Style := psOwnerDraw;
End;

Procedure TForm1.UltimDBFooterDrawPanel(FooterBar: TUltimDBFooter; Panel: TFooterPanel;
   Const Rect: TRect);
Var
   DrawRect: TRect;
Begin
   // Dessin personnalis
   With  FooterBar Do
   Begin
      DrawRect := Rect;
      Canvas.Brush.Color := clYellow;
      Canvas.FillRect(DrawRect);
      Canvas.Font.Color := clRed;
      Canvas.Font.Style := Canvas.Font.Style + [fsBold];
      DrawText(Canvas.Handle, PChar(Panel.Text), Length(Panel.Text), DrawRect,
         DT_NOPREFIX Or DT_CENTER Or DT_END_ELLIPSIS);
   End;
End;

Procedure TForm1.UltimDBGrid1GetCellProps(Sender: TObject; Field: TField; AFont: TFont;
   Var Background: TColor);
Begin
   If (UltimDBGrid1.Col <> GridCol) Or (UltimDBGrid1.Row <> GridRow) Then
   Begin
      GridCol := UltimDBGrid1.Col;
      GridRow := UltimDBGrid1.Row;
      UltimDBFooter1.UpdateDataPanels(False);
   End;
End;

Procedure TForm1.ADOTable1AfterRefresh(DataSet: TDataSet);
Begin
   // Mandatory / obligatoire
   UltimDBFooter1.UpdateDataPanels(True);
End;

Procedure TForm1.BDETable2AfterRefresh(DataSet: TDataSet);
Begin
   // Mandatory / obligatoire
   UltimDBFooter2.UpdateDataPanels(True);
End;

Procedure TForm1.PanelResize(Sender: TObject);
Begin
   DBNavigator2.Top := UltimDBFooter1.Top - 18;
End;

End.