Unit UltimDBFilter;

Interface

{$I OPTIONS.INC}

Uses
   Windows, SysUtils, Forms, StdCtrls, Buttons, Controls, Classes;

{$I LANG_STR.INC}

Type
   TFUltimDBFilter = Class(TForm)
      LblField: TLabel;
      CB_Field: TComboBox;
      LblFilter: TLabel;
      FilterCond: TEdit;
      LblORExpr: TLabel;
      ExprCompl: TEdit;
      LblORPreset: TLabel;
      CB_Presets: TComboBox;
      B_OK: TBitBtn;
      B_Cancel: TBitBtn;
      Procedure CB_FieldChange(Sender: TObject);
      Procedure ExprComplChange(Sender: TObject);
      Procedure CB_PresetsChange(Sender: TObject);
      Procedure FormCloseQuery(Sender: TObject; Var CanClose: Boolean);
   Private
   Public
      Filter: String;
   End;

Var
   FUltimDBFilter: TFUltimDBFilter;

Implementation

{$R *.DFM}

Procedure TFUltimDBFilter.CB_FieldChange(Sender: TObject);
Begin
   If CB_Field.ItemIndex = -1 Then
      Exit;
   ExprCompl.Text := '';
End;

Procedure TFUltimDBFilter.ExprComplChange(Sender: TObject);
Begin
   If ExprCompl.Text = '' Then 
      Exit;
   CB_Field.ItemIndex := -1;
   FilterCond.Text := '';
End;

Procedure TFUltimDBFilter.CB_PresetsChange(Sender: TObject);
Var
   Sep: Integer;
Begin
   If CB_Presets.ItemIndex = -1 Then
      Exit;
   Sep := Pos('|', CB_Presets.Text);
   ExprCompl.Text := Copy(CB_Presets.Text, Sep + 2, Length(CB_Presets.Text));
End;

Procedure TFUltimDBFilter.FormCloseQuery(Sender: TObject; Var CanClose: Boolean);
Var
   Sep: Integer;
   Field: String;
Begin
   If ModalResult = mrOk Then
   Begin
      FilterCond.Text := Trim(FilterCond.Text);
      ExprCompl.Text := Trim(ExprCompl.Text);
      If ((CB_Field.Text = '') Or (FilterCond.Text = '')) And (ExprCompl.Text = '') Then
      Begin
         Application.MessageBox(lsNoFilter, lsError, MB_ICONWARNING);
         CanClose := False;
         Exit;
      End;
      If CB_Field.Text <> '' Then
      Begin
         Sep := Pos('|', CB_Field.Text);
         If Sep > 0 Then
            Field := Copy(CB_Field.Text, Sep + 2, Length(CB_Field.Text))
         Else
            Field := CB_Field.Text;
         If Pos(' ', Field) > 0 Then
            Filter := '[' + Field + '] ' + FilterCond.Text
         Else
            Filter := Field + ' ' + FilterCond.Text;
      End
      Else
         Filter := ExprCompl.Text;
   End;
End;

End.