Unit UltimDBExport;

Interface

{$I OPTIONS.INC}

Uses
   Windows, SysUtils, Forms, Classes, StdCtrls, Buttons, Controls, Mask, ToolEdit,
   ExtCtrls;

{$I LANG_STR.INC}

Type
   TFUltimDBExport = Class(TForm)
      ExportFileName: TFilenameEdit;
      Cadre: TBevel;
      RB_FormatHTML: TRadioButton;
      RB_FormatSYLK: TRadioButton;
      RB_FormatTXT: TRadioButton;
      LblDelim: TLabel;
      E_Delim: TEdit;
      CB_Titles: TCheckBox;
      B_OK: TBitBtn;
      B_Cancel: TBitBtn;
      Procedure ExportFileNameButtonClick(Sender: TObject);
      Procedure RB_FormatClick(Sender: TObject);
      Procedure FormCloseQuery(Sender: TObject; Var CanClose: Boolean);
   Private
   Public
   End;

Var
   FUltimDBExport: TFUltimDBExport;

Implementation

{$R *.DFM}

Procedure TFUltimDBExport.ExportFileNameButtonClick(Sender: TObject);
Begin
   If RB_FormatHTML.Checked Then
   Begin
      ExportFileName.DefaultExt := 'HTM';
      ExportFileName.Filter := lsHTMLFilter + '|' + lsDefaultFilter;
   End
   Else If RB_FormatSYLK.Checked Then
   Begin
      ExportFileName.DefaultExt := 'SLK';
      ExportFileName.Filter := lsSYLKFilter + '|' + lsDefaultFilter;
   End
   Else
   Begin
      ExportFileName.DefaultExt := 'TXT';
      ExportFileName.Filter := lsTXTFilter + '|' + lsDefaultFilter;
   End;
End;

Procedure TFUltimDBExport.RB_FormatClick(Sender: TObject);
Begin
   If RB_FormatHTML.Checked Then
      ExportFileName.FileName := ChangeFileExt(ExportFileName.FileName, '.htm')
   Else If RB_FormatSYLK.Checked Then
      ExportFileName.FileName := ChangeFileExt(ExportFileName.FileName, '.slk')
   Else
      ExportFileName.FileName := ChangeFileExt(ExportFileName.FileName, '.txt')
End;

Procedure TFUltimDBExport.FormCloseQuery(Sender: TObject; Var CanClose: Boolean);
Begin
   If ModalResult = mrOk Then
   Begin
      ExportFileName.FileName := Trim(ExportFileName.FileName);
      If ExportFileName.FileName = '' Then
      Begin
         ExportFileName.SetFocus;
         Application.MessageBox(lsNoExportFileName, lsError, MB_ICONWARNING);
         CanClose := False;
         Exit;
      End;
      If RB_FormatTXT.Checked And (E_Delim.Text = '') Then
      Begin
         E_Delim.SetFocus;
         Application.MessageBox(lsNoDelimiter, lsError, MB_ICONWARNING);
         CanClose := False;
         Exit;
      End;
   End;
End;

End.