Unit UltimDBConfig;

Interface

{$I OPTIONS.INC}

Uses
   Windows, SysUtils, Forms, Dialogs, StdCtrls, Buttons, Mask, ToolEdit, Classes, Controls;

{$I LANG_STR.INC}

Type
   TFUltimDBConfig = Class(TForm)
      INIFileName: TFilenameEdit;
      CB_Layout: TCheckBox;
      CB_SortSettings: TCheckBox;
      CB_Filters: TCheckBox;
      B_OK: TBitBtn;
      B_Cancel: TBitBtn;
      Procedure FormCloseQuery(Sender: TObject; Var CanClose: Boolean);
   Private
      FSaveForm: Boolean;
      Procedure SetSaveForm(Value: Boolean);
   Public
      Property SaveForm: Boolean Read FSaveForm Write SetSaveForm;
   End;

Var
   FUltimDBConfig: TFUltimDBConfig;

Implementation

{$R *.DFM}

Procedure TFUltimDBConfig.SetSaveForm;
Begin
   FSaveForm := Value;
   If FSaveForm Then
   Begin // Sauvegarde
      INIFileName.DialogKind := dkSave;
      INIFileName.DialogOptions := [ofHideReadOnly, ofNoReadOnlyReturn, ofPathMustExist,
         ofOverwritePrompt, ofEnableSizing];
   End
   Else
   Begin // Chargement
      INIFileName.DialogKind := dkOpen;
      INIFileName.DialogOptions := [ofHideReadOnly, ofPathMustExist, ofFileMustExist,
         ofEnableSizing];
   End;
End;

Procedure TFUltimDBConfig.FormCloseQuery(Sender: TObject; Var CanClose: Boolean);
Begin
   If ModalResult = mrOk Then
   Begin
      INIFileName.FileName := Trim(INIFileName.FileName);
      If INIFileName.FileName = '' Then
      Begin
         Application.MessageBox(lsNoCfgFileName, lsError, MB_ICONWARNING);
         CanClose := False;
         Exit;
      End;
      If Not (CB_Layout.Checked Or CB_SortSettings.Checked Or CB_Filters.Checked) Then
      Begin
         If SaveForm Then
            Application.MessageBox(lsNoSaveOptions, lsError, MB_ICONWARNING)
         Else
            Application.MessageBox(lsNoRestoreOptions, lsError, MB_ICONWARNING);
         CanClose := False;
         Exit;
      End;
   End;
End;

End.