//---------------------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop
#include "Unit1.h"
//---------------------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "RXDBCtrl"
#pragma link "ToolEdit"
#pragma link "UltimDBFooter"
#pragma link "UltimDBGrid"
#pragma resource "*.dfm"
TDemoBCB *DemoBCB;
//---------------------------------------------------------------------------------------
__fastcall TDemoBCB::TDemoBCB(TComponent* Owner): TForm(Owner)
{
}
//---------------------------------------------------------------------------------------
TStringList*
   SearchCol;
bool
  LockGrid = false,
  Insertion = false;
int
   RepCount,
   OthCount,
   RCol,
   RecNo,
   GridCol,
   GridRow;
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::FormCreate(TObject *Sender)
{
   SearchCol = new TStringList;
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::FormDestroy(TObject *Sender)
{
   delete SearchCol;
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::FormShow(TObject *Sender)
{
   ADOTable->Active = true;
   Grille->FilterList.Length = 5;
   Grille->FilterList[0].Name = "Only United States of America";
   Grille->FilterList[0].Filter = "Pays  = 'Etats-Unis'";
   Grille->FilterList[1].Name = "Only United Kingdom";
   Grille->FilterList[1].Filter = "Pays  = 'Royaume-Uni'";
   Grille->FilterList[2].Name = "Only men";
   Grille->FilterList[2].Filter = "[Titre de courtoisie] <> 'Mme' And [Titre de courtoisie] <> 'Mle'";
   Grille->FilterList[3].Name = "Names beginning by D";
   Grille->FilterList[3].Filter = "Nom LIKE 'D*'";
   Grille->FilterList[4].Name = "Only trainees";
   Grille->FilterList[4].Filter = "Stagiaire = -1";
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::B_QuitterClick(TObject *Sender)
{
   Application->Terminate();
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::GrilleShowEditor(TObject *Sender, TField *Field, bool &AllowEdit)
{
   if (Field != NULL)
   {
      if ((Field->FieldName == "Fonction") && SameText(Field->AsString, "Vice-prsident"))
      { // For demo purpose, the field "Fonction" of Andrew Fuller is not editable
         DemoBCB->Caption = "\"" + Field->AsString + "\" valeur verrouille/locked value";
         AllowEdit = false;
      }
      else
         DemoBCB->Caption = "Demo";
   }
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::GrilleAutoWidthChange(TObject *Sender, TAutoWidth &NewValue)
{
   LockGrid = true;
   CB_AutoWidth->ItemIndex = NewValue;
   LockGrid = false;
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::CB_AutoWidthChange(TObject *Sender)
{
   if (!LockGrid)
      Grille->AutoWidth = TAutoWidth(CB_AutoWidth->ItemIndex);
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::B_IndicTitleClick(TObject *Sender)
{
   if (Grille->Options.Contains(dgIndicator) && Grille->Options.Contains(dgTitles))
   {
      Grille->Options = Grille->Options >> dgIndicator;
      Grille->Options = Grille->Options >> dgTitles;
   }
   else if (Grille->Options.Contains(dgTitles))
   {
      Grille->Options = Grille->Options << dgIndicator;
      Grille->Options = Grille->Options >> dgTitles;
   }
   else
      Grille->Options = Grille->Options << dgTitles;
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::B_FontChangeClick(TObject *Sender)
{
   if (Grille->TitleFont->Size != 14)
   {
      Grille->TitleFont->Size = 14;
      Grille->Columns->Items[0]->Font->Style = TFontStyles()<< fsItalic;
   }
   else
   {
      Grille->TitleFont->Size = 8;
      Grille->Columns->Items[0]->Font->Style = TFontStyles();
   }
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::B_VisibleClick(TObject *Sender)
{
   Grille->Columns->Items[0]->Visible = !Grille->Columns->Items[0]->Visible;
   if (Grille->Columns->Items[0]->Visible)
      B_Visible->Caption = "Invisible C1";
   else
      B_Visible->Caption = "Visible C1";
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::E_TextToSearchChange(TObject *Sender)
{
   B_Search->Enabled = (E_TextToSearch->Text != "");
   B_SearchNext->Enabled = false;
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::E_TextToSearchKeyPress(TObject *Sender, char &Key)
{
   if (Key == char(13)) // Touche Entre
      B_SearchClick(Sender);
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::B_SearchClick(TObject *Sender)
{
   SearchCol->Clear();
   for (int I = 0; I < Grille->Columns->Count; I++)
   {
      if (Grille->Columns->Items[I]->Visible)
         SearchCol->Add(Grille->Columns->Items[I]->FieldName);
   }
   if (Grille->Search(E_TextToSearch->Text, SearchCol, RCol, RecNo, true))
      B_SearchNext->Enabled = true;
   else
      MsgBox("Not Found", "\"" + E_TextToSearch->Text + "\" not found.", MB_ICONWARNING);
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::B_SearchNextClick(TObject *Sender)
{
   if (!Grille->SearchNext(RCol, RecNo, true))
   {
      MsgBox("Not Found", "\"" + E_TextToSearch->Text + "\" not found.", MB_ICONWARNING);
      B_SearchNext->Enabled = false;
   }
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::M_NotesEnter(TObject *Sender)
{
   M_Notes->SelStart = 0;
   M_Notes->SelLength = M_Notes->Text.Length();
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::GrilleGetCellProps(TObject *Sender, TField *Field, TFont *AFont,
   TColor &Background)
{
   if ((Grille->Col != GridCol) || (Grille->Row != GridRow))
   {
      GridCol = Grille->Col;
      GridRow = Grille->Row;
      UltimDBFooter->UpdateDataPanels(false);
   }
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::UltimDBFooterBeforeDisplayText(TUltimDBFooter *FooterBar,
   TFooterColumn *Column, const Variant &Value, AnsiString &Text, TFooterPanelStyle &Style)
{
   if (Column->FieldName == "Nom")
      Style = Ultimdbfooter::psOwnerDraw;
   else if (Column->FieldName == "Pays")
      Text = "C=" + IntToStr(GridCol) + ", R=" + IntToStr(GridRow);
   else if (Column->FieldName == "Fonction")
      Text = "Repr = " + IntToStr(RepCount) + " | Othr = " + IntToStr(OthCount);
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::UltimDBFooterBeforeReadFields(TUltimDBFooter *FooterBar)
{
   RepCount = 0;
   OthCount = 0;
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::UltimDBFooterReadFieldValue(TUltimDBFooter *FooterBar,
   TFooterColumn *Column, const Variant &Value)
{
   if (Column->FieldName == "Fonction")
   {
      if ((Value != Null) && (AnsiString(Value) != FTR_ERROR))
      {
         if (AnsiString(Value) == "Reprsentant(e)")
            RepCount++;
         else
            OthCount++;
      }
   }
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::UltimDBFooterDrawPanel(TUltimDBFooter *FooterBar,
   TFooterPanel *Panel, const TRect &Rect)
{
   // Dessin personnalis
   TRect DrawRect = Rect;
   FooterBar->Canvas->Brush->Color = clYellow;
   FooterBar->Canvas->FillRect(DrawRect);
   FooterBar->Canvas->Font->Color = clRed;
   FooterBar->Canvas->Font->Style = TFontStyles()<< fsBold;
   DrawText((HDC)FooterBar->Canvas->Handle, PChar(Panel->Text.c_str()), -1, &DrawRect,
      DT_NOPREFIX | DT_CENTER | DT_END_ELLIPSIS);
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::ADOTableAfterCancel(TDataSet *DataSet)
{
   Insertion = false;
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::ADOTableAfterInsert(TDataSet *DataSet)
{
   Insertion = true;
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::ADOTableAfterPost(TDataSet *DataSet)
{
   if (Insertion)
   {
      // Il faut rouvrir la table pour rcuprer l'index autoincrment
      Grille->SaveGridPosition();
      ADOTable->Requery(TExecuteOptions());
      Grille->RestoreGridPosition();
      Insertion = false;
   }
}
//---------------------------------------------------------------------------------------
void __fastcall TDemoBCB::ADOTableAfterRefresh(TDataSet *DataSet)
{
   // Mandatory/obligatoire
   UltimDBFooter->UpdateDataPanels(true);
}
//---------------------------------------------------------------------------------------
