Unit Unit1;

Interface

Uses
   SysUtils, Forms, Graphics, Db, DBTables, Grids, DBGrids, RXDBCtrl, UltimDBGrid, StdCtrls,
   Buttons, DBCtrls, Controls, ExtCtrls, Classes;

Type
   TForm1 = Class(TForm)
      DataSource1: TDataSource;
      Panel1: TPanel;
      DBNavigator1: TDBNavigator;
      B_Quitter: TBitBtn;
      Grille: TUltimDBGrid;
      B_DisplayImages: TBitBtn;
      QueryAnimals: TQuery;
      ShpRO: TShape;
      LblRO: TLabel;
      Procedure B_QuitterClick(Sender: TObject);
      Procedure B_DisplayImagesClick(Sender: TObject);
      Procedure GrilleTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
      Procedure GrilleGetBtnParams(Sender: TObject; Field: TField; AFont: TFont;
         Var Background: TColor; Var SortMarker: TSortMarker; IsDown: Boolean);
      Procedure GrilleDblClick(Sender: TObject);
      Procedure GrilleCheckButton(Sender: TObject; ACol: Integer; Field: TField;
         Var Enabled: Boolean);
   Private
    { Dclarations prives }
   Public
    { Dclarations publiques }
   End;

Var
   Form1: TForm1;

Implementation

Uses Unit2;

{$R *.DFM}

Procedure TForm1.B_QuitterClick(Sender: TObject);
Begin
   Application.Terminate;
End;

Procedure TForm1.B_DisplayImagesClick(Sender: TObject);
Begin
   If Grille.DisplayImages Then
   Begin
      Grille.DisplayImages := False;
      B_DisplayImages.Caption := 'Display Images';
   End
   Else
   Begin
      Grille.DisplayImages := True;
      B_DisplayImages.Caption := 'Hide Images';
   End;
End;

Const
   MySortedField: String = '';

Procedure TForm1.GrilleTitleBtnClick(Sender: TObject; ACol: Integer; Field: TField);
Var
   NewSQL: String;
Begin
   If MySortedField = Field.FieldName Then
   Begin
      MySortedField := '';
      NewSQL := 'SELECT * FROM Animals;';
   End
   Else
   Begin
      MySortedField := Field.FieldName;
      NewSQL := 'SELECT * FROM Animals ORDER BY ' + IntToStr(Field.FieldNo) + ';';
   End;
   If NewSQL <> QueryAnimals.SQL.Text Then
   Begin
      QueryAnimals.SQL.Text := NewSQL;
      QueryAnimals.Open;
   End;
   ShpRO.Visible := Not QueryAnimals.CanModify;
   LblRO.Visible := Not QueryAnimals.CanModify;
End;

Procedure TForm1.GrilleGetBtnParams(Sender: TObject; Field: TField; AFont: TFont;
   Var Background: TColor; Var SortMarker: TSortMarker; IsDown: Boolean);
Begin
   If MySortedField = Field.FieldName Then
      SortMarker := smUP
   Else
      SortMarker := smNONE;
End;

Procedure TForm1.GrilleDblClick(Sender: TObject);
Begin
   If Grille.SelectedField <> Nil Then
      If Grille.SelectedField.FieldName = 'BMP' Then
      Begin
         Form2.ShowModal;
         Grille.SetFocus;
      End;
End;

Procedure TForm1.GrilleCheckButton(Sender: TObject; ACol: Integer; Field: TField;
   Var Enabled: Boolean);
Begin
   If Field <> Nil Then
      Enabled := (UpperCase(Field.FieldName) <> 'BMP');
End;

End.
