Unit Unit1;

Interface

Uses
   Forms, Classes, Controls, Graphics, Buttons, StdCtrls, ExtCtrls, Mask, Db, DBTables, Grids,
   DBGrids, RXDBCtrl, UltimDBGrid, DBImageEditor, DBCtrls, ToolEdit;

Type
   TForm1 = Class(TForm)
      DataSource1: TDataSource;
      BioLife2: TTable;
      Grille: TUltimDBGrid;
      Panel1: TPanel;
      CB_AutoWidth: TComboBox;
      DBNavigator1: TDBNavigator;
      B_Visible: TBitBtn;
      B_IndicTitle: TBitBtn;
      B_FontSize: TBitBtn;
      DBDateEdit1: TDBDateEdit;
      DBComboBox1: TDBComboBox;
      DBMemo1: TDBMemo;
      DBImageEditor1: TDBImageEditor;
      E_TextToSearch: TEdit;
      B_Search: TBitBtn;
      B_SearchNext: TBitBtn;
      B_Quitter: TBitBtn;
      Procedure FormCreate(Sender: TObject);
      Procedure FormShow(Sender: TObject);
      Procedure FormDestroy(Sender: TObject);
      Procedure B_QuitterClick(Sender: TObject);
      Procedure B_IndicTitleClick(Sender: TObject);
      Procedure CB_AutoWidthChange(Sender: TObject);
      Procedure B_VisibleClick(Sender: TObject);
      Procedure B_FontSizeClick(Sender: TObject);
      Procedure GrilleAutoWidthChange(Sender: TObject; Var NewValue: TAutoWidth);
      Procedure GrilleShowEditor(Sender: TObject; Field: TField; Var AllowEdit: Boolean);
      Procedure DBMemo1Enter(Sender: TObject);
      Procedure E_TextToSearchChange(Sender: TObject);
      Procedure B_SearchClick(Sender: TObject);
      Procedure B_SearchNextClick(Sender: TObject);
   Private
   Public
   End;

Var
   Form1: TForm1;

Implementation

{$R *.DFM}

Const
   LockGrid: Boolean = False;
Var
   SearchCol: TStringList;
   RCol, RecNo: Integer;

Procedure TForm1.FormCreate(Sender: TObject);
Begin
   SearchCol := TStringList.Create;
End;

Procedure TForm1.FormShow(Sender: TObject);
Begin
   BioLife2.Active := True;
   SetLength(Grille.FilterList, 2);
   Grille.FilterList[0].Name := 'Longer than 90 cm';
   Grille.FilterList[0].Filter := '[Length (cm)] > 90';
   Grille.FilterList[1].Name := 'Snapper and wrasse';
   Grille.FilterList[1].Filter := 'Category = ''Snapper'' OR Category = ''Wrasse''';
End;

Procedure TForm1.FormDestroy(Sender: TObject);
Begin
   SearchCol.Free;
End;

Procedure TForm1.B_QuitterClick(Sender: TObject);
Begin
   Application.Terminate;
End;

Procedure TForm1.B_IndicTitleClick(Sender: TObject);
Begin
   If (dgIndicator In Grille.Options) And (dgTitles In Grille.Options) Then
   Begin
      Grille.Options := Grille.Options - [dgIndicator];
      Grille.Options := Grille.Options - [dgTitles];
   End
   Else If dgTitles In Grille.Options Then
   Begin
      Grille.Options := Grille.Options + [dgIndicator];
      Grille.Options := Grille.Options - [dgTitles];
   End
   Else
      Grille.Options := Grille.Options + [dgTitles];
End;

Procedure TForm1.CB_AutoWidthChange(Sender: TObject);
Begin
   If Not LockGrid Then
      Grille.AutoWidth := TAutoWidth(CB_AutoWidth.ItemIndex);
End;

Procedure TForm1.B_VisibleClick(Sender: TObject);
Begin
   Grille.Columns[0].Visible := NOT Grille.Columns[0].Visible;
   If Grille.Columns[0].Visible Then
      B_Visible.Caption := 'Invisible C1'
   Else
      B_Visible.Caption := 'Visible C1';
End;

Procedure TForm1.B_FontSizeClick(Sender: TObject);
Begin
   If Grille.TitleFont.Size <> 14 Then
   Begin
      Grille.TitleFont.Size := 14;
      Grille.Columns[0].Font.Style := [fsItalic];
   End
   Else
   Begin
      Grille.TitleFont.Size := 8;
      Grille.Columns[0].Font.Style := [];
   End;
End;

Procedure TForm1.GrilleAutoWidthChange(Sender: TObject; Var NewValue: TAutoWidth);
Begin
   LockGrid := True;
   CB_AutoWidth.ItemIndex := Ord(NewValue);
   LockGrid := False;
End;

Procedure TForm1.GrilleShowEditor(Sender: TObject; Field: TField; Var AllowEdit: Boolean);
Begin
   If Field <> Nil Then
   Begin
      If (Field.FieldName = 'Category') And (Field.AsString = 'Cod') Then
      Begin // For demo purpose, the field "Category" of cod fishes is not editable
         Form1.Caption := Field.FieldName + ' "' + Field.AsString +
            '" valeur verrouille/locked value';
         AllowEdit := False;
      End
      Else
         Form1.Caption := 'Demo';
   End;
End;

Procedure TForm1.DBMemo1Enter(Sender: TObject);
Begin
   DBMemo1.SelStart := 0;
   DBMemo1.SelLength := Length(DBMemo1.Text);
End;

Procedure TForm1.E_TextToSearchChange(Sender: TObject);
Begin
   B_Search.Enabled := (E_TextToSearch.Text <> '');
   B_SearchNext.Enabled := False;
End;

Procedure TForm1.B_SearchClick(Sender: TObject);
Begin
   SearchCol.Clear;
   SearchCol.Add('Species Name');
   SearchCol.Add('Notes');
   SearchCol.Add('Category');
   SearchCol.Add('Common_Name');
   If Grille.Search(E_TextToSearch.Text, SearchCol, RCol, RecNo, True) Then
      B_SearchNext.Enabled := True
   Else
      Application.MessageBox('Not found', '', 0);
End;

Procedure TForm1.B_SearchNextClick(Sender: TObject);
Begin
   If Not Grille.SearchNext(RCol, RecNo, True) Then 
   Begin
      Application.MessageBox('Not found', '', 0);
      B_SearchNext.Enabled := False;
   End;
End;

End.