unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, Textdifference, StdCtrls, ExtCtrls, ComCtrls;

type
  TForm2 = class(TForm)
    StringGrid2: TStringGrid;
    LTextDiff1: TLTextDiff;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Panel2: TPanel;
    LTextDiff2: TLTextDiff;
    RichEdit1: TRichEdit;
    Splitter1: TSplitter;
    Label3: TLabel;
    Label4: TLabel;
    StringGrid1: TStringGrid;
    Label5: TLabel;
    Label6: TLabel;
    ProgressBar1: TProgressBar;
    Label7: TLabel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure StringGrid2SelectCell(Sender: TObject; ACol,
      ARow: Integer; var CanSelect: Boolean);
    procedure LTextDiff1Progress(Sender: TObject;
      Progresspercent: Integer);
    procedure LTextDiff2Progress(Sender: TObject;
      Progresspercent: Integer);
    procedure FormShow(Sender: TObject);
    procedure StringGrid2DrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
  private
    keineDetailsjetzt: boolean;
    procedure Stringgrid2Dimensions;
    function getDifferenceSection(var beginline,endline: integer; fromRow: integer): boolean;
    procedure makeInputLines(beginline, endline: integer);
    procedure TextIntoRichedit(s: String; hinzu,weg: boolean);
    procedure Richeditformat;
    { Private-Deklarationen }
  public
    procedure makeLists;
  end;

var
  Form2: TForm2;

implementation

uses Unit1;

{$R *.DFM}



PROCEDURE WindowsAlive;
  VAR M: TMsg;
  BEGIN
    IF PeekMessage(M,0,0,0,pm_Remove) THEN BEGIN
      TranslateMessage(M);
      DispatchMessage(M);
    END;
  END;


PROCEDURE Delay(MS:LONGINT);
  procedure nothing;
  begin
  end;
  VAR TickCount: LONGINT;
  BEGIN
    TickCount := GetTickCount;
    WHILE GetTickCount - TickCount < MS DO nothing {WindowsAlive};
  END;

PROCEDURE Delayalive(MS:LONGINT);
  VAR TickCount: LONGINT;
  BEGIN
    TickCount := GetTickCount;
    WHILE GetTickCount - TickCount < MS DO WindowsAlive;
  END;






procedure TForm2.Stringgrid2Dimensions;
begin
   with Stringgrid2 do begin
       ColWidths[0]:=30;
       ColWidths[2]:=0;
       ColWidths[3]:=10;
       ColWidths[4]:=0;
       ColWidths[1]:=(clientWidth-5-30-10) div 2;
       ColWidths[5]:=ColWidths[1];
   end;
end;

procedure TForm2.FormResize(Sender: TObject);
begin
     Stringgrid2Dimensions;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
     keineDetailsjetzt:=true;
     Stringgrid2Dimensions;
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    Action:=caFree;
    Form2:=nil;
end;

procedure TForm2.FormDestroy(Sender: TObject);
begin
    Form2:=nil;
end;



procedure TForm2.makeLists;
var i,row1,row2: integer;
begin
    for i:=0 to Stringgrid2.ColCount-1 do Stringgrid2.Cols[i].Clear;
    LTextDiff1.noRecursionType:=by_Lines_Or_Words;
    LTextDiff1.RecursionType:=no_Recursion;
  //  LTextDiff1.algorithmforLines:=Seq_SequentialStandard;
    LTextDiff1.inputFirstLines.Assign(Form1.Richedit1.Lines);
    LTextDiff1.inputSecondLines.Assign(Form1.Richedit2.Lines);
    LTextDiff1.Execute;
    row1:=0;
    row2:=0;
    for i:=0 to LTextDiff1.ResultList.Count-1 do begin
        if LTextDiff1.ResultList[i]='' then continue;
        case LTextDiff1.ResultList[i][1] of
          '+': begin
                  Stringgrid2.Cells[4,row2]:=' ';
                  Stringgrid2.Cells[5,row2]:=copy(LTextDiff1.ResultList[i],2,maxint);
                 // inc(row1);
                  inc(row2);
               end;
          '-': begin
                  Stringgrid2.Cells[2,row1]:=' ';
                  Stringgrid2.Cells[1,row1]:=copy(LTextDiff1.ResultList[i],2,maxint);
                  inc(row1);
                 // inc(row2);
               end;
          '0': begin
                  if row1>row2 then row2:=row1 else row1:=row2;
                  Stringgrid2.Cells[1,row1]:=copy(LTextDiff1.ResultList[i],2,maxint);
                  Stringgrid2.Cells[5,row2]:=copy(LTextDiff1.ResultList[i],2,maxint);
                  inc(row1);
                  inc(row2);
               end;
        else
           if row1>row2 then row2:=row1 else row1:=row2;
           Stringgrid2.Cells[1,row1]:=copy(LTextDiff1.ResultList[i],2,maxint);
           Stringgrid2.Cells[5,row2]:=copy(LTextDiff1.ResultList[i],2,maxint);
           inc(row1);
           inc(row2);
        end;
        if Stringgrid2.RowCount<row1+10 then Stringgrid2.RowCount:=Stringgrid2.RowCount+30;
        if Stringgrid2.RowCount<row2+10 then Stringgrid2.RowCount:=Stringgrid2.RowCount+30;
        application.ProcessMessages;
    end;
    for i:=0 to Stringgrid2.RowCount-1 do Stringgrid2.Cells[0,i]:=IntToStr(i+1);
end;




procedure TForm2.makeInputLines(beginline,endline: integer);
var i: integer;
    s: String;
begin
   LTextDiff2.inputFirstLines.Clear;
   LTextDiff2.inputSecondLines.Clear;
   for i:=beginline to endline do begin
      if (Stringgrid2.Cells[1,i])<>'' then begin
           s:=Stringgrid2.Cells[1,i];
           if s[Length(s)]=#10 then delete(s,Length(s),1);
           LTextDiff2.inputFirstLines.Add(s);
      end;
      if (Stringgrid2.Cells[5,i])<>'' then begin
           s:=Stringgrid2.Cells[5,i];
           if s[Length(s)]=#10 then delete(s,Length(s),1);
           LTextDiff2.inputSecondLines.Add(s);
      end;
   end;
end;


function TForm2.getDifferenceSection(var beginline,endline: integer; fromRow: integer): boolean;
var i,j,k: integer;
    s: String;
begin
    beginline:=fromrow;
    endline:=fromrow;
    Result:=false;
    if Stringgrid2.Cells[1,fromRow]=Stringgrid2.Cells[5,fromRow] then exit;
    k:=beginline;
    for i:=k downto 0 do begin
       if (Stringgrid2.Cells[1,i]<>Stringgrid2.Cells[5,i]) then beginline:=i else break;
    end;
    k:=endline;
    for i:=k to Stringgrid2.RowCount-1 do begin
       if (Stringgrid2.Cells[1,i]<>Stringgrid2.Cells[5,i]) then endline:=i else break;
    end;

    s:=IntToStr(beginline+1)+' --> '+IntToStr(endline+1);
    if Label4.Caption=s then exit;
    Label4.Caption:=s;
    Result:=true;
end;



procedure TForm2.TextIntoRichedit(s: String; hinzu,weg: boolean);
var lvor: integer;
begin
     Richedit1.SelStart:=maxint;
     lvor:=Richedit1.SelStart;
     Richedit1.Text:=Richedit1.Text+s;
     if hinzu then begin
       Stringgrid1.Cells[0,Stringgrid1.Rowcount-1]:=inttostr(lvor);
       Stringgrid1.Cells[1,Stringgrid1.Rowcount-1]:=inttostr(Length(s));
       Stringgrid1.Cells[2,Stringgrid1.Rowcount-1]:='+';
       Stringgrid1.RowCount:=Stringgrid1.RowCount+1;
     end;
     if weg then begin
       Stringgrid1.Cells[0,Stringgrid1.Rowcount-1]:=inttostr(lvor);
       Stringgrid1.Cells[1,Stringgrid1.Rowcount-1]:=inttostr(Length(s));
       Stringgrid1.Cells[2,Stringgrid1.Rowcount-1]:='-';
       Stringgrid1.RowCount:=Stringgrid1.RowCount+1;
     end;
end;


procedure TForm2.Richeditformat;
var i: integer;
begin
  Richedit1.selectall;
  Richedit1.SelAttributes.Style:=[];
  Richedit1.SelAttributes.Color:=clblack;
  for i:=0 to Stringgrid1.RowCount-1 do begin
     if Stringgrid1.Cells[0,i]='' then continue;
     if Stringgrid1.Cells[2,i]='+' then begin
         Richedit1.SelStart:=StrToInt(Stringgrid1.Cells[0,i]);
         Richedit1.SelLength:=StrToInt(Stringgrid1.Cells[1,i]);
         Richedit1.SelAttributes.Style:=[fsunderline,fsbold];
         Richedit1.SelAttributes.Color:=clgreen;
     end;
     if Stringgrid1.Cells[2,i]='-' then begin
         Richedit1.SelStart:=StrToInt(Stringgrid1.Cells[0,i]);
         Richedit1.SelLength:=StrToInt(Stringgrid1.Cells[1,i]);
         Richedit1.SelAttributes.Style:=[fsstrikeout,fsbold];
         Richedit1.SelAttributes.Color:=clred;
     end;
  end;
  Richedit1.SelStart:=maxint;
  Richedit1.SelLength:=0;
  Richedit1.SelStart:=0;
end;

procedure TForm2.StringGrid2SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
var i,beginline,endline: integer;
    s: String;
begin
    if keineDetailsjetzt then exit;

    for i:=0 to Stringgrid1.ColCount do Stringgrid1.Cols[i].Clear;
    Stringgrid1.RowCount:=1;

    if Stringgrid2.Cells[1,ARow]=Stringgrid2.Cells[5,ARow] then begin
       Richedit1.Lines.Clear;
       Richedit1.selectall;
       Richedit1.SelAttributes.Style:=[];
       Richedit1.SelAttributes.Color:=clblack;
       Richedit1.Lines.add(Stringgrid2.Cells[1,ARow]);
       Label4.Caption:=IntToStr(ARow+1);
       exit;
    end;


    if not getDifferenceSection(beginline,endline,ARow) then exit;

    LTextDiff2.setbreak;
    makeInputLines(beginline,endline);

    Label7.visible:=true;
    ProgressBar1.Visible:=true;

    if RadioButton1.checked then LTextDiff2.RecursionType:=downto_letters else LTextDiff2.RecursionType:=downto_words;
    LTextDiff2.Execute;
    Label7.visible:=false;
    ProgressBar1.Visible:=false;
    Richedit1.Lines.Clear;

    for i:=0 to LTextDiff2.ResultList.count-1 do begin
        if LTextDiff2.ResultList[i]='' then continue;
        s:=copy(LTextDiff2.ResultList[i],2,maxint);
        case LTextDiff2.ResultList[i][1] of
            '0': begin
                    TextIntoRichedit(s,false,false);
                 end;
            '+': begin
                    TextIntoRichedit(s,true,false);
                 end;
            '-': begin
                    TextIntoRichedit(s,false,true);
                 end;
        end;
    end;
    Richeditformat;
end;

procedure TForm2.LTextDiff1Progress(Sender: TObject;
  Progresspercent: Integer);
begin
   Form1.ProgressBar2.Position:=Progresspercent;
end;

procedure TForm2.LTextDiff2Progress(Sender: TObject;
  Progresspercent: Integer);
begin
    ProgressBar1.Position:=Progresspercent;
end;

procedure TForm2.FormShow(Sender: TObject);
var b: boolean;
begin
     Label4.Caption:='';
     keineDetailsjetzt:=false;
//     Stringgrid2SelectCell(nil,Stringgrid2.Col,Stringgrid2.Row,b);
end;

procedure TForm2.StringGrid2DrawCell(Sender: TObject; ACol, ARow: Integer;
  Rect: TRect; State: TGridDrawState);
var bcolor,fcolor: TColor;
begin
       fcolor:=clblack;
       if gdselected in State then bcolor:=clsilver else bcolor:=clwhite;
       if ACol=0 then bcolor:=clsilver;

       if ACol=1 then begin
          if Stringgrid2.Cells[2,ARow]<>'' then begin
              if gdselected in State then begin
                 bcolor:=clsilver;
                 fcolor:=clred;
              end else begin
                 bcolor:=clred;
                 fcolor:=clwhite;
              end;
          end;
       end;
       if ACol=5 then begin
          if Stringgrid2.Cells[4,ARow]<>'' then begin
              if gdselected in State then begin
                 bcolor:=clsilver;
                 fcolor:=clgreen;
              end else begin
                 bcolor:=clgreen;
                 fcolor:=clwhite;
              end;
          end;
       end;

       with StringGrid2 do begin
          Canvas.Brush.Color:=bcolor;
          Canvas.Font.Color:=fcolor;
          Canvas.TextRect(Rect, Rect.Left+2, Rect.Top+2, trimright(Cells[ACol, ARow]));
       end;
end;

end.


