unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Textdifference, StdCtrls, Buttons, ComCtrls, inifiles, ExtCtrls;

type
  TForm1 = class(TForm)
    LTextDiff1: TLTextDiff;
    BitBtn1: TBitBtn;
    RichEdit1: TRichEdit;
    RichEdit2: TRichEdit;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    OpenDialog1: TOpenDialog;
    Label1: TLabel;
    Label2: TLabel;
    ComboBox1: TComboBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    ComboBox2: TComboBox;
    ComboBox3: TComboBox;
    ComboBox4: TComboBox;
    BitBtn4: TBitBtn;
    Bevel1: TBevel;
    ProgressBar1: TProgressBar;
    Bevel2: TBevel;
    Label8: TLabel;
    ComboBox5: TComboBox;
    ProgressBar2: TProgressBar;
    Label9: TLabel;
    BitBtn5: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BitBtn4Click(Sender: TObject);
    procedure LTextDiff1Progress(Sender: TObject;
      Progresspercent: Integer);
    procedure BitBtn5Click(Sender: TObject);
  private
    procedure readinifile;
    procedure writeinifile;
    function getAppDir: String;
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm1.BitBtn1Click(Sender: TObject);
var s: String;
begin
    LTextDiff1.noRecursionType:=by_Lines_Or_Words;
    case ComboBox1.ItemIndex of
      0: begin
            LTextDiff1.RecursionType:=no_Recursion;
            LTextDiff1.noRecursionType:=by_Lines_Or_Words;
         end;
      1: begin
            LTextDiff1.RecursionType:=no_Recursion;
            LTextDiff1.noRecursionType:=by_Words_only;
         end;
      2: begin
            LTextDiff1.RecursionType:=no_Recursion;
            LTextDiff1.noRecursionType:=by_Letters_only;
         end;
      3: LTextDiff1.RecursionType:=downto_Words;
      4: LTextDiff1.RecursionType:=downto_Letters;
    end;
    case ComboBox2.ItemIndex of
      0: LTextDiff1.algorithmforLines:=Seq_SequentialStandard;
      1: LTextDiff1.algorithmforLines:=BB_BranchAndBound;
    end;
    case ComboBox3.ItemIndex of
      0: LTextDiff1.algorithmforWords:=Seq_SequentialStandard;
      1: LTextDiff1.algorithmforWords:=BB_BranchAndBound;
    end;
    case ComboBox4.ItemIndex of
      0: LTextDiff1.algorithmforLetters:=Seq_SequentialStandard;
      1: LTextDiff1.algorithmforLetters:=BB_BranchAndBound;
    end;


    LTextDiff1.inputFirstLines.Assign(Richedit1.Lines);
    LTextDiff1.inputSecondLines.Assign(Richedit2.Lines);
    LTextDiff1.Execute;
    if (not LTextDiff1.breaked) then begin
    if LTextDiff1.DifferencesOccured then begin
      s:=getAppDir+'difference.html';
      LTextDiff1.makeHTMLfromResultList(s,true);
    end else showmessage('no differences detected');
    end;
    ProgressBar1.Position:=0;
end;

function TForm1.getAppDir: String;
begin
    Result:=ExtractFileDir(application.exename);
    if Result='' then Result:='c:\';
    if Result[Length(Result)]<>'\' then Result:=Result+'\';
end;

procedure TForm1.BitBtn2Click(Sender: TObject);
begin
     if not Opendialog1.execute then exit;
     Richedit1.PlainText:=true;
     Richedit1.Lines.LoadFromFile(Opendialog1.filename);
end;

procedure TForm1.BitBtn3Click(Sender: TObject);
begin
     if not Opendialog1.execute then exit;
     Richedit2.PlainText:=true;
     Richedit2.Lines.LoadFromFile(Opendialog1.filename);
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
    ComboBox1.ItemIndex:=0;
    ComboBox2.ItemIndex:=0;
    ComboBox3.ItemIndex:=0;
    ComboBox4.ItemIndex:=0;
    readinifile;
    if FileExists(getAppDir+'first.txt') then Richedit1.Lines.LoadFromFile(getAppDir+'first.txt');
    if FileExists(getAppDir+'second.txt') then Richedit2.Lines.LoadFromFile(getAppDir+'second.txt');
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
    Richedit1.Lines.SaveToFile(getAppDir+'first.txt');
    Richedit2.Lines.SaveToFile(getAppDir+'second.txt');
    writeinifile;
end;

procedure TForm1.readinifile;
var ini: TIniFile;
begin
    ini:=TIniFile.Create(getAppDir+'algorithms.ini');
    try
       ComboBox1.Itemindex:=ini.ReadInteger('set','c1',0);
       ComboBox2.Itemindex:=ini.ReadInteger('set','c2',0);
       ComboBox3.Itemindex:=ini.ReadInteger('set','c3',0);
       ComboBox4.Itemindex:=ini.ReadInteger('set','c4',0);
       ComboBox5.Itemindex:=ini.ReadInteger('set','c5',0);
    finally
       ini.Free;
    end;
end;

procedure TForm1.writeinifile;
var ini: TIniFile;
begin
    ini:=TIniFile.Create(getAppDir+'algorithms.ini');
    try
       ini.WriteInteger('set','c1',ComboBox1.Itemindex);
       ini.WriteInteger('set','c2',ComboBox2.Itemindex);
       ini.WriteInteger('set','c3',ComboBox3.Itemindex);
       ini.WriteInteger('set','c4',ComboBox4.Itemindex);
       ini.WriteInteger('set','c5',ComboBox5.Itemindex);
    finally
       ini.Free;
    end;
end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
    if Form2<>nil then Form2.Free;
    Application.CreateForm(TForm2,Form2);
    if combobox5.Itemindex=1 then Form2.LTextDiff1.algorithmforLines:=BB_BranchAndBound
    else Form2.LTextDiff1.algorithmforLines:=Seq_SequentialStandard;
    Form2.makeLists;
    ProgressBar2.Position:=0;
    Form2.Show;
end;

procedure TForm1.LTextDiff1Progress(Sender: TObject;
  Progresspercent: Integer);
begin
    ProgressBar1.Position:=Progresspercent;
end;

procedure TForm1.BitBtn5Click(Sender: TObject);
begin
  LTextDiff1.setbreak;
end;

end.
