{*******************************************************}
{                                                       }
{         CA SweetControls Component Library            }
{                                                       }
{  Copyright (c) 1996,2004 CodeAccelerate Corporation   }
{                                                       }
{*******************************************************}

unit SCRegisters;

{$I SweetControls.inc}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  {$IFDEF SC_DELPHI6} Types, DesignEditors, DesignIntf, {$ELSE}
  TypInfo, DsgnIntf, {$ENDIF} Extctrls, ImgList, StdActns, ActnList, Menus,
  SCConsts, SCPropertyEditors, SCCommon, SCControl, SCStdControls, SCEdits,
  SCMaskEdit, SCAdvEdits, SCSimpleListbox, SCExtControls, SCTabSet, SCTrackbar,
  SCPanels, SCButtonSet, SCStatusBar, SCScrollbars, SCFontsAndColors,
  SCColorControls, SCColorbox, SCPopupColors, SCImageBox, SCDateTimeControls,
  SCSplitter;

procedure Register;

implementation

{$R *.dcr}

procedure Register;
begin
  RegisterComponentEditor(TSCCustomControl, TSCAboutEditor);

  RegisterComponentEditor(TSCPictureList, TSCPictureListItemsEditor);
  RegisterComponentEditor(TSCSimpleListbox, TSCSimpleListboxItemsEditor);
  RegisterComponentEditor(TSCListboxEx, TSCListboxExItemEditor);
  RegisterComponentEditor(TSCTabset, TSCTabsetTabEditor);
  RegisterComponentEditor(TSCHeader, TSCHeaderColumnEditor);
  RegisterComponentEditor(TSCButtonSet, TSCButtonSetButtonEditor);
  RegisterComponentEditor(TSCStatusBar, TSCStatusBarPanelEditor);
  RegisterComponentEditor(TSCListGroup, TSCListGroupItemEditor);
  RegisterComponentEditor(TSCCustomComboboxEx, TSCComboboxExItemEditor);
  RegisterComponentEditor(TSCCombobox, TSCComboboxItemEditor);
  RegisterComponentEditor(TSCCustomImageBox, TSCImageBoxPictureEditor);

  RegisterPropertyEditor(TypeInfo(TSCAboutString), TSCCustomControl, 'About', TSCAboutProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCustomControl, 'ImageIndex', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCustomEdit, 'PasswordImage', TSCImageIndexProperty);

  RegisterPropertyEditor(TypeInfo(string), TSCCustomMaskEdit, 'EditMask', TSCEditMaskProperty);
  RegisterPropertyEditor(TypeInfo(string), TSCCustomMaskEdit, 'Text', TSCEditMaskInputProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCustomSpinnerEdit, 'ButtonDownImage', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCustomSpinnerEdit, 'ButtonUpImage', TSCImageIndexProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCheckbox, 'ImageChecked', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCheckbox, 'ImageGrayed', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCheckbox, 'ImageToggle', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCheckbox, 'ImageUnchecked', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCheckbox, 'ImageMark', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCCheckbox, 'ImageMarkGrayed', TSCImageIndexProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCRadioButton, 'ImageChecked', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCRadioButton, 'ImageToggle', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCRadioButton, 'ImageUnchecked', TSCImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCRadioButton, 'ImageMark', TSCImageIndexProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCLabel, 'HotImage', TSCImageIndexProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCListboxExItem, 'ImageIndex', TSCListboxExItemImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCComboboxExItem, 'ImageIndex', TSCComboboxExItemImageIndexProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCAdvGroupCaption, 'Icon', TSCAdvGroupCaptionIconIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCAdvGroupCaption, 'CloseButton', TSCAdvGroupCaptionImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCAdvGroupCaption, 'DownButton', TSCAdvGroupCaptionImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCAdvGroupCaption, 'UpButton', TSCAdvGroupCaptionImageIndexProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCListGroupStyle, 'ImageIndex', TSCLGroupStyleImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCListGroupStyle, 'LargeImageIndex', TSCLGroupStyleLargeImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCListGroupItem,  'ImageIndex', TSCLGroupItemImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCListGroupItem,  'LargeImageIndex', TSCLGroupItemLargeImageIndexProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCListGroupScroller, 'ImageDefault', TSCLGroupScrollerImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCListGroupScroller, 'ImageDisabled', TSCLGroupScrollerImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCListGroupScroller, 'ImageHot', TSCLGroupScrollerImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCListGroupScroller, 'ImagePressed', TSCLGroupScrollerImageIndexProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCAdvGroupCaption, 'Icon', TSCAdvGroupCaptionIconIndexProperty);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCEditButton, 'Image', TSCEditButtonImageIndexProperty);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TSCPopupbox, 'ButtonImage', TSCImageIndexProperty);

  RegisterComponents('Sweet Standart', [TSCLabel, TSCEdit, TSCButton, TSCCheckBox,
    TSCRadioButton, TSCSimpleListbox, TSCPanel, TSCProgress, TSCSpinButton,
    TSCScrollbar, TSCGroupBox, TSCTrackbar, TSCButtonSet, TSCTabset, TSCHeader,
    TSCStatusBar, TSCControlSizer]);

  RegisterComponents('Sweet Additional', [TSCPictureList, TSCImageBox, TSCMaskEdit,
    TSCListboxEx, TSCComboboxEx, TSCCalendar, TSCSplitter]);

  RegisterComponents('Sweet Edits', [TSCFrameEdit, TSCCombobox, TSCPopupbox,
    TSCButtonEdit, TSCHyperlinkEdit, TSCSpinnerEdit, TSCIntSpinEdit,
    TSCFloatSpinEdit, TSCTimeEdit, TSCPopupCalendar, TSCPopupColors]);

  RegisterComponents('Sweet Panels', [TSCGroupContainer, TSCAdvPanel,
    TSCListGroup, TSCListGroupStyle]);

  RegisterComponents('Sweet Fonts && Colors', [TSCFontListbox, TSCFontCombobox,
    TSCColorListbox, TSCColorCombobox, TSCFontSizeListbox, TSCFontSizeCombobox,
    TSCFontCharsetListbox, TSCFontCharsetCombobox]);

  RegisterComponents('Sweet Colors', [TSCColorbox, TSCColorPalette,
    TSCColorSelectBox, TSCColorSelector, TSCColorGradient, TSCHSVGradient,
    TSCHueSlider, TSCLumSlider, TSCRGBRoller, TSCRGBSlider]);
end;

end.
