unit ufmRTEDDemo;

interface

uses
  Classes,
  ComCtrls,
  Controls,
  Dialogs,
  ExtCtrls,
  Forms,
  Graphics,
  hRTExceptionDumper,
  Messages,
  ShellAPI,
  StdCtrls,
  SysUtils,
  Tabs,
  ufmRTEDCustomDump,
  ufmRTEDDump,
  uRTExceptionDumper,
  uRTExceptionDumperSupport,
  uRTExceptionDumperSysLib,
  Variants,
  Windows;

type
  TfmRTEDDemo = class(TForm)
    CheckBox1    : TCheckBox;
    CheckBox2    : TCheckBox;
    Image1       : TImage;
    Image10      : TImage;
    Image11      : TImage;
    Image12      : TImage;
    Image13      : TImage;
    Image14      : TImage;
    Image15      : TImage;
    Image16      : TImage;
    Image17      : TImage;
    Image18      : TImage;
    Image19      : TImage;
    Image2       : TImage;
    Image20      : TImage;
    Image21      : TImage;
    Image22      : TImage;
    Image23      : TImage;
    Image24      : TImage;
    Image25      : TImage;
    Image26      : TImage;
    Image27      : TImage;
    Image28      : TImage;
    Image29      : TImage;
    Image3       : TImage;
    Image30      : TImage;
    Image31      : TImage;
    Image32      : TImage;
    Image33      : TImage;
    Image34      : TImage;
    Image35      : TImage;
    Image36      : TImage;
    Image37      : TImage;
    Image38      : TImage;
    Image39      : TImage;
    Image4       : TImage;
    Image40      : TImage;
    Image41      : TImage;
    Image42      : TImage;
    Image43      : TImage;
    Image5       : TImage;
    Image6       : TImage;
    Image7       : TImage;
    Image8       : TImage;
    Image9       : TImage;
    Label1       : TLabel;
    Label2       : TLabel;
    Label3       : TLabel;
    mmExceptDesc : TMemo;
    mmInfo       : TMemo;
    Notebook1    : TNotebook;
    Panel1       : TPanel;
    Panel2       : TPanel;
    shContent    : TShape;
    shHeader     : TShape;
    StaticText1  : TStaticText;
    StaticText10 : TStaticText;
    StaticText11 : TStaticText;
    StaticText12 : TStaticText;
    StaticText13 : TStaticText;
    StaticText14 : TStaticText;
    StaticText15 : TStaticText;
    StaticText16 : TStaticText;
    StaticText17 : TStaticText;
    StaticText18 : TStaticText;
    StaticText19 : TStaticText;
    StaticText2  : TStaticText;
    StaticText20 : TStaticText;
    StaticText21 : TStaticText;
    StaticText22 : TStaticText;
    StaticText23 : TStaticText;
    StaticText24 : TStaticText;
    StaticText25 : TStaticText;
    StaticText26 : TStaticText;
    StaticText27 : TStaticText;
    StaticText28 : TStaticText;
    StaticText29 : TStaticText;
    StaticText3  : TStaticText;
    StaticText30 : TStaticText;
    StaticText31 : TStaticText;
    StaticText32 : TStaticText;
    StaticText33 : TStaticText;
    StaticText34 : TStaticText;
    StaticText35 : TStaticText;
    StaticText36 : TStaticText;
    StaticText37 : TStaticText;
    StaticText38 : TStaticText;
    StaticText39 : TStaticText;
    StaticText4  : TStaticText;
    StaticText40 : TStaticText;
    StaticText41 : TStaticText;
    StaticText42 : TStaticText;
    StaticText43 : TStaticText;
    StaticText44 : TStaticText;
    StaticText5  : TStaticText;
    StaticText6  : TStaticText;
    StaticText7  : TStaticText;
    StaticText8  : TStaticText;
    StaticText9  : TStaticText;
    TabSet1      : TTabSet;
    CheckBox3: TCheckBox;

    procedure CheckBox1Click(Sender: TObject);
    procedure Image34Click(Sender: TObject);
    procedure Image36Click(Sender: TObject);
    procedure Image38Click(Sender: TObject);
    procedure Image40Click(Sender: TObject);
    procedure Image42Click(Sender: TObject);
    procedure StaticText2Click(Sender: TObject);
    procedure TabSet1Change(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
    procedure Image35Click(Sender: TObject);
    procedure Image37Click(Sender: TObject);
    procedure Image39Click(Sender: TObject);
    procedure Image41Click(Sender: TObject);
    procedure Image43Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  protected
    function  CheckRTEDEnabled: Boolean;
  public
    VclSynch : TRTEDVclSynchronizer;
    procedure  SynchronizedExceptionDump;
  end;

var
  fmRTEDDemo : TfmRTEDDemo;

implementation

{$R *.dfm}

procedure External_MainThread_OSException;     external 'RTExceptionDumperDLL.dll';
procedure External_MainThread_DelphiException; external 'RTExceptionDumperDLL.dll';
procedure External_OtherThread_OSException;    external 'RTExceptionDumperDLL.dll';

{ Global Exception Stacker custom handler }

procedure OnNotifyUnhandledException(
  AExceptObj  : TObject;
  AExceptAddr : Pointer;
  AExceptKind : TExceptionKind
);
begin
  fmRTEDDemo.VclSynch.Synchronize(fmRTEDDemo.SynchronizedExceptionDump);
end;

{ TfmRTEDDemo }

procedure TfmRTEDDemo.StaticText2Click(Sender: TObject);
var
  Link : String;
begin
  Link := TStaticText(Sender).Caption;
  if not SameText(Copy(Link, 1, 4), 'HTTP') then
    Link := 'mailto:' + Link;

  ShellExecute(Handle, 'open', PChar(Link), nil, nil, SW_NORMAL);
end;

procedure TfmRTEDDemo.TabSet1Change(Sender: TObject; NewTab: Integer; var AllowChange: Boolean);
begin
  with Notebook1 do
    ActivePage := Pages[NewTab];
end;

procedure TfmRTEDDemo.Image34Click(Sender: TObject);
begin
  mmExceptDesc.Text :=
    ' This kind of exception can be represented either by:'                   + #13#10#13#10 +
    '  1) an Operating System Exception:'                                     + #13#10#13#10 +
    '     X := Y / 0; { Division by Zero }'                                   + #13#10#13#10 +
    '  2) a Delphi Custom Exception:'                                         + #13#10#13#10 +
    '     raise EMyException.Create(''My Error Message'');'                   + #13#10#13#10 +
    ' raised into the Main Thread Context and usually intercepted from users' + #13#10 +
    ' by TApplication.OnException event.'
  ;
end;

procedure TfmRTEDDemo.Image36Click(Sender: TObject);
begin
  mmExceptDesc.Text :=
    ' This is kind of exception can be represented by uncaught errors' + #13#10 +
    ' generated in any Thread Context other than Main Thread:'         + #13#10#13#10 +
    '   procedure TMyThread.Execute;'                                  + #13#10 +
    '   begin'                                                         + #13#10 +
    '     { We raise an OS exception without take control over it }'   + #13#10 +
    '     PByte(nil)^ := 0;'                                           + #13#10 +
    '   end;'
  ;
end;

procedure TfmRTEDDemo.Image38Click(Sender: TObject);
begin
  mmExceptDesc.Text :=
    ' This is kind of exception can be represented by an operating'  + #13#10 +
    ' system exception raised within an external DLL module at Main' + #13#10 +
    ' Thread Level.'                                                 + #13#10#13#10 +
    ' Note that the exception dumper will scan only DLL modules'     + #13#10 +
    ' compiled with TD32 symbolic informations.'
  ;
end;

procedure TfmRTEDDemo.Image40Click(Sender: TObject);
begin
  mmExceptDesc.Text  :=
    ' This is kind of exception can be represented by a Delphi exception '  + #13#10 +
    ' raised within an external DLL module at Main Thread Level.'           + #13#10 +
    ' This kind of exceptions cannot be caught by TApplication.OnException' + #13#10 +
    ' event. Thus you cannot avoid the annoying error message box.'         + #13#10#13#10 +
    ' Note that the exception dumper will scan only DLL modules'            + #13#10 +
    ' compiled with TD32 symbolic informations.'
  ;
end;

procedure TfmRTEDDemo.Image42Click(Sender: TObject);
begin
  mmExceptDesc.Text :=
    ' This is kind of exception can be represented by an operating system'  + #13#10 +
    ' exception raised within an external DLL module within a Thread other' + #13#10 +
    ' than Main Thread.'                                                    + #13#10#13#10 +
    ' Note that the exception dumper will scan only DLL modules'            + #13#10 +
    ' compiled with TD32 symbolic informations.'
  ;
end;

function TfmRTEDDemo.CheckRTEDEnabled: Boolean;
begin
  Result := GlobalRTExceptionDumperActive;
  if not Result then
    Result := (MessageDlg('RTED not active. Do you want to continue?', mtWarning, [mbYes,mbNo], 0) = mrYes);  
end;

procedure TfmRTEDDemo.CheckBox1Click(Sender: TObject);
var
  Result : Boolean;
begin
  Result := RTExceptionDumper(CheckBox1.Checked);
  if not Result then begin
    MessageDlg('Error during RTED set/reset.', mtError, [mbAbort], 0);
    Exit;
  end;

  if CheckBox1.Checked then
    { Assign global notification handler }
    GlobalRTExceptionDumper.OnNotifyException := OnNotifyUnhandledException;
end;

procedure TfmRTEDDemo.Image35Click(Sender: TObject);
begin
  Image34Click(Sender);

  if not CheckRTEDEnabled then
    Exit;

  { Main Thread - Main Exe }
  raise EStackerDemoException.Create('This an exception raised in the Main Thread of the Main Executable.')
end;

procedure TfmRTEDDemo.Image37Click(Sender: TObject);
begin
  Image36Click(Sender);

  if not CheckRTEDEnabled then 
    Exit;

  { Other Thread - Main Exe }
  TStackerErrorThread.Create;
end;

procedure TfmRTEDDemo.Image39Click(Sender: TObject);
begin
  Image38Click(Sender);

  if not CheckRTEDEnabled then
    Exit;

  { Delphi Exception - Main Thread - DLL }
  External_MainThread_DelphiException;
end;

procedure TfmRTEDDemo.Image41Click(Sender: TObject);
begin
  Image40Click(Sender);

  if not CheckRTEDEnabled then
    Exit;

  { OS Exception - Main Thread - DLL }
  External_MainThread_OSException;
end;

procedure TfmRTEDDemo.Image43Click(Sender: TObject);
begin
  Image42Click(Sender);

  if not CheckRTEDEnabled then
    Exit;

  { OS Exception - Other Thread - DLL }
  External_OtherThread_OSException;
end;

procedure TfmRTEDDemo.FormCreate(Sender: TObject);
begin
  Caption  := Format(Caption, [VER_RTED]);
  VclSynch := TRTEDVclSynchronizer.Create;
end;

procedure TfmRTEDDemo.FormDestroy(Sender: TObject);
begin
  FreeAndNil(VclSynch);
end;

procedure TfmRTEDDemo.SynchronizedExceptionDump;
begin
  if CheckBox3.Checked then
  
    { Custom dump }
    with TfmRTEDCustomDump.Create(Self) do begin
      DumpException(CheckBox2.Checked);

      Show;
      Update;
    end

  else
    { Dump the exception }
    with TfmRTEDDump.Create(fmRTEDDemo) do begin
      mmDump.Text := GlobalRTExceptionDumper.GetAsText(
        False,
        True { Don't acquire locks }
      );

      { Disassembly }
      if CheckBox2.Checked then
        mmDump.Text := mmDump.Text +
          Format(#13#10#13#10'[Instruction disassembly]'#13#10#13#10'%s', [
            GlobalRTExceptionDumper.DisasmStackStep(0)
          ]);

      Show;
      Update;
    end;
end;

end.

