unit ufmRTEDCustomDump;

interface

uses
  Classes,
  ComCtrls,
  Controls,
  Dialogs,
  Forms,
  Graphics,
  hRTExceptionDumper,
  Messages,
  StdCtrls,
  SysUtils,
  uRTExceptionDumper,
{$IFDEF VER140}
  Variants,
{$ENDIF}
  Windows;

type
  TfmRTEDCustomDump = class(TForm)
    ListView1    : TListView;
    Memo1        : TMemo;
    PageControl1 : TPageControl;
    StaticText1  : TStaticText;
    StaticText10 : TStaticText;
    StaticText11 : TStaticText;
    StaticText12 : TStaticText;
    StaticText13 : TStaticText;
    StaticText14 : TStaticText;
    StaticText15 : TStaticText;
    StaticText16 : TStaticText;
    StaticText17 : TStaticText;
    StaticText18 : TStaticText;
    StaticText19 : TStaticText;
    StaticText2  : TStaticText;
    StaticText20 : TStaticText;
    StaticText21 : TStaticText;
    StaticText22 : TStaticText;
    StaticText23 : TStaticText;
    StaticText24 : TStaticText;
    StaticText25 : TStaticText;
    StaticText26 : TStaticText;
    StaticText27 : TStaticText;
    StaticText28 : TStaticText;
    StaticText29 : TStaticText;
    StaticText3  : TStaticText;
    StaticText30 : TStaticText;
    StaticText31 : TStaticText;
    StaticText32 : TStaticText;
    StaticText33 : TStaticText;
    StaticText34 : TStaticText;
    StaticText35 : TStaticText;
    StaticText36 : TStaticText;
    StaticText37 : TStaticText;
    StaticText38 : TStaticText;
    StaticText39 : TStaticText;
    StaticText4  : TStaticText;
    StaticText40 : TStaticText;
    StaticText41 : TStaticText;
    StaticText42 : TStaticText;
    StaticText43 : TStaticText;
    StaticText44 : TStaticText;
    StaticText45 : TStaticText;
    StaticText46 : TStaticText;
    StaticText47 : TStaticText;
    StaticText48 : TStaticText;
    StaticText49 : TStaticText;
    StaticText5  : TStaticText;
    StaticText50 : TStaticText;
    StaticText51 : TStaticText;
    StaticText52 : TStaticText;
    StaticText53 : TStaticText;
    StaticText54 : TStaticText;
    StaticText6  : TStaticText;
    StaticText7  : TStaticText;
    StaticText8  : TStaticText;
    StaticText9  : TStaticText;
    TabSheet1    : TTabSheet;
    TabSheet3    : TTabSheet;
    TabSheet4    : TTabSheet;

    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  public
    DoDisasm : Boolean;

    procedure DumpException(ADisasm: Boolean);
  end;

  TCustomExceptionFormatter = class(TRTExceptionDumperFormatter)
  public
    procedure Execute; override;
  end;

var
  fmRTEDCustomDump : TfmRTEDCustomDump;

implementation

{$R *.dfm}

{ TfmRTEDCustomDump }

procedure TfmRTEDCustomDump.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TfmRTEDCustomDump.DumpException(ADisasm: Boolean);
begin
  DoDisasm := ADisasm;
  GlobalRTExceptionDumper.FormatCustom(TCustomExceptionFormatter, Self);
end;

{ TCustomExceptionFormatter }

procedure TCustomExceptionFormatter.Execute;
var
  F        : TRTEDCpuFlag;
  C        : Integer;
  fS       : Boolean;
  fSN, fLN : String;

  procedure Dump(AFormatter: TRTExceptionDumperFormatter);
  var
    I                   : Integer;
    CallerAddress       : Pointer;
    CallerPhysAddress   : Pointer;
    CallerMethodAddress : Pointer;
    SectionNumber       : Integer;
    SectionOffset       : Integer;
    ModuleName          : String;
    UnitName            : String;
    PublicName          : String;
    LineNumber          : Integer;
  begin
    with AFormatter do
      for I := 0 to (GetStackDepth - 1) do
        if GetStackRow(
          I,
          CallerAddress,
          CallerPhysAddress,
          CallerMethodAddress,
          SectionNumber,
          SectionOffset,
          ModuleName,
          UnitName,
          PublicName,
          LineNumber
        ) then
          with TfmRTEDCustomDump(Param).ListView1.Items.Add do begin
            Caption := Format('%.08x', [DWORD(CallerPhysAddress)]);
            SubItems.Add(Format('%.08x', [DWORD(CallerAddress)]));
            SubItems.Add(IntToStr(SectionNumber));
            SubItems.Add(ModuleName);
            SubItems.Add(UnitName);
            SubItems.Add(PublicName);
            SubItems.Add(IntToStr(LineNumber));
          end;
  end;
  
begin
  with TfmRTEDCustomDump(Param) do begin
    { General/CPU }
    StaticText4.Caption  := Format('0x%x', [DWORD(GetExceptionAddress)]);
    StaticText5.Caption  := GetExceptionObject.ClassName;
    StaticText6.Caption  := GetExceptionMessage;

    StaticText16.Caption := Format('0x%.04x', [GetThreadId]);
    with GetThreadContext^ do begin
      StaticText17.Caption := Format('0x%.08x', [EAX]);
      StaticText18.Caption := Format('0x%.08x', [EBX]);
      StaticText19.Caption := Format('0x%.08x', [ECX]);
      StaticText20.Caption := Format('0x%.08x', [EDX]);
      StaticText21.Caption := Format('0x%.08x', [ESI]);
      StaticText22.Caption := Format('0x%.08x', [EDI]);
      StaticText23.Caption := Format('0x%.08x', [ESP]);
      StaticText24.Caption := Format('0x%.08x', [EIP]);
                              
      StaticText31.Caption := Format('0x%.08x', [SegCS]);
      StaticText32.Caption := Format('0x%.08x', [SegDS]);
      StaticText33.Caption := Format('0x%.08x', [SegES]);
      StaticText34.Caption := Format('0x%.08x', [SegFS]);
      StaticText35.Caption := Format('0x%.08x', [SegGS]);
      StaticText36.Caption := Format('0x%.08x', [SegSS]);
    end;

    C := 37;
    F := Low(TRTEDCpuFlag);
    while (F <= High(TRTEDCpuFlag)) do begin
      GetCPUFlag(F, fS, fSN, fLN);
      TStaticText(FindComponent(Format('StaticText%d', [C]))).Caption     := Format('%s (%s):', [fSN, fLN]);
      TStaticText(FindComponent(Format('StaticText%d', [C + 9]))).Caption := Format('%d', [DWORD(fS)]);

      Inc(F);
      Inc(C);
    end;

    { Stack }
    for C := 0 to (GetFollowedModulesCount - 1) do
      Dump(GetModuleFormatter(C));
    Dump(Self);

    { Disassembly }
    TabSheet4.TabVisible := DoDisasm;
    if DoDisasm then
      Memo1.Lines.Text := GetStackDisassembly(0);
  end;
end;

end.
