{$INCLUDE ..\cDefines.inc}
unit cGraphUtils;

interface

uses
  { Delphi }
  Graphics;

type
  TBMP24Pixel = packed record
    R, G, B: Byte;
  end;
  PBMP24Pixel = ^TBMP24Pixel;

  TBMP24ScanLine = Array[0..$FFFFFF] of TBMP24Pixel;
  PBMP24ScanLine = ^TBMP24ScanLine;

procedure bmpConvertRGB24(const Bmp: TBitmap);
procedure bmp24ReplaceColor(const Bmp: TBitmap; const OldCol, NewCol: TColor);

implementation

procedure bmpConvertRGB24(const Bmp: TBitmap);
begin
  if not Assigned(Bmp) or (Bmp.PixelFormat = pf24Bit) then
    exit;
  Bmp.PixelFormat := pf24Bit;
end;

procedure bmp24ReplaceColor(const Bmp: TBitmap; const OldCol, NewCol: TColor);
var P    : PBMP24Pixel;
    W, H : Integer;
    I, J : Integer;
    F, R : Integer;
    E    : TBMP24Pixel;
begin
  if not Assigned(Bmp) then
    exit;
  W := Bmp.Width;
  H := Bmp.Height;
  if (W = 0) or (H = 0) then
    exit;
  // convert colors
  F := ColorToRGB(OldCol);
  R := ColorToRGB(NewCol);
  E.B := (R and $FF0000) shr 16;
  E.G := (R and $00FF00) shr 8;
  E.R := (R and $0000FF);
  // make RGB24 format
  bmpConvertRGB24(Bmp);
  // make unique
  Bmp.Handle;
  // replace pixels
  For I := 0 to H - 1 do
    begin
      P := PBMP24Pixel(Bmp.ScanLine[I]);
      For J := 0 to W - 1 do
        begin
          if (P^.B shl 16) or (P^.G shl 8) or P^.R = F then
            P^ := E;
          Inc(P);
        end;
    end;
end;



end.
